---
title: "Chapter support and retiring"
linkTitle: "Support & retiring"
weight: 9
---

## Get support for your chapter

Things to try if you are struggling or can no longer serve as your chapter's organiser: :muscle:

1. If you struggle to organise events, please let us know and we will put you in [contact with an experienced organiser that can mentor you](/coordination/monitoring/).
2. Please message the members of your chapter on meetup and ask if anyone is willing to help you co-organise the chapter or take over the chapter.

- If someone comes forward, send an email `chapters@rladies.org` to inform them of this change and share the new contact's information. Next, please check that the information concerning your chapter [in our website repository](https://github.com/rladies/rladies.github.io/tree/main/data/chapters) accurately reflects this change. If not, please make the necessary adjustments and submit a GitHub pull request to R-Ladies with the updated information. If you do not feel comfortable making a pull request, please mention this in your initial email to chapters@rladies.org. We will help you update the contact information for the chapter. The new contact will also receive access to the organiser Slack channel.
- If no one comes forward, please make an announcement in the [community slack](/comm/slack/) to see if anyone is willing to take over.

## Our monitoring of chapters

Once a chapter is created, we would love to see it grow and be active. We support chapters by providing the digital infrastructure: a custom rladies.org email address, logo and templates for setting up social media channels (i.e. Twitter) and a subscription on meetup.com.

All this infrastructure is time and resource intensive to maintain, therefore we cannot sustain a limitless number of chapters. We provide resources on a first-come-first-serve basis but expect chapters to be actively engaging the local community. As a rule of thumb, we expect at least a meetup within 6 months from the initial setup and, possibly, more often thereafter.

Many R-Ladies chapters organize monthly, bi-monthly or quarterly events, but the frequency of meetups depends on the demand of your local community and on the availability of the organizers. In general, organizing events is much easier if you let people help you. We encourage you to welcome co-organizers and volunteers to help split the workload.

You can check your chapter' status here: [https://r-community.github.io/user-groups/rladies.html](https://r-community.github.io/user-groups/rladies.html).
Please note: **Active groups** have had an event in the past 6 months or have an upcoming event in the future; **Inactive groups** have not had an event in the past 6 months and do not have an upcoming event; **Unbegun groups** have not had an event in the past and none are planned for the future.

🚨**If your chapter is labelled as 'inactive', below are the steps we follow:**

1. At the beginning of every quarter a list is compiled with inactive chapters (no activity in the previous 6 months) and retirement is discussed during the first available leadership call. The list of inactive chapters is also available here: https://r-community.github.io/user-groups/rladies.html.
2. We notify inactive chapters that they are going to be retired soon. Notifications are sent to <chapter_name>@rladies.org or via slack private messages, please check email and slack regularly.
3. If no answer is received, we assume you are happy to retire your chapter.

[More details](/coordination/monitoring/).

Things you could do:

- If you struggle to organise events, please let us know and we will [put you in contact with an experienced organiser that could mentor you](/coordination/mentoring/).
- Please message the members of your chapter on meetup and ask if anyone is willing to take over.
- If no one comes forward, please make an announcement in the community slack to see if anyone is willing to take over.

Remember that if you organise an event, your chapter is automatically removed from the list of retiring chapters. However, if you are busy and can no longer organise events, please let us know as soon as possible and send us login credentials to local email/slack/twitter/facebook etc. The leadership team will retire the chapter and close/suspend any other related accounts.

Should you wish to chat with us about options, please feel free to contact the leadership team on the organizers slack or email `info@rladies.org`.
