---
title: "Finance"
linkTitle: "Finance"
weight: 3
---

We do not want you to spend your personal money on your local chapter!

## Local sponsors

If you find a local sponsors, at the moment since there is no formal structure for receiving funds, it is best if the sponsor pays directly for a need of your chapter, like food at the next event or accomodation for a guest speaker.
The sponsor might also want to e.g. put a room at your disposal for free.

There is the option of paying from your own pocket and have the sponsor reimburse you but that is riskier.

We are piloting using [Open Collective](https://opencollective.com/) -- the results of the pilot are not in yet.

### How to find sponsors?

You might try to cold email (i.e. reach out to, without knowing them) local IT companies you think might be interested in R-Ladies mission.

You might try to use your personal contacts such as current or past employers, and those of the members of the meetup who could ask their own employers to provide a room for meetups for instance.

You might also hear of special call for proposals of diversity initiatives where your chapter could apply.

In all cases, it can help to tell the members of your chapter to be on the lookout and help you not miss opportunities.

### How to convince sponsors?

What are our strenghts?

- our focus on women and gender minorities;
- events being free.

You could hand out flyers (for instance see [R-Ladies Cotonou's flyers](https://github.com/sbnadejda/flyers_R-LadiesCtn)), and send (cold) emails.
See email template below, just given for information as you can write your own! This email template was adapted from an email graciously shared by R-Ladies Philly.

```markdown
Dear [Name],
I am contacting you about the possibility of supporting the local chapter of R-Ladies [chapter name and online presence]. R-Ladies is a world-wide organization that promotes gender diversity in the data science community. As the [chapter name] chapter, we actively share and exchange knowledge with 100+ other chapters across the world, and bring together [usual number of attendees] members each [event frequency] for networking and knowledge sharing events. Since starting in [creation date], we’ve grown to [number of meetup members] members, and have set the groundwork for [positive phrase, e.g. "civic engagement" if you paired with non-profits, "community building among data scientists", etc].
If you are unfamiliar, R is an open source programming language for statistical computing that is widely used in many sectors. We are organizing [event types e.g. workshops] for women and underrepresented genders interested in R with topics like beginning R, R/Shiny, and statistical methods. [Add other events here if relevant e.g. bookclubs, networking events]
Continuing these efforts to increase diversity through opportunities in data science in [chapter location] will require time and resources (e.g. food, location space, online hosting, access to experts). We are committed to dedicating our time to this mission, and we would welcome the opportunity to partner with [company] to develop these avenues further.
[Here is a good place to customize - are you specifically interested in this sponsor hosting an event? Providing food for an event? Providing printing services?]
Best,
[your name]
```

Now as regards to the subject of the email, you want it to

- convey what's in the email ("Partner with R-Ladies Philly");
- not look spammy;
- possibly explain R-Ladies, maybe using keywords like "feminist", "R", "data science"...

### How to thank sponsors?

- listing them as sponsors in the promotion of activities they supported;
- a short time slot at the beginning of a meetup to present their company;
- etc.

## R Consortium grants

Refer to [The User Group Program](https://www.r-consortium.org/projects/r-user-group-support-program).

R Consortium can offer grants to support the mission of local chapters in facilitating the exchange of knowledge and the formation of enduring R user group communities. These grants are aimed at assisting active user groups in their efforts to foster R-related learning and collaboration within their chapters. This document outlines the step-by-step process for applying for an R Consortium grant through R-Ladies.

**Step 1: Express Interest**

1. Contact [Batool Almarzouq](grants@rladies.org) from the R-Ladies Global Team to express your interest in applying for an R Consortium grant.
   - In your communication, specify the following details:
     - The desired grant amount.
     - The R-Ladies chapter for which you are applying.
     - The name of the organizer(s) in your chapter who will be responsible for managing the grant.

**Step 2: Complete the Online Application** 3. Once Batool Almarzouq has received and recorded the above information, proceed to the grant application process. Access the grant application form [available on the R Consortium website](https://r-consortium.org/all-projects/rugsprogram.html).

- Fill out all required fields accurately and comprehensively.
- Ensure that you have prepared a detailed proposal outlining the purpose and scope of your project.
- Submit the completed application form through the website.
- contact Batool again to confirm submission and report the day you submitted your application at.

**Step 3: Fund Disbursement** 4. Upon approval of your grant application by R Consortium, you will receive the grant funds. You have the flexibility to transfer the funds to any suitable account for your chapter's use.

**Additional Tips:**

- Ensure that your grant application is well-documented and aligns with the goals and objectives of your R-Ladies chapter.
- Keep track of all expenses related to the grant and maintain clear records for accountability.
- If you encounter any challenges during the application or fund management process, don't hesitate to reach out to Batool Almarzouq or other members of the R-Ladies Global Team for assistance.

## Expenses reimbursed by the global organization

Subject to **availability of funding and after discussion with the finance team**, expenses can be reimbursed.

### What expenses can I get reimbursed?

If you need money to buy food/drinks for your event, we suggest to get a sponsor or to apply for a grant through the [R User Group support program](https://r-consortium.org/all-projects/rugsprogram.html).

If you cannot get an sponsor/grant and/or wish to discuss what type of expenses could be covered by the R-Ladies organisation, please contact the **finance team** (`finance@rladies.org`) **before making any expense**.

### How to submit expenses

**If the finance team agrees on covering you expenses**, please follow the steps below:

1. Complete the R Consortium Expense Reimbursement form that the finance team will give you, filling in dates and descriptions of the expenses. **Remember to add to the expenses any international transaction fees to transfer USD to your account (ask your bank for more details)**. Sign and date the form.

2. If you reside in the US, you will get a check payment (remember to specify your home address in the reimbursement form). If you reside outside the US, please fill in the Wire Form that the finance team will give you as the payment will be made via wire transfer (remember to specify the IBAN in your bank account details).

3. Create 1 pdf file containing: the reimbursement form, wire form (if applicable) and all the receipts. Name the file <YYYYMMDD_SURNAMENAME.pdf>, where YYYYMMDD is the date you submit of your expenses.

4. Send the pdf to the **finance team** (`finance@rladies.org`)

Please remember:

- to use an email address you check regularly as we might need extra information from you;
- to provide a receipt for each item you wish to get reimbursed;
- lastly, let us know if you wish to get an invite to the private slack-channel 'expenses' to join discussion related to expenses.

### Timing

You can send a request for reimbursement any time, however, beware that requests will be collated and submitted to the funding body once a month (usually, the last week of each month).
If the details you provide is incomplete we will get in touch with you for more information using the email address you provided. If you fail to provide information and/or the information you provide is erroneous, we reserve the rights not to reimburse your expenses. Therefore, please, take extra care when submitting a claim.
If no problems arise, the reimbursement will be issued within few weeks.

### Any questions?

Should you have any questions, do not hesitate to contact the **finance team** (`finance@rladies.org`).
