---
title: "About speakers"
linkTitle: "Speakers"
weight: 2
---

## How to recruit speakers

- Regularly tell meetup attendees that you are looking for speakers.

- Suggest topics to members of your chapter; e.g. if you notice someone got started with ggplot2 or wrote their own package, suggest they talk about that.

- Lightning talks events can be a way to invite new speakers since they can prepare a short talk. Example [Call for Proposals by R-Ladies NYC](https://www.rladiesnyc.org/post/lightning-talk-submissions-request/).

- For short talks, you could use R-Ladies Cotonou's approach of asking speakers to briefly present _"what they like the most about R or would like to know."_.

- Post a call for speakers on the R-Ladies Slack or Twitter accounts.

- Message the R-Ladies meetup.com group.

- Reach out to people in your network or the networks of other members of your chapter.

- You might be able to reach out to potential speakers outside of your chapter's location thanks to meetups being online / sponsor funding for travel.

- You can give a talk yourself once in a while!

- Remember the [rules about Prioritization of Underrepresented/Minority Genders](/about/mission/#r-ladies-rules--guidelines).

- In line with R-Ladies’ Mission Statement and with our [Black Lives Matter Statement](https://rladies.org/news/2020-06-06-blm/)
  to achieve participation and representation in our events of generally excluded groups, taking into account the intersectionality of gender, race, language and geography; for these reasons we request:

  - In chapter events, invite speakers of diverse race, language and geography (i.e., avoid a one year period with all white speakers at the chapter events).
  - For panel discussions of 3 or more panelists, invite speakers of diverse race, language and geography (i.e., avoid all white panels).
    We need to do for the minority groups inside our community the same that we request other communities and spaces do for women and gender minorities.

### How to find speakers?

Note that directories will not necessarily have direct information on race, language and geography; but diversifying the way you identify speakers (e.g. not only inviting people you already know) should help having no all white panels.

- You can use the [R-Ladies Directory](https://rladies.org/directory/).
- You can check similar directories and reach out to other communities (see lists below).
- You can reach out to other R-Ladies in the R-Ladies Community Slack.
- You can follow other communities on social media to get to know about speakers in their communities.
- For online events, we encourage local chapters to reach out beyond their local community to invite R-Ladies from different parts of the world as speakers.

### Other communities to reach out to

- [Minorities in R](https://mircommunity.com/)

- [Black Girls Code](https://www.blackgirlscode.com/)

- [Black in Data](https://www.blackindata.co.uk/)

- [Black in Data Week](https://blkindata.github.io/)

- [Coding Black Female](https://codingblackfemales.com/)

- [Black in AI](https://blackinai.github.io/#/)

### Other womens speakers directories

- [500 Scientific Women](https://500womenscientists.org/request-a-scientist)

- [Diversifica](https://diversifyeeb.com)

- [Women in geospatial](https://www.womeningeospatial.org/join/speakers-database)

- [Find your speakers](https://speakerinnen.org/)

- [Survey of scientists from Women in Bioinformatics and Data Science LatAm](https://t.co/nI8rHED8ry?amp=1)

- [Directory of technology speakers](https://github.com/lasdesistemas/speakers-tecnologia) from [Las de Sistemas - LatAm](https://twitter.com/lasdesistemas/status/1273374539888672774?s=20):

## How to support speakers

### Before the event

Ask the speaker for how many people they can present their talk or tutorial.

Also ask them for a bio, and make sure you know their pronouns.

Have the speaker write an abstract, make sure it is informative of the content and format. See the next section about [promoting the event](/organization/events/promotion/).

You can check in with the speaker to ask them if they need any help, e.g. to make a survey of participants' skills.
You should check how the speaker is going to share their screen or show their slides; do not hesitate to schedule a testing session especially for online events.

If you are funding travel and accommodation for the speakers, make sure to let them have the accommodation they need and that all places are accessible to them.

Depending on the time of the event, discuss the possibility of a shared meal or drinks or simple friendly debrief after the meetup, especially for outside guest speakers, but do not put any pressure on the speaker.

Here are resources you can share with speakers.

- [Public Speaking - Dealing with nerves by Hadi Hariri](https://hadihariri.com/2018/08/15/public-speaking-dealing-with-nerves/)

- [Notes on preparing a tech talk by Emily Riederer](https://emilyriederer.netlify.app/post/writing-a-tech-talk/)

- [Giving Your First Data Science Talk by Emily Robinson](https://hookedondata.org/giving-your-first-data-science-talk/)

### During the event

- Introduce the speaker and their pronouns.

- As the organizer you are responsible for reminding everyone of the code of conduct and of logistical details.

- If relevant be a moderator for questions to be asked to the speaker.

### After the event

- Send a thank you message (or note?) to the speaker.

- Following our [guidance about promotion](/organization/events/promotion/), encourage the speaker to submit the link to their materials to R Weekly, or offer to do that.
