---
title: "Promoting events"
linkTitle: "Promotion"
weight: 5
---

How to promote events and speakers?

{{% notice tip %}}
To ensure attendees are not all from the majority gender, consider first advertising your event to R-Ladies directly or in private communication channels such as your [chapter slack](/organization/online-presence/slack/) if there's one.
Please do be aware of the relevant Equality Legislation in your jurisdiction, e.g the Equality Act 2010 in the UK, when designing participation frameworks for the majority gender, to ensure your procedures are not infringing local laws re. potential discrimination.
{{% /notice %}}

- Reach out to people you know directly! Especially for the kick-off event, it's important to give personal invitations in the beginning.

- Try to make the event title both fun and informative.

- Write an informative summary for Meetup, including short speaker bios validated by speakers. What can attendees expect (topic, hands-on or not)? Who is the speaker (short bio, links to online presence)? Will there be food?

{{% notice tip %}}
Making an event inclusive can mean to be explicit about things you thought might go without saying, for instance, if kids are able to attend the meeting, say it! Chances are people with kids will show up; or, you might wanna tell people without a personal computer they can come with a notebook and a pencil and write down some ideas and that you will have a few printed handouts for them (pairing people could also be an option or hosting your event at a library/working space with available computers to loan).
{{% /notice %}}

- Make graphics for social media? You could use [canva](https://canva.com/), [OmniGraffle](https://www.omnigroup.com/omnigraffle/) on Mac, slides templates (Google slides or Microsoft Powerpoint) saved as PNG, [a Shiny app to design hex logos](https://connect.thinkr.fr/hexmake/). Example below. In any case make sure to add an alternative text to the image on social media, and to make the text of your tweet informative, as well as to add a link to the event on Meetup.

- Put presentations or links to them in your chapter's [GitHub repo](/organization/tech/accounts/#github)[^iwd]. Read [Carpe talk](https://www.tidyverse.org/blog/2018/07/carpe-talk/) by Jenny Bryan and Mara Averick.

- If your chapter has a website put information about the event before and after the event (link to slides)

- Submit link to slides or other material to [R Weekly](https://github.com/rweekly/rweekly.org#how-to-have-my-content-shared-by-r-weekly).

[^iwd]: These resources are a goldmine, as shown by one of our [previous International Women Day campaigns](https://github.com/rladies/IWD).
