---
title: "Scheduling & Hosting an Online Meetup with the R-Ladies Zoom account"
linkTitle: "Online with Zoom"
weight: 3
---

{{% notice info %}}
:loudspeaker: Hello all, we have a Zoom Pro account for chapter meetups!  
:computer: What: Zoom Meeting for up to 100 participants </br>
:link: Where: Calendly link (in the description of the \#online_meetups channel on the R-Ladies Organizer Slack)</br>
:video_camera: If you record the Zoom session we can host it on our [YouTube channel](/organization/youtube)! </br>
:eyes: If you don't use Zoom, you can still find [the resources section](organization/online/#more-resources) useful.
{{% /notice %}}

## Booking a slot

### Book with Calendly

You can see which time slots are available and book any of them through
Calendly (link in the \#online_meetups channel on the R-Ladies Organizer Slack -- please do not share it!).
After you book a meeting time, you will receive
an email with the Zoom link. We've set the availability to 24/7.

### Announce the event on Meetup

- [Hosting an online event on Meetup](https://help.meetup.com/hc/en-us/articles/360040609112) is easy as booking any other event. You'll need to fill up all the event details as well as the link received when booking the slot on Calendly. Please mind, that if you connect your Zoom account on Meetup, it will swap the link with one automated generated link from your personal Zoom account, so please make sure the link you add on meetup is the same as the one you received by email upon confirmation from Calendly.
- [Meetup event policies and the coronavirus (COVID-19)](https://help.meetup.com/hc/en-us/articles/360041040931)

### A slot for what?

Feel free to book a slot for any type of R-Ladies events: talk/tutorial but also co-working/hangout, networking, code workshop, co-watching past conference talks...

## Running a meeting

:jigsaw: To let you run your meetups as independently as possible, we have set it up the
zoom in a specific way to enable that.
Notice that you will need **two** numerical codes to run your online event:

1. **Passcode** to get into the scheduled zoom booking (sent via e-mail and embedded in
   zoom link)
2. **Host key** to [claim host](#how-to-claim-host-controls-using-the-host-key) once you are in the zoom room (found in the \#online_meetups
   Slack channel.

:slot_machine: Anyone entering any meeting will need a passcode. This
passcode will be unique to the timeslot you have booked, and will only
be active to let you and your attendants in your booked time.

:information_desk_person: You will be able to be the Host of the
meeting with the associated privileges/controls. As the Host you can
also make co-organizers and presenters Co-Hosts of the meeting.

:key: We will give you the Zoom **Host Key**
with which you can [make yourself the Host](#how-to-claim-host-controls-using-the-host-key) without anybody of us needing
to be online to make you the Host. We will post the Host Key once a
month in the \#online_meetups channel on the R-Ladies Organizer Slack.

:clock2: We won't be able to be online to start
the meeting for you (because of timezones) so we have enabled "join
before host" and disabled the waiting room. To minimise the likelihood
of trolls crashing the meeting before you join and make yourself the
Host, we suggest to add a 15-minute buffer at the start of your meeting
to the calendly booking, e.g., book for 5:45pm and tell your meetup
participants that it starts at 6pm. **Please be punctual so that the
Host is there to manage the meetup before others show up.**

:warning: You can [claim the Host](#how-to-claim-host-controls-using-the-host-key) role after you joined the meeting by clicking on
participants and then on "claim host" in the right-hand corner. You will
need to enter the host key which you'll get from \#online_meetups channel on the
R-Ladies Organizer Slack.

:wave: **Please remember to _end_ the meeting, not just _leave_ the meeting**
so that the next organizer can access the room for their meetup.

{{% notice warning %}}
Do not forget to remind attendees of the code of conduct at the beginning of the event.
{{% /notice %}}

### How to claim Host controls using the Host Key

1.  Click on the Zoom meeting URL and join the meeting with the passcode (get it from  
    the \#online_meetups channel on the R-Ladies Organizer Slack).

2.  Once you're in the meeting, click on the 'Participants' list to bring up the list below.
    At the very bottom you should see some buttons -- click on the 'Claim Host' button.

{{< figure src="claim-host.png" alt="Screenshot of the claim host button in the Zoom interface" >}}

3.  Type in the Host key (get the key from the \#online_meetups channel on the R-Ladies Organizer Slack & don't share it)

{{< figure src="enter-key.png" alt="Screenshot of the 'enter key' form in the Zoom interface" >}}

### Tips for running the Zoom meeting

{{% notice note %}}
These guidance has been updated based on experiences from the Baltimore, Irvine, NYC, and Santa Barbara chapter guidelines, specifically to address issues with trolls in zoom meetings.
{{% /notice %}}

:eyes: After becoming the Host, we suggest that you:

- Enable the waiting room.
- Admit your co-organizers from the waiting room and
  make them co-hosts so that they can manage bad actors with you if
  necessary. **Having multiple co-organizers run an online meeting makes things much easier (e.g., one organizer can keep an eye on the chat).**
  It also makes it possible for your co-host to claim host if you for some reason disconnect or experience other technical difficulties.
  We recommend having (at a minimum) one co-host to help you. For larger events, you may consider three to four co-hosts.

- Cross-reference the Meetup RSVP list with names of folks in the waiting room before admitting them into the meeting. (Before this step, encourage all members of your Meetup group to add their real first and last names to their profiles along with a profile picture.)

- Make organizers easy to recognize.
  Introduce yourselves at the beginning, and add "Organizer - " to your name.
  This is important, as it helps participants more easily request assistance and report incidents related to the code of conduct.

- Make your presenter a co-host as well so that they can share their screen
  even if regular participants cannot.

- Enable Close Captions: On the Zoom Rooms controller, tap the Captions icon (a square with the text _CC_). You may need to tap the More (...) icon first to see the option.

:zombie: We have set the meeting options to prevent trolling as best as possible
(e.g., _enabling the waiting room feature by default; participants are muted on entry and must request permission to unmute; participants who have been
removed from the meeting can't rejoin; disabling participant file
transfers, private messages (only messages to everyone or to the hosts only are allowed), screen sharing, profile pictures, and virtual
backgrounds_). With the latest version of the Zoom client, the Host has
an extra security control menu where they can adapt a lot of these
settings during the meeting (e.g., _turning on/off the chat and screen sharing_).

However, if you do have to deal with trolls:

- Remove the participant (hover your mouse over their name, click
  "more," and then click "remove.")

- Lock the meeting so no one can come in (select "more" under
  participants and "lock meeting").

- Email our code of conduct team (reporting [at] rladies [dot] org) after the meeting to let us know what happened. By reporting incidents like these to us, we can better prevent them in the future.

Lastly, the link to book the online meetup is **not to be shared
publicly** as it's only intended for organizers.

{{% notice warning %}}
**Like for in-person events, be respectful of participants' privacy.**
If you want to save the Zoom chat, ask participants for their permission at the beginning of the event.
Advise participants to not take photos of the Zoom screen to publish on social networks unless permission is collected from all people appearing in the screenshot.
{{% /notice %}}

### Broadcasting to a broader audience

#### Ask for permission from the attendees

{{% notice warning %}}
Please also check the local laws!
{{% /notice %}}

If recording/livestreaming,

- First ask the speaker(s) if they are ok with streaming/recording.

- Mention that in the event description, maybe even ask for "approval for participation in a recorded event." or something similar.

- Before starting the video recording, advise that you are going to record and that those who do not want to be recording should turn off their camera.

#### Zoom recording and YouTube

One may also use the zoom recording option if your speaker is up for that.
It is a great way to get content available to more people.
We can host this on our [YouTube channel](/organization/events/youtube/).

{{% notice warning %}}
It is best if you use the _local_ recording option on Zoom, this way you have the recording file at hand.
If you were unable to do so, please ask for the recording via the \#online_meetups channel on the R-Ladies Organizer Slack.
{{% /notice %}}

#### Zoom and YouTube live streaming

We also, through our YouTube channel, have the opportunity to do live streaming.
To arrange for live streaming, please email `youtube@rladies.org` at least two weeks before the event.
If you are doing live streaming, you will be given temporary user access to the R-Ladies YT channel so you can run it at your leisure.

[Zoom meeting/webinar simultaneously with YT livestream, Zoom docs](https://support.zoom.us/hc/en-us/articles/360028478292-Streaming-a-Meeting-or-Webinar-on-YouTube-Live)

You can also do your YouTube livestream as unlisted and only share the link with the people you want to attend.
If they share the link others can see the livestream,
but the stream won't be publicly listed and there won't be notifications sent to channel subscribers.

### Running virtual social events

Running an event (or part of an event) especially dedicated to socializing might be great for everyone in these difficult times!

Here are some tips mostly from R-Ladies NYC:

- Dedicating an entire event to "virtual social networking" help make it clear that the event is about getting to know each other.

- If the group of all attendees isn't too big (15 people?), have everyone introduce themselves in the big group so as not to have to repeat an intro in every breakout room (and take up precious time!)

- Utilize [Zoom breakout rooms](https://support.zoom.us/hc/en-us/articles/206476313-Managing-Breakout-Rooms) for a social event. Ideally, you want 3-4 people in a group, and if you can, put a member of your organizing team/board in each room (or as many rooms possible). These breakout meetings should be 15-20 minutes long.

{{% notice tip %}}
You can use the random feature on Zoom to first create the groups, then re-allocate members of your organizing team. Make sure to pay attention to who's in which group when you do this, and try not to repeat combinations of people!
{{% /notice %}}

- Give the groups a fun question to spur conversation, maybe R-related, such as, "did you learn base r or the tidyverse first?" or "what's the latest cool R package you started using?".

- Use a pre-survey to ask participants if they have ideas for questions or topics for the breakout rooms.

Outside of Zoom you could try out platforms such as [gather.town](https://gather.town/).

## More resources

### General best practice

- ["Virtual Meetups" LinkedIn post by Noa Tamir](https://www.linkedin.com/pulse/virtual-meetups-noa-tamir/)

- [The Carpentries guide for online teaching](https://carpentries.org/blog/2020/03/tips-for-teaching-online/)

- [Code Buddies, a community of independent code learners](https://codebuddies.org/)

- [Alan Turing Institute's checklist for online events](https://github.com/alan-turing-institute/the-turing-way/blob/ms-collaboration-book/book/content/remote_collaboration/checklist/checklist.md)

- [Experience from satRday Neuchâtel](https://docs.google.com/document/d/1ZXmwVibQKtfCY_HiB49-OhQL-yKhUS9YD9yeMQZH88E/edit?usp=sharing)

- (_in Spanish_) [R-Ladies lleva (Español) - Cómo hacer una reunión virtual inolvidable (sin morir en el intento)](https://www.youtube.com/watch?v=lZICjcX7O0U&feature=youtu.be)

### Accessibility best practice

- [How to organize and run an awesome deaf accessible virtual event?](https://hearmeoutcc.com/deaf-accessible-virtual-events/)

### Tooling

- [Codeshare, "Share Code in Real-time with Developers"](https://codeshare.io/)

- [livecode, an R package that enables you to broadcast a local R document](https://github.com/rundel/livecode) and [ngrok](https://ngrok.com/), [walk-through for usage of the two tools](https://bitsandbricks.github.io/post/code-live-from-rstudio-and-share-it-with-the-world-in-real-time/)

### Polls

- You can do polls with Zoom, for that you could have the meetup start 15 minutes later than your booking in order to be able to set up the poll (you can't set up the poll in advance).
- You can use other platforms such as the (limited) free plan of [mentimeter](https://www.mentimeter.com/plans).
- If you find or set up another solution, please tell us so we might share your wisdom!

## Conclusion

We hope this gives you an option to move your meetups online. If you
have any feedback, please let us know in the
[\#online_meetups](https://r-ladies.slack.com/archives/C01025GA7HU)
channel in the R-Ladies Organizer Slack.
:raised_hands:
