---
title: "Organizing events"
linkTitle: "Events"
weight: 1
---

{{% notice info %}}
If you are an R-Ladies organizer and have further tips, please submit them!
If you are an R-Ladies organizer and have further questions, please ask them in an issue.
{{% /notice %}}

## Planning events

- Organise the year (or, say, semester) in advance. Even if you change your plan in the middle is always good to know what to expect.

- Find speakers at least two months before the talk. Even if it is a 5 minutes talk, it will give you peace of mind and time for people to prepare their talk.

- To find ideas for topics, have a look at [other R-Ladies groups](https://www.meetup.com/pro/rladies/) or at conference programs. Also ask your meetup members for ideas and wishes, potentially in a [dedicated GitHub repository](https://github.com/rladies-seattle/rladies-seattle-organizing)[^repo].

- You can consider creating a checklist to follow for planning events, like [R-Ladies Seattle's](https://github.com/rladies-seattle/rladies-seattle-organizing/blob/master/how-to-run-an-event.md#checklist).

### Launch Event

Different ideas:

- Kickoff/Meet & Greet: Present your vision/idea for the meetup, invite others to help
  organise.
- Lightning talks: Short talks of 5 minutes on a range of topics. This format usually
  also has a low barrier to participate.
- Survey: Some chapters have set up an online questionnaire before their first meeting to
  find out what people were looking for in the meetup. Here are examples from
  [Paris](https://docs.google.com/forms/d/e/1FAIpQLSfPHTc1CuMHFmisaR53kM0G5iReXZfZH6CcKV6wsX0Gww5m3Q/viewform?c=0&w=1), [Madrid](https://chucheria.typeform.com/to/dGf4OR), [Tbilisi](https://docs.google.com/forms/d/e/1FAIpQLSedln6IeqdQXFRAm7PI0CxvRZXmFY74iG_wyLc-cuBy8pxnPw/viewform), [Oslo](https://docs.google.com/forms/d/e/1FAIpQLSePbvOiSGDPK8z7Eo0beK7P1BCrip7xUZzo_mcUidoi4lFMgQ/viewform), [Los Angeles](https://docs.google.com/forms/d/e/1FAIpQLSfEePUCFgkiRWa2nL1ECBntndw4Z2U7hvIVb3ao2IsriWFkag/viewform).
- Making your group/event known: you can reach out to some other meetups in the area which
  might have overlapping audiences (e.g., data science meetup and R user groups) and
  universities (e.g., statistics departments).
- Finding co-organisers: Some chapters have found their organising team at the launch
  event, others have included a question on who would be interested in organising in the
  initial survey.
  {{% notice warning %}}
  As written in [our mission](/about/mission/#r-ladies-rules--guidelines),
  Chapters and events may not be ‘used’ by a corporation/as a commercial vehicle for private aims.
  This also means that speakers cannot give talks about paid products/services,
  even if they don't work at the company offering the product/service.
  {{% /notice %}}

### Where to hold events?

This is a paragraph for when we all can have events in-person again.

To find a good space for your event, think of spaces you know (maybe a room at work, a room that the city lets local groups use, etc.), ask other local meetups.

Please keep accessibility in mind: can everyone access your meetup space? E.g. you don't want to exclude people who use wheelchairs! If the space you are holding the event at does not clearly list accessibility on their website, check with them, and list the information on your event description (potential attendees should not have to ask).

If possible and relevant, finding a space where one can loan computers might help some attendees get the most out of practical sessions even when they do not own a computer.

### When to hold events

Choosing the right slot, duration and weekday for events depends on your local community,
and their different work and life obligations (including yours!).
You could mix it up with workday evening meetups, lunch meetups, week-end meetups, etc.

You could poll your local community to find optimal slots (but keep in mind that event attendees are a biased sample :wink:).

### Announce events

See [event promotion](/organization/events/promotion/).

### Events RSVP

Note that some people might RSVP to an event and not attend, it's actually quite common.
You will however need to set a maximal number of participants based on the physical capabilities of the room you organize the event it, or based on the online platform you use.

### Inter-chapter events

Yes, you may host inter-chapter events! These consist of at least two R-Ladies chapters.
For example, chapters within a country, shared language, or shared time zone
can get together to organize an event, especially online.

Examples

- [R-Ladies Netherlands' Book club](https://github.com/rladiesnl/book_club);

- [Spanish metameetup](https://blog.rladies.org/post/spanishmetameetup/).

### Inter-group events

Yes, you may partner with groups outside of R-Ladies to host an event! Examples
include, but are not limited to, PyLadies and R User Groups.

When partnering with another organization for a meetup, be careful to not partner with an organization that is using your chapter for free diversity points.
Knowing the group you partner with well (and its organizers) will help you make a decision. As an example, a good partner may be an active member of your local R-Ladies chapter or another R-Ladies chapter.

Consider how the partner wants to administer the event. Are they offering to organize an event that will benefit the R-Ladies community or will the event only benefit their business/operations? They must agree not to openly market or sell a service and/or product during the meetup and access to a product and/or service must be free without fees for all R-Ladies attending. See [R-Ladies Rules & Guidelines: _No Commercial Agenda_](/about/mission/#r-ladies-rules--guidelines) for more information.
You can also ask other organizers for experience and advice.

In advance of the event, decide upon the Code of Conduct that applies to the event,
and make that explicit during the event. Also be aware that different groups may
have different policies regarding the gender of event organizers and speakers, and
be sure to agree upon your event's policy in advance.

Inter-group events should still be hosted via the R-Ladies chapter specific Meetup
account to ensure that chapter activity is accurately recorded. It is OK to also
host the event on multiple accounts if needed, but it is not required. For example,
an event hosted between R-Ladies and PyLadies could be hosted on both the R-Ladies
chapter Meetup and the PyLadies Meetup to promote awareness among both communities.

Examples

- [Mastering Shiny Bookclub (in collaboration with R-Ladies RTP and Ashton Drew)](https://www.eventbrite.com/e/mastering-shiny-book-club-tickets-135706500797) - In this event R-Ladies RTP partnered with Ashton Drew, who runs her own research consulting and R training company and is also an active member of the R-Ladies RTP chapter. Ashton wanted to open up the event to more than R-Ladies RTP members so R-Ladies RTP agreed to do this if all R-Ladies members were able to join the event free-of-charge using an Eventbrite promo-code. All proceeds collected from non-R-Ladies attendees were donated to R-Ladies Global at the end of the event. Finally, Ashton was organizing the event for the benefit attendees as well as her own personal desire to learn the material alongside other members of the R-Ladies and larger R community.

## During events

{{% notice warning %}}
Always remember that there is a code of conduct, remind everyone of the code of conduct at the beginning of events, and do not be afraid to use it! Minorities will feel at home if there's someone there to guard their safe space. Sometimes it can be very intimidating to tell someone to shut up or that they are not welcome but the code of conduct actually gives you the authority to do it without being a personal issue.

Refer people to the written coc on the website, and underline that it applies to all forms of media and communication.  
{{% /notice %}}

Arrive at the venue 15-30 minutes early to set up the room.
Check projector, microphone, laptop connections, etc. if necessary.

Make organizers easy to recognize.
Introduce yourselves at the beginning, consider wearing a specific badge.
This is important for participants for different requests for help and for being able to report incidents related to the code of conduct.

Bring name tags for attendees. Name tags should have space for names and pronouns.

As people are arriving, it's nice to have a slide up that explains when the meeting will begin, what to do while waiting (e.g., find food or any setup steps for a tutorial), and how to connect to wifi.

Begin the meeting with a few intro slides.
First, welcome attendees, state the mission of R-Ladies, point people to the R-Ladies Slack/Twitter/etc., mention code of conduct.
Then review today's topic and introduce the speakers.

### Snacks

If you found a sponsor willing to fund snacks for the event, that might be a great way to make it look more welcoming and promote people talking to each other.
Try to cater for dietary restrictions.

### What is a successful event?

A successful event does not need to have a huge turnout.
Of course you want a few people to attend to make your efforts and the speaker's efforts worthwhile, but there does not need to be dozens of participants.
Also, some events, the first, or some random events, might have a lower turnout than expected and that's ok.

### Resources

- [Awesome event organiser resources](https://github.com/stephlocke/awesome-organiser-resources) curated by Steph Locke

[^repo]: R-Ladies Seattle's workflow is inspired by rOpenSci community call workflow.
