---
title: "R-Ladies chapter mentoring program guidelines"
linkTitle: "Chapter mentoring"
weight: 55
---

## Objective 🎯

> The main objective of the R-Ladies chapter mentoring program is to help organisers conduct successful meetups and keep their chapters active.

Organizing an R-Ladies chapter involves a series of non-trivial tasks that can feel overwhelming to a new organiser. However, a number of experienced R-Ladies organisers are willing to mentor new ones, and can provide great advice.

For mentors, this is an opportunity to help to build community, learn about the realities of other chapters, gain experience as a mentor and contribute to R-Ladies as an organisation.

## Mentors and Mentees 🙂

### Who can be a mentor?

- Any experienced R-Ladies organizers can be mentors, as long as they have the time to commit to mentorship.

### Who can be a mentee?

- An organizer from a new chapter
- An organizer from an inactive chapter

## How the mentoring program works ⚙

1. Mentors and mentees should nominate themselves for the program through [this **form**](https://rladies.org/form/mentoring-signup/).
2. Mentors and mentees will be contacted by **someone from the R-Ladies global team. This person will serve as their point of contact throughout the program**, and will make the initial introductions.
3. In order to maintain low-pressure engagement, we strongly recommend that the mentee, mentor, and R-Ladies global team member mutually arrive at a consensus on the mode and frequency of communication through the program. Ideally, this should be decided before the program officially starts.
4. The mentoring program is considered **concluded** in the following circumstances
   - When the mentee's checklist (defined in the initial google form) is complete, and all reasonably related concerns have been addressed
   - When the mentee's first meetup is successfully executed
   - When a decision is made to retire the mentee's chapter
5. We strongly encourage that both mentors and mentees fill **the feedback form that will be provided at the end of the program**. This information will only be used to help us to improve the experience of the mentoring program for future participants.
6. **If the mentoring is not successful**(for e.g.- the chapter does not become active), the mentee could ask for a new mentor, or stop participating in the program. Confidentiality is requested in this situation.

#### Role of the mentor ✔

- Understand your own boundaries and be ready to refer the mentee to others who might have more knowledge. For example, encourage your mentee to use the R-Ladies slack.
- Provide guidance, offer relevant advice and give feedback to the mentee when required. Don’t feel responsible for solving problems. Instead, tease out an issue or problem with your mentee, and encourage them to find their own solutions.
- Stick to your mutually agreed contact commitments. We understand that sometimes things get in the way - if they do, please communicate to your mentee or R-Ladies point of contact in advance.
- Be a good listener and respect confidentiality.
- Practice kindness and empathy!

#### Role of the mentee ✔

- While the mentor will provide guidance, feedback and advice, it is up to the mentee to take responsibility for the activation of their chapter.
- Be proactive in initiating contact with your mentor and asking for feedback and advice.
- Stick to your mutually agreed contact commitments. We understand that sometimes things get in the way - if they do, please communicate to your mentee or R-Ladies point of contact in advance.
- Be willing to listen and learn.
- Ensure that confidentiality is maintained.
- Practice kindness and empathy!

## Mentoring agreement 🤝

_By signing on participating in the mentoring program you agree to the following:_

1. **Abide by [R-Ladies’ Code of Conduct](https://rladies.org/coc/) in all activity and interactions** you have within the mentoring program. If at any moment, the mentor or mentee feel uncomfortable, or any issues arise, we offer two channels of resolution:

   (a) **The relationship between mentor and mentee does not work**. There could be many causes for this to happen (e.g. breakdown in communication, or lack of engagement from one party). In this case, the mentor and/or mentee should talk to their R-Ladies point of contact. The mentor and/or mentee can decide to (1) quit the program or, in the case of the mentee, (2) ask for a new mentor. We won't explicitly ask you why you think the relationship did not work, but we do encourage you fill out the feedback form.


   (b) **There was a violation of the [Code of Conduct](https://rladies.org/coc/)**. In this case, please follow our [reporting guidelines](https://rladies.org/coc/#reporting)), and don’t hesitate to reach out to any member of the team. You can also email us at reporting@rladies.org for support or discussion. Relevant measures will be taken for the resolution of the case.

2. **The mentor and mentee should discuss and decide if they would like to speak publicly of their participation in the program.** If confidentiality is desired by either party, their privacy should be respected. R-Ladies will not share any information about program participation without consent from **both** the mentor and the mentee.
3. If the mentoring is successful, R-Ladies could ask the mentor and the mentee if they want to share the good news (e.g. on R-Ladies Twitter account and R-Ladies webpage). **Mentors and mentees could are both fully within their rights to refrain from sharing their identity in public.** If they refuse, R-Ladies just will advertise the activation of a new chapter due to the mentoring program without mentioning anyone involved explicitly. **If for any reason the mentoring is not successful, confidentiality would be required** no matter what the mentor and mentee had agreed to, in order to protect both parties.
