---
title: "Meetup account management"
linkTitle: "Meetup"
weight: 35
---

## Goal

The goal of this activity is to create and monitor chapters on the meetup.com
platform. The person in charge needs to be able to commit a few hours weekly.
Ideally, this will become a team of at least 2 people, to split the workload
and guarantee requests are addressed any time of the year.

## What to do

- Monitor the notifications of \@rladies/meetup-pro on GitHub.
  You were added to that team during your onboarding process to R-Ladies
  Global. The Chapter Onboarding team will mention \@rladies/meetup-pro
  in the issue of the [new-chapters-onboarding repository](https://github.com/rladies/new-chapters-onboarding/issues) where the
  prospective chapter is being created.
- When a request is made, activate a
  new meetup group for the chapter following the instructions in [Appendix A](#appendix-a-new-meetupcom-page-template). During your onboarding
  process you were granted the necessary credentials.

- Once the chapter is activated on meetup.com, let the organiser know
  via a DM on Slack. The Chapter Onboarding team will let you know the
  name of the organizer(s). You can also find that information in the
  email where the request to open the chapter was made (emails to `chapters@rladies.org` are forwarded to your rladies.org email account).
  See [Appendix B](#appendix-b-message-template) for
  a message template (make sure you adapt the template with the correct
  name of the chapter).

- The organiser is expected to join the meetup group, so that you can
  make them a co-organiser. In order to do that:

  - Go to the meetup page for the chapter

  - Then click on 'N members' (see red oval shape in the screenshot
    below)

![Screenshot of the meetup page of a chapter where the number of members is written below the location](image4.png)

- In the list, locate the member you want to make a co-organiser and
  click the three dots next to the name

![Screenshot of the organizers list, near every person's name are three dots](image2.png)

- Click 'Change member role'
- Select 'co-organiser' and click on 'Update role'

![Screenshot of the checkboxes for choosing roles](image1.png)

- Post the Meetup url in the issue dedicated to creating the chapter
  on the [new-chapters-onboarding repository](https://github.com/rladies/new-chapters-onboarding/issues). Check the tasks listed
  there, so the Chapter Onboarding team knows when this part
  of the process is ready.

- If any **meetup-related problems** arise, please liaise with
  the R-Ladies dedicated Account Manager for Meetup Pro. You
  will find their email on the Wiki of the [New Chapters Onboarding
  repository](https://github.com/rladies/new-chapters-onboarding/).
  Examples of problems we have experienced:

  - The name of the city is not available in the meetup database
    which prevents us from creating the meetup page. Sometimes,
    you have to check spelling in different languages. If that
    does not work, our Account Manager will be able to add the
    city to the database manually.

  - If you are trying to **re-activate a chapter that was previously
    retired**, meetup won't allow you to use the standard string
    for the chapter's url (rladies-cityname). In this case you should
    contact our Account Manager. If you have already created a new page,
    please ask them to change the custom address to the standard
    rladies-cityname.

- Periodically **monitor content on meetup**:

  - Things to check:

    - Every chapter has at least one co-organiser (if there are no
      co-organisers, let the leadership know as this chapter
      will need to retire)

    - No cis-men should be made co-organisers or assistant
      organizer.

    - Make sure people do not abuse the R-Ladies org. For instance,
      please check that chapters are not run by companies
      under the hood.

  - If there are any problems, please contact the organiser to ask
    for clarification. If the situation cannot be sorted in a
    friendly way, then report to the leadership team
    on the #team-global channel, and we will help you find a way
    forward. If you are not sure about something (e.g., the chapter
    content is in a language you don't speak), please seek for
    advice onn the #team-global channel.

- **Delete chapter pages if necessary**.

  - The Chapter Monitoring Team will periodically provide you with the
    list of inactive chapters to retire.

  - A chapter page on meetup will need to be deleted if the chapter is
    not following R-Ladies mission and guidelines (e.g. is run by a
    company, charges for events, etc).

- **Keep the record on GitHub always up-to-date**
  (<https://github.com/rladies/rladies.github.io/tree/main/data/chapters>).
  This means adding new chapters to the list, or changing their
  status from Prospective to Active or from Active to Retired.

### Appendix A: New meetup.com page template

#### Step1: What\'s your new Meetup Group\'s hometown?

**City, Country (ISO2 Code)**

#### Step 2: What will your Meetup be about?

Meetup doesn't always show the same categories. But usually Technology or
Data Science are displayed. You will be able to add R related topics in one of the steps below.

**Category: Technology or Data Science**

#### Step 3: What will your Meetup\'s name be?

Name: **R-Ladies City**.

By default meetup will create a page
with this URL `https://www.meetup.com/R-Ladies-City/` (e.g., R-Ladies Lima will create `https://www.meetup.com/R-Ladies-Lima/`).
This URL will be changed in one of the steps below.

#### Step 4: Describe who should join, and what your Meetup will do.

```markdown
This is a local chapter of R-Ladies Global (https://www.rladies.org), an organisation that promotes gender diversity in the R community worldwide. We meetup in person or virtually to learn about the R programming language, algorithms and advanced tools.

R-Ladies welcomes members of all R proficiency levels, whether you're a new or aspiring R user, or an experienced R programmer interested in mentoring, networking & expert upskilling. Our community is designed to develop our members' R skills & knowledge through social, collaborative learning & sharing. Supporting minority identity access to STEM skills & careers, the Free Software Movement, and contributing to the global R community!

We are pro-actively inclusive of queer, trans, and all minority identities, with additional sensitivity to intersectional identities. Our priority is to provide a safe community space for anyone identifying as a minority gender who is interested in working with R. As a founding principle, there is no cost or charge to participate in any of our R-Ladies communities around the world. You can access our presentations, R scripts, and Projects on our Github account (https://github.com/rladies) and follow us on Mastodon (https://hachyderm.io/@RLadiesGlobal) to stay up to date about R-Ladies news!

Make sure you read and comply with our code of conduct (https://rladies.org/coc/) and community guidelines (https://guide.rladies.org/about/mission/#r-ladies-rules--guidelines).

Please note that by taking part in an R-Ladies event you grant the community organizers full rights to use the images resulting from the photography/video filming/media, and any reproductions or adaptations of the images for publicity, fundraising or other purposes to help achieve the community's aims. This might include (but is not limited to), the right to use them in their printed and online publicity, social media, press releases and funding applications. If you do not wish to be recorded in these media please inform a community organizer.
```

**Done!**
The message "Your group is in review" will show up. In the meantime you can
customize the group.

#### Step 5: Customise group

- **Short bio:** R-Ladies is a world-wide organization to promote
  gender diversity in the R community (https://rladies.org/).

- **Organizer profile photo:** Add [this one](https://github.com/rladies/branding-materials/blob/main/logo/R-LadiesGlobal_RBG_online_LogoOnly.png).

- **Welcome message:** Hello and welcome to R-Ladies!

- **From the group's home page click on: Manage Group > Edit Group Settings and
  select the 'Basic Information' tab**

  - **Custom member label:** R-Ladies

  - **Custom address:** meetup.com/rladies-cityname.
    If the city name has more than one word, separate them with a `-`
    (e.g. R-Ladies Sao Paulo gets rladies-sao-paulo)

  - Topics: Add "R Project for Statistical Computing" and "Data Science using R".
    Organizers can add other relevant topics later.

  - Social Media:

    - Add R-Ladies Mastodon account on the "Other" category: https://hachyderm.io/@RLadiesGlobal

    - LinkedIn: https://www.linkedin.com/company/rladies/

- Save, then go Back to group settings and **select the 'Optional
  features' tab:**

  - Change mailing list to match urlname: rladies-cityname

  - In **Mailing list**,

    - select 'Allow all members to send messages'

    - Your mailing list address must be unique:
      rladies-cityname

### Appendix B: Message template

**This message has markdown formatting.** In order to be able to copy paste it and keep the formatting on Slack, you need to ensure that markdown is enable (by default it is not). On the R-Ladies Slack, you need to go to _Preferences_ > _Advanced_ and select _Format messages with markup_.

**Message the organiser with basic info:**

```markdown
Hi and welcome to R-Ladies!

Your chapter is set up on Meetup:

- Link: ADD MEETUP LINK

Things to keep in mind/to know:

- Please visit the website and click on the button "Join Group". Let me know when you become a member of the group, so that I can make you an organizer with full admin rights. The page contains some standard text in English that you can customise or translate.

- Once your meetup group is established, please hold your first event within the next 6 months. After that, please keep your chapter active with at least one event every 6 months. For comparison, many chapters do an event every 2-3 months and some chapters do monthly events. If you find yourself struggling with the 6 months frequency, you can seek for advice in the #organizers channel on Slack or you can join our Mentoring Program.

- Every time you run an event publish it into your chapter Meetup account. This will keep the chapter active. Only events published on Meetup are considered as chapter activity (because these are the ones we can keep track of).
- The R-Ladies Guide has a whole [section about organizing events](https://guide.rladies.org/organization/events/general/). There, you'll find useful information, such as tips for planning and promoting events, instructions for using the R-Ladies Zoom account, etc.
- The [RLadies Guide](https://guide.rladies.org/organization/tech/brand/) also has a section about our branding materials, like official logos, color palettes, presentation templates, stickers, etc.

- When there is any change in your group (e.g., create social media accounts, etc) please, update the info here: https://github.com/rladies/rladies.github.io/tree/main/data/chapters. This is the place where the chapter info is stored so make sure it is up to date.

- If needed, we can create a GitHub repo for your chapter on the R-Ladies GitHub Organization. You can request it in the #new-chapters channel.

- Please remember that the R-Ladies Organizers Slack is our prefered channel of communication.

Regarding adding new organizers to your chapter:

- Probably in the next few weeks/months new organizers will be joining your team. There is a section in the [R-Ladies Guide](https://guide.rladies.org/organization/intro/co-organizers/#how-to-onboard-organizers) with all the information you need to know about how to onboard them. This the only official way to add a co-organizer

If you have any questions, please do not hesitate to contact us. The #organizers channel on Slack is also a great place to seek for advise.

**Thank you for being part of the R-Ladies community!**
```
