---
title: "R-Ladies community slack"
menuTitle: "Community slack"
weight: 55
---

R-Ladies is a global organisation that aims to [promote gender diversity in the R community](/about/mission). 

To facilitate communication and enable networking in a safe environment among all R-Ladies worldwide, we set up a Slack workspace. It allows R-Ladies members to have a safe and global space to discuss within public channels rstats news, packages, community ideas, aiming to create an awesome sharing culture and network of R-Ladies around the world. An additional objective is to re-focus the original ([organizers' slack](/tech/accounts/#slack)) R-Ladies Slack to be for chapter organisers only so we as a global team and other organisers can help organise and coordinate R-Ladies activities. 



## For whom is this Slack?

This Slack is for people that identify as a woman or gender minority and are interested in the R programming language. 

If you are a cis-male (you were born male, and you also identify as male), please [do not sign up](/ally).

### Why is this Slack for women and gender minorities only? 

The mission of R-Ladies is to increase gender diversity in the R community. One way to achieve this, is, to provide a safe space where genders currently underrepresented in the R community feel at ease to exchange and collectively progress. We believe that by offering such a safe space, we can contribute to a harassment-free, welcoming, friendly and safe community. 
 
###  Does this also mean that R-Ladies meetups are for women and gender minorities only? 

Most R-Ladies chapters have the policy that organisers and presenters are women or gender minorities, but welcome allies to participate in meetups as guest. Each chapter has a contact email address and we encourage you to contact the meetup organisers if something is unclear. 


## What should and can you do on this Slack?

In principle anything that contributes to a friendly and welcoming community.  

Here are a few examples:

* Ask and answer questions
* Share your achievements
* Look for and share job opportunities
* Advertise events and conferences
* Share #rstats news
* Share resources
* Bring in your ideas for the R-Ladies community

## What is this Slack not?

There are a few things this Slack is not meant for:

* Promoting commercial products (if you would like to provide a discount to R-Ladies members, please discuss with the leadership team first).
* Sharing inappropriate content. Examples are disturbing images or videos, fashions that promote negative values, health risks or bad habits, false information, offensive or mocking content.

If you are unsure whether a post is suitable, best is to ask the Community Management Team within Slack (`@Community Management Team`) or send an email at `slack@rladies.org`.

## How to sign up?

Go to the [sign-up link](https://rladies.org/form/community-slack/).

## Gender neutral language

We would like to encourage gender-neutral language in this Slack. Please avoid addressing people as "ladies" or "guys". You can use expressions as "folks", "y'all", "everyone", "everybody", "friends" or "pals"  instead.

There are plenty of reasons for a preference of being addressed in a gender-neutral way and we would like to respect that.

## Code of Conduct

Refer to R-Ladies [Code of Conduct](/about/coc/), and more specifically, we ask you to:

* **Not share anything that was shared on Slack outside this Slack**. If you want to share any content, please ask the person involved for their consent.
* Avoid overtly sexual or offensive usernames or profile photos which might detract from a friendly, safe and welcoming environment for all.

### Reporting

If you are being harassed by a member/guest/participant of/at R-Ladies, notice that someone else is being harassed, or have any other concerns, please contact the Global Leadership Team via `reporting@rladies.org`.

If a participant engages in harassing behaviour, the Global Leadership Team may take any action they deem appropriate.

### Consequences

Participants asked to stop any harassing behaviour are expected to comply immediately. If a participant engages in harassing behaviour, the Global Leadership Team may take any action they deem appropriate, up to and including expulsion from all R-Ladies spaces (including meetups, Twitter, Slack, mailing lists, both online and offline) and identification of the participant as a harasser to other R-Ladies members or the general public.

## Contact

If you have a question regarding R-Ladies Community Slack please contact `slack@rladies.org`.

If you are interested in starting an R-Ladies chapter in your city (awesome!), refer to [organizers' get started guidance](/organization/intro/get-started/).

If you would like to report harassment or violation of parts of the [Code of Conduct](/about/coc/), please contact `reporting@rladies.org`.

Within Slack you can contact us via `@Community Management Team`.

## Guidelines for community management

**If you're a volunteer taking care of the community slack, thank you!**

We enjoy the organiser community and hope this slack can serve as a model for the R-Ladies Community Slack. Things we think work well:

* Please ensure that people feel welcome and encourage them to introduce themselves.
* Keep conversations focused: not too much off-topic chat in the “wrong” channel.  This will help people fine-tune their channel subscriptions so that they neither miss out on relevant conversation (because it’s happening in the “wrong” channel) nor see too many messages which are not directly relevant to them.  Consider opening a new channel if too much “offtopic” happens with recurrent themes. Remember that there is always #random.
* Prevent conversation from getting too fragmented, i.e., close or combine channels, so that we have fewer channels with an empty history and that we don’t have an overwhelmingly long list of channels.
* Encourage people to use threads, if possible.
* Ensure that the code of conduct is respected. 
* Discourage the use of @channel - @here is an alternative which only notifies people whose status is set to active
* Give guidance on how to use Slack if required (in #how_to_slack)

