---
title: "International Women's Day Campaign"
menuTitle: "International Women's Day Campaign"
weight: 120
---

Although R-Ladies mission is not limited to women but instead to all Underrepresented/Minority Genders, we have used [International Women's Day](https://en.wikipedia.org/wiki/International_Women%27s_Day) as the occasion to run campaigns, until 2020 of Twitter. 

The goals of this chapter is to document our previous efforts for folks who might want to lead future campaigns. We hope to:

* Interest more people who want to join the R-Ladies project.
* Explain how you can collaborate.
* Collect more ideas for future campaigns.
* Inspire other types of local or regional chapter campaigns.
* Inspire campaigns from other communities.

## Information about previous campaigns

* [Behind the scenes of R-Ladies IWD2018 Twitter action!](https://rladies.org/blog/conclusion/) -- tweets featuring all R-Ladies from the R-Ladies directory. Take-home message: sign up in our directory.

* [IWD 2019 Twitter Action](https://rladies.org/blog/2019-03-25-blog_iwdtwitter_2019/) -- tweets featuring all R-Ladies chapters. Take-home message: how to create an R-Ladies chapter.

* IWD 2020 had [tweets featuring R-Ladies lessons](https://github.com/rladies/IWD#catalog-the-meetup-material-in-github-from-the-chapters-and-tweet-this-material-during-the-campaign). [Shiny app](https://yabellini.shinyapps.io/RLadiesLesson/). Take-home message: share and re-use (depending on the licence) materials from R-Ladies meetups.

     
## Other ideas for future campaigns

* Make a list of blogs (and posts) by R-Ladies, and tweet this material on March 8.
* Make a list of packages built for/by R-Ladies and post this during the campaign.


## Infrastructure

The only "infrastructure" of the IWD campains is the [`rladies_iwd`](https://twitter.com/rladies_iwd) Twitter account. 
It is linked to `iwd@rladies.org`.

## How to launch a new campaign?

### For R-Ladies

Discuss it in the Slack, and if the global team gives you their ok, ask for access to the Twitter account.

### In all cases

* Have a clear goal for the campaign that aligns with your mission.
* Having a separate account for the content might be less "annoying" for folks who e.g. do not want to see hundreds of tweets in a day.
* Not that we have done this but try to diversify communication channels.
* Use automation and test it. Sometimes though for some aspects doing it manually might be quicker and there's no prize for doing everything the hard way.
* Have a _team_ of volunteers.
* Prepare communication for before the campaign (here's what we going to communicate about and why) and after the campaign (what's your take-home message and where to re-read the content in another form, if relevant).
* Use best practice for planning the project (e.g. have a clear list of tasks).
* If using content or pictures by or of other people ask for their permission first!