---
title: "R-Ladies Directory"
menuTitle: "Directory"
weight: 110
---

R-Ladies Global manages a global directory of R-Ladies.
R-Ladies follow instructions on the [website](https://rladies.org/directory/) to input their data (at the moment of writing, a form or an email).
Volunteers in charge of managing it edits data, at the moment in WordPress (soon in another format).
Work (which entries need editing, etc.) is managed via a private spreadsheet.

## Some instructions for directory volunteers

### Login
https://rladies.org/wp-login.php

### How to add a new country

1. Charts & Maps > Maps > edit Speaker Map and add JSON entry to list for new country using ISO country code (e.g. South Africa = ZA)
2. Connections > Categories > add new country as a category and record ID number for step 3
3. Pages > add new page for country will need url from step 1 and ID number from step 2, in body of page add: [connections category_in=XX] where XX is the ID number from step 2
4. Add new R lady and check that she shows up on the R Ladies Global map

### Request about new chapters
To start a new chapter, contact:
chapters@rladies.org

### Updating Deadnames

When updating an existing R-Ladies member directory profile, we usually edit the entry but this will not fix the URL. As a result, the [deadname](https://www.huffpost.com/entry/deadnaming-a-trans-person-is-violenceso-why-does_b_58cc58cce4b0e0d348b3434b) will still appear in the URL for the directory entry. Therefore, when requested to remove a deadname in an existing directory entry, we will need to completely delete the old entry and add the entry as a new entry. This will create a new URL with the updated name.

### Misc

- write out countries but not states, leave states as initial (e.g. NY)
- All degrees go in suffix without comma NOT prefix (so Dr. —-> PhD); the format is ", [degree]" where [degree] can be "BA", "BS", "MA", "MS" (note not "MSc"), "PhD", "MD"
- The order and style for "Biographical Info" is:
R-Groups: [including R-Ladies chapters]
R-Packages:
Interests:
Contact method:
[other comments]

## Email templates

### Template for More Info

Subject:

```
Response Requested: Additional Information Needed to Complete Your R-Ladies Global Directory Entry
```

Body:

```
Dear XXXX,

Thank you for adding your contact information to the R-Ladies Global directory! You've indicated that you'd like to be a speaker so please respond to this email with a preferred contact method (e.g., Twitter, LinkedIn, personal website link). To protect your privacy, we cannot accept personal email addresses or phone numbers.

All the best,
XXXX
R-Ladies Global Communications Team
```

### Template for Slack Channel Info

```
Dear XXXX,

Thanks so much for adding your name to the R-Ladies Global directory! 
If you're interested and are not already a member, please feel free to join our R-Ladies Global Community Slack. 
You can sign up using the [Community sign-up form](https://rladies.org/form/community-slack/). 
It's a fun and welcoming space to meet other members of R-Ladies Global, talk about how awesome R is, and ask R questions.

All the best,
XXXX
R-Ladies Global Communications Team

```
