---
title: "Global Team"
weight: 2
---


## About

The R-Ladies Global Team is comprised of the 

* the Leadership Team, who are officially on the Board of Directors for the 
non-profit organization.

* various smaller teams critical to operations that support chapter activity
and global presence.

A description of the members and roles of the Global Team is at <https://rladies.org/about-us/global-team/>. 
We do our best to keep this up to date;
however, global team members are regularly on-boarding or off-boarding, and new teams
are being formed, so please keep in mind this might not be an exact
representation.

Global Team members often serve in more than one role as the need arises; for example,
an individual can serve on both the leadership team and the website team.

## Our Values

1. **Diversity and Inclusivity:** Embrace and celebrate the diversity of genders and backgrounds, creating an inclusive environment where everyone feels valued and heard.

2. **Empowerment:** Empower individuals by providing resources, mentorship, and opportunities to develop skills and confidence in R programming, fostering a sense of agency and capability.

3. **Advocacy and Representation:** Advocate for the representation and recognition of underrepresented genders in the R programming community, highlighting their contributions and advocating for equal opportunities.

4. **Community Engagement:** Foster a vibrant community that encourages collaboration, knowledge-sharing, and support among underrepresented genders in R programming, creating a network that uplifts each other.

5. **Education and Accessibility:** Strive to make learning R programming accessible to all, regardless of background or previous experience, by providing free resources, workshops, and educational materials.

6. **Innovation and Creativity:** Encourage innovative thinking and creativity, promoting new ideas, approaches, and perspectives in R programming while encouraging experimentation and exploration.

7. **Transparency and Integrity:** Operate with transparency and integrity in all endeavors, ensuring accountability, honesty, and fairness in decision-making processes and interactions.

8. **Continuous Learning and Growth:** Foster a culture of continuous learning and growth, encouraging personal and professional development within the R programming domain and beyond.

9. **Respect and Support:** Cultivate a supportive environment where respect, empathy, and understanding are paramount, fostering a culture of kindness and support for each other's journeys.

10. **Impact and Sustainability:** Strive for a lasting impact by developing sustainable programs, initiatives, and partnerships that contribute to the long-term growth and success of underrepresented genders in R programming.

## Commitment

As R-Ladies is a purely volunteer run organisation, we respect and encourage your
need to have vacations, free-time and focus on other aspects of your life. The 
hours spent on R-Ladies work should happen when you are truly available to do them. 
We do ask those that are seeking to join the Global Team commit to one year of service 
(of course, we would understand if life interrupts this commitment), and an estimated
weekly time commitment is 1 to 4 hours a week. In addition, the needs of
the specific roles may vary: some volunteers work on a weekly, monthly, or quarterly
basis due to natural workload fluctuations.

If a volunteer needs to temporarily pause their responsibilities for any reason
(e.g., work, health, or vacation) please let the leadership team know so that we
may fill your role during your absence.

If a volunteer is ready to exit the Global Team for any reason, please let the leadership
team know. If you are capable, we would appreciate it if you have the capacity to on-board a new
team member to your role; but if you are unable, we understand.

We suspect that after service over time in a specific role you may be ready to
try a new role, if you wish to continue on the Global Team. If you have reached that
point, please let the leadership team know so that we may re-assign you to role
that aligns with your current interests.

## Communication

Our primary communication channel is Slack, and the common language we communicate
in is English. We hope for Global Team members to regularly check Slack; if the 
team member is not present on Slack, then we require them to be responsive via email.

## Operations

Individual teams within the Global Team may operate relatively independently
from the Global Team or may work more closely with the Global Team. Individual
teams may establish their own work preferences or set their own small team meetings.
In addition, many, but not all, members of the Global Team serve on multiple 
individual teams. Lastly, belonging to a specific team does not mean your contributions
or communications are limited to that team. Individual teams often solicit and
receive feedback or assistance from other members of the Global Team.

## Benefits

By participating in R-Ladies you are helping women and gender minorities 
by creating a safe space to learn, teach, and develop, as well as build
a support network and contacts.

Some of the personal benefits that we think come with joining the global team
and volunteering time are gaining experience in leadership, asynchronous remote work,
international team work, not-for-profit open-source work, and work in gender minority
only team and organization.

Depending on the role, there also may be opportunities for technical upskilling. 
For example, some members of the Global team use R, reproducible reports, 
git/GitHub, GitHub Actions, Hugo website development, and database integrations. 
Knowledge of these tools is not a requirement for selection; the Global team will 
provide training on processes specific to your role.

## Joining the Global Team

The Global Team regularly needs to fulfill roles. This may be accomplished by 
asking on the organizers or community slack if anyone has capacity to fulfill a 
position, via a more formal call for volunteers via a News announcement on the 
R-Ladies website (such as the one from [2023-04-11](https://rladies.org/news/2023-04-11-global-team-recruiting/)),
or via individual volunteers reaching out.

In selecting volunteers, we are looking for demonstrated:
1. alignment with the values of the Global Team, and
2. interaction with the R-Ladies organization.


Potential organizational interactions can include:
* Having an entry in the R-Ladies directory.
* Having attended R-Ladies chapter meet-ups, either online or in person.
* Given a talk for an R-Ladies chapter meet-up.
* Being a current or past R-Ladies chapter organizer.
* Being present (even better, active!) in the R-Ladies community or organizer's slack.
* Contributing a blog post to the website.
* Making a pull request on the website or the guide.
* Other actions that fulfill the mission of R-Ladies.

Alignment with core values is required for entry to the Global Team, in addition
to some (but not all) of the potential organizational interactions.

If you have interest in joining the Global Team, please inform us by completing the [R-Ladies Global Team Volunteer Interest Form](https://airtable.com/appgo0YoQ9oIc6Qa1/pagvJWAClzKUO7Tak/form).

## Contact

If you are an organizer but not in the global team, the quickest way to contact
the leadership team is to use `#help-ask_the_leadership` in the R-Ladies organizer slack.

If you are on Global Team, you can communicate with other other members of the global
team (including the leadership team) on the private `#team-global` channel
in the R-Ladies Organizer slack.

Otherwise, the leadership team can be contacted via email at `info@rladies.org`.

