#ifndef MICROPHYSICS_MATH_H
#define MICROPHYSICS_MATH_H

#include <AMReX.H>
#include <AMReX_REAL.H>

// Override definitions of constants in GCEM to work around lack of support
// on Power9 for long double. We don't use arithmetic > 64 bit anyway.

#define GCEM_LOG_2 0.6931471805599453094172321214581765680755
#define GCEM_LOG_10 2.3025850929940456840179914546843642076011
#define GCEM_PI 3.1415926535897932384626433832795028841972
#define GCEM_LOG_PI 1.1447298858494001741434273513530587116473
#define GCEM_LOG_2PI 1.8378770664093454835606594728112352797228
#define GCEM_LOG_SQRT_2PI 0.9189385332046727417803297364056176398614
#define GCEM_SQRT_2 1.4142135623730950488016887242096980785697
#define GCEM_HALF_PI 1.5707963267948966192313216916397514420986
#define GCEM_SQRT_PI 1.7724538509055160272981674833411451827975
#define GCEM_SQRT_HALF_PI 1.2533141373155002512078826424055226265035
#define GCEM_E 2.7182818284590452353602874713526624977572

#include <gcem.hpp>

#endif
