//Last updated July 2024
//Update notes: 1. the original version of this file used std::pow, which we replaced with a combo of std::exp/std::log wherever possible.
//Update notes: 2. added free-free cooling which was missing from the previous version
//Author: Piyush Sharda (sharda@strw.leidenuniv.nl)


#ifndef actual_rhs_H
#define actual_rhs_H

#include <AMReX_REAL.H>
#include <AMReX_Array.H>

#include <extern_parameters.H>
#include <actual_network.H>
#include <burn_type.H>
#include <jacobian_utilities.H>
#include <extern_parameters.H>

using namespace amrex;
using namespace ArrayUtil;
using namespace network_rp;



AMREX_GPU_HOST_DEVICE AMREX_INLINE
void rhs_specie(const burn_t& state,
             Array1D<Real, 1, neqs>& ydot,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const /*z*/) {

    using namespace Rates;

    Real T = state.T;

    Real x0 = std::exp((-0.75)*std::log(std::abs(T)));

    Real x1 = 2.5950363272655348e-10*X(0)*X(4)*x0;

    Real x2 = 1.3300135414628029e-18*std::exp((0.94999999999999996)*std::log(std::abs(T)))*X(0)*X(5)*std::exp(-0.00010729613733905579*T);

    Real x3 = ((T)*(T));

    Real x4 = T <= 10000.0;

    Real x5 = X(0)*X(6)*((x4) ? (
   -5.5279999999999998e-28*((T)*(T)*(T)*(T)*(T)) + 3.3467999999999999e-23*((((T)*(T)))*(((T)*(T)))) - 7.5474000000000004e-19*((T)*(T)*(T)) - 2.3088e-11*T + 7.3427999999999993e-15*x3 + 4.2277999999999996e-8
)
: (
   0
));

    Real x6 = std::log(T);

    Real x7 = 0.10684732509875319*x6 - 1;

    Real x8 = ((x7)*(x7));

    Real x9 = ((x7)*(x7)*(x7));

    Real x10 = ((((x7)*(x7)))*(((x7)*(x7))));

    Real x11 = ((x7)*(x7)*(x7)*(x7)*(x7));

    Real x12 = std::exp((6)*std::log(std::abs(x7)));

    Real x13 = ((x7)*(x7)*(x7)*(x7)*(x7)*(x7)*(x7));

    Real x14 = std::exp((8)*std::log(std::abs(x7)));

    Real x15 = ((x7)*(x7)*(x7)*(x7)*(x7)*(x7)*(x7)*(x7)*(x7));

    Real x16 = X(2)*X(3);

    Real x17 = x16*((T <= 1160.0) ? (
   1.4643482606109061e-16*std::exp((1.78186)*std::log(std::abs(T)))
)
: (
   3.3178155742407614e-14*std::exp((1.1394493358416311)*std::log(std::abs(T)))*std::exp(-10.993097527150175*x10 + 14.449862906216714*x11 + 58.228375789703179*x12 - 162.59852239006702*x13 + 144.55426734953477*x14 - 44.454280878123605*x15 - 12.447178055372778*x8 + 6.9391784778399117*x9)
));

    Real x18 = X(1)*X(3);

    Real x19 = 1.0e-8*std::exp((-0.40000000000000002)*std::log(std::abs(T)))*x18;

    Real x20 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    Real x21 = X(3)*X(5);

    Real x22 = x20*x21;

    Real x23 = X(0)*X(2);

    Real x24 = 1.4000000000000001e-18*std::exp((0.92800000000000005)*std::log(std::abs(T)))*x23*std::exp(-6.1728395061728397e-5*T);

    Real x25 = X(0)*X(12);

    Real x26 = 3.8571873359681582e-209*std::exp((43.933476326349997)*std::log(std::abs(T)))*x25*std::exp(-5902.1601240760483*x10 + 5825.9326359379538*x11 - 3578.1439181805954*x12 + 1242.7294446825149*x13 - 186.35635455381879*x14 - 1618.789587733125*x8 + 3854.4033653120223*x9);

    Real x27 = 3.7903999274394518e-18*std::exp((2.360852208681)*std::log(std::abs(T)))*X(0)*X(3)*std::exp(-258.18559308467115*x10 + 846.15238706523724*x11 - 1113.0879095147111*x12 + 671.95094388835207*x13 - 154.90262957142161*x14 - 24.766609674457612*x8 + 13.307984239358756*x9);

    Real x28 = std::sqrt(T);

    Real x29 = 1.0/x28;

    Real x30 = X(0)*x29;

    Real x31 = 5.7884371785482823e-10*X(11)*x30*std::exp((-1.7524)*std::log(std::abs(0.00060040841663220993*x28 + 1.0)))*std::exp((-0.24759999999999999)*std::log(std::abs(0.32668576019240059*x28 + 1.0)));

    Real x32 = 1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)));

    Real x33 = 8.6173430000000006e-5*T;

    Real x34 = 1.0/T;

    Real x35 = -4.3524079114767552e-117*std::exp((23.915965629999999)*std::log(std::abs(T)))*X(0)*X(13)*std::exp(-4361.9927099007555*x10 + 4879.7345146260486*x11 - 3366.4639698826941*x12 + 1300.3028484326148*x13 - 214.82451513312137*x14 - 941.91483008144996*x8 + 2506.9866529060901*x9) + x25*((x33 <= 9280.0) ? (
   x32
)
: (
   1250086.112245841*std::exp((-1.5)*std::log(std::abs(T)))*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661*x34))*std::exp(-469943.50750964211*x34) + x32
));

    Real x36 = -5.9082438637265071e-70*std::exp((13.536555999999999)*std::log(std::abs(T)))*x23*std::exp(-2207.4643501257692*x10 + 2500.8077583366976*x11 - 1768.8867461266502*x12 + 704.19926629500367*x13 - 120.0438480494693*x14 - 502.72883252679094*x8 + 1281.477767828706*x9) + X(0)*X(1)*((x33 <= 5500.0) ? (
   x32
)
: (
   3.2867337024382687e-10*std::exp((-0.72411256578268512)*std::log(std::abs(T)))*std::exp(-2.4649195146505534*x10 - 1.020773727011937*x11 + 3.3530579587656564*x12 + 3.6203127646377791*x13 - 1.0930705283186732*x14 - 1.6921001126637107*x15 - 1.774686809424741*x8 - 1.951835616513679*x9)
));

    Real x37 = 7.1999999999999996e-8*X(9)*x30;

    Real x38 = X(2)*X(7);

    Real x39 = x20*x38;

    Real x40 = x16*(1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T))))/(0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0);

    Real x41 = X(0)*X(8);

    Real x42 = 35.5*std::exp((-2.2799999999999998)*std::log(std::abs(T)))*x41*std::exp(-46707.0*x34);

    Real x43 = x37 - x39 - x40 + x42;

    Real x44 = M_LN10;

    Real x45 = 1.0/x44;

    Real x46 = x45*x6;

    Real x47 = std::exp((-0.12690000000000001*std::exp((-3.0)*std::log(std::abs(x44)))*((x6)*(x6)*(x6)) + 1.1180000000000001*std::exp((-2.0)*std::log(std::abs(x44)))*((x6)*(x6)) - 1.5229999999999999*x46 - 19.379999999999999)*std::log(std::abs(10.0)));

    Real x48 = X(1)*X(5);

    Real x49 = x47*x48;

    Real x50 = x18*((T >= 10.0 && T <= 100000.0) ? (
   -7.7700000000000002e-13*T + 2.5000000000000002e-10*x28 + 2.96e-6*x29 - 1.73e-9
)
: (
   0
));

    Real x51 = 1.0000000000000001e-9*X(1)*X(10)*std::exp(-457.0*x34);

    Real x52 = ((x6)*(x6));

    Real x53 = std::exp((-2)*std::log(std::abs(x44)));

    Real x54 = x52*x53;

    Real x55 = 8.4600000000000008e-10*x46 - 1.3700000000000002e-10*x54 + 4.1700000000000001e-10;

    Real x56 = ((x6)*(x6)*(x6));

    Real x57 = x56/((x44)*(x44)*(x44));

    Real x58 = X(1)*X(2)*((T < 30) ? (
   3.4977396723747635e-20*std::exp((-0.14999999999999999)*std::log(std::abs(T)))
)
: (
   std::exp((-3.194*x46 + 1.786*x52*x53 - 0.2072*x57 - 18.199999999999999)*std::log(std::abs(10)))
));

    Real x59 = 6.0e-10*X(2)*X(6);

    Real x60 = ((((x6)*(x6)))*(((x6)*(x6))));

    Real x61 = ((x6)*(x6)*(x6)*(x6)*(x6));

    Real x62 = X(1)*X(8)*((T >= 100.0 && T <= 30000.0) ? (
   (-1.4491368e-7*x52 + 3.4172804999999998e-8*x56 + 3.5311931999999998e-13*((x6)*(x6)*(x6)*(x6)*(x6)*(x6)*(x6)) - 1.8171411000000001e-11*std::exp((6)*std::log(std::abs(x6))) + 3.3735381999999997e-7*x6 - 4.7813727999999997e-9*x60 + 3.9731542e-10*x61 - 3.3232183000000002e-7)*std::exp(-21237.150000000001*x34)
)
: (
   0
));

    Real x63 = -x59 + x62;

    Real x64 = x19 + x58 + x63;

    Real x65 = 6.3999999999999996e-10*X(2)*X(9);

    Real x66 = -x65;

    Real x67 = std::exp((-0.5)*std::log(std::abs(T)));

    Real x68 = X(7)*x67;

    Real x69 = 7.9674337148168363e-7*X(1)*x68;

    Real x70 = X(1)*X(13)*((x4) ? (
   1.26e-9*x0*std::exp(-127500.0*x34)
)
: (
   4.0000000000000003e-37*std::exp((4.7400000000000002)*std::log(std::abs(T)))
));

    Real x71 = std::exp((0.25)*std::log(std::abs(T)));

    Real x72 = 2.8833736969617052e-16*X(12)*X(2)*x71;

    Real x73 = T >= 50.0;

    Real x74 = x48*((x73) ? (
   2.0000000000000001e-10*std::exp((0.40200000000000002)*std::log(std::abs(T)))*std::exp(-37.100000000000001*x34) - 3.3099999999999998e-17*std::exp((1.48)*std::log(std::abs(T)))
)
: (
   0
));

    Real x75 = X(2)*X(4);

    Real x76 = x75*((x73) ? (
   2.0299999999999998e-9*std::exp((-0.33200000000000002)*std::log(std::abs(T))) + 2.0600000000000001e-10*std::exp((0.39600000000000002)*std::log(std::abs(T)))*std::exp(-33.0*x34)
)
: (
   0
));

    Real x77 = x74 - x76;

    Real x78 = x36 + x66 + x69 + x70 - x72 + x77;

    Real x79 = 4.9999999999999996e-6*X(3)*X(6)*x29;

    Real x80 = ((X(2))*(X(2))*(X(2)));

    Real x81 = 1.0/x71;

    Real x82 = 1.0e-25*X(2)*X(5);

    Real x83 = X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9);

    Real x84 = -133.82830000000001*x34 - 4.8909149999999997*x45*x6 + 0.47490300000000002*x54;

    Real x85 = std::exp(-0.0022727272727272726*T);

    Real x86 = std::exp(-0.00054054054054054055*T);

    Real x87 = -2.0563129999999998*x85 + 0.58640729999999996*x86 + 0.82274429999999998;

    Real x88 = -69.700860000000006*x45*std::log(40870.379999999997*x34 + 1.0) + 4.6331670000000003*x57;

    Real x89 = std::exp((-23705.700000000001*x34 - 2080.4099999999999*x34/(std::exp((x87)*std::log(std::abs(std::exp((-x84 - 13.656822)*std::log(std::abs(10.0)))*x83))) + 1.0) - 68.422430000000006*x46 + 43.20243*x52*x53 - x88 - 178.4239 - (19.734269999999999*x45*std::log(16780.950000000001*x34 + 1.0) - 14.509090000000008*x46 + 37.886913*x52*x53 - x88 - 307.31920000000002)/(std::exp((x87)*std::log(std::abs(std::exp((-x84 - 14.82123)*std::log(std::abs(10.0)))*x83))) + 1.0))*std::log(std::abs(10.0)));

    Real x90 = 743.05999999999995*x34 - 2.4640089999999999*x45*x6 + 0.19859550000000001*x54;

    Real x91 = 2.9375070000000001*x85 + 0.23588480000000001*x86 + 0.75022860000000002;

    Real x92 = -21.360939999999999*x45*std::log(27535.310000000001*x34 + 1.0) + 0.25820969999999999*x57;

    Real x93 = std::exp((-21467.790000000001*x34 - 1657.4099999999999*x34/(std::exp((x91)*std::log(std::abs(std::exp((-x90 - 8.1313220000000008)*std::log(std::abs(10.0)))*x83))) + 1.0) + 42.707410000000003*x45*x6 - 2.0273650000000001*x54 - x92 - 142.7664 - (70.138370000000009*x45*x6 + 11.28215*x45*std::log(14254.549999999999*x34 + 1.0) - 4.7035149999999994*x54 - x92 - 203.11568)/(std::exp((x91)*std::log(std::abs(std::exp((-x90 - 9.3055640000000004)*std::log(std::abs(10.0)))*x83))) + 1.0))*std::log(std::abs(10.0)));

    Real x94 = X(2)*X(8);

    Real x95 = 5.0000000000000004e-32*x67 + 1.5e-32*x81;

    Real x96 = ((X(2))*(X(2)))*X(8);

    Real x97 = x47*x75;

    Real x98 = 1.0/(std::exp((1.3*x45*(x6 - 9.2103403719761836) - 137.42519902360013*x53*((0.10857362047581294*x6 - 1)*(0.10857362047581294*x6 - 1)) - 4.8449999999999998)*std::log(std::abs(10.0)))*x83 + 1.0);

    Real x99 = ((X(8))*(X(8)))*std::exp((x98)*std::log(std::abs(1.1800000000000001e-10*std::exp(-69500.0*x34))))*std::exp((1.0 - x98)*std::log(std::abs(8.1250000000000003e-8*x67*(1.0 - std::exp(-6000.0*x34))*std::exp(-52000.0*x34))));

    Real x100 = std::exp((0.34999999999999998)*std::log(std::abs(T)))*x41*std::exp(-102000.0*x34);

    Real x101 = X(5)*X(8)*((T <= 1167.4796423742259) ? (
   std::exp((5.8888600000000002*x46 + 7.1969200000000004*x54 + 2.2506900000000001*x57 - 56.473700000000001 - 2.1690299999999998*x60/((((x44)*(x44)))*(((x44)*(x44)))) + 0.31788699999999998*x61/((x44)*(x44)*(x44)*(x44)*(x44)))*std::log(std::abs(10)))
)
: (
   3.1699999999999999e-10*std::exp(-5207.0*x34)
));

    Real x102 = X(10)*X(2)*((T > 200.0) ? (
   5.25e-11*std::exp(-4430.0*x34 + 173900.0/x3)
)
: (
   0
));

    Real x103 = x101 - x102;

    Real x104 = 6.1739095063118665e-10*std::exp((0.40999999999999998)*std::log(std::abs(T)));

    Real x105 = x104*x21;

    Real x106 = x104*x38;

    Real x107 = x105 - x106;

    Real x108 = x107 + x17 - x24 + x27;

    Real x109 = x80*(2.0000000000000002e-31*x67 + 6.0000000000000001e-32*x81) + x94*(-x89 - x93);

    Real x110 = x40 - x42 + x79;

    Real x111 = 9.8726896031426014e-7*X(4)*x68;

    Real x112 = -x51;

    Real x113 = -x55;

    Real x114 = -x37 + x49;

    Real x115 = x103 + x22 + x82;

    Real x116 = X(4)*X(8);

    Real x117 = x26 - x31;

    Real x118 = x35 - x70 + x72;

    ydot(1) = -x1 + x17 + x19 - x2 + x22 - x24 + x26 + x27 - x31 - x35 - x36 - x43 - x5;

    ydot(2) = X(4)*X(8)*x55 - x49 - x50 - x51 - x64 - x78;

    ydot(3) = 8.7599999999999997e-10*x100 + x103 + x108 + x109 + x43 + 2*x5 + 2*x50 - x58 + x63 + x78 + x79 + x80*(-6.0000000000000005e-31*x67 - 1.8e-31*x81) - x82 + x94*(3*x89 + 3*x93) - x95*x96 - x97 + 2*x99;

    ydot(4) = -x108 - x110 - x19 - x22 - x50;

    ydot(5) = X(4)*X(8)*x113 - x1 - x111 - x112 + x74 - x76 - x97;

    ydot(6) = 1.9745379206285203e-6*X(4)*X(7)*x67 + x1 - x107 - x114 - x115 - x2 + x69 - x77;

    ydot(7) = -x5 + x64 - x79;

    ydot(8) = x105 - x106 - x111 + x2 - x39 - x69;

    ydot(9) = -4.3799999999999999e-10*x100 - x101 + x102 + x109 + x110 + x113*x116 + x51 + x59 - x62 + x95*x96 + x96*(-2.5000000000000002e-32*x67 - 7.5000000000000001e-33*x81) - x99;

    ydot(10) = x114 + x66 + x97;

    ydot(11) = x112 + x115 + x116*x55 + x39 + x65;

    ydot(12) = x117;

    ydot(13) = -x117 - x118;

    ydot(14) = x118;



}

AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real rhs_eint(const burn_t& state,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const z) {

    using namespace Rates;

    Real T = state.T;
        Real x0 = 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9);

    Real x1 = 1.0/x0;

    Real x2 = std::sqrt(T);

    Real x3 = X(1) + X(12) + X(4);

    Real x4 = 1.0/T;

    Real x5 = 2.73*z + 2.73;

    Real x6 = T <= 10;

    Real x7 = X(0)*X(12);

    Real x8 = ((x6) ? (
   1.0/10.0
)
: (
   x4
));

    Real x9 = std::sqrt(T);

    Real x10 = ((x6) ? (
   std::sqrt(10)
)
: (
   x9
));

    Real x11 = 1.0/(0.0031622776601683794*x10 + 1.0);

    Real x12 = X(0)*x11;

    Real x13 = X(2)*x12;

    Real x14 = X(0)*x10*((x6) ? (
   0.63095734448019325
)
: (
   std::exp((-0.20000000000000001)*std::log(std::abs(T)))
))/(6.3095734448019361e-5*((x6) ? (
   5.011872336272722
)
: (
   std::exp((0.69999999999999996)*std::log(std::abs(T)))
)) + 1.0);

    Real x15 = 1.0/x2;

    Real x16 = X(10) + X(2) + X(3) + X(9);

    Real x17 = X(1) + 2.0*X(6) + 2.0*X(8) + x16;

    Real x18 = 1.0/(1000000.0*x15/(x17*(1.6000000000000001*X(2)*std::exp(-160000.0/((T)*(T))) + 1.3999999999999999*X(8)*std::exp(-12000.0/(T + 1200.0)))) + 1.0);

    Real x19 = x11*x7;

    Real x20 = ((X(0))*(X(0)))*X(12)*x11*((x6) ? (
   0.67810976749343443
)
: (
   std::exp((-0.16869999999999999)*std::log(std::abs(T)))
));

    Real x21 = std::exp((-0.25)*std::log(std::abs(T)));

    Real x22 = std::sqrt(M_PI);

    Real x23 = std::log(T);

    Real x24 = M_LN10;

    Real x25 = 1.0/x24;

    Real x26 = std::exp((-2)*std::log(std::abs(x24)));

    Real x27 = 1.0/(std::exp((1.3*x25*(x23 - 9.2103403719761836) - 137.42519902360013*x26*((0.10857362047581294*x23 - 1)*(0.10857362047581294*x23 - 1)) - 4.8449999999999998)*std::log(std::abs(10.0)))*x17 + 1.0);

    Real x28 = ((x23)*(x23));

    Real x29 = x26*x28;

    Real x30 = -4.8909149999999997*x23*x25 + 0.47490300000000002*x29 - 133.82830000000001*x4;

    Real x31 = std::exp(-0.0022727272727272726*T);

    Real x32 = std::exp(-0.00054054054054054055*T);

    Real x33 = -2.0563129999999998*x31 + 0.58640729999999996*x32 + 0.82274429999999998;

    Real x34 = x23*x25;

    Real x35 = amrex::Math::powi<-3>(x24);

    Real x36 = ((x23)*(x23)*(x23))*x35;

    Real x37 = -69.700860000000006*x25*std::log(40870.379999999997*x4 + 1.0) + 4.6331670000000003*x36;

    Real x38 = -2.4640089999999999*x23*x25 + 0.19859550000000001*x29 + 743.05999999999995*x4;

    Real x39 = 2.9375070000000001*x31 + 0.23588480000000001*x32 + 0.75022860000000002;

    Real x40 = -21.360939999999999*x25*std::log(27535.310000000001*x4 + 1.0) + 0.25820969999999999*x36;

    Real x41 = std::log(((T >= 10000.0) ? (
   10000.0
)
: (
   T
)));

    Real x42 = std::exp((-4)*std::log(std::abs(x24)));

    Real x43 = ((((x41)*(x41)))*(((x41)*(x41))));

    Real x44 = ((x41)*(x41)*(x41));

    Real x45 = ((x41)*(x41));

    Real x46 = X(2) <= 0.01;

    Real x47 = std::log(((((x46) ? (
   false
)
: (
   X(2) >= 10000000000.0
))) ? (
   10000000000.0
)
: (
   ((x46) ? (
      0.01
   )
   : (
      X(2)
   ))
)));

    Real x48 = ((((x47)*(x47)))*(((x47)*(x47))));

    Real x49 = ((x47)*(x47)*(x47));

    Real x50 = ((x47)*(x47));

    Real x51 = amrex::Math::powi<-5>(x24);

    Real x52 = std::exp((-8)*std::log(std::abs(x24)));

    Real x53 = amrex::Math::powi<-7>(x24);

    Real x54 = std::exp((-6)*std::log(std::abs(x24)));

    Real x55 = x0 >= 0.5;

    Real x56 = 1.0000420000000001*x25;

    Real x57 = x0 >= 9.9999999999999998e-13;

    Real x58 = ((x57) ? (
   std::exp((x56*std::log(((x55) ? (
      0.5
   )
   : (
      x0
   ))) + 2.1498900000000001)*std::log(std::abs(10.0)))
)
: (
   0.0
));

    Real x59 = X(0) + X(11) + X(13) + X(5) + X(6) + X(7) + X(8) + x16 + x3;

    Real x60 = x59 <= 9.9999999999999993e-41;

    Real x61 = x0 <= 9.9999999999999993e-41;

    Real x62 = x0*x22*x9;

    Real x63 = std::exp((2.1498900000000001 - 0.69317629274152892*x25)*std::log(std::abs(10.0)))*x62;

    Real x64 = std::exp((x56*std::log(x0) + 2.1498900000000001)*std::log(std::abs(10.0)))*x62;

    Real x65 = 0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9);

    Real x66 = 1.0/std::fabs(x65);

    Real x67 = std::sqrt(x59);

    Real x68 = std::exp((-2)*std::log(std::abs(x65)));

    Real x69 = std::sqrt(x59*x68);

    Real x70 = 1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41;

    Real x71 = 28601.610899577994*std::exp((-0.45000000000000001)*std::log(std::abs(x59)));

    Real x72 = 4.985670872372847e-33*std::exp((3.7599999999999998)*std::log(std::abs(T)))*std::exp(-2197000.0/((T)*(T)*(T)))/(6.0142468035272636e-8*std::exp((2.1000000000000001)*std::log(std::abs(T))) + 1.0) + 1.6e-18*std::exp(-11700.0*x4) + 6.7e-19*std::exp(-5860.0*x4) + 3.0e-24*std::exp(-510.0*x4);

    Real x73 = T < 2000.0;

    Real x74 = x23 - 6.9077552789821368;

    Real x75 = 0.14476482730108395*x23 - 1;

    Real x76 = x26*((x75)*(x75));

    Real x77 = ((x75)*(x75)*(x75));

    Real x78 = x35*x77;

    Real x79 = ((((x75)*(x75)))*(((x75)*(x75))));

    Real x80 = ((x75)*(x75)*(x75)*(x75)*(x75));

    Real x81 = x54*std::exp((6)*std::log(std::abs(x75)));

    Real x82 = x53*((x75)*(x75)*(x75)*(x75)*(x75)*(x75)*(x75));

    Real x83 = std::exp((8)*std::log(std::abs(x75)));

    Real x84 = std::exp((5.0194035000000001*x25*x74 + 5627.2167698544854*x42*x79 + 86051.290034608537*x51*x80 + 9415777.8988952208*x52*x83 - 75.100986441619156*x76 - 1554.3387057364687*x78 - 428804.85473346239*x81 - 1662263.0320406025*x82 - 20.584225)*std::log(std::abs(10.0)));

    Real x85 = T <= 10000.0;

    Real x86 = 0.00020000000000000001*T;

    Real x87 = x86 - 6.0;

    Real x88 = x87 >= 300.0;

    Real x89 = ((x73) ? (
   x72
)
: ((x85) ? (
   x84
)
: (
   5.5313336794064847e-19/(std::exp(((x88) ? (
      300.0
   )
   : (
      x87
   ))) + 1.0)
)));

    Real x90 = std::exp((25.0*x25)*std::log(std::abs(T)));

    Real x91 = std::exp((-200.0 + 20000.0/((10.0 + 2.3538526683701997e+17/x90)*(1.6889118802245084e-48*x90 + 10.0)))*std::log(std::abs(10.0)));

    Real x92 = x42*x79;

    Real x93 = x51*x80;

    Real x94 = std::exp((2.0943374000000001*x25*x74 + 144.02112655888752*x35*x77 - 36.814414747418546*x76 - 339.5619991617852*x92 - 529.07725573213918*x93 - 23.962112000000001)*std::log(std::abs(10.0)))*X(8)*x91;

    Real x95 = x25*x74;

    Real x96 = std::exp((-38.89917505778142*x76 + 95.70878894783884*x78 - 377.88183430702219*x92 + 3018.4974183098116*x93 + 2.1892372*x95 - 23.689236999999999)*std::log(std::abs(10.0)))*X(13);

    Real x97 = T > 10.0;

    Real x98 = x85 && x97;

    Real x99 = std::exp((16.666666666666664*x25)*std::log(std::abs(T)));

    Real x100 = std::exp((-200.0 + 20000.0/((10.0 + 785.77199422741614/x99)*(5.0592917094448065e-34*x99 + 10.0)))*std::log(std::abs(10.0)));

    Real x101 = 1.002560385050777e-22*X(13)*x100;

    Real x102 = std::exp((0.73442154540113413*x76 - 77.855706084264682*x78 - 1161.2797752309887*x92 + 5059.6285287169567*x93 + 1.5714710999999999*x95 - 22.089523)*std::log(std::abs(10.0)))*X(1);

    Real x103 = 1.1825091393820599e-21*X(1)*x100;

    Real x104 = std::exp((2774.5177117396752*x76 + 16037.924047681272*x78 + 45902.322591745004*x92 + 60522.293708798054*x93 + 37.383713*x95 - 16.818342000000001)*std::log(std::abs(10.0)))*X(2);

    Real x105 = T <= 100.0;

    Real x106 = std::exp((3.5692468000000002*x25*x74 - 540.77102118284597*x76 - 9179.8864335208946*x78 - 48562.751069188118*x92 - 66875.646562351845*x93 - 24.311209000000002)*std::log(std::abs(10.0)))*X(2);

    Real x107 = T <= 1000.0;

    Real x108 = std::exp((-177.55453097873294*x76 + 1956.911370108365*x78 - 12547.661945180447*x92 + 24439.250555499191*x93 + 4.6450521*x95 - 24.311209000000002)*std::log(std::abs(10.0)))*X(2);

    Real x109 = T <= 6000.0;

    Real x110 = std::exp((17.997580222853362*x25)*std::log(std::abs(T)));

    Real x111 = 1.8623144679125181e-22*std::exp((-200.0 + 20000.0/((10.0 + 2973.7534532281375/x110)*(1.3368457736780898e-34*x110 + 10.0)))*std::log(std::abs(10.0)))*X(2);

    Real x112 = x52*x83;

    Real x113 = std::exp((366063607.58415633*x112 + 4616.3011562659685*x76 + 113122.17137872758*x78 + 87115306.05744876*x81 + 273295393.17143697*x82 + 1672890.7229183144*x92 + 15471651.937466398*x93 + 16.815729999999999*x95 - 21.928795999999998)*std::log(std::abs(10.0)))*X(0);

    Real x114 = T <= 500.0;

    Real x115 = T > 100;

    Real x116 = x114 && x115;

    Real x117 = std::exp((-33025002.640084207*x112 + 44.525106942242758*x76 + 1331.8748828877385*x78 + 968783.44101153011*x81 + 4831859.3594864924*x82 - 10763.919849753534*x92 - 138531.11016116844*x93 + 1.6802758*x95 - 22.921188999999998)*std::log(std::abs(10.0)))*X(0);

    Real x118 = T > 500.0;

    Real x119 = x91*((x116) ? (
   x113
)
: ((x118) ? (
   x117
)
: (
   0
))) + x94 + ((x98) ? (
   x102
)
: (
   x103
)) + ((x98) ? (
   x96
)
: (
   x101
)) + ((x105) ? (
   x104
)
: ((x107) ? (
   x106
)
: ((x109) ? (
   x108
)
: (
   x111
))));

    Real x120 = x72 >= 1.0e-99;

    Real x121 = x113*x91;

    Real x122 = x104 + x94;

    Real x123 = x102 + x96;

    Real x124 = x122 + x123;

    Real x125 = x121 + x124 >= 1.0e-99;

    Real x126 = x123 + x94;

    Real x127 = x106 + x126;

    Real x128 = x121 + x127 >= 1.0e-99;

    Real x129 = x108 + x126;

    Real x130 = x121 + x129 >= 1.0e-99;

    Real x131 = x111 + x126;

    Real x132 = x121 + x131 >= 1.0e-99;

    Real x133 = x101 + x103;

    Real x134 = x122 + x133;

    Real x135 = x121 + x134 >= 1.0e-99;

    Real x136 = x133 + x94;

    Real x137 = x106 + x136;

    Real x138 = x121 + x137 >= 1.0e-99;

    Real x139 = x108 + x136;

    Real x140 = x121 + x139 >= 1.0e-99;

    Real x141 = x111 + x136;

    Real x142 = x121 + x141 >= 1.0e-99;

    Real x143 = x117*x91;

    Real x144 = x124 + x143 >= 1.0e-99;

    Real x145 = x127 + x143 >= 1.0e-99;

    Real x146 = x129 + x143 >= 1.0e-99;

    Real x147 = x131 + x143 >= 1.0e-99;

    Real x148 = x134 + x143 >= 1.0e-99;

    Real x149 = x137 + x143 >= 1.0e-99;

    Real x150 = x139 + x143 >= 1.0e-99;

    Real x151 = x141 + x143 >= 1.0e-99;

    Real x152 = x124 >= 1.0e-99;

    Real x153 = x127 >= 1.0e-99;

    Real x154 = x129 >= 1.0e-99;

    Real x155 = x131 >= 1.0e-99;

    Real x156 = x134 >= 1.0e-99;

    Real x157 = x137 >= 1.0e-99;

    Real x158 = x139 >= 1.0e-99;

    Real x159 = x141 >= 1.0e-99;

    Real x160 = x84 >= 1.0e-99;

    Real x161 = 5.5313336794064847e-19/(0.0024787521766663585*std::exp(x86) + 1.0) >= 1.0e-99;


    return (x1*(-3.1438547368704001e-21*std::exp((0.34999999999999998)*std::log(std::abs(T)))*X(0)*X(8)*std::exp(-102000.0*x4) - 0.00022681492*((((T)*(T)))*(((T)*(T))))*x0*x58*((((x55 && x57 && x60 && x61) ? (
   4.8339620236294848e-32/((x63 + 2.1986273043946046e-56)*(x63 + 2.1986273043946046e-56)) >= 1.0
)
: (
   ((x57 && x60 && x61) ? (
      4.8339620236294848e-32/((x64 + 2.1986273043946046e-56)*(x64 + 2.1986273043946046e-56)) >= 1.0
   )
   : (
      ((x60 && x61) ? (
         true
      )
      : (
         ((x55 && x57 && x60) ? (
            216.48287161311649/((x63*x66 + 1.471335691176954e-39)*(x63*x66 + 1.471335691176954e-39)) >= 1.0
         )
         : (
            ((x57 && x60) ? (
               216.48287161311649/((x64*x66 + 1.471335691176954e-39)*(x64*x66 + 1.471335691176954e-39)) >= 1.0
            )
            : (
               ((x60) ? (
                  true
               )
               : (
                  ((x55 && x57 && x61) ? (
                     4.833962023629485e-72/((x63*x67 + 2.1986273043946045e-76)*(x63*x67 + 2.1986273043946045e-76)) >= 1.0
                  )
                  : (
                     ((x57 && x61) ? (
                        4.833962023629485e-72/((x64*x67 + 2.1986273043946045e-76)*(x64*x67 + 2.1986273043946045e-76)) >= 1.0
                     )
                     : (
                        ((x61) ? (
                           true
                        )
                        : (
                           ((x55 && x57) ? (
                              2.1648287161311648e-38/((x63*x69 + 1.471335691176954e-59)*(x63*x69 + 1.471335691176954e-59)) >= 1.0
                           )
                           : (
                              ((x57) ? (
                                 2.1648287161311648e-38/((x64*x69 + 1.471335691176954e-59)*(x64*x69 + 1.471335691176954e-59)) >= 1.0
                              )
                              : (
                                 true
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
))) ? (
   1.0
)
: (
   483396202.36294854/((x58*x62*std::sqrt(((x60) ? (
      9.9999999999999993e-41
   )
   : (
      x59
   ))*((x61) ? (
      1.0e+80
   )
   : (
      2.232953576238777e+46*x68
   ))) + 2.1986273043946046e-36)*(x58*x62*std::sqrt(((x60) ? (
      9.9999999999999993e-41
   )
   : (
      x59
   ))*((x61) ? (
      1.0e+80
   )
   : (
      2.232953576238777e+46*x68
   ))) + 2.1986273043946046e-36))
)) + 0.00084373771595996178*T*(1.3806479999999999e-16*X(0) + 1.3806479999999999e-16*X(1) + 1.3806479999999999e-16*X(10) + 1.3806479999999999e-16*X(11) + 1.3806479999999999e-16*X(12) + 1.3806479999999999e-16*X(13) + 1.3806479999999999e-16*X(2) + 1.3806479999999999e-16*X(3) + 1.3806479999999999e-16*X(4) + 1.3806479999999999e-16*X(5) + 1.3806479999999999e-16*X(6) + 1.3806479999999999e-16*X(7) + 1.3806479999999999e-16*X(8) + 1.3806479999999999e-16*X(9))/(std::sqrt(x1)*x22) - 2.1299999999999999e-27*X(0)*x2*(4.0*X(11) + x3) - 5.6500000000000001e-36*X(0)*(T - x5)*((((z + 1.0)*(z + 1.0)))*(((z + 1.0)*(z + 1.0)))) - 3.4635323838154264e-26*X(1)*x14 - 1.3854129535261706e-25*X(11)*x14 - 9.3799999999999993e-22*X(13)*x10*x12*std::exp(-285335.40000000002*x8) + 7.1777505408000004e-12*((X(2))*(X(2))*(X(2)))*x18*(2.0000000000000002e-31*x15 + 6.0000000000000001e-32*x21) + 7.1777505408000004e-12*((X(2))*(X(2)))*X(8)*x18*(2.5000000000000002e-32*x15 + 7.5000000000000001e-33*x21) + 5.6556829037999995e-12*X(2)*X(3)*x18*(1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T))))/(0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0) + 1.75918975308e-21*X(2)*X(6)*x18 - 7.1777505408000004e-12*X(2)*X(8)*(std::exp((42.707410000000003*x23*x25 - 2.0273650000000001*x29 - 21467.790000000001*x4 - 1657.4099999999999*x4/(std::exp((x39)*std::log(std::abs(std::exp((-x38 - 8.1313220000000008)*std::log(std::abs(10.0)))*x17))) + 1.0) - x40 - 142.7664 - (70.138370000000009*x23*x25 + 11.28215*x25*std::log(14254.549999999999*x4 + 1.0) - 4.7035149999999994*x29 - x40 - 203.11568)/(std::exp((x39)*std::log(std::abs(std::exp((-x38 - 9.3055640000000004)*std::log(std::abs(10.0)))*x17))) + 1.0))*std::log(std::abs(10.0))) + std::exp((43.20243*x26*x28 - 68.422430000000006*x34 - x37 - 23705.700000000001*x4 - 2080.4099999999999*x4/(std::exp((x33)*std::log(std::abs(std::exp((-x30 - 13.656822)*std::log(std::abs(10.0)))*x17))) + 1.0) - 178.4239 - (19.734269999999999*x25*std::log(16780.950000000001*x4 + 1.0) + 37.886913*x26*x28 - 14.509090000000008*x34 - x37 - 307.31920000000002)/(std::exp((x33)*std::log(std::abs(std::exp((-x30 - 14.82123)*std::log(std::abs(10.0)))*x17))) + 1.0))*std::log(std::abs(10.0)))) - 7.1777505408000004e-12*((X(8))*(X(8)))*std::exp((x27)*std::log(std::abs(1.1800000000000001e-10*std::exp(-69500.0*x4))))*std::exp((1.0 - x27)*std::log(std::abs(8.1250000000000003e-8*x15*(1.0 - std::exp(-6000.0*x4))*std::exp(-52000.0*x4)))) - 1.2700000000000001e-21*x10*x13*std::exp(-157809.10000000001*x8) - 4.9500000000000001e-22*x10*x19*std::exp(-631515.0*x8) - 7.4999999999999996e-19*x13*std::exp(-118348.0*x8) - 5.5399999999999998e-17*x19*((x6) ? (
   0.4008667176273028
)
: (
   std::exp((-0.39700000000000002)*std::log(std::abs(T)))
))*std::exp(-473638.0*x8) - 5.0099999999999997e-27*x20*std::exp(-55338.0*x8) - 9.1000000000000001e-27*x20*std::exp(-13179.0*x8) - 1.24e-13*x7*(1.0 + 0.29999999999999999*std::exp(-94000.0*x8))*((x6) ? (
   0.031622776601683791
)
: (
   std::exp((-1.5)*std::log(std::abs(T)))
))*std::exp(-470000.0*x8) - 1.5499999999999999e-26*x7*((x6) ? (
   2.3157944032250755
)
: (
   std::exp((0.36470000000000002)*std::log(std::abs(T)))
)) - ((T < 2.0) ? (
   0
)
: (
   X(8)*((((x70) ? (
      true
   )
   : (
      x71 >= 1.0
   ))) ? (
      1.0
   )
   : (
      ((x70) ? (
         1.000000000000001e+18
      )
      : (
         x71
      ))
   ))*((((x105 && x114 && x115 && x73 && x85 && x97) ? (
      x120 && x125
   )
   : (
      ((x107 && x114 && x115 && x73 && x85 && x97) ? (
         x120 && x128
      )
      : (
         ((x109 && x114 && x115 && x73 && x85 && x97) ? (
            x120 && x130
         )
         : (
            ((x114 && x115 && x73 && x85 && x97) ? (
               x120 && x132
            )
            : (
               ((x105 && x114 && x115 && x73) ? (
                  x120 && x135
               )
               : (
                  ((x107 && x114 && x115 && x73) ? (
                     x120 && x138
                  )
                  : (
                     ((x109 && x114 && x115 && x73) ? (
                        x120 && x140
                     )
                     : (
                        ((x114 && x115 && x73) ? (
                           x120 && x142
                        )
                        : (
                           ((x105 && x118 && x73 && x85 && x97) ? (
                              x120 && x144
                           )
                           : (
                              ((x107 && x118 && x73 && x85 && x97) ? (
                                 x120 && x145
                              )
                              : (
                                 ((x109 && x118 && x73 && x85 && x97) ? (
                                    x120 && x146
                                 )
                                 : (
                                    ((x118 && x73 && x85 && x97) ? (
                                       x120 && x147
                                    )
                                    : (
                                       ((x105 && x118 && x73) ? (
                                          x120 && x148
                                       )
                                       : (
                                          ((x107 && x118 && x73) ? (
                                             x120 && x149
                                          )
                                          : (
                                             ((x109 && x118 && x73) ? (
                                                x120 && x150
                                             )
                                             : (
                                                ((x118 && x73) ? (
                                                   x120 && x151
                                                )
                                                : (
                                                   ((x105 && x73 && x85 && x97) ? (
                                                      x120 && x152
                                                   )
                                                   : (
                                                      ((x107 && x73 && x85 && x97) ? (
                                                         x120 && x153
                                                      )
                                                      : (
                                                         ((x109 && x73 && x85 && x97) ? (
                                                            x120 && x154
                                                         )
                                                         : (
                                                            ((x73 && x85 && x97) ? (
                                                               x120 && x155
                                                            )
                                                            : (
                                                               ((x105 && x73) ? (
                                                                  x120 && x156
                                                               )
                                                               : (
                                                                  ((x107 && x73) ? (
                                                                     x120 && x157
                                                                  )
                                                                  : (
                                                                     ((x109 && x73) ? (
                                                                        x120 && x158
                                                                     )
                                                                     : (
                                                                        ((x73) ? (
                                                                           x120 && x159
                                                                        )
                                                                        : (
                                                                           ((x105 && x114 && x115 && x85 && x97) ? (
                                                                              x125 && x160
                                                                           )
                                                                           : (
                                                                              ((x107 && x114 && x115 && x85 && x97) ? (
                                                                                 x128 && x160
                                                                              )
                                                                              : (
                                                                                 ((x109 && x114 && x115 && x85 && x97) ? (
                                                                                    x130 && x160
                                                                                 )
                                                                                 : (
                                                                                    ((x114 && x115 && x85 && x97) ? (
                                                                                       x132 && x160
                                                                                    )
                                                                                    : (
                                                                                       ((x105 && x114 && x115 && x85) ? (
                                                                                          x135 && x160
                                                                                       )
                                                                                       : (
                                                                                          ((x107 && x114 && x115 && x85) ? (
                                                                                             x138 && x160
                                                                                          )
                                                                                          : (
                                                                                             ((x109 && x114 && x115 && x85) ? (
                                                                                                x140 && x160
                                                                                             )
                                                                                             : (
                                                                                                ((x114 && x115 && x85) ? (
                                                                                                   x142 && x160
                                                                                                )
                                                                                                : (
                                                                                                   ((x105 && x118 && x85 && x97) ? (
                                                                                                      x144 && x160
                                                                                                   )
                                                                                                   : (
                                                                                                      ((x107 && x118 && x85 && x97) ? (
                                                                                                         x145 && x160
                                                                                                      )
                                                                                                      : (
                                                                                                         ((x109 && x118 && x85 && x97) ? (
                                                                                                            x146 && x160
                                                                                                         )
                                                                                                         : (
                                                                                                            ((x118 && x85 && x97) ? (
                                                                                                               x147 && x160
                                                                                                            )
                                                                                                            : (
                                                                                                               ((x105 && x118 && x85) ? (
                                                                                                                  x148 && x160
                                                                                                               )
                                                                                                               : (
                                                                                                                  ((x107 && x118 && x85) ? (
                                                                                                                     x149 && x160
                                                                                                                  )
                                                                                                                  : (
                                                                                                                     ((x109 && x118 && x85) ? (
                                                                                                                        x150 && x160
                                                                                                                     )
                                                                                                                     : (
                                                                                                                        ((x118 && x85) ? (
                                                                                                                           x151 && x160
                                                                                                                        )
                                                                                                                        : (
                                                                                                                           ((x105 && x85 && x97) ? (
                                                                                                                              x152 && x160
                                                                                                                           )
                                                                                                                           : (
                                                                                                                              ((x107 && x85 && x97) ? (
                                                                                                                                 x153 && x160
                                                                                                                              )
                                                                                                                              : (
                                                                                                                                 ((x109 && x85 && x97) ? (
                                                                                                                                    x154 && x160
                                                                                                                                 )
                                                                                                                                 : (
                                                                                                                                    ((x98) ? (
                                                                                                                                       x155 && x160
                                                                                                                                    )
                                                                                                                                    : (
                                                                                                                                       ((x105 && x85) ? (
                                                                                                                                          x156 && x160
                                                                                                                                       )
                                                                                                                                       : (
                                                                                                                                          ((x107 && x85) ? (
                                                                                                                                             x157 && x160
                                                                                                                                          )
                                                                                                                                          : (
                                                                                                                                             ((x109 && x85) ? (
                                                                                                                                                x158 && x160
                                                                                                                                             )
                                                                                                                                             : (
                                                                                                                                                ((x85) ? (
                                                                                                                                                   x159 && x160
                                                                                                                                                )
                                                                                                                                                : (
                                                                                                                                                   ((x88 && (x105 || x88) && (x107 || x88) && (x109 || x88) && (x114 || x88) && (x115 || x88) && (x118 || x88) && (x105 || x107 || x88) && (x105 || x109 || x88) && (x105 || x114 || x88) && (x105 || x115 || x88) && (x105 || x118 || x88) && (x107 || x109 || x88) && (x107 || x114 || x88) && (x107 || x115 || x88) && (x107 || x118 || x88) && (x109 || x114 || x88) && (x109 || x115 || x88) && (x109 || x118 || x88) && (x114 || x115 || x88) && (x115 || x118 || x88) && (x105 || x107 || x109 || x88) && (x105 || x107 || x114 || x88) && (x105 || x107 || x115 || x88) && (x105 || x107 || x118 || x88) && (x105 || x109 || x114 || x88) && (x105 || x109 || x115 || x88) && (x105 || x109 || x118 || x88) && (x105 || x114 || x115 || x88) && (x105 || x115 || x118 || x88) && (x107 || x109 || x114 || x88) && (x107 || x109 || x115 || x88) && (x107 || x109 || x118 || x88) && (x107 || x114 || x115 || x88) && (x107 || x115 || x118 || x88) && (x109 || x114 || x115 || x88) && (x109 || x115 || x118 || x88) && (x105 || x107 || x109 || x114 || x88) && (x105 || x107 || x109 || x115 || x88) && (x105 || x107 || x109 || x118 || x88) && (x105 || x107 || x114 || x115 || x88) && (x105 || x107 || x115 || x118 || x88) && (x105 || x109 || x114 || x115 || x88) && (x105 || x109 || x115 || x118 || x88) && (x107 || x109 || x114 || x115 || x88) && (x107 || x109 || x115 || x118 || x88) && (x105 || x107 || x109 || x114 || x115 || x88) && (x105 || x107 || x109 || x115 || x118 || x88)) ? (
                                                                                                                                                      false
                                                                                                                                                   )
                                                                                                                                                   : (
                                                                                                                                                      ((x105 && x114 && x115) ? (
                                                                                                                                                         x135 && x161
                                                                                                                                                      )
                                                                                                                                                      : (
                                                                                                                                                         ((x107 && x114 && x115) ? (
                                                                                                                                                            x138 && x161
                                                                                                                                                         )
                                                                                                                                                         : (
                                                                                                                                                            ((x109 && x114 && x115) ? (
                                                                                                                                                               x140 && x161
                                                                                                                                                            )
                                                                                                                                                            : (
                                                                                                                                                               ((x116) ? (
                                                                                                                                                                  x142 && x161
                                                                                                                                                               )
                                                                                                                                                               : (
                                                                                                                                                                  ((x105 && x118) ? (
                                                                                                                                                                     x148 && x161
                                                                                                                                                                  )
                                                                                                                                                                  : (
                                                                                                                                                                     ((x107 && x118) ? (
                                                                                                                                                                        x149 && x161
                                                                                                                                                                     )
                                                                                                                                                                     : (
                                                                                                                                                                        ((x109 && x118) ? (
                                                                                                                                                                           x150 && x161
                                                                                                                                                                        )
                                                                                                                                                                        : (
                                                                                                                                                                           x151 && x161
                                                                                                                                                                        ))
                                                                                                                                                                     ))
                                                                                                                                                                  ))
                                                                                                                                                               ))
                                                                                                                                                            ))
                                                                                                                                                         ))
                                                                                                                                                      ))
                                                                                                                                                   ))
                                                                                                                                                ))
                                                                                                                                             ))
                                                                                                                                          ))
                                                                                                                                       ))
                                                                                                                                    ))
                                                                                                                                 ))
                                                                                                                              ))
                                                                                                                           ))
                                                                                                                        ))
                                                                                                                     ))
                                                                                                                  ))
                                                                                                               ))
                                                                                                            ))
                                                                                                         ))
                                                                                                      ))
                                                                                                   ))
                                                                                                ))
                                                                                             ))
                                                                                          ))
                                                                                       ))
                                                                                    ))
                                                                                 ))
                                                                              ))
                                                                           ))
                                                                        ))
                                                                     ))
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))) ? (
      x119*x89/(x119 + x89)
   )
   : (
      0
   ))
)) - ((T >= x5) ? (
   std::exp((21.93385*x25*x41 + 0.92432999999999998*x25*x47 + 0.77951999999999999*x26*x41*x47 - 10.19097*x26*x45 + 0.54962*x26*x50 - 1.06447*x35*x41*x50 + 2.1990599999999998*x35*x44 - 0.54262999999999995*x35*x45*x47 - 0.076759999999999995*x35*x49 + 0.11864*x41*x42*x49 - 0.0036600000000000001*x41*x48*x51 - 0.17333999999999999*x42*x43 + 0.11711000000000001*x42*x44*x47 + 0.62343000000000004*x42*x45*x50 + 0.0027499999999999998*x42*x48 - 0.0083499999999999998*x43*x47*x51 + 6.1920000000000003e-5*x43*x48*x52 - 0.001482*x43*x49*x53 + 0.0106*x43*x50*x54 - 0.00066631000000000004*x44*x48*x53 + 0.017590000000000001*x44*x49*x54 - 0.13768*x44*x50*x51 + 0.0025140000000000002*x45*x48*x54 - 0.073660000000000003*x45*x49*x51 - 42.567880000000002)*std::log(std::abs(10.0)))*X(10)
)
: (
   0
))));
}


AMREX_GPU_HOST_DEVICE AMREX_INLINE
void actual_rhs (burn_t& state, Array1D<Real, 1, neqs>& ydot)
{
    Real z = redshift;

    Array1D<Real, 0, NumSpec-1> X;
    for (int i = 0; i < NumSpec; ++i) {
           X(i) = state.xn[i];
    }
    // YDOTS

    rhs_specie(state, ydot, X, z);

    // Edot

    Real edot = rhs_eint(state, X, z);

    // Append the energy equation (this is erg/g/s)

    ydot(net_ienuc) = edot;

}


template<class MatrixType>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
void jac_nuc(const burn_t& state,
             MatrixType& jac,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const z)
{

    Real T = state.T;

    Real x0 = 0;
    Real x1 = 0;
    Real x2 = 0;
    Real x3 = 0;
    Real x4 = 0;
    Real x5 = 0;
    Real x6 = 0;
    Real x7 = 0;
    Real x8 = 0;
    Real x9 = 0;
    Real x10 = 0;
    Real x11 = 0;
    Real x12 = 0;
    Real x13 = 0;
    Real x14 = 0;
    Real x15 = 0;
    Real x16 = 0;
    Real x17 = 0;
    Real x18 = 0;
    Real x19 = 0;
    Real x20 = 0;
    Real x21 = 0;
    Real x22 = 0;
    Real x23 = 0;
    Real x24 = 0;
    Real x25 = 0;
    Real x26 = 0;
    Real x27 = 0;
    Real x28 = 0;
    Real x29 = 0;
    Real x30 = 0;
    Real x31 = 0;
    Real x32 = 0;
    Real x33 = 0;
    Real x34 = 0;
    Real x35 = 0;
    Real x36 = 0;
    Real x37 = 0;
    Real x38 = 0;
    Real x39 = 0;
    Real x40 = 0;
    Real x41 = 0;
    Real x42 = 0;
    Real x43 = 0;
    Real x44 = 0;
    Real x45 = 0;
    Real x46 = 0;
    Real x47 = 0;
    Real x48 = 0;
    Real x49 = 0;
    Real x50 = 0;
    Real x51 = 0;
    Real x52 = 0;
    Real x53 = 0;
    Real x54 = 0;
    Real x55 = 0;
    Real x56 = 0;
    Real x57 = 0;
    Real x58 = 0;
    Real x59 = 0;
    Real x60 = 0;
    Real x61 = 0;
    Real x62 = 0;
    Real x63 = 0;
    Real x64 = 0;
    Real x65 = 0;
    Real x66 = 0;
    Real x67 = 0;
    Real x68 = 0;
    Real x69 = 0;
    Real x70 = 0;
    Real x71 = 0;
    Real x72 = 0;
    Real x73 = 0;
    Real x74 = 0;
    Real x75 = 0;
    Real x76 = 0;
    Real x77 = 0;
    Real x78 = 0;
    Real x79 = 0;
    Real x80 = 0;
    Real x81 = 0;
    Real x82 = 0;
    Real x83 = 0;
    Real x84 = 0;
    Real x85 = 0;
    Real x86 = 0;
    Real x87 = 0;
    Real x88 = 0;
    Real x89 = 0;
    Real x90 = 0;
    Real x91 = 0;
    Real x92 = 0;
    Real x93 = 0;
    Real x94 = 0;
    Real x95 = 0;
    Real x96 = 0;
    Real x97 = 0;
    Real x98 = 0;
    Real x99 = 0;
    Real x100 = 0;
    Real x101 = 0;
    Real x102 = 0;
    Real x103 = 0;
    Real x104 = 0;
    Real x105 = 0;
    Real x106 = 0;
    Real x107 = 0;
    Real x108 = 0;
    Real x109 = 0;
    Real x110 = 0;
    Real x111 = 0;
    Real x112 = 0;
    Real x113 = 0;
    Real x114 = 0;
    Real x115 = 0;
    Real x116 = 0;
    Real x117 = 0;
    Real x118 = 0;
    Real x119 = 0;
    Real x120 = 0;
    Real x121 = 0;
    Real x122 = 0;
    Real x123 = 0;
    Real x124 = 0;
    Real x125 = 0;
    Real x126 = 0;
    Real x127 = 0;
    Real x128 = 0;
    Real x129 = 0;
    Real x130 = 0;
    Real x131 = 0;
    Real x132 = 0;
    Real x133 = 0;
    Real x134 = 0;
    Real x135 = 0;
    Real x136 = 0;
    Real x137 = 0;
    Real x138 = 0;
    Real x139 = 0;
    Real x140 = 0;
    Real x141 = 0;
    Real x142 = 0;
    Real x143 = 0;
    Real x144 = 0;
    Real x145 = 0;
    Real x146 = 0;
    Real x147 = 0;
    Real x148 = 0;
    Real x149 = 0;
    Real x150 = 0;
    Real x151 = 0;
    Real x152 = 0;
    Real x153 = 0;
    Real x154 = 0;
    Real x155 = 0;
    Real x156 = 0;
    Real x157 = 0;
    Real x158 = 0;
    Real x159 = 0;
    Real x160 = 0;
    Real x161 = 0;
    Real x162 = 0;
    Real x163 = 0;
    Real x164 = 0;
    Real x165 = 0;
    Real x166 = 0;
    Real x167 = 0;
    Real x168 = 0;
    Real x169 = 0;
    Real x170 = 0;
    Real x171 = 0;
    Real x172 = 0;
    Real x173 = 0;
    Real x174 = 0;
    Real x175 = 0;
    Real x176 = 0;
    Real x177 = 0;
    Real x178 = 0;
    Real x179 = 0;
    Real x180 = 0;
    Real x181 = 0;
    Real x182 = 0;
    Real x183 = 0;
    Real x184 = 0;
    Real x185 = 0;
    Real x186 = 0;
    Real x187 = 0;
    Real x188 = 0;
    Real x189 = 0;
    Real x190 = 0;
    Real x191 = 0;
    Real x192 = 0;
    Real x193 = 0;
    Real x194 = 0;
    Real x195 = 0;
    Real x196 = 0;
    Real x197 = 0;
    Real x198 = 0;
    Real x199 = 0;
    Real x200 = 0;
    Real x201 = 0;
    Real x202 = 0;
    Real x203 = 0;
    Real x204 = 0;
    Real x205 = 0;
    Real x206 = 0;
    Real x207 = 0;
    Real x208 = 0;
    Real x209 = 0;
    Real x210 = 0;
    Real x211 = 0;
    Real x212 = 0;
    Real x213 = 0;
    Real x214 = 0;
    Real x215 = 0;
    Real x216 = 0;
    Real x217 = 0;
    Real x218 = 0;
    Real x219 = 0;
    Real x220 = 0;
    Real x221 = 0;
    Real x222 = 0;
    Real x223 = 0;
    Real x224 = 0;
    Real x225 = 0;
    Real x226 = 0;
    Real x227 = 0;
    Real x228 = 0;
    Real x229 = 0;
    Real x230 = 0;
    Real x231 = 0;
    Real x232 = 0;
    Real x233 = 0;
    Real x234 = 0;
    Real x235 = 0;
    Real x236 = 0;
    Real x237 = 0;
    Real x238 = 0;
    Real x239 = 0;
    Real x240 = 0;
    Real x241 = 0;
    Real x242 = 0;
    Real x243 = 0;
    Real x244 = 0;
    Real x245 = 0;
    Real x246 = 0;
    Real x247 = 0;
    Real x248 = 0;
    Real x249 = 0;
    Real x250 = 0;
    Real x251 = 0;
    Real x252 = 0;
    Real x253 = 0;
    Real x254 = 0;
    Real x255 = 0;
    Real x256 = 0;
    Real x257 = 0;
    Real x258 = 0;
    Real x259 = 0;
    Real x260 = 0;
    Real x261 = 0;
    Real x262 = 0;
    Real x263 = 0;
    Real x264 = 0;
    Real x265 = 0;
    Real x266 = 0;
    Real x267 = 0;
    Real x268 = 0;
    Real x269 = 0;
    Real x270 = 0;
    Real x271 = 0;
    Real x272 = 0;
    Real x273 = 0;
    Real x274 = 0;
    Real x275 = 0;
    Real x276 = 0;
    Real x277 = 0;
    Real x278 = 0;
    Real x279 = 0;
    Real x280 = 0;
    Real x281 = 0;
    Real x282 = 0;
    Real x283 = 0;
    Real x284 = 0;
    Real x285 = 0;
    Real x286 = 0;
    Real x287 = 0;
    Real x288 = 0;
    Real x289 = 0;
    Real x290 = 0;
    Real x291 = 0;
    Real x292 = 0;
    Real x293 = 0;
    Real x294 = 0;
    Real x295 = 0;
    Real x296 = 0;
    Real x297 = 0;
    Real x298 = 0;
    Real x299 = 0;
    Real x300 = 0;
    Real x301 = 0;
    Real x302 = 0;
    Real x303 = 0;
    Real x304 = 0;
    Real x305 = 0;
    Real x306 = 0;
    Real x307 = 0;
    Real x308 = 0;
    Real x309 = 0;
    Real x310 = 0;
    Real x311 = 0;
    Real x312 = 0;
    Real x313 = 0;
    Real x314 = 0;
    Real x315 = 0;
    Real x316 = 0;
    Real x317 = 0;
    Real x318 = 0;
    Real x319 = 0;
    Real x320 = 0;
    Real x321 = 0;
    Real x322 = 0;
    Real x323 = 0;
    Real x324 = 0;
    Real x325 = 0;
    Real x326 = 0;
    Real x327 = 0;
    Real x328 = 0;
    Real x329 = 0;
    Real x330 = 0;
    Real x331 = 0;
    Real x332 = 0;
    Real x333 = 0;
    Real x334 = 0;
    Real x335 = 0;
    Real x336 = 0;
    Real x337 = 0;
    Real x338 = 0;
    Real x339 = 0;
    Real x340 = 0;
    Real x341 = 0;
    Real x342 = 0;
    Real x343 = 0;
    Real x344 = 0;
    Real x345 = 0;
    Real x346 = 0;
    Real x347 = 0;
    Real x348 = 0;
    Real x349 = 0;
    Real x350 = 0;
    Real x351 = 0;
    Real x352 = 0;
    Real x353 = 0;
    Real x354 = 0;
    Real x355 = 0;
    Real x356 = 0;
    Real x357 = 0;
    Real x358 = 0;
    Real x359 = 0;
    Real x360 = 0;
    Real x361 = 0;
    Real x362 = 0;
    Real x363 = 0;
    Real x364 = 0;
    Real x365 = 0;
    Real x366 = 0;
    Real x367 = 0;
    Real x368 = 0;
    Real x369 = 0;
    Real x370 = 0;
    Real x371 = 0;
    Real x372 = 0;
    Real x373 = 0;
    Real x374 = 0;
    Real x375 = 0;
    Real x376 = 0;
    Real x377 = 0;
    Real x378 = 0;
    Real x379 = 0;
    Real x380 = 0;
    Real x381 = 0;
    Real x382 = 0;
    Real x383 = 0;
    Real x384 = 0;
    Real x385 = 0;
    Real x386 = 0;
    Real x387 = 0;
    Real x388 = 0;
    Real x389 = 0;
    Real x390 = 0;
    Real x391 = 0;
    Real x392 = 0;
    Real x393 = 0;
    Real x394 = 0;
    Real x395 = 0;
    Real x396 = 0;
    Real x397 = 0;
    Real x398 = 0;
    Real x399 = 0;
    Real x400 = 0;
    Real x401 = 0;
    Real x402 = 0;
    Real x403 = 0;
    Real x404 = 0;
    Real x405 = 0;
    Real x406 = 0;
    Real x407 = 0;
    Real x408 = 0;
    Real x409 = 0;
    Real x410 = 0;
    Real x411 = 0;
    Real x412 = 0;
    Real x413 = 0;
    Real x414 = 0;
    Real x415 = 0;
    Real x416 = 0;
    Real x417 = 0;
    Real x418 = 0;
    Real x419 = 0;
    Real x420 = 0;
    Real x421 = 0;
    Real x422 = 0;
    Real x423 = 0;
    Real x424 = 0;
    Real x425 = 0;
    Real x426 = 0;
    Real x427 = 0;
    Real x428 = 0;
    Real x429 = 0;
    Real x430 = 0;
    Real x431 = 0;
    Real x432 = 0;
    Real x433 = 0;
    Real x434 = 0;
    Real x435 = 0;
    Real x436 = 0;
    Real x437 = 0;
    Real x438 = 0;
    Real x439 = 0;
    Real x440 = 0;
    Real x441 = 0;
    Real x442 = 0;
    Real x443 = 0;
    Real x444 = 0;
    Real x445 = 0;
    Real x446 = 0;
    Real x447 = 0;
    Real x448 = 0;
    Real x449 = 0;
    Real x450 = 0;
    Real x451 = 0;
    Real x452 = 0;
    Real x453 = 0;
    Real x454 = 0;
    Real x455 = 0;
    Real x456 = 0;
    Real x457 = 0;
    Real x458 = 0;
    Real x459 = 0;
    Real x460 = 0;
    Real x461 = 0;
    Real x462 = 0;
    Real x463 = 0;
    Real x464 = 0;
    Real x465 = 0;
    Real x466 = 0;
    Real x467 = 0;
    Real x468 = 0;
    Real x469 = 0;
    Real x470 = 0;
    Real x471 = 0;
    Real x472 = 0;
    Real x473 = 0;
    Real x474 = 0;
    Real x475 = 0;
    Real x476 = 0;
    Real x477 = 0;
    Real x478 = 0;
    Real x479 = 0;
    Real x480 = 0;
    Real x481 = 0;
    Real x482 = 0;
    Real x483 = 0;
    Real x484 = 0;
    Real x485 = 0;
    Real x486 = 0;
    Real x487 = 0;
    Real x488 = 0;
    Real x489 = 0;
    Real x490 = 0;
    Real x491 = 0;
    Real x492 = 0;
    Real x493 = 0;
    Real x494 = 0;
    Real x495 = 0;
    Real x496 = 0;
    Real x497 = 0;
    Real x498 = 0;
    Real x499 = 0;
    Real x500 = 0;
    Real x501 = 0;
    Real x502 = 0;
    Real x503 = 0;
    Real x504 = 0;
    Real x505 = 0;
    Real x506 = 0;
    Real x507 = 0;
    Real x508 = 0;
    Real x509 = 0;
    Real x510 = 0;
    Real x511 = 0;
    Real x512 = 0;
    Real x513 = 0;
    Real x514 = 0;
    Real x515 = 0;
    Real x516 = 0;
    Real x517 = 0;
    Real x518 = 0;
    Real x519 = 0;
    Real x520 = 0;
    Real x521 = 0;
    Real x522 = 0;
    Real x523 = 0;
    Real x524 = 0;
    Real x525 = 0;
    Real x526 = 0;
    Real x527 = 0;
    Real x528 = 0;
    Real x529 = 0;
    Real x530 = 0;
    Real x531 = 0;
    Real x532 = 0;
    Real x533 = 0;
    x0 = 2.5950363272655348e-10*std::exp((-0.75)*std::log(std::abs(T)));

    x1 = std::sqrt(T);

    x2 = 1.0/x1;

    x3 = 7.1999999999999996e-8*x2;

    x4 = std::exp(-6.1728395061728397e-5*T);

    x5 = X(2)*x4;

    x6 = std::exp((0.92800000000000005)*std::log(std::abs(T)));

    x7 = 1.4000000000000001e-18*x6;

    x8 = std::exp(-0.00010729613733905579*T);

    x9 = X(5)*x8;

    x10 = std::exp((0.94999999999999996)*std::log(std::abs(T)));

    x11 = 1.3300135414628029e-18*x10;

    x12 = 1.0/T;

    x13 = std::exp(-46707.0*x12);

    x14 = X(8)*x13;

    x15 = 35.5*std::exp((-2.2799999999999998)*std::log(std::abs(T)));

    x16 = 0.00060040841663220993*x1 + 1.0;

    x17 = std::exp((-1.7524)*std::log(std::abs(x16)));

    x18 = 0.32668576019240059*x1 + 1.0;

    x19 = std::exp((-0.24759999999999999)*std::log(std::abs(x18)));

    x20 = X(11)*x19;

    x21 = x17*x20;

    x22 = 5.7884371785482823e-10*x2;

    x23 = ((T)*(T));

    x24 = ((T)*(T)*(T));

    x25 = ((((T)*(T)))*(((T)*(T))));

    x26 = T <= 10000.0;

    x27 = ((x26) ? (
   -5.5279999999999998e-28*((T)*(T)*(T)*(T)*(T)) - 2.3088e-11*T + 7.3427999999999993e-15*x23 - 7.5474000000000004e-19*x24 + 3.3467999999999999e-23*x25 + 4.2277999999999996e-8
)
: (
   0
));

    x28 = 1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)));

    x29 = 8.6173430000000006e-5*T;

    x30 = x29 <= 9280.0;

    x31 = (1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661*x12))*std::exp(-469943.50750964211*x12);

    x32 = ((x30) ? (
   x28
)
: (
   1250086.112245841*std::exp((-1.5)*std::log(std::abs(T)))*x31 + x28
));

    x33 = std::exp((2.360852208681)*std::log(std::abs(T)));

    x34 = std::log(x29);

    x35 = ((x34)*(x34));

    x36 = ((x34)*(x34)*(x34));

    x37 = ((((x34)*(x34)))*(((x34)*(x34))));

    x38 = ((x34)*(x34)*(x34)*(x34)*(x34));

    x39 = std::exp((6)*std::log(std::abs(x34)));

    x40 = ((x34)*(x34)*(x34)*(x34)*(x34)*(x34)*(x34));

    x41 = std::exp((8)*std::log(std::abs(x34)));

    x42 = std::exp(-0.28274430617039997*x35 + 0.01623316639567*x36 - 0.033650120313629989*x37 + 0.01178329782711*x38 - 0.001656194699504*x39 + 0.0001068275202678*x40 - 2.6312858092069998e-6*x41);

    x43 = std::exp((13.536555999999999)*std::log(std::abs(T)));

    x44 = std::exp(-5.7393287500000003*x35 + 1.56315498*x36 - 0.28770560000000001*x37 + 0.034825597700000002*x38 - 0.00263197617*x39 + 0.000111954395*x40 - 2.0391498499999999e-6*x41);

    x45 = std::exp((23.915965629999999)*std::log(std::abs(T)));

    x46 = std::exp(-10.753230200000001*x35 + 3.0580387500000001*x36 - 0.56851189000000002*x37 + 0.067953912300000002*x38 - 0.0050090561*x39 + 0.000206723616*x40 - 3.6491614100000001e-6*x41);

    x47 = std::exp((43.933476326349997)*std::log(std::abs(T)));

    x48 = std::exp(-18.480669935680002*x35 + 4.7016264867590021*x36 - 0.76924663344919997*x37 + 0.081130420973029999*x38 - 0.005324020628287001*x39 + 0.00019757053122209999*x40 - 3.1655810656650001e-6*x41);

    x49 = x29 <= 5500.0;

    x50 = std::exp((-0.72411256578268512)*std::log(std::abs(T)));

    x51 = ((x34)*(x34)*(x34)*(x34)*(x34)*(x34)*(x34)*(x34)*(x34));

    x52 = std::exp(-0.02026044731984691*x35 - 0.002380861877349834*x36 - 0.00032126052131887958*x37 - 1.421502914054107e-5*x38 + 4.9891089202995129e-6*x39 + 5.7556141375757583e-7*x40 - 1.8567670397752609e-8*x41 - 3.0711352431965949e-9*x51);

    x53 = ((x49) ? (
   x28
)
: (
   3.2867337024382687e-10*x50*x52
));

    x54 = 1.0e-8*std::exp((-0.40000000000000002)*std::log(std::abs(T)));

    x55 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x56 = 0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0;

    x57 = 1.0/x56;

    x58 = 1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T)));

    x59 = x57*x58;

    x60 = 5.9082438637265071e-70*x43;

    x61 = T <= 1160.0;

    x62 = std::exp(-0.14210135215541481*x35 + 0.0084644553866299998*x36 - 0.0014327641212992001*x37 + 0.00020122502847909999*x38 + 8.6639632430900003e-5*x39 - 2.5850096802639999e-5*x40 + 2.4555011970391999e-6*x41 - 8.0683824611800006e-8*x51);

    x63 = 3.3178155742407614e-14*std::exp((1.1394493358416311)*std::log(std::abs(T)))*x62;

    x64 = ((x61) ? (
   1.4643482606109061e-16*std::exp((1.78186)*std::log(std::abs(T)))
)
: (
   x63
));

    x65 = 3.7903999274394518e-18*x33;

    x66 = X(0)*x17;

    x67 = 3.8571873359681582e-209*x47*x48;

    x68 = 4.3524079114767552e-117*x45;

    x69 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x70 = 2.0860422997526066e-16*x69;

    x71 = 3.4767371836380304e-16*x69;

    x72 = 2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)));

    x73 = X(0)/std::exp((3.0/2.0)*std::log(std::abs(T)));

    x74 = X(0)*x5;

    x75 = X(0)*x9;

    x76 = X(0)*x14;

    x77 = X(2)*X(3);

    x78 = X(3)*x42;

    x79 = X(2)*x44;

    x80 = X(13)*x46;

    x81 = X(0)*X(12);

    x82 = -9.5174852894472843e-11*std::exp((-1.6353)*std::log(std::abs(T)));

    x83 = std::exp((-3.5)*std::log(std::abs(T)));

    x84 = x12*x34;

    x85 = x12*x36;

    x86 = x12*x38;

    x87 = x12*x40;

    x88 = x12*x41;

    jac(1,1) = -X(1)*x53 - X(12)*x32 + 3.8571873359681582e-209*X(12)*x47*x48 + 4.3524079114767552e-117*X(13)*x45*x46 + 5.9082438637265071e-70*X(2)*x43*x44 + 3.7903999274394518e-18*X(3)*x33*x42 - X(4)*x0 - X(6)*x27 - X(9)*x3 - x11*x9 - x14*x15 - x21*x22 - x5*x7;


    jac(1,2) = -X(0)*x53 + X(3)*x54;


    jac(1,3) = -X(0)*x4*x7 + X(0)*x44*x60 + X(3)*x59 + X(3)*x64 + X(7)*x55;


    jac(1,4) = X(0)*x42*x65 + X(1)*x54 + X(2)*x59 + X(2)*x64 + X(5)*x55;


    jac(1,5) = -X(0)*x0;


    jac(1,6) = -X(0)*x11*x8 + X(3)*x55;


    jac(1,7) = -X(0)*x27;


    jac(1,8) = X(2)*x55;


    jac(1,9) = -X(0)*x13*x15;


    jac(1,10) = -X(0)*x3;


    jac(1,11) = 0;


    jac(1,12) = -x19*x22*x66;


    jac(1,13) = -X(0)*x32 + X(0)*x67;


    jac(1,14) = X(0)*x46*x68;


    jac(1,15) = (-1658098.5*std::exp((-4.2799999999999994)*std::log(std::abs(T)))*x76 + 80.939999999999998*std::exp((-3.2799999999999998)*std::log(std::abs(T)))*x76 + 1.9462772454491511e-10*std::exp((-1.75)*std::log(std::abs(T)))*X(0)*X(4) - 4.0000000000000002e-9*std::exp((-1.3999999999999999)*std::log(std::abs(T)))*X(1)*X(3) - 1.2992000000000002e-18*std::exp((-0.071999999999999953)*std::log(std::abs(T)))*x74 - 1.2635128643896626e-18*std::exp((-0.050000000000000044)*std::log(std::abs(T)))*x75 + 8.9485740404797324e-18*std::exp((1.360852208681)*std::log(std::abs(T)))*X(0)*x78 + 7.997727392299023e-69*std::exp((12.536555999999999)*std::log(std::abs(T)))*X(0)*x79 + 1.0409203801861816e-115*std::exp((22.915965629999999)*std::log(std::abs(T)))*X(0)*x80 + 1.694596485110541e-207*std::exp((42.933476326349997)*std::log(std::abs(T)))*x48*x81 - X(0)*X(1)*((x49) ? (
   x82
)
: (
   -2.3799651743169991e-10*std::exp((-1.724112565782685)*std::log(std::abs(T)))*x52 + 3.2867337024382687e-10*x50*x52*(-0.0071425856320495021*x12*x35 - 7.1075145702705346e-5*x12*x37 + 2.9934653521797078e-5*x12*x38 + 4.0289298963030308e-6*x12*x39 - 0.04052089463969382*x84 - 0.0012850420852755183*x85 - 1.4854136318202087e-7*x87 - 2.7640217188769353e-8*x88)
)) - X(0)*X(6)*((x26) ? (
   1.4685599999999999e-14*T - 2.2642200000000001e-18*x23 + 1.3387199999999999e-22*x24 - 2.7639999999999999e-27*x25 - 2.3088e-11
)
: (
   0
)) + 3.0451686126851684e-13*X(0)*x12*std::exp((-2.7523999999999997)*std::log(std::abs(x16)))*x20 + X(0)*x60*x79*(4.6894649399999997*x12*x35 + 0.1741279885*x12*x37 + 0.00078368076500000001*x12*x39 - 11.478657500000001*x84 - 1.1508224*x85 - 0.015791857020000001*x86 - 1.6313198799999999e-5*x87) + X(0)*x65*x78*(0.048699499187009998*x12*x35 + 0.058916489135550004*x12*x37 + 0.00074779264187460007*x12*x39 - 0.56548861234079995*x84 - 0.13460048125451995*x85 - 0.009937168197024001*x86 - 2.1050286473655998e-5*x87) + X(0)*x68*x80*(9.1741162500000009*x12*x35 + 0.33976956150000004*x12*x37 + 0.001447065312*x12*x39 - 21.506460400000002*x84 - 2.2740475600000001*x85 - 0.030054336600000002*x86 - 2.9193291280000001e-5*x87) + 2.3410580000000002e-11*X(11)*x12*std::exp((-1.2476)*std::log(std::abs(x18)))*x66 - X(2)*X(7)*x72 - X(3)*X(5)*x72 + 3.5999999999999998e-8*X(9)*x73 + 1.4270531560759686e-22*x10*x75 + 2.8942185892741411e-10*x21*x73 + x57*x77*(1.3296555000000001e-10*std::exp((-0.90150700000000006)*std::log(std::abs(T))) + 2.466314622e-10*std::exp((-0.44389999999999996)*std::log(std::abs(T))) + 8.1647792100000001e-16*std::exp((1.1825999999999999)*std::log(std::abs(T)))) + 8.6419753086419757e-23*x6*x74 + x67*x81*(14.104879460277006*x12*x35 + 0.40565210486515002*x12*x37 + 0.0013829937185547*x12*x39 - 36.961339871360003*x84 - 3.0769865337967999*x85 - 0.031944123769722006*x86 - 2.5324648525320001e-5*x87) + x77*((x61) ? (
   2.6092635916521491e-16*std::exp((0.78186)*std::log(std::abs(T)))
)
: (
   3.7804827525136553e-14*std::exp((0.13944933584163111)*std::log(std::abs(T)))*x62 + x63*(0.025393366159889998*x12*x35 + 0.0010061251423955*x12*x37 + 0.00051983779458540007*x12*x38 - 0.00018095067761848*x12*x39 + 1.9644009576313599e-5*x12*x40 - 0.28420270431082961*x84 - 0.0057310564851968003*x85 - 7.2615442150620009e-7*x88)
)) - x81*((x30) ? (
   x82
)
: (
   -1875129.1683687614*std::exp((-2.5)*std::log(std::abs(T)))*x31 + 587469852277.90271*x31*x83 + x82 + 54.282214350476039*x83*std::exp(-563932.20901156683*x12)
)) + x58*x77*(-0.0064764051000000007*std::exp((0.04610000000000003)*std::log(std::abs(T))) - 2.7293978880000002e-10*std::exp((2.0424000000000002)*std::log(std::abs(T))) - 1.229450816e-13*std::exp((2.7740999999999998)*std::log(std::abs(T))))/((x56)*(x56)))/(X(0)*x70 + X(1)*x70 + X(10)*x71 + X(11)*x70 + X(12)*x70 + X(13)*x70 + X(2)*x70 + X(3)*x70 + X(4)*x70 + X(5)*x70 + X(6)*x71 + X(7)*x70 + X(8)*x71 + X(9)*x71);


    x0 = 8.6173430000000006e-5*T;

    x1 = std::log(x0);

    x2 = ((x1)*(x1));

    x3 = ((x1)*(x1)*(x1));

    x4 = ((((x1)*(x1)))*(((x1)*(x1))));

    x5 = ((x1)*(x1)*(x1)*(x1)*(x1));

    x6 = std::exp((6)*std::log(std::abs(x1)));

    x7 = ((x1)*(x1)*(x1)*(x1)*(x1)*(x1)*(x1));

    x8 = std::exp((8)*std::log(std::abs(x1)));

    x9 = std::exp(-5.7393287500000003*x2 + 1.56315498*x3 - 0.28770560000000001*x4 + 0.034825597700000002*x5 - 0.00263197617*x6 + 0.000111954395*x7 - 2.0391498499999999e-6*x8);

    x10 = std::exp((13.536555999999999)*std::log(std::abs(T)));

    x11 = 5.9082438637265071e-70*x10;

    x12 = x0 <= 5500.0;

    x13 = std::exp((-0.72411256578268512)*std::log(std::abs(T)));

    x14 = std::exp(-3.0711352431965949e-9*((x1)*(x1)*(x1)*(x1)*(x1)*(x1)*(x1)*(x1)*(x1)) - 0.02026044731984691*x2 - 0.002380861877349834*x3 - 0.00032126052131887958*x4 - 1.421502914054107e-5*x5 + 4.9891089202995129e-6*x6 + 5.7556141375757583e-7*x7 - 1.8567670397752609e-8*x8);

    x15 = ((x12) ? (
   1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)))
)
: (
   3.2867337024382687e-10*x13*x14
));

    x16 = 7.9674337148168363e-7*std::exp((-0.5)*std::log(std::abs(T)));

    x17 = 1.0e-8*std::exp((-0.40000000000000002)*std::log(std::abs(T)));

    x18 = 1.0/T;

    x19 = std::exp(-457.0*x18);

    x20 = 1.0000000000000001e-9*x19;

    x21 = std::exp((-0.75)*std::log(std::abs(T)));

    x22 = std::exp(-127500.0*x18);

    x23 = T <= 10000.0;

    x24 = ((x23) ? (
   1.26e-9*x21*x22
)
: (
   4.0000000000000003e-37*std::exp((4.7400000000000002)*std::log(std::abs(T)))
));

    x25 = std::exp(-37.100000000000001*x18);

    x26 = T >= 50.0;

    x27 = ((x26) ? (
   2.0000000000000001e-10*std::exp((0.40200000000000002)*std::log(std::abs(T)))*x25 - 3.3099999999999998e-17*std::exp((1.48)*std::log(std::abs(T)))
)
: (
   0
));

    x28 = std::sqrt(T);

    x29 = 1.0/x28;

    x30 = T >= 10.0 && T <= 100000.0;

    x31 = ((x30) ? (
   -7.7700000000000002e-13*T + 2.5000000000000002e-10*x28 + 2.96e-6*x29 - 1.73e-9
)
: (
   0
));

    x32 = std::log(T);

    x33 = M_LN10;

    x34 = 1.0/x33;

    x35 = x32*x34;

    x36 = std::exp((-3.0)*std::log(std::abs(x33)));

    x37 = std::exp((-2.0)*std::log(std::abs(x33)));

    x38 = ((x32)*(x32));

    x39 = std::exp((-0.12690000000000001*((x32)*(x32)*(x32))*x36 - 1.5229999999999999*x35 + 1.1180000000000001*x37*x38 - 19.379999999999999)*std::log(std::abs(10.0)));

    x40 = X(5)*x39;

    x41 = T < 30;

    x42 = amrex::Math::powi<-3>(x33);

    x43 = ((x32)*(x32)*(x32));

    x44 = std::exp((-2)*std::log(std::abs(x33)));

    x45 = ((x32)*(x32));

    x46 = std::exp((-3.194*x35 - 0.2072*x42*x43 + 1.786*x44*x45 - 18.199999999999999)*std::log(std::abs(10)));

    x47 = ((x41) ? (
   3.4977396723747635e-20*std::exp((-0.14999999999999999)*std::log(std::abs(T)))
)
: (
   x46
));

    x48 = std::exp(-21237.150000000001*x18);

    x49 = ((((x32)*(x32)))*(((x32)*(x32))));

    x50 = ((x32)*(x32)*(x32)*(x32)*(x32));

    x51 = std::exp((6)*std::log(std::abs(x32)));

    x52 = x48*(3.5311931999999998e-13*((x32)*(x32)*(x32)*(x32)*(x32)*(x32)*(x32)) + 3.3735381999999997e-7*x32 + 3.4172804999999998e-8*x43 - 1.4491368e-7*x45 - 4.7813727999999997e-9*x49 + 3.9731542e-10*x50 - 1.8171411000000001e-11*x51 - 3.3232183000000002e-7);

    x53 = T >= 100.0 && T <= 30000.0;

    x54 = ((x53) ? (
   x52
)
: (
   0
));

    x55 = 2.8833736969617052e-16*std::exp((0.25)*std::log(std::abs(T)));

    x56 = std::exp(-33.0*x18);

    x57 = ((x26) ? (
   2.0299999999999998e-9*std::exp((-0.33200000000000002)*std::log(std::abs(T))) + 2.0600000000000001e-10*std::exp((0.39600000000000002)*std::log(std::abs(T)))*x56
)
: (
   0
));

    x58 = 8.4600000000000008e-10*x35 - 1.3700000000000002e-10*x44*x45 + 4.1700000000000001e-10;

    x59 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x60 = 2.0860422997526066e-16*x59;

    x61 = 3.4767371836380304e-16*x59;

    x62 = std::exp((-2)*std::log(std::abs(T)));

    x63 = x18*x32;

    x64 = x18*x34;

    x65 = x18*x45;

    x66 = x1*x18;

    x67 = x18*x3;

    x68 = x18*x7;

    jac(2,1) = -X(1)*x15 + X(2)*x11*x9;


    jac(2,2) = -X(0)*x15 - X(10)*x20 - X(13)*x24 - X(2)*x47 - X(3)*x17 - X(3)*x31 - X(5)*x27 - X(7)*x16 - X(8)*x54 - x40;


    jac(2,3) = X(0)*x11*x9 - X(1)*x47 + X(12)*x55 + X(4)*x57 + 6.0e-10*X(6) + 6.3999999999999996e-10*X(9);


    jac(2,4) = -X(1)*x17 - X(1)*x31;


    jac(2,5) = X(2)*x57 + X(8)*x58;


    jac(2,6) = -X(1)*x27 - X(1)*x39;


    jac(2,7) = 6.0e-10*X(2);


    jac(2,8) = -X(1)*x16;


    jac(2,9) = -X(1)*x54 + X(4)*x58;


    jac(2,10) = 6.3999999999999996e-10*X(2);


    jac(2,11) = -X(1)*x20;


    jac(2,12) = 0;


    jac(2,13) = X(2)*x55;


    jac(2,14) = -X(1)*x24;


    jac(2,15) = (3.9837168574084181e-7*std::exp((-1.5)*std::log(std::abs(T)))*X(1)*X(7) + 4.0000000000000002e-9*std::exp((-1.3999999999999999)*std::log(std::abs(T)))*X(1)*X(3) + 7.997727392299023e-69*std::exp((12.536555999999999)*std::log(std::abs(T)))*X(0)*X(2)*x9 - X(0)*X(1)*((x12) ? (
   -9.5174852894472843e-11*std::exp((-1.6353)*std::log(std::abs(T)))
)
: (
   -2.3799651743169991e-10*std::exp((-1.724112565782685)*std::log(std::abs(T)))*x14 + 3.2867337024382687e-10*x13*x14*(-0.0071425856320495021*x18*x2 - 7.1075145702705346e-5*x18*x4 + 2.9934653521797078e-5*x18*x5 + 4.0289298963030308e-6*x18*x6 - 2.7640217188769353e-8*x18*x8 - 0.04052089463969382*x66 - 0.0012850420852755183*x67 - 1.4854136318202087e-7*x68)
)) + 5.9082438637265071e-70*X(0)*X(2)*x10*x9*(4.6894649399999997*x18*x2 + 0.1741279885*x18*x4 - 0.015791857020000001*x18*x5 + 0.00078368076500000001*x18*x6 - 11.478657500000001*x66 - 1.1508224*x67 - 1.6313198799999999e-5*x68) - 4.5700000000000003e-7*X(1)*X(10)*x19*x62 - X(1)*X(13)*((x23) ? (
   0.00016065*std::exp((-2.75)*std::log(std::abs(T)))*x22 - 9.4499999999999994e-10*std::exp((-1.75)*std::log(std::abs(T)))*x22
)
: (
   1.8960000000000001e-36*std::exp((3.7400000000000002)*std::log(std::abs(T)))
)) - X(1)*X(2)*((x41) ? (
   -5.2466095085621454e-21*std::exp((-1.1499999999999999)*std::log(std::abs(T)))
)
: (
   x33*x46*(3.5720000000000001*x18*x32*x44 - 0.62159999999999993*x42*x65 - 3.194*x64)
)) - X(1)*X(3)*((x30) ? (
   1.2500000000000001e-10*x29 - 7.7700000000000002e-13 - 1.48e-6/std::exp((3.0/2.0)*std::log(std::abs(T)))
)
: (
   0
)) - X(1)*X(5)*((x26) ? (
   7.4200000000000004e-9*std::exp((-1.5979999999999999)*std::log(std::abs(T)))*x25 + 8.0400000000000002e-11*std::exp((-0.59799999999999998)*std::log(std::abs(T)))*x25 - 4.8987999999999998e-17*std::exp((0.47999999999999998)*std::log(std::abs(T)))
)
: (
   0
)) - X(1)*X(8)*((x53) ? (
   x48*(-1.9125491199999999e-8*x18*x43 + 1.9865770999999999e-9*x18*x49 - 1.09028466e-10*x18*x50 + 2.4718352399999997e-12*x18*x51 + 3.3735381999999997e-7*x18 - 2.8982736e-7*x63 + 1.0251841499999999e-7*x65) + 21237.150000000001*x52*x62
)
: (
   0
)) - X(1)*x40*(5.1485802679346868*x18*std::exp((1.0)*std::log(std::abs(x32)))*x37 - 0.87659414490283338*x18*x36*x38 - 3.5068370966299316*x64) + 7.2084342424042629e-17*X(12)*X(2)*x21 + X(2)*X(4)*((x26) ? (
   6.7980000000000007e-9*std::exp((-1.6040000000000001)*std::log(std::abs(T)))*x56 - 6.7396000000000002e-10*std::exp((-1.3320000000000001)*std::log(std::abs(T))) + 8.1576000000000009e-11*std::exp((-0.60399999999999998)*std::log(std::abs(T)))*x56
)
: (
   0
)) + X(4)*X(8)*(8.4600000000000008e-10*x18*x34 - 2.7400000000000004e-10*x44*x63))/(X(0)*x60 + X(1)*x60 + X(10)*x61 + X(11)*x60 + X(12)*x60 + X(13)*x60 + X(2)*x60 + X(3)*x60 + X(4)*x60 + X(5)*x60 + X(6)*x61 + X(7)*x60 + X(8)*x61 + X(9)*x61);


    x0 = std::sqrt(T);

    x1 = 1.0/x0;

    x2 = 7.1999999999999996e-8*x1;

    x3 = std::exp(-6.1728395061728397e-5*T);

    x4 = X(2)*x3;

    x5 = std::exp((0.92800000000000005)*std::log(std::abs(T)));

    x6 = 1.4000000000000001e-18*x5;

    x7 = 1.0/T;

    x8 = std::exp(-46707.0*x7);

    x9 = X(8)*x8;

    x10 = 35.5*std::exp((-2.2799999999999998)*std::log(std::abs(T)));

    x11 = std::exp(-102000.0*x7);

    x12 = X(8)*x11;

    x13 = 8.7599999999999997e-10*std::exp((0.34999999999999998)*std::log(std::abs(T)));

    x14 = ((T)*(T));

    x15 = ((T)*(T)*(T));

    x16 = ((((T)*(T)))*(((T)*(T))));

    x17 = T <= 10000.0;

    x18 = 2*((x17) ? (
   -5.5279999999999998e-28*((T)*(T)*(T)*(T)*(T)) - 2.3088e-11*T + 7.3427999999999993e-15*x14 - 7.5474000000000004e-19*x15 + 3.3467999999999999e-23*x16 + 4.2277999999999996e-8
)
: (
   0
));

    x19 = 8.6173430000000006e-5*T;

    x20 = std::log(x19);

    x21 = ((x20)*(x20));

    x22 = ((x20)*(x20)*(x20));

    x23 = ((((x20)*(x20)))*(((x20)*(x20))));

    x24 = ((x20)*(x20)*(x20)*(x20)*(x20));

    x25 = std::exp((6)*std::log(std::abs(x20)));

    x26 = ((x20)*(x20)*(x20)*(x20)*(x20)*(x20)*(x20));

    x27 = std::exp((8)*std::log(std::abs(x20)));

    x28 = std::exp(-0.28274430617039997*x21 + 0.01623316639567*x22 - 0.033650120313629989*x23 + 0.01178329782711*x24 - 0.001656194699504*x25 + 0.0001068275202678*x26 - 2.6312858092069998e-6*x27);

    x29 = X(3)*x28;

    x30 = 3.7903999274394518e-18*std::exp((2.360852208681)*std::log(std::abs(T)));

    x31 = x29*x30;

    x32 = std::exp(-5.7393287500000003*x21 + 1.56315498*x22 - 0.28770560000000001*x23 + 0.034825597700000002*x24 - 0.00263197617*x25 + 0.000111954395*x26 - 2.0391498499999999e-6*x27);

    x33 = X(2)*x32;

    x34 = 5.9082438637265071e-70*std::exp((13.536555999999999)*std::log(std::abs(T)));

    x35 = x33*x34;

    x36 = x19 <= 5500.0;

    x37 = std::exp((-0.72411256578268512)*std::log(std::abs(T)));

    x38 = ((x20)*(x20)*(x20)*(x20)*(x20)*(x20)*(x20)*(x20)*(x20));

    x39 = std::exp(-0.02026044731984691*x21 - 0.002380861877349834*x22 - 0.00032126052131887958*x23 - 1.421502914054107e-5*x24 + 4.9891089202995129e-6*x25 + 5.7556141375757583e-7*x26 - 1.8567670397752609e-8*x27 - 3.0711352431965949e-9*x38);

    x40 = ((x36) ? (
   1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)))
)
: (
   3.2867337024382687e-10*x37*x39
));

    x41 = std::exp((-0.75)*std::log(std::abs(T)));

    x42 = std::exp(-127500.0*x7);

    x43 = ((x17) ? (
   1.26e-9*x41*x42
)
: (
   4.0000000000000003e-37*std::exp((4.7400000000000002)*std::log(std::abs(T)))
));

    x44 = std::exp(-37.100000000000001*x7);

    x45 = T >= 50.0;

    x46 = ((x45) ? (
   2.0000000000000001e-10*std::exp((0.40200000000000002)*std::log(std::abs(T)))*x44 - 3.3099999999999998e-17*std::exp((1.48)*std::log(std::abs(T)))
)
: (
   0
));

    x47 = std::exp(-21237.150000000001*x7);

    x48 = std::log(T);

    x49 = ((x48)*(x48));

    x50 = ((x48)*(x48)*(x48));

    x51 = ((((x48)*(x48)))*(((x48)*(x48))));

    x52 = ((x48)*(x48)*(x48)*(x48)*(x48));

    x53 = std::exp((6)*std::log(std::abs(x48)));

    x54 = x47*(3.5311931999999998e-13*((x48)*(x48)*(x48)*(x48)*(x48)*(x48)*(x48)) + 3.3735381999999997e-7*x48 - 1.4491368e-7*x49 + 3.4172804999999998e-8*x50 - 4.7813727999999997e-9*x51 + 3.9731542e-10*x52 - 1.8171411000000001e-11*x53 - 3.3232183000000002e-7);

    x55 = T >= 100.0 && T <= 30000.0;

    x56 = ((x55) ? (
   x54
)
: (
   0
));

    x57 = T < 30;

    x58 = M_LN10;

    x59 = 1.0/x58;

    x60 = x48*x59;

    x61 = amrex::Math::powi<-3>(x58);

    x62 = x50*x61;

    x63 = std::exp((-2)*std::log(std::abs(x58)));

    x64 = std::exp((1.786*x49*x63 - 3.194*x60 - 0.2072*x62 - 18.199999999999999)*std::log(std::abs(10)));

    x65 = ((x57) ? (
   3.4977396723747635e-20*std::exp((-0.14999999999999999)*std::log(std::abs(T)))
)
: (
   x64
));

    x66 = T >= 10.0 && T <= 100000.0;

    x67 = 2*((x66) ? (
   -7.7700000000000002e-13*T + 2.5000000000000002e-10*x0 + 2.96e-6*x1 - 1.73e-9
)
: (
   0
));

    x68 = std::sqrt(T);

    x69 = 1.0/x68;

    x70 = X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9);

    x71 = x49*x63;

    x72 = -4.8909149999999997*x48*x59 - 133.82830000000001*x7 + 0.47490300000000002*x71;

    x73 = std::exp((x72 + 14.82123)*std::log(std::abs(10.0)));

    x74 = 1.0/x73;

    x75 = x70*x74;

    x76 = std::exp(-0.0022727272727272726*T);

    x77 = std::exp(-0.00054054054054054055*T);

    x78 = -2.0563129999999998*x76 + 0.58640729999999996*x77 + 0.82274429999999998;

    x79 = std::exp((x78)*std::log(std::abs(x75)));

    x80 = x79 + 1.0;

    x81 = 1.0/x80;

    x82 = 16780.950000000001*x7 + 1.0;

    x83 = 40870.379999999997*x7 + 1.0;

    x84 = -69.700860000000006*x59*std::log(x83) + 4.6331670000000003*x62;

    x85 = 37.886913*x49*x63 + 19.734269999999999*x59*std::log(x82) - 14.509090000000008*x60 - x84 - 307.31920000000002;

    x86 = std::exp((x72 + 13.656822)*std::log(std::abs(10.0)));

    x87 = 1.0/x86;

    x88 = x70*x87;

    x89 = std::exp((x78)*std::log(std::abs(x88)));

    x90 = x89 + 1.0;

    x91 = 1.0/x90;

    x92 = std::exp((43.20243*x49*x63 - 68.422430000000006*x60 - 2080.4099999999999*x7*x91 - 23705.700000000001*x7 - x81*x85 - x84 - 178.4239)*std::log(std::abs(10.0)));

    x93 = x7*x89/((x90)*(x90));

    x94 = 4790.3210533157426*x93;

    x95 = x86*x87;

    x96 = 1.0/x70;

    x97 = x78*x96;

    x98 = x95*x97;

    x99 = x79*x85/((x80)*(x80));

    x100 = 2.3025850929940459*x99;

    x101 = x73*x74;

    x102 = x101*x97;

    x103 = x92*(x100*x102 + x94*x98);

    x104 = -2.4640089999999999*x48*x59 + 743.05999999999995*x7 + 0.19859550000000001*x71;

    x105 = std::exp((x104 + 9.3055640000000004)*std::log(std::abs(10.0)));

    x106 = 1.0/x105;

    x107 = x106*x70;

    x108 = 2.9375070000000001*x76 + 0.23588480000000001*x77 + 0.75022860000000002;

    x109 = std::exp((x108)*std::log(std::abs(x107)));

    x110 = x109 + 1.0;

    x111 = 1.0/x110;

    x112 = 14254.549999999999*x7 + 1.0;

    x113 = 27535.310000000001*x7 + 1.0;

    x114 = -21.360939999999999*x59*std::log(x113) + 0.25820969999999999*x62;

    x115 = -x114 + 70.138370000000009*x48*x59 + 11.28215*x59*std::log(x112) - 4.7035149999999994*x71 - 203.11568;

    x116 = std::exp((x104 + 8.1313220000000008)*std::log(std::abs(10.0)));

    x117 = 1.0/x116;

    x118 = x117*x70;

    x119 = std::exp((x108)*std::log(std::abs(x118)));

    x120 = x119 + 1.0;

    x121 = 1.0/x120;

    x122 = std::exp((-x111*x115 - x114 - 1657.4099999999999*x121*x7 + 42.707410000000003*x48*x59 - 21467.790000000001*x7 - 2.0273650000000001*x71 - 142.7664)*std::log(std::abs(10.0)));

    x123 = x119*x7/((x120)*(x120));

    x124 = 3816.3275589792611*x123;

    x125 = x116*x117;

    x126 = x108*x96;

    x127 = x125*x126;

    x128 = x109*x115/((x110)*(x110));

    x129 = 2.3025850929940459*x128;

    x130 = x105*x106;

    x131 = x126*x130;

    x132 = x122*(x124*x127 + x129*x131);

    x133 = -x103 - x132;

    x134 = X(2)*X(8);

    x135 = 3*x103 + 3*x132;

    x136 = std::log(0.0001*T);

    x137 = std::exp((-1.6200000000000001*((x136)*(x136))*x63 + 1.3*x136*x59 - 4.8449999999999998)*std::log(std::abs(10.0)));

    x138 = x137*x70;

    x139 = x138 + 1.0;

    x140 = std::exp((-2)*std::log(std::abs(x139)));

    x141 = 1.0 - std::exp(-6000.0*x7);

    x142 = 52000.0*x7;

    x143 = std::exp(-x142);

    x144 = x141*x143;

    x145 = 8.1250000000000003e-8*x144*x69;

    x146 = std::log(x145);

    x147 = x140*x146;

    x148 = ((X(8))*(X(8)));

    x149 = 1.1800000000000001e-10*std::exp(-69500.0*x7);

    x150 = 1.0/x139;

    x151 = 1.0*x150;

    x152 = std::exp((x151)*std::log(std::abs(x149)));

    x153 = 1.0 - x151;

    x154 = std::exp((x153)*std::log(std::abs(x145)));

    x155 = x152*x154;

    x156 = x148*x155;

    x157 = x137*x156;

    x158 = 2.0*x157;

    x159 = x140*std::log(x149);

    x160 = x158*x159;

    x161 = x133*x134 + x134*x135 + x147*x158 - x160;

    x162 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x163 = std::exp((0.25)*std::log(std::abs(T)));

    x164 = 2.8833736969617052e-16*x163;

    x165 = 6.1739095063118665e-10*std::exp((0.40999999999999998)*std::log(std::abs(T)));

    x166 = 1.0/x163;

    x167 = -1.5e-32*x166 - 5.0000000000000004e-32*x69;

    x168 = ((X(2))*(X(2)));

    x169 = 1.0/x14;

    x170 = 5.25e-11*std::exp(173900.0*x169 - 4430.0*x7);

    x171 = T > 200.0;

    x172 = ((x171) ? (
   x170
)
: (
   0
));

    x173 = std::exp(-33.0*x7);

    x174 = ((x45) ? (
   2.0299999999999998e-9*std::exp((-0.33200000000000002)*std::log(std::abs(T))) + 2.0600000000000001e-10*std::exp((0.39600000000000002)*std::log(std::abs(T)))*x173
)
: (
   0
));

    x175 = std::exp((-3.0)*std::log(std::abs(x58)));

    x176 = std::exp((-2.0)*std::log(std::abs(x58)));

    x177 = ((x48)*(x48));

    x178 = std::exp((-0.12690000000000001*x175*((x48)*(x48)*(x48)) + 1.1180000000000001*x176*x177 - 1.5229999999999999*x60 - 19.379999999999999)*std::log(std::abs(10.0)));

    x179 = X(4)*x178;

    x180 = 0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0;

    x181 = 1.0/x180;

    x182 = 1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T)));

    x183 = x181*x182;

    x184 = T <= 1160.0;

    x185 = std::exp(-0.14210135215541481*x21 + 0.0084644553866299998*x22 - 0.0014327641212992001*x23 + 0.00020122502847909999*x24 + 8.6639632430900003e-5*x25 - 2.5850096802639999e-5*x26 + 2.4555011970391999e-6*x27 - 8.0683824611800006e-8*x38);

    x186 = 3.3178155742407614e-14*std::exp((1.1394493358416311)*std::log(std::abs(T)))*x185;

    x187 = ((x184) ? (
   1.4643482606109061e-16*std::exp((1.78186)*std::log(std::abs(T)))
)
: (
   x186
));

    x188 = -x122 - x92;

    x189 = 3*x92;

    x190 = 3*x122;

    x191 = x189 + x190;

    x192 = 4.9999999999999996e-6*x1;

    x193 = amrex::Math::powi<-5>(x58);

    x194 = std::exp((-4)*std::log(std::abs(x58)));

    x195 = std::exp((0.31788699999999998*x193*x52 - 2.1690299999999998*x194*x51 + 5.8888600000000002*x60 + 2.2506900000000001*x62 + 7.1969200000000004*x71 - 56.473700000000001)*std::log(std::abs(10)));

    x196 = T <= 1167.4796423742259;

    x197 = std::exp(-5207.0*x7);

    x198 = ((x196) ? (
   x195
)
: (
   3.1699999999999999e-10*x197
));

    x199 = 4.6051701859880918*x102*x99 + 9580.6421066314851*x93*x98;

    x200 = 7632.6551179585222*x123*x127 + 4.6051701859880918*x128*x131;

    x201 = 4.0*x157;

    x202 = x134*(-x122*x200 - x199*x92) + x134*(x189*x199 + x190*x200) + x147*x201 - x159*x201;

    x203 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x204 = 2.0860422997526066e-16*x203;

    x205 = 3.4767371836380304e-16*x203;

    x206 = std::exp((-1.5)*std::log(std::abs(T)));

    x207 = X(2)*X(7);

    x208 = 2.5313028975878652e-10*std::exp((-0.59000000000000008)*std::log(std::abs(T)));

    x209 = std::exp((-3.0/2.0)*std::log(std::abs(T)));

    x210 = X(0)*x4;

    x211 = X(0)*x9;

    x212 = X(0)*x12;

    x213 = ((X(2))*(X(2))*(X(2)));

    x214 = std::exp((-1.25)*std::log(std::abs(T)));

    x215 = X(2)*X(3);

    x216 = x59*x7;

    x217 = x49*x7;

    x218 = x217*x61;

    x219 = x48*x7;

    x220 = x50*x7;

    x221 = x51*x7;

    x222 = x20*x7;

    x223 = x22*x7;

    x224 = x24*x7;

    x225 = x26*x7;

    x226 = x219*x63;

    x227 = x27*x7;

    x228 = 1.0*x138*(-7.460375701300709*x136*x63*x7 + 2.9933606208922598*x59*x7);

    x229 = 2*x156;

    x230 = std::exp((-2.5)*std::log(std::abs(T)));

    x231 = x169*x59;

    x232 = x231/x83;

    x233 = 0.0046734386363636356*x76 - 0.00031697691891891889*x77;

    x234 = x78*(-308.15104860073512*x169 - 2.1870091368363029*x226 + 11.261747970100974*x59*x7);

    x235 = x100*(x101*x234 + x233*std::log(x75)) + 4790.3210533157426*x169*x91 + 54584.391438988954*x169 - 157.54846734442862*x216 - 32.004783802655837*x218 + 198.95454259823751*x226 - 6559375.6154640894*x232 - 2.3025850929940459*x81*(-14.509090000000008*x216 - 13.899501000000001*x218 - 331159.79815649998*x231/x82 - 2848700.6345267999*x232 + 75.773826*x48*x63*x7) + x94*(x233*std::log(x88) + x234*x95);

    x236 = x231/x113;

    x237 = -0.0066761522727272725*x76 - 0.0001275052972972973*x77;

    x238 = x108*(1710.9588792001557*x169 + 5.6735903924031659*x216 - 0.91456607567139814*x226);

    x239 = -2.3025850929940459*x111*(-0.77462909999999996*x218 - 9.4070299999999989*x226 - 588180.10479140002*x236 + 70.138370000000009*x59*x7 - 160821.97128249999*x231/x112) + 3816.3275589792611*x121*x169 + x124*(x125*x238 + x237*std::log(x118)) + x129*(x130*x238 + x237*std::log(x107)) + 49431.413233526648*x169 + 98.337445626384849*x216 - 1.783649418259394*x218 - 9.3363608541157479*x226 - 1354334.7412883535*x236;

    jac(3,1) = X(1)*x40 + X(6)*x18 + X(9)*x2 + x10*x9 + x12*x13 + x31 - x35 - x4*x6;


    jac(3,2) = X(0)*x40 + X(13)*x43 - X(2)*x65 + X(3)*x67 + X(5)*x46 + 7.9674337148168363e-7*X(7)*x69 + X(8)*x56 + x161;


    jac(3,3) = -X(0)*x3*x6 - X(0)*x32*x34 - X(1)*x65 - X(10)*x172 - X(12)*x164 + X(2)*X(8)*x133 + X(2)*X(8)*x135 + 2*X(2)*X(8)*x167 - X(3)*x183 + X(3)*x187 - X(4)*x174 - 1.0e-25*X(5) - 6.0e-10*X(6) - X(7)*x162 - X(7)*x165 + X(8)*x188 + X(8)*x191 - 6.3999999999999996e-10*X(9) + 2.0*x137*x140*x146*x148*x152*x154 - x160 + 3*x168*(-1.8e-31*x166 - 6.0000000000000005e-31*x69) + 3*x168*(6.0000000000000001e-32*x166 + 2.0000000000000002e-31*x69) - x179;


    jac(3,4) = X(0)*x28*x30 + X(1)*x67 - X(2)*x183 + X(2)*x187 + X(5)*x165 + X(6)*x192 + x161;


    jac(3,5) = -X(2)*x174 - X(2)*x178;


    jac(3,6) = X(1)*x46 - 1.0e-25*X(2) + X(3)*x165 + X(8)*x198;


    jac(3,7) = X(0)*x18 - 6.0e-10*X(2) + X(3)*x192 + x202;


    jac(3,8) = 7.9674337148168363e-7*X(1)*x69 - X(2)*x162 - X(2)*x165;


    jac(3,9) = X(0)*x10*x8 + X(0)*x11*x13 + X(1)*x56 + X(2)*x188 + X(2)*x191 + X(5)*x198 + 4*X(8)*x155 + x167*x168 + x202;


    jac(3,10) = X(0)*x2 - 6.3999999999999996e-10*X(2) + x161;


    jac(3,11) = -X(2)*x172 + x161;


    jac(3,12) = 0;


    jac(3,13) = -X(2)*x164;


    jac(3,14) = X(1)*x43;


    jac(3,15) = (1658098.5*std::exp((-4.2799999999999994)*std::log(std::abs(T)))*x211 - 80.939999999999998*std::exp((-3.2799999999999998)*std::log(std::abs(T)))*x211 + 8.9351999999999994e-5*std::exp((-1.6499999999999999)*std::log(std::abs(T)))*x212 + 2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)))*x207 + 3.0659999999999995e-10*std::exp((-0.65000000000000002)*std::log(std::abs(T)))*x212 - 1.2992000000000002e-18*std::exp((-0.071999999999999953)*std::log(std::abs(T)))*x210 + 8.9485740404797324e-18*std::exp((1.360852208681)*std::log(std::abs(T)))*X(0)*x29 - 7.997727392299023e-69*std::exp((12.536555999999999)*std::log(std::abs(T)))*X(0)*x33 + X(0)*X(1)*((x36) ? (
   -9.5174852894472843e-11*std::exp((-1.6353)*std::log(std::abs(T)))
)
: (
   -2.3799651743169991e-10*std::exp((-1.724112565782685)*std::log(std::abs(T)))*x39 + 3.2867337024382687e-10*x37*x39*(-0.0071425856320495021*x21*x7 - 0.04052089463969382*x222 - 0.0012850420852755183*x223 - 1.4854136318202087e-7*x225 - 2.7640217188769353e-8*x227 - 7.1075145702705346e-5*x23*x7 + 2.9934653521797078e-5*x24*x7 + 4.0289298963030308e-6*x25*x7)
)) + 2*X(0)*X(6)*((x17) ? (
   1.4685599999999999e-14*T - 2.2642200000000001e-18*x14 + 1.3387199999999999e-22*x15 - 2.7639999999999999e-27*x16 - 2.3088e-11
)
: (
   0
)) - 3.5999999999999998e-8*X(0)*X(9)*x209 + X(0)*x31*(0.048699499187009998*x21*x7 - 0.56548861234079995*x222 - 0.13460048125451995*x223 - 0.009937168197024001*x224 - 2.1050286473655998e-5*x225 + 0.058916489135550004*x23*x7 + 0.00074779264187460007*x25*x7) - X(0)*x35*(4.6894649399999997*x21*x7 - 11.478657500000001*x222 - 1.1508224*x223 - 0.015791857020000001*x224 - 1.6313198799999999e-5*x225 + 0.1741279885*x23*x7 + 0.00078368076500000001*x25*x7) + X(1)*X(13)*((x17) ? (
   0.00016065*std::exp((-2.75)*std::log(std::abs(T)))*x42 - 9.4499999999999994e-10*std::exp((-1.75)*std::log(std::abs(T)))*x42
)
: (
   1.8960000000000001e-36*std::exp((3.7400000000000002)*std::log(std::abs(T)))
)) - X(1)*X(2)*((x57) ? (
   -5.2466095085621454e-21*std::exp((-1.1499999999999999)*std::log(std::abs(T)))
)
: (
   x58*x64*(-3.194*x216 - 0.62159999999999993*x218 + 3.5720000000000001*x48*x63*x7)
)) + 2*X(1)*X(3)*((x66) ? (
   1.2500000000000001e-10*x1 - 1.48e-6*x209 - 7.7700000000000002e-13
)
: (
   0
)) + X(1)*X(5)*((x45) ? (
   7.4200000000000004e-9*std::exp((-1.5979999999999999)*std::log(std::abs(T)))*x44 + 8.0400000000000002e-11*std::exp((-0.59799999999999998)*std::log(std::abs(T)))*x44 - 4.8987999999999998e-17*std::exp((0.47999999999999998)*std::log(std::abs(T)))
)
: (
   0
)) - 3.9837168574084181e-7*X(1)*X(7)*x206 + X(1)*X(8)*((x55) ? (
   21237.150000000001*x169*x54 + x47*(1.0251841499999999e-7*x217 - 2.8982736e-7*x219 - 1.9125491199999999e-8*x220 + 1.9865770999999999e-9*x221 - 1.09028466e-10*x52*x7 + 2.4718352399999997e-12*x53*x7 + 3.3735381999999997e-7*x7)
)
: (
   0
)) - X(10)*X(2)*((x171) ? (
   x170*(4430.0*x169 - 347800.0/x15)
)
: (
   0
)) - 7.2084342424042629e-17*X(12)*X(2)*x41 - X(2)*X(4)*((x45) ? (
   6.7980000000000007e-9*std::exp((-1.6040000000000001)*std::log(std::abs(T)))*x173 - 6.7396000000000002e-10*std::exp((-1.3320000000000001)*std::log(std::abs(T))) + 8.1576000000000009e-11*std::exp((-0.60399999999999998)*std::log(std::abs(T)))*x173
)
: (
   0
)) - X(2)*x179*(-0.87659414490283338*x175*x177*x7 + 5.1485802679346868*x176*std::exp((1.0)*std::log(std::abs(x48)))*x7 - 3.5068370966299316*x216) + X(3)*X(5)*x208 - 2.4999999999999998e-6*X(3)*X(6)*x209 + X(5)*X(8)*((x196) ? (
   x195*x58*(1.5894349999999999*x193*x221 - 8.6761199999999992*x194*x220 + 5.8888600000000002*x216 + 6.7520699999999998*x218 + 14.393840000000001*x226)
)
: (
   1.650619e-6*x169*x197
)) + X(8)*x168*(2.5000000000000002e-32*x206 + 3.75e-33*x214) + x134*(-x122*x239 - x235*x92) + x134*(x189*x235 + x190*x239) - x181*x215*(1.3296555000000001e-10*std::exp((-0.90150700000000006)*std::log(std::abs(T))) + 2.466314622e-10*std::exp((-0.44389999999999996)*std::log(std::abs(T))) + 8.1647792100000001e-16*std::exp((1.1825999999999999)*std::log(std::abs(T)))) - x207*x208 + 8.6419753086419757e-23*x210*x5 + x213*(-1.0000000000000001e-31*x206 - 1.5e-32*x214) + x213*(3.0000000000000003e-31*x206 + 4.5e-32*x214) + x215*((x184) ? (
   2.6092635916521491e-16*std::exp((0.78186)*std::log(std::abs(T)))
)
: (
   3.7804827525136553e-14*std::exp((0.13944933584163111)*std::log(std::abs(T)))*x185 + x186*(0.025393366159889998*x21*x7 - 0.28420270431082961*x222 - 0.0057310564851968003*x223 - 7.2615442150620009e-7*x227 + 0.0010061251423955*x23*x7 + 0.00051983779458540007*x24*x7 - 0.00018095067761848*x25*x7 + 1.9644009576313599e-5*x26*x7)
)) + x229*(x147*x228 + 12307692.307692308*x153*x68*(0.0042250000000000005*x141*x143*x230 - 4.0625000000000001e-8*x144*x206 - 0.00048750000000000003*x230*std::exp(-58000.0*x7))*std::exp(x142)/x141) + x229*(69500.0*x150*x169 - x159*x228) - x182*x215*(-0.0064764051000000007*std::exp((0.04610000000000003)*std::log(std::abs(T))) - 2.7293978880000002e-10*std::exp((2.0424000000000002)*std::log(std::abs(T))) - 1.229450816e-13*std::exp((2.7740999999999998)*std::log(std::abs(T))))/((x180)*(x180)))/(X(0)*x204 + X(1)*x204 + X(10)*x205 + X(11)*x204 + X(12)*x204 + X(13)*x204 + X(2)*x204 + X(3)*x204 + X(4)*x204 + X(5)*x204 + X(6)*x205 + X(7)*x204 + X(8)*x205 + X(9)*x205);


    x0 = std::exp(-6.1728395061728397e-5*T);

    x1 = X(2)*x0;

    x2 = std::exp((0.92800000000000005)*std::log(std::abs(T)));

    x3 = 1.4000000000000001e-18*x2;

    x4 = 1.0/T;

    x5 = std::exp(-46707.0*x4);

    x6 = X(8)*x5;

    x7 = 35.5*std::exp((-2.2799999999999998)*std::log(std::abs(T)));

    x8 = std::log(8.6173430000000006e-5*T);

    x9 = ((x8)*(x8));

    x10 = ((x8)*(x8)*(x8));

    x11 = ((((x8)*(x8)))*(((x8)*(x8))));

    x12 = ((x8)*(x8)*(x8)*(x8)*(x8));

    x13 = std::exp((6)*std::log(std::abs(x8)));

    x14 = ((x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8));

    x15 = std::exp((8)*std::log(std::abs(x8)));

    x16 = std::exp(0.01623316639567*x10 - 0.033650120313629989*x11 + 0.01178329782711*x12 - 0.001656194699504*x13 + 0.0001068275202678*x14 - 2.6312858092069998e-6*x15 - 0.28274430617039997*x9);

    x17 = X(3)*x16;

    x18 = 3.7903999274394518e-18*std::exp((2.360852208681)*std::log(std::abs(T)));

    x19 = x17*x18;

    x20 = 1.0e-8*std::exp((-0.40000000000000002)*std::log(std::abs(T)));

    x21 = std::sqrt(T);

    x22 = 1.0/x21;

    x23 = T >= 10.0 && T <= 100000.0;

    x24 = ((x23) ? (
   -7.7700000000000002e-13*T + 2.5000000000000002e-10*x21 + 2.96e-6*x22 - 1.73e-9
)
: (
   0
));

    x25 = 6.1739095063118665e-10*std::exp((0.40999999999999998)*std::log(std::abs(T)));

    x26 = 0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0;

    x27 = 1.0/x26;

    x28 = 1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T)));

    x29 = x27*x28;

    x30 = T <= 1160.0;

    x31 = std::exp(0.0084644553866299998*x10 - 0.0014327641212992001*x11 + 0.00020122502847909999*x12 + 8.6639632430900003e-5*x13 - 2.5850096802639999e-5*x14 + 2.4555011970391999e-6*x15 - 8.0683824611800006e-8*((x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8)) - 0.14210135215541481*x9);

    x32 = 3.3178155742407614e-14*std::exp((1.1394493358416311)*std::log(std::abs(T)))*x31;

    x33 = ((x30) ? (
   1.4643482606109061e-16*std::exp((1.78186)*std::log(std::abs(T)))
)
: (
   x32
));

    x34 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x35 = 4.9999999999999996e-6*x22;

    x36 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x37 = 2.0860422997526066e-16*x36;

    x38 = 3.4767371836380304e-16*x36;

    x39 = std::exp((-0.59000000000000008)*std::log(std::abs(T)));

    x40 = std::exp((-3.0/2.0)*std::log(std::abs(T)));

    x41 = X(2)*X(3);

    x42 = x4*x8;

    x43 = x10*x4;

    jac(4,1) = x1*x3 - x19 + x6*x7;


    jac(4,2) = -X(3)*x20 - X(3)*x24;


    jac(4,3) = X(0)*x0*x3 - X(3)*x29 - X(3)*x33 + X(7)*x25;


    jac(4,4) = -X(0)*x16*x18 - X(1)*x20 - X(1)*x24 - X(2)*x29 - X(2)*x33 - X(5)*x25 - X(5)*x34 - X(6)*x35;


    jac(4,5) = 0;


    jac(4,6) = -X(3)*x25 - X(3)*x34;


    jac(4,7) = -X(3)*x35;


    jac(4,8) = X(2)*x25;


    jac(4,9) = X(0)*x5*x7;


    jac(4,10) = 0;


    jac(4,11) = 0;


    jac(4,12) = 0;


    jac(4,13) = 0;


    jac(4,14) = 0;


    jac(4,15) = (1658098.5*std::exp((-4.2799999999999994)*std::log(std::abs(T)))*X(0)*X(8)*x5 - 80.939999999999998*std::exp((-3.2799999999999998)*std::log(std::abs(T)))*X(0)*x6 + 4.0000000000000002e-9*std::exp((-1.3999999999999999)*std::log(std::abs(T)))*X(1)*X(3) + 2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)))*X(3)*X(5) + 1.2992000000000002e-18*std::exp((-0.071999999999999953)*std::log(std::abs(T)))*X(0)*X(2)*x0 - 8.9485740404797324e-18*std::exp((1.360852208681)*std::log(std::abs(T)))*X(0)*x17 - 8.6419753086419757e-23*X(0)*x1*x2 - X(0)*x19*(0.058916489135550004*x11*x4 - 0.009937168197024001*x12*x4 + 0.00074779264187460007*x13*x4 - 2.1050286473655998e-5*x14*x4 + 0.048699499187009998*x4*x9 - 0.56548861234079995*x42 - 0.13460048125451995*x43) - X(1)*X(3)*((x23) ? (
   1.2500000000000001e-10*x22 - 1.48e-6*x40 - 7.7700000000000002e-13
)
: (
   0
)) + 2.5313028975878652e-10*X(2)*X(7)*x39 - 2.5313028975878652e-10*X(3)*X(5)*x39 + 2.4999999999999998e-6*X(3)*X(6)*x40 - x27*x41*(1.3296555000000001e-10*std::exp((-0.90150700000000006)*std::log(std::abs(T))) + 2.466314622e-10*std::exp((-0.44389999999999996)*std::log(std::abs(T))) + 8.1647792100000001e-16*std::exp((1.1825999999999999)*std::log(std::abs(T)))) - x41*((x30) ? (
   2.6092635916521491e-16*std::exp((0.78186)*std::log(std::abs(T)))
)
: (
   3.7804827525136553e-14*std::exp((0.13944933584163111)*std::log(std::abs(T)))*x31 + x32*(0.0010061251423955*x11*x4 + 0.00051983779458540007*x12*x4 - 0.00018095067761848*x13*x4 + 1.9644009576313599e-5*x14*x4 - 7.2615442150620009e-7*x15*x4 + 0.025393366159889998*x4*x9 - 0.28420270431082961*x42 - 0.0057310564851968003*x43)
)) - x28*x41*(-0.0064764051000000007*std::exp((0.04610000000000003)*std::log(std::abs(T))) - 2.7293978880000002e-10*std::exp((2.0424000000000002)*std::log(std::abs(T))) - 1.229450816e-13*std::exp((2.7740999999999998)*std::log(std::abs(T))))/((x26)*(x26)))/(X(0)*x37 + X(1)*x37 + X(10)*x38 + X(11)*x37 + X(12)*x37 + X(13)*x37 + X(2)*x37 + X(3)*x37 + X(4)*x37 + X(5)*x37 + X(6)*x38 + X(7)*x37 + X(8)*x38 + X(9)*x38);


    x0 = 2.5950363272655348e-10*std::exp((-0.75)*std::log(std::abs(T)));

    x1 = 1.0/T;

    x2 = std::exp(-457.0*x1);

    x3 = 1.0000000000000001e-9*x2;

    x4 = std::exp(-37.100000000000001*x1);

    x5 = T >= 50.0;

    x6 = ((x5) ? (
   2.0000000000000001e-10*std::exp((0.40200000000000002)*std::log(std::abs(T)))*x4 - 3.3099999999999998e-17*std::exp((1.48)*std::log(std::abs(T)))
)
: (
   0
));

    x7 = std::exp(-33.0*x1);

    x8 = ((x5) ? (
   2.0299999999999998e-9*std::exp((-0.33200000000000002)*std::log(std::abs(T))) + 2.0600000000000001e-10*std::exp((0.39600000000000002)*std::log(std::abs(T)))*x7
)
: (
   0
));

    x9 = M_LN10;

    x10 = 1.0/x9;

    x11 = std::log(T);

    x12 = x10*x11;

    x13 = std::exp((-3.0)*std::log(std::abs(x9)));

    x14 = std::exp((-2.0)*std::log(std::abs(x9)));

    x15 = ((x11)*(x11));

    x16 = std::exp((-0.12690000000000001*((x11)*(x11)*(x11))*x13 - 1.5229999999999999*x12 + 1.1180000000000001*x14*x15 - 19.379999999999999)*std::log(std::abs(10.0)));

    x17 = X(4)*x16;

    x18 = 9.8726896031426014e-7*std::exp((-0.5)*std::log(std::abs(T)));

    x19 = std::exp((-2)*std::log(std::abs(x9)));

    x20 = 1.3700000000000002e-10*((x11)*(x11))*x19 - 8.4600000000000008e-10*x12 - 4.1700000000000001e-10;

    x21 = x1*x10;

    x22 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x23 = 2.0860422997526066e-16*x22;

    x24 = 3.4767371836380304e-16*x22;

    jac(5,1) = -X(4)*x0;


    jac(5,2) = X(10)*x3 + X(5)*x6;


    jac(5,3) = -X(4)*x8 - x17;


    jac(5,4) = 0;


    jac(5,5) = -X(0)*x0 - X(2)*x16 - X(2)*x8 - X(7)*x18 + X(8)*x20;


    jac(5,6) = X(1)*x6;


    jac(5,7) = 0;


    jac(5,8) = -X(4)*x18;


    jac(5,9) = X(4)*x20;


    jac(5,10) = 0;


    jac(5,11) = X(1)*x3;


    jac(5,12) = 0;


    jac(5,13) = 0;


    jac(5,14) = 0;


    jac(5,15) = (1.9462772454491511e-10*std::exp((-1.75)*std::log(std::abs(T)))*X(0)*X(4) + 4.9363448015713007e-7*std::exp((-1.5)*std::log(std::abs(T)))*X(4)*X(7) + X(1)*X(5)*((x5) ? (
   7.4200000000000004e-9*std::exp((-1.5979999999999999)*std::log(std::abs(T)))*x4 + 8.0400000000000002e-11*std::exp((-0.59799999999999998)*std::log(std::abs(T)))*x4 - 4.8987999999999998e-17*std::exp((0.47999999999999998)*std::log(std::abs(T)))
)
: (
   0
)) - X(2)*X(4)*((x5) ? (
   6.7980000000000007e-9*std::exp((-1.6040000000000001)*std::log(std::abs(T)))*x7 - 6.7396000000000002e-10*std::exp((-1.3320000000000001)*std::log(std::abs(T))) + 8.1576000000000009e-11*std::exp((-0.60399999999999998)*std::log(std::abs(T)))*x7
)
: (
   0
)) - X(2)*x17*(5.1485802679346868*x1*std::exp((1.0)*std::log(std::abs(x11)))*x14 - 0.87659414490283338*x1*x13*x15 - 3.5068370966299316*x21) + X(4)*X(8)*(2.7400000000000004e-10*x1*x11*x19 - 8.4600000000000008e-10*x21) + 4.5700000000000003e-7*X(1)*X(10)*x2/((T)*(T)))/(X(0)*x23 + X(1)*x23 + X(10)*x24 + X(11)*x23 + X(12)*x23 + X(13)*x23 + X(2)*x23 + X(3)*x23 + X(4)*x23 + X(5)*x23 + X(6)*x24 + X(7)*x23 + X(8)*x24 + X(9)*x24);


    x0 = 2.5950363272655348e-10*std::exp((-0.75)*std::log(std::abs(T)));

    x1 = 7.1999999999999996e-8/std::sqrt(T);

    x2 = std::exp(-0.00010729613733905579*T);

    x3 = X(5)*x2;

    x4 = std::exp((0.94999999999999996)*std::log(std::abs(T)));

    x5 = 1.3300135414628029e-18*x4;

    x6 = std::exp((-0.5)*std::log(std::abs(T)));

    x7 = 1.0/T;

    x8 = std::exp(-37.100000000000001*x7);

    x9 = T >= 50.0;

    x10 = ((x9) ? (
   2.0000000000000001e-10*std::exp((0.40200000000000002)*std::log(std::abs(T)))*x8 - 3.3099999999999998e-17*std::exp((1.48)*std::log(std::abs(T)))
)
: (
   0
));

    x11 = M_LN10;

    x12 = 1.0/x11;

    x13 = std::log(T);

    x14 = x12*x13;

    x15 = std::exp((-3.0)*std::log(std::abs(x11)));

    x16 = std::exp((-2.0)*std::log(std::abs(x11)));

    x17 = ((x13)*(x13));

    x18 = std::exp((-0.12690000000000001*((x13)*(x13)*(x13))*x15 - 1.5229999999999999*x14 + 1.1180000000000001*x16*x17 - 19.379999999999999)*std::log(std::abs(10.0)));

    x19 = X(5)*x18;

    x20 = 6.1739095063118665e-10*std::exp((0.40999999999999998)*std::log(std::abs(T)));

    x21 = std::exp((-2)*std::log(std::abs(T)));

    x22 = 5.25e-11*std::exp(173900.0*x21 - 4430.0*x7);

    x23 = T > 200.0;

    x24 = ((x23) ? (
   x22
)
: (
   0
));

    x25 = std::exp(-33.0*x7);

    x26 = ((x9) ? (
   2.0299999999999998e-9*std::exp((-0.33200000000000002)*std::log(std::abs(T))) + 2.0600000000000001e-10*std::exp((0.39600000000000002)*std::log(std::abs(T)))*x25
)
: (
   0
));

    x27 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x28 = amrex::Math::powi<-5>(x11);

    x29 = std::exp((-4)*std::log(std::abs(x11)));

    x30 = ((((x13)*(x13)))*(((x13)*(x13))));

    x31 = amrex::Math::powi<-3>(x11);

    x32 = ((x13)*(x13)*(x13));

    x33 = std::exp((-2)*std::log(std::abs(x11)));

    x34 = ((x13)*(x13));

    x35 = std::exp((0.31788699999999998*((x13)*(x13)*(x13)*(x13)*(x13))*x28 + 5.8888600000000002*x14 - 2.1690299999999998*x29*x30 + 2.2506900000000001*x31*x32 + 7.1969200000000004*x33*x34 - 56.473700000000001)*std::log(std::abs(10)));

    x36 = T <= 1167.4796423742259;

    x37 = std::exp(-5207.0*x7);

    x38 = ((x36) ? (
   x35
)
: (
   3.1699999999999999e-10*x37
));

    x39 = std::exp((-1.5)*std::log(std::abs(T)))*X(7);

    x40 = std::exp((-0.59000000000000008)*std::log(std::abs(T)));

    x41 = x12*x7;

    x42 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x43 = 2.0860422997526066e-16*x42;

    x44 = 3.4767371836380304e-16*x42;

    jac(6,1) = X(4)*x0 + X(9)*x1 - x3*x5;


    jac(6,2) = -X(5)*x10 + 7.9674337148168363e-7*X(7)*x6 - x19;


    jac(6,3) = X(10)*x24 + X(4)*x26 - 1.0e-25*X(5) + X(7)*x20;


    jac(6,4) = -X(5)*x20 - X(5)*x27;


    jac(6,5) = X(0)*x0 + X(2)*x26 + 1.9745379206285203e-6*X(7)*x6;


    jac(6,6) = -X(0)*x2*x5 - X(1)*x10 - X(1)*x18 - 1.0e-25*X(2) - X(3)*x20 - X(3)*x27 - X(8)*x38;


    jac(6,7) = 0;


    jac(6,8) = 7.9674337148168363e-7*X(1)*x6 + X(2)*x20 + 1.9745379206285203e-6*X(4)*x6;


    jac(6,9) = -X(5)*x38;


    jac(6,10) = X(0)*x1;


    jac(6,11) = X(2)*x24;


    jac(6,12) = 0;


    jac(6,13) = 0;


    jac(6,14) = 0;


    jac(6,15) = (-1.9462772454491511e-10*std::exp((-1.75)*std::log(std::abs(T)))*X(0)*X(4) + 2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)))*X(3)*X(5) - 1.2635128643896626e-18*std::exp((-0.050000000000000044)*std::log(std::abs(T)))*X(0)*x3 + 1.4270531560759686e-22*X(0)*X(5)*x2*x4 - X(1)*X(5)*((x9) ? (
   7.4200000000000004e-9*std::exp((-1.5979999999999999)*std::log(std::abs(T)))*x8 + 8.0400000000000002e-11*std::exp((-0.59799999999999998)*std::log(std::abs(T)))*x8 - 4.8987999999999998e-17*std::exp((0.47999999999999998)*std::log(std::abs(T)))
)
: (
   0
)) - X(1)*x19*(5.1485802679346868*std::exp((1.0)*std::log(std::abs(x13)))*x16*x7 - 0.87659414490283338*x15*x17*x7 - 3.5068370966299316*x41) - 3.9837168574084181e-7*X(1)*x39 + X(10)*X(2)*((x23) ? (
   x22*(4430.0*x21 - 347800.0/((T)*(T)*(T)))
)
: (
   0
)) + X(2)*X(4)*((x9) ? (
   6.7980000000000007e-9*std::exp((-1.6040000000000001)*std::log(std::abs(T)))*x25 - 6.7396000000000002e-10*std::exp((-1.3320000000000001)*std::log(std::abs(T))) + 8.1576000000000009e-11*std::exp((-0.60399999999999998)*std::log(std::abs(T)))*x25
)
: (
   0
)) + 2.5313028975878652e-10*X(2)*X(7)*x40 - 2.5313028975878652e-10*X(3)*X(5)*x40 - 9.8726896031426014e-7*X(4)*x39 - X(5)*X(8)*((x36) ? (
   x11*x35*(14.393840000000001*x13*x33*x7 + 1.5894349999999999*x28*x30*x7 - 8.6761199999999992*x29*x32*x7 + 6.7520699999999998*x31*x34*x7 + 5.8888600000000002*x41)
)
: (
   1.650619e-6*x21*x37
)) - 3.5999999999999998e-8*X(0)*X(9)/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x43 + X(1)*x43 + X(10)*x44 + X(11)*x43 + X(12)*x43 + X(13)*x43 + X(2)*x43 + X(3)*x43 + X(4)*x43 + X(5)*x43 + X(6)*x44 + X(7)*x43 + X(8)*x44 + X(9)*x44);


    x0 = ((T)*(T));

    x1 = ((T)*(T)*(T));

    x2 = ((((T)*(T)))*(((T)*(T))));

    x3 = T <= 10000.0;

    x4 = ((x3) ? (
   -5.5279999999999998e-28*((T)*(T)*(T)*(T)*(T)) - 2.3088e-11*T + 7.3427999999999993e-15*x0 - 7.5474000000000004e-19*x1 + 3.3467999999999999e-23*x2 + 4.2277999999999996e-8
)
: (
   0
));

    x5 = 1.0e-8*std::exp((-0.40000000000000002)*std::log(std::abs(T)));

    x6 = T < 30;

    x7 = std::log(T);

    x8 = M_LN10;

    x9 = 3.194/x8;

    x10 = amrex::Math::powi<-3>(x8);

    x11 = ((x7)*(x7)*(x7));

    x12 = std::exp((-2)*std::log(std::abs(x8)));

    x13 = ((x7)*(x7));

    x14 = std::exp((-0.2072*x10*x11 + 1.786*x12*x13 - x7*x9 - 18.199999999999999)*std::log(std::abs(10)));

    x15 = ((x6) ? (
   3.4977396723747635e-20*std::exp((-0.14999999999999999)*std::log(std::abs(T)))
)
: (
   x14
));

    x16 = 1.0/T;

    x17 = std::exp(-21237.150000000001*x16);

    x18 = ((((x7)*(x7)))*(((x7)*(x7))));

    x19 = ((x7)*(x7)*(x7)*(x7)*(x7));

    x20 = std::exp((6)*std::log(std::abs(x7)));

    x21 = x17*(3.4172804999999998e-8*x11 - 1.4491368e-7*x13 - 4.7813727999999997e-9*x18 + 3.9731542e-10*x19 - 1.8171411000000001e-11*x20 + 3.5311931999999998e-13*((x7)*(x7)*(x7)*(x7)*(x7)*(x7)*(x7)) + 3.3735381999999997e-7*x7 - 3.3232183000000002e-7);

    x22 = T >= 100.0 && T <= 30000.0;

    x23 = ((x22) ? (
   x21
)
: (
   0
));

    x24 = 4.9999999999999996e-6/std::sqrt(T);

    x25 = x13*x16;

    x26 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x27 = 2.0860422997526066e-16*x26;

    x28 = 3.4767371836380304e-16*x26;

    jac(7,1) = -X(6)*x4;


    jac(7,2) = X(2)*x15 + X(3)*x5 + X(8)*x23;


    jac(7,3) = X(1)*x15 - 6.0e-10*X(6);


    jac(7,4) = X(1)*x5 - X(6)*x24;


    jac(7,5) = 0;


    jac(7,6) = 0;


    jac(7,7) = -X(0)*x4 - 6.0e-10*X(2) - X(3)*x24;


    jac(7,8) = 0;


    jac(7,9) = X(1)*x23;


    jac(7,10) = 0;


    jac(7,11) = 0;


    jac(7,12) = 0;


    jac(7,13) = 0;


    jac(7,14) = 0;


    jac(7,15) = (-4.0000000000000002e-9*std::exp((-1.3999999999999999)*std::log(std::abs(T)))*X(1)*X(3) - X(0)*X(6)*((x3) ? (
   1.4685599999999999e-14*T - 2.2642200000000001e-18*x0 + 1.3387199999999999e-22*x1 - 2.7639999999999999e-27*x2 - 2.3088e-11
)
: (
   0
)) + X(1)*X(2)*((x6) ? (
   -5.2466095085621454e-21*std::exp((-1.1499999999999999)*std::log(std::abs(T)))
)
: (
   x14*x8*(-0.62159999999999993*x10*x25 + 3.5720000000000001*x12*x16*x7 - x16*x9)
)) + X(1)*X(8)*((x22) ? (
   x17*(-1.9125491199999999e-8*x11*x16 + 1.9865770999999999e-9*x16*x18 - 1.09028466e-10*x16*x19 + 2.4718352399999997e-12*x16*x20 - 2.8982736e-7*x16*x7 + 3.3735381999999997e-7*x16 + 1.0251841499999999e-7*x25) + 21237.150000000001*x21/x0
)
: (
   0
)) + 2.4999999999999998e-6*X(3)*X(6)/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x27 + X(1)*x27 + X(10)*x28 + X(11)*x27 + X(12)*x27 + X(13)*x27 + X(2)*x27 + X(3)*x27 + X(4)*x27 + X(5)*x27 + X(6)*x28 + X(7)*x27 + X(8)*x28 + X(9)*x28);


    x0 = std::exp(-0.00010729613733905579*T);

    x1 = X(5)*x0;

    x2 = std::exp((0.94999999999999996)*std::log(std::abs(T)));

    x3 = 1.3300135414628029e-18*x2;

    x4 = std::exp((-0.5)*std::log(std::abs(T)));

    x5 = X(7)*x4;

    x6 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x7 = 6.1739095063118665e-10*std::exp((0.40999999999999998)*std::log(std::abs(T)));

    x8 = std::exp((-1.5)*std::log(std::abs(T)))*X(7);

    x9 = X(2)*X(7);

    x10 = 2.5313028975878652e-10*std::exp((-0.59000000000000008)*std::log(std::abs(T)));

    x11 = X(0)*x1;

    x12 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x13 = 2.0860422997526066e-16*x12;

    x14 = 3.4767371836380304e-16*x12;

    jac(8,1) = x1*x3;


    jac(8,2) = -7.9674337148168363e-7*x5;


    jac(8,3) = -X(7)*x6 - X(7)*x7;


    jac(8,4) = X(5)*x7;


    jac(8,5) = -9.8726896031426014e-7*x5;


    jac(8,6) = X(0)*x0*x3 + X(3)*x7;


    jac(8,7) = 0;


    jac(8,8) = -7.9674337148168363e-7*X(1)*x4 - X(2)*x6 - X(2)*x7 - 9.8726896031426014e-7*X(4)*x4;


    jac(8,9) = 0;


    jac(8,10) = 0;


    jac(8,11) = 0;


    jac(8,12) = 0;


    jac(8,13) = 0;


    jac(8,14) = 0;


    jac(8,15) = (2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)))*x9 + 1.2635128643896626e-18*std::exp((-0.050000000000000044)*std::log(std::abs(T)))*x11 + 3.9837168574084181e-7*X(1)*x8 + X(3)*X(5)*x10 + 4.9363448015713007e-7*X(4)*x8 - x10*x9 - 1.4270531560759686e-22*x11*x2)/(X(0)*x13 + X(1)*x13 + X(10)*x14 + X(11)*x13 + X(12)*x13 + X(13)*x13 + X(2)*x13 + X(3)*x13 + X(4)*x13 + X(5)*x13 + X(6)*x14 + X(7)*x13 + X(8)*x14 + X(9)*x14);


    x0 = 1.0/T;

    x1 = std::exp(-46707.0*x0);

    x2 = X(8)*x1;

    x3 = 35.5*std::exp((-2.2799999999999998)*std::log(std::abs(T)));

    x4 = std::exp(-102000.0*x0);

    x5 = X(8)*x4;

    x6 = 4.3799999999999999e-10*std::exp((0.34999999999999998)*std::log(std::abs(T)));

    x7 = std::exp(-21237.150000000001*x0);

    x8 = std::log(T);

    x9 = ((x8)*(x8));

    x10 = ((x8)*(x8)*(x8));

    x11 = ((((x8)*(x8)))*(((x8)*(x8))));

    x12 = ((x8)*(x8)*(x8)*(x8)*(x8));

    x13 = std::exp((6)*std::log(std::abs(x8)));

    x14 = x7*(3.4172804999999998e-8*x10 - 4.7813727999999997e-9*x11 + 3.9731542e-10*x12 - 1.8171411000000001e-11*x13 + 3.5311931999999998e-13*((x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8)) + 3.3735381999999997e-7*x8 - 1.4491368e-7*x9 - 3.3232183000000002e-7);

    x15 = T >= 100.0 && T <= 30000.0;

    x16 = ((x15) ? (
   x14
)
: (
   0
));

    x17 = std::exp(-457.0*x0);

    x18 = 1.0000000000000001e-9*x17;

    x19 = 1.1800000000000001e-10*std::exp(-69500.0*x0);

    x20 = std::log(x19);

    x21 = X(1) + X(10) + X(2) + X(3) + 2.0*X(6) + 2.0*X(8) + X(9);

    x22 = std::log(0.0001*T);

    x23 = M_LN10;

    x24 = 1.0/x23;

    x25 = std::exp((-2)*std::log(std::abs(x23)));

    x26 = std::exp((-1.6200000000000001*((x22)*(x22))*x25 + 1.3*x22*x24 - 4.8449999999999998)*std::log(std::abs(10.0)));

    x27 = x21*x26;

    x28 = x27 + 1.0;

    x29 = std::exp((-2)*std::log(std::abs(x28)));

    x30 = 1.0*x29;

    x31 = x20*x30;

    x32 = ((X(8))*(X(8)));

    x33 = 1.0/x28;

    x34 = 1.0*x33;

    x35 = std::exp((x34)*std::log(std::abs(x19)));

    x36 = std::sqrt(T);

    x37 = 1.0/x36;

    x38 = 1.0 - std::exp(-6000.0*x0);

    x39 = 52000.0*x0;

    x40 = std::exp(-x39);

    x41 = x38*x40;

    x42 = 8.1250000000000003e-8*x37*x41;

    x43 = 1.0 - x34;

    x44 = std::exp((x43)*std::log(std::abs(x42)));

    x45 = x35*x44;

    x46 = x32*x45;

    x47 = x26*x46;

    x48 = std::log(x42);

    x49 = x30*x48;

    x50 = x25*x9;

    x51 = -133.82830000000001*x0 - 4.8909149999999997*x24*x8 + 0.47490300000000002*x50;

    x52 = std::exp((x51 + 14.82123)*std::log(std::abs(10.0)));

    x53 = 1.0/x52;

    x54 = x21*x53;

    x55 = std::exp(-0.0022727272727272726*T);

    x56 = std::exp(-0.00054054054054054055*T);

    x57 = -2.0563129999999998*x55 + 0.58640729999999996*x56 + 0.82274429999999998;

    x58 = std::exp((x57)*std::log(std::abs(x54)));

    x59 = x58 + 1.0;

    x60 = 1.0/x59;

    x61 = x24*x8;

    x62 = 16780.950000000001*x0 + 1.0;

    x63 = amrex::Math::powi<-3>(x23);

    x64 = x10*x63;

    x65 = 40870.379999999997*x0 + 1.0;

    x66 = -69.700860000000006*x24*std::log(x65) + 4.6331670000000003*x64;

    x67 = 19.734269999999999*x24*std::log(x62) + 37.886913*x25*x9 - 14.509090000000008*x61 - x66 - 307.31920000000002;

    x68 = std::exp((x51 + 13.656822)*std::log(std::abs(10.0)));

    x69 = 1.0/x68;

    x70 = x21*x69;

    x71 = std::exp((x57)*std::log(std::abs(x70)));

    x72 = x71 + 1.0;

    x73 = 1.0/x72;

    x74 = std::exp((-2080.4099999999999*x0*x73 - 23705.700000000001*x0 + 43.20243*x25*x9 - x60*x67 - 68.422430000000006*x61 - x66 - 178.4239)*std::log(std::abs(10.0)));

    x75 = x0*x71/((x72)*(x72));

    x76 = 4790.3210533157426*x75;

    x77 = x68*x69;

    x78 = 1.0/x21;

    x79 = x57*x78;

    x80 = x77*x79;

    x81 = x58*x67/((x59)*(x59));

    x82 = 2.3025850929940459*x81;

    x83 = x52*x53;

    x84 = x79*x83;

    x85 = 743.05999999999995*x0 - 2.4640089999999999*x24*x8 + 0.19859550000000001*x50;

    x86 = std::exp((x85 + 9.3055640000000004)*std::log(std::abs(10.0)));

    x87 = 1.0/x86;

    x88 = x21*x87;

    x89 = 2.9375070000000001*x55 + 0.23588480000000001*x56 + 0.75022860000000002;

    x90 = std::exp((x89)*std::log(std::abs(x88)));

    x91 = x90 + 1.0;

    x92 = 1.0/x91;

    x93 = 14254.549999999999*x0 + 1.0;

    x94 = 27535.310000000001*x0 + 1.0;

    x95 = -21.360939999999999*x24*std::log(x94) + 0.25820969999999999*x64;

    x96 = 70.138370000000009*x24*x8 + 11.28215*x24*std::log(x93) - 4.7035149999999994*x50 - x95 - 203.11568;

    x97 = std::exp((x85 + 8.1313220000000008)*std::log(std::abs(10.0)));

    x98 = 1.0/x97;

    x99 = x21*x98;

    x100 = std::exp((x89)*std::log(std::abs(x99)));

    x101 = x100 + 1.0;

    x102 = 1.0/x101;

    x103 = std::exp((-1657.4099999999999*x0*x102 - 21467.790000000001*x0 + 42.707410000000003*x24*x8 - 2.0273650000000001*x50 - x92*x96 - x95 - 142.7664)*std::log(std::abs(10.0)));

    x104 = x0*x100/((x101)*(x101));

    x105 = 3816.3275589792611*x104;

    x106 = x97*x98;

    x107 = x78*x89;

    x108 = x106*x107;

    x109 = x90*x96/((x91)*(x91));

    x110 = 2.3025850929940459*x109;

    x111 = x86*x87;

    x112 = x107*x111;

    x113 = X(2)*X(8);

    x114 = x113*(-x103*(x105*x108 + x110*x112) - x74*(x76*x80 + x82*x84)) + x31*x47 - x47*x49;

    x115 = std::exp((-2)*std::log(std::abs(T)));

    x116 = 5.25e-11*std::exp(-4430.0*x0 + 173900.0*x115);

    x117 = T > 200.0;

    x118 = ((x117) ? (
   x116
)
: (
   0
));

    x119 = -x103 - x74;

    x120 = ((X(2))*(X(2)));

    x121 = std::exp((-0.25)*std::log(std::abs(T)));

    x122 = 0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0;

    x123 = 1.0/x122;

    x124 = 1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T)));

    x125 = x123*x124;

    x126 = 1.5e-32*x121 + 5.0000000000000004e-32*x37;

    x127 = 2*x113;

    x128 = -7.5000000000000001e-33*x121 - 2.5000000000000002e-32*x37;

    x129 = 4.9999999999999996e-6/std::sqrt(T);

    x130 = 1.3700000000000002e-10*x25*x9 - 8.4600000000000008e-10*x61 - 4.1700000000000001e-10;

    x131 = amrex::Math::powi<-5>(x23);

    x132 = std::exp((-4)*std::log(std::abs(x23)));

    x133 = std::exp((-2.1690299999999998*x11*x132 + 0.31788699999999998*x12*x131 + 7.1969200000000004*x50 + 5.8888600000000002*x61 + 2.2506900000000001*x64 - 56.473700000000001)*std::log(std::abs(10)));

    x134 = T <= 1167.4796423742259;

    x135 = std::exp(-5207.0*x0);

    x136 = ((x134) ? (
   x133
)
: (
   3.1699999999999999e-10*x135
));

    x137 = 2.0*x29*x47;

    x138 = x137*x48;

    x139 = -x103*(7632.6551179585222*x104*x108 + 4.6051701859880918*x109*x112) - x74*(9580.6421066314851*x75*x80 + 4.6051701859880918*x81*x84);

    x140 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x141 = 2.0860422997526066e-16*x140;

    x142 = 3.4767371836380304e-16*x140;

    x143 = X(0)*x2;

    x144 = X(0)*x5;

    x145 = std::exp((-1.5)*std::log(std::abs(T)));

    x146 = std::exp((-1.25)*std::log(std::abs(T)));

    x147 = X(8)*x120;

    x148 = x0*x24;

    x149 = x0*x8;

    x150 = x149*x25;

    x151 = X(2)*X(3);

    x152 = x0*x9;

    x153 = x0*x10;

    x154 = x0*x11;

    x155 = x152*x63;

    x156 = x27*(-7.460375701300709*x0*x22*x25 + 2.9933606208922598*x0*x24);

    x157 = std::exp((-2.5)*std::log(std::abs(T)));

    x158 = x115*x24;

    x159 = x158/x65;

    x160 = 0.0046734386363636356*x55 - 0.00031697691891891889*x56;

    x161 = x57*(11.261747970100974*x0*x24 - 308.15104860073512*x115 - 2.1870091368363029*x150);

    x162 = x158/x94;

    x163 = -0.0066761522727272725*x55 - 0.0001275052972972973*x56;

    x164 = x89*(1710.9588792001557*x115 + 5.6735903924031659*x148 - 0.91456607567139814*x150);

    jac(9,1) = -x2*x3 - x5*x6;


    jac(9,2) = X(10)*x18 - X(8)*x16 + x114;


    jac(9,3) = X(10)*x118 + X(3)*x125 + 6.0e-10*X(6) + X(8)*x119 + x114 + 3*x120*(6.0000000000000001e-32*x121 + 2.0000000000000002e-31*x37) + x126*x127 + x127*x128;


    jac(9,4) = X(2)*x125 + X(6)*x129 + x114;


    jac(9,5) = X(8)*x130;


    jac(9,6) = -X(8)*x136;


    jac(9,7) = 6.0e-10*X(2) + X(3)*x129 + x113*x139 + x137*x20 - x138;


    jac(9,8) = 0;


    jac(9,9) = -X(0)*x1*x3 - X(0)*x4*x6 - X(1)*x16 + X(2)*X(8)*x139 + X(2)*x119 + X(4)*x130 - X(5)*x136 - 2*X(8)*x45 + x120*x126 + x120*x128 - x138 + 2.0*x20*x26*x29*x32*x35*x44;


    jac(9,10) = x114;


    jac(9,11) = X(1)*x18 + X(2)*x118 + x114;


    jac(9,12) = 0;


    jac(9,13) = 0;


    jac(9,14) = 0;


    jac(9,15) = (-1658098.5*std::exp((-4.2799999999999994)*std::log(std::abs(T)))*x143 + 80.939999999999998*std::exp((-3.2799999999999998)*std::log(std::abs(T)))*x143 - 4.4675999999999997e-5*std::exp((-1.6499999999999999)*std::log(std::abs(T)))*x144 - 1.5329999999999998e-10*std::exp((-0.65000000000000002)*std::log(std::abs(T)))*x144 + 4.5700000000000003e-7*X(1)*X(10)*x115*x17 - X(1)*X(8)*((x15) ? (
   21237.150000000001*x115*x14 + x7*(-1.09028466e-10*x0*x12 + 2.4718352399999997e-12*x0*x13 + 3.3735381999999997e-7*x0 - 2.8982736e-7*x149 + 1.0251841499999999e-7*x152 - 1.9125491199999999e-8*x153 + 1.9865770999999999e-9*x154)
)
: (
   0
)) + X(10)*X(2)*((x117) ? (
   x116*(4430.0*x115 - 347800.0/((T)*(T)*(T)))
)
: (
   0
)) + ((X(2))*(X(2))*(X(2)))*(-1.0000000000000001e-31*x145 - 1.5e-32*x146) + X(4)*X(8)*(-8.4600000000000008e-10*x148 + 2.7400000000000004e-10*x150) - X(5)*X(8)*((x134) ? (
   x133*x23*(1.5894349999999999*x131*x154 - 8.6761199999999992*x132*x153 + 5.8888600000000002*x148 + 14.393840000000001*x150 + 6.7520699999999998*x155)
)
: (
   1.650619e-6*x115*x135
)) + x113*(-x103*(3816.3275589792611*x102*x115 + x105*(x106*x164 + x163*std::log(x99)) + x110*(x111*x164 + x163*std::log(x88)) + 49431.413233526648*x115 + 98.337445626384849*x148 - 9.3363608541157479*x150 - 1.783649418259394*x155 - 1354334.7412883535*x162 - 2.3025850929940459*x92*(70.138370000000009*x0*x24 - 9.4070299999999989*x150 - 0.77462909999999996*x155 - 160821.97128249999*x158/x93 - 588180.10479140002*x162)) - x74*(4790.3210533157426*x115*x73 + 54584.391438988954*x115 - 157.54846734442862*x148 + 198.95454259823751*x150 - 32.004783802655837*x155 - 6559375.6154640894*x159 - 2.3025850929940459*x60*(75.773826*x0*x25*x8 - 14.509090000000008*x148 - 13.899501000000001*x155 - 331159.79815649998*x158/x62 - 2848700.6345267999*x159) + x76*(x160*std::log(x70) + x161*x77) + x82*(x160*std::log(x54) + x161*x83))) + x123*x151*(1.3296555000000001e-10*std::exp((-0.90150700000000006)*std::log(std::abs(T))) + 2.466314622e-10*std::exp((-0.44389999999999996)*std::log(std::abs(T))) + 8.1647792100000001e-16*std::exp((1.1825999999999999)*std::log(std::abs(T)))) + x147*(-2.5000000000000002e-32*x145 - 3.75e-33*x146) + x147*(1.2500000000000001e-32*x145 + 1.875e-33*x146) - x46*(69500.0*x115*x33 - x156*x31) - x46*(x156*x49 + 12307692.307692308*x36*x43*(-4.0625000000000001e-8*x145*x41 + 0.0042250000000000005*x157*x38*x40 - 0.00048750000000000003*x157*std::exp(-58000.0*x0))*std::exp(x39)/x38) + x124*x151*(-0.0064764051000000007*std::exp((0.04610000000000003)*std::log(std::abs(T))) - 2.7293978880000002e-10*std::exp((2.0424000000000002)*std::log(std::abs(T))) - 1.229450816e-13*std::exp((2.7740999999999998)*std::log(std::abs(T))))/((x122)*(x122)) - 2.4999999999999998e-6*X(3)*X(6)/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x141 + X(1)*x141 + X(10)*x142 + X(11)*x141 + X(12)*x141 + X(13)*x141 + X(2)*x141 + X(3)*x141 + X(4)*x141 + X(5)*x141 + X(6)*x142 + X(7)*x141 + X(8)*x142 + X(9)*x142);


    x0 = 7.1999999999999996e-8/std::sqrt(T);

    x1 = std::log(T);

    x2 = M_LN10;

    x3 = 1.0/x2;

    x4 = std::exp((-3.0)*std::log(std::abs(x2)));

    x5 = std::exp((-2.0)*std::log(std::abs(x2)));

    x6 = ((x1)*(x1));

    x7 = std::exp((-1.5229999999999999*x1*x3 - 0.12690000000000001*((x1)*(x1)*(x1))*x4 + 1.1180000000000001*x5*x6 - 19.379999999999999)*std::log(std::abs(10.0)));

    x8 = X(5)*x7;

    x9 = X(4)*x7;

    x10 = 1.0/T;

    x11 = 5.1485802679346868*std::exp((1.0)*std::log(std::abs(x1)))*x10*x5 - 3.5068370966299316*x10*x3 - 0.87659414490283338*x10*x4*x6;

    x12 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x13 = 2.0860422997526066e-16*x12;

    x14 = 3.4767371836380304e-16*x12;

    jac(10,1) = -X(9)*x0;


    jac(10,2) = x8;


    jac(10,3) = -6.3999999999999996e-10*X(9) + x9;


    jac(10,4) = 0;


    jac(10,5) = X(2)*x7;


    jac(10,6) = X(1)*x7;


    jac(10,7) = 0;


    jac(10,8) = 0;


    jac(10,9) = 0;


    jac(10,10) = -X(0)*x0 - 6.3999999999999996e-10*X(2);


    jac(10,11) = 0;


    jac(10,12) = 0;


    jac(10,13) = 0;


    jac(10,14) = 0;


    jac(10,15) = (X(1)*x11*x8 + X(2)*x11*x9 + 3.5999999999999998e-8*X(0)*X(9)/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x13 + X(1)*x13 + X(10)*x14 + X(11)*x13 + X(12)*x13 + X(13)*x13 + X(2)*x13 + X(3)*x13 + X(4)*x13 + X(5)*x13 + X(6)*x14 + X(7)*x13 + X(8)*x14 + X(9)*x14);


    x0 = 1.0/T;

    x1 = std::exp(-457.0*x0);

    x2 = 1.0000000000000001e-9*x1;

    x3 = 2.6534040307116387e-9*std::exp((-0.10000000000000001)*std::log(std::abs(T)));

    x4 = std::exp((-2)*std::log(std::abs(T)));

    x5 = 5.25e-11*std::exp(-4430.0*x0 + 173900.0*x4);

    x6 = T > 200.0;

    x7 = ((x6) ? (
   x5
)
: (
   0
));

    x8 = M_LN10;

    x9 = 1.0/x8;

    x10 = std::log(T);

    x11 = x10*x9;

    x12 = std::exp((-2)*std::log(std::abs(x8)));

    x13 = ((x10)*(x10));

    x14 = x12*x13;

    x15 = 8.4600000000000008e-10*x11 - 1.3700000000000002e-10*x14 + 4.1700000000000001e-10;

    x16 = amrex::Math::powi<-5>(x8);

    x17 = std::exp((-4)*std::log(std::abs(x8)));

    x18 = ((((x10)*(x10)))*(((x10)*(x10))));

    x19 = amrex::Math::powi<-3>(x8);

    x20 = ((x10)*(x10)*(x10));

    x21 = std::exp((0.31788699999999998*((x10)*(x10)*(x10)*(x10)*(x10))*x16 + 5.8888600000000002*x11 + 7.1969200000000004*x14 - 2.1690299999999998*x17*x18 + 2.2506900000000001*x19*x20 - 56.473700000000001)*std::log(std::abs(10)));

    x22 = T <= 1167.4796423742259;

    x23 = std::exp(-5207.0*x0);

    x24 = ((x22) ? (
   x21
)
: (
   3.1699999999999999e-10*x23
));

    x25 = 2.6534040307116389e-10*std::exp((-1.1000000000000001)*std::log(std::abs(T)));

    x26 = x0*x10*x12;

    x27 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x28 = 2.0860422997526066e-16*x27;

    x29 = 3.4767371836380304e-16*x27;

    jac(11,1) = 0;


    jac(11,2) = -X(10)*x2;


    jac(11,3) = -X(10)*x7 + 1.0e-25*X(5) + X(7)*x3 + 6.3999999999999996e-10*X(9);


    jac(11,4) = X(5)*x3;


    jac(11,5) = X(8)*x15;


    jac(11,6) = 1.0e-25*X(2) + X(3)*x3 + X(8)*x24;


    jac(11,7) = 0;


    jac(11,8) = X(2)*x3;


    jac(11,9) = X(4)*x15 + X(5)*x24;


    jac(11,10) = 6.3999999999999996e-10*X(2);


    jac(11,11) = -X(1)*x2 - X(2)*x7;


    jac(11,12) = 0;


    jac(11,13) = 0;


    jac(11,14) = 0;


    jac(11,15) = (-4.5700000000000003e-7*X(1)*X(10)*x1*x4 - X(10)*X(2)*((x6) ? (
   x5*(4430.0*x4 - 347800.0/((T)*(T)*(T)))
)
: (
   0
)) - X(2)*X(7)*x25 - X(3)*X(5)*x25 + X(4)*X(8)*(8.4600000000000008e-10*x0*x9 - 2.7400000000000004e-10*x26) + X(5)*X(8)*((x22) ? (
   x21*x8*(6.7520699999999998*x0*x13*x19 + 1.5894349999999999*x0*x16*x18 - 8.6761199999999992*x0*x17*x20 + 5.8888600000000002*x0*x9 + 14.393840000000001*x26)
)
: (
   1.650619e-6*x23*x4
)))/(X(0)*x28 + X(1)*x28 + X(10)*x29 + X(11)*x28 + X(12)*x28 + X(13)*x28 + X(2)*x28 + X(3)*x28 + X(4)*x28 + X(5)*x28 + X(6)*x29 + X(7)*x28 + X(8)*x29 + X(9)*x29);


    x0 = std::sqrt(T);

    x1 = 0.00060040841663220993*x0 + 1.0;

    x2 = std::exp((-1.7524)*std::log(std::abs(x1)));

    x3 = 0.32668576019240059*x0 + 1.0;

    x4 = std::exp((-0.24759999999999999)*std::log(std::abs(x3)));

    x5 = X(11)*x4;

    x6 = x2*x5;

    x7 = 5.7884371785482823e-10/x0;

    x8 = std::log(8.6173430000000006e-5*T);

    x9 = ((x8)*(x8));

    x10 = ((x8)*(x8)*(x8));

    x11 = ((((x8)*(x8)))*(((x8)*(x8))));

    x12 = ((x8)*(x8)*(x8)*(x8)*(x8));

    x13 = std::exp((6)*std::log(std::abs(x8)));

    x14 = ((x8)*(x8)*(x8)*(x8)*(x8)*(x8)*(x8));

    x15 = std::exp(4.7016264867590021*x10 - 0.76924663344919997*x11 + 0.081130420973029999*x12 - 0.005324020628287001*x13 + 0.00019757053122209999*x14 - 3.1655810656650001e-6*std::exp((8)*std::log(std::abs(x8))) - 18.480669935680002*x9);

    x16 = X(12)*x15;

    x17 = 3.8571873359681582e-209*std::exp((43.933476326349997)*std::log(std::abs(T)));

    x18 = x16*x17;

    x19 = X(0)*x2;

    x20 = 1.0/T;

    x21 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x22 = 2.0860422997526066e-16*x21;

    x23 = 3.4767371836380304e-16*x21;

    jac(12,1) = x18 - x6*x7;


    jac(12,2) = 0;


    jac(12,3) = 0;


    jac(12,4) = 0;


    jac(12,5) = 0;


    jac(12,6) = 0;


    jac(12,7) = 0;


    jac(12,8) = 0;


    jac(12,9) = 0;


    jac(12,10) = 0;


    jac(12,11) = 0;


    jac(12,12) = -x19*x4*x7;


    jac(12,13) = X(0)*x15*x17;


    jac(12,14) = 0;


    jac(12,15) = (1.694596485110541e-207*std::exp((42.933476326349997)*std::log(std::abs(T)))*X(0)*x16 + 3.0451686126851684e-13*X(0)*std::exp((-2.7523999999999997)*std::log(std::abs(x1)))*x20*x5 + X(0)*x18*(-3.0769865337967999*x10*x20 + 0.40565210486515002*x11*x20 - 0.031944123769722006*x12*x20 + 0.0013829937185547*x13*x20 - 2.5324648525320001e-5*x14*x20 - 36.961339871360003*x20*x8 + 14.104879460277006*x20*x9) + 2.3410580000000002e-11*X(11)*x19*x20*std::exp((-1.2476)*std::log(std::abs(x3))) + 2.8942185892741411e-10*X(0)*x6/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x22 + X(1)*x22 + X(10)*x23 + X(11)*x22 + X(12)*x22 + X(13)*x22 + X(2)*x22 + X(3)*x22 + X(4)*x22 + X(5)*x22 + X(6)*x23 + X(7)*x22 + X(8)*x23 + X(9)*x23);


    x0 = std::sqrt(T);

    x1 = 0.00060040841663220993*x0 + 1.0;

    x2 = std::exp((-1.7524)*std::log(std::abs(x1)));

    x3 = 0.32668576019240059*x0 + 1.0;

    x4 = std::exp((-0.24759999999999999)*std::log(std::abs(x3)));

    x5 = X(11)*x4;

    x6 = x2*x5;

    x7 = 5.7884371785482823e-10/x0;

    x8 = 1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)));

    x9 = 8.6173430000000006e-5*T;

    x10 = x9 <= 9280.0;

    x11 = 1.0/T;

    x12 = (1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661*x11))*std::exp(-469943.50750964211*x11);

    x13 = ((x10) ? (
   x8
)
: (
   1250086.112245841*std::exp((-1.5)*std::log(std::abs(T)))*x12 + x8
));

    x14 = std::log(x9);

    x15 = ((x14)*(x14));

    x16 = ((x14)*(x14)*(x14));

    x17 = ((((x14)*(x14)))*(((x14)*(x14))));

    x18 = ((x14)*(x14)*(x14)*(x14)*(x14));

    x19 = std::exp((6)*std::log(std::abs(x14)));

    x20 = ((x14)*(x14)*(x14)*(x14)*(x14)*(x14)*(x14));

    x21 = std::exp((8)*std::log(std::abs(x14)));

    x22 = std::exp(-10.753230200000001*x15 + 3.0580387500000001*x16 - 0.56851189000000002*x17 + 0.067953912300000002*x18 - 0.0050090561*x19 + 0.000206723616*x20 - 3.6491614100000001e-6*x21);

    x23 = std::exp((23.915965629999999)*std::log(std::abs(T)));

    x24 = 4.3524079114767552e-117*x23;

    x25 = std::exp(-18.480669935680002*x15 + 4.7016264867590021*x16 - 0.76924663344919997*x17 + 0.081130420973029999*x18 - 0.005324020628287001*x19 + 0.00019757053122209999*x20 - 3.1655810656650001e-6*x21);

    x26 = 3.8571873359681582e-209*std::exp((43.933476326349997)*std::log(std::abs(T)))*x25;

    x27 = std::exp((-0.75)*std::log(std::abs(T)));

    x28 = std::exp(-127500.0*x11);

    x29 = T <= 10000.0;

    x30 = ((x29) ? (
   1.26e-9*x27*x28
)
: (
   4.0000000000000003e-37*std::exp((4.7400000000000002)*std::log(std::abs(T)))
));

    x31 = 2.8833736969617052e-16*std::exp((0.25)*std::log(std::abs(T)));

    x32 = X(0)*x2;

    x33 = X(0)*X(12);

    x34 = -9.5174852894472843e-11*std::exp((-1.6353)*std::log(std::abs(T)));

    x35 = std::exp((-3.5)*std::log(std::abs(T)));

    x36 = x11*x14;

    x37 = x11*x16;

    x38 = x11*x18;

    x39 = x11*x20;

    x40 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x41 = 2.0860422997526066e-16*x40;

    x42 = 3.4767371836380304e-16*x40;

    jac(13,1) = -X(12)*x13 - X(12)*x26 + X(13)*x22*x24 + x6*x7;


    jac(13,2) = X(13)*x30;


    jac(13,3) = -X(12)*x31;


    jac(13,4) = 0;


    jac(13,5) = 0;


    jac(13,6) = 0;


    jac(13,7) = 0;


    jac(13,8) = 0;


    jac(13,9) = 0;


    jac(13,10) = 0;


    jac(13,11) = 0;


    jac(13,12) = x32*x4*x7;


    jac(13,13) = -X(0)*x13 - X(0)*x26 - X(2)*x31;


    jac(13,14) = X(0)*x22*x24 + X(1)*x30;


    jac(13,15) = (1.0409203801861816e-115*std::exp((22.915965629999999)*std::log(std::abs(T)))*X(0)*X(13)*x22 - 1.694596485110541e-207*std::exp((42.933476326349997)*std::log(std::abs(T)))*x25*x33 + 4.3524079114767552e-117*X(0)*X(13)*x22*x23*(9.1741162500000009*x11*x15 + 0.33976956150000004*x11*x17 + 0.001447065312*x11*x19 - 21.506460400000002*x36 - 2.2740475600000001*x37 - 0.030054336600000002*x38 - 2.9193291280000001e-5*x39) - 3.0451686126851684e-13*X(0)*std::exp((-2.7523999999999997)*std::log(std::abs(x1)))*x11*x5 + X(1)*X(13)*((x29) ? (
   0.00016065*std::exp((-2.75)*std::log(std::abs(T)))*x28 - 9.4499999999999994e-10*std::exp((-1.75)*std::log(std::abs(T)))*x28
)
: (
   1.8960000000000001e-36*std::exp((3.7400000000000002)*std::log(std::abs(T)))
)) - 2.3410580000000002e-11*X(11)*x11*std::exp((-1.2476)*std::log(std::abs(x3)))*x32 - 7.2084342424042629e-17*X(12)*X(2)*x27 - x26*x33*(14.104879460277006*x11*x15 + 0.40565210486515002*x11*x17 + 0.0013829937185547*x11*x19 - 36.961339871360003*x36 - 3.0769865337967999*x37 - 0.031944123769722006*x38 - 2.5324648525320001e-5*x39) - x33*((x10) ? (
   x34
)
: (
   -1875129.1683687614*std::exp((-2.5)*std::log(std::abs(T)))*x12 + 587469852277.90271*x12*x35 + x34 + 54.282214350476039*x35*std::exp(-563932.20901156683*x11)
)) - 2.8942185892741411e-10*X(0)*x6/std::exp((3.0/2.0)*std::log(std::abs(T))))/(X(0)*x41 + X(1)*x41 + X(10)*x42 + X(11)*x41 + X(12)*x41 + X(13)*x41 + X(2)*x41 + X(3)*x41 + X(4)*x41 + X(5)*x41 + X(6)*x42 + X(7)*x41 + X(8)*x42 + X(9)*x42);


    x0 = 1.4981088130721367e-10*std::exp((-0.63529999999999998)*std::log(std::abs(T)));

    x1 = 8.6173430000000006e-5*T;

    x2 = x1 <= 9280.0;

    x3 = 1.0/T;

    x4 = (1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661*x3))*std::exp(-469943.50750964211*x3);

    x5 = ((x2) ? (
   x0
)
: (
   1250086.112245841*std::exp((-1.5)*std::log(std::abs(T)))*x4 + x0
));

    x6 = std::log(x1);

    x7 = ((x6)*(x6));

    x8 = ((x6)*(x6)*(x6));

    x9 = ((((x6)*(x6)))*(((x6)*(x6))));

    x10 = ((x6)*(x6)*(x6)*(x6)*(x6));

    x11 = std::exp((6)*std::log(std::abs(x6)));

    x12 = ((x6)*(x6)*(x6)*(x6)*(x6)*(x6)*(x6));

    x13 = std::exp(0.067953912300000002*x10 - 0.0050090561*x11 + 0.000206723616*x12 - 3.6491614100000001e-6*std::exp((8)*std::log(std::abs(x6))) - 10.753230200000001*x7 + 3.0580387500000001*x8 - 0.56851189000000002*x9);

    x14 = X(13)*x13;

    x15 = 4.3524079114767552e-117*std::exp((23.915965629999999)*std::log(std::abs(T)));

    x16 = x14*x15;

    x17 = std::exp((-0.75)*std::log(std::abs(T)));

    x18 = std::exp(-127500.0*x3);

    x19 = T <= 10000.0;

    x20 = ((x19) ? (
   1.26e-9*x17*x18
)
: (
   4.0000000000000003e-37*std::exp((4.7400000000000002)*std::log(std::abs(T)))
));

    x21 = 2.8833736969617052e-16*std::exp((0.25)*std::log(std::abs(T)));

    x22 = -9.5174852894472843e-11*std::exp((-1.6353)*std::log(std::abs(T)));

    x23 = std::exp((-3.5)*std::log(std::abs(T)));

    x24 = 1.0/(9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9));

    x25 = 2.0860422997526066e-16*x24;

    x26 = 3.4767371836380304e-16*x24;

    jac(14,1) = X(12)*x5 - x16;


    jac(14,2) = -X(13)*x20;


    jac(14,3) = X(12)*x21;


    jac(14,4) = 0;


    jac(14,5) = 0;


    jac(14,6) = 0;


    jac(14,7) = 0;


    jac(14,8) = 0;


    jac(14,9) = 0;


    jac(14,10) = 0;


    jac(14,11) = 0;


    jac(14,12) = 0;


    jac(14,13) = X(0)*x5 + X(2)*x21;


    jac(14,14) = -X(0)*x13*x15 - X(1)*x20;


    jac(14,15) = (-1.0409203801861816e-115*std::exp((22.915965629999999)*std::log(std::abs(T)))*X(0)*x14 + X(0)*X(12)*((x2) ? (
   x22
)
: (
   -1875129.1683687614*std::exp((-2.5)*std::log(std::abs(T)))*x4 + x22 + 587469852277.90271*x23*x4 + 54.282214350476039*x23*std::exp(-563932.20901156683*x3)
)) - X(0)*x16*(-0.030054336600000002*x10*x3 + 0.001447065312*x11*x3 - 2.9193291280000001e-5*x12*x3 - 21.506460400000002*x3*x6 + 9.1741162500000009*x3*x7 - 2.2740475600000001*x3*x8 + 0.33976956150000004*x3*x9) - X(1)*X(13)*((x19) ? (
   0.00016065*std::exp((-2.75)*std::log(std::abs(T)))*x18 - 9.4499999999999994e-10*std::exp((-1.75)*std::log(std::abs(T)))*x18
)
: (
   1.8960000000000001e-36*std::exp((3.7400000000000002)*std::log(std::abs(T)))
)) + 7.2084342424042629e-17*X(12)*X(2)*x17)/(X(0)*x25 + X(1)*x25 + X(10)*x26 + X(11)*x25 + X(12)*x25 + X(13)*x25 + X(2)*x25 + X(3)*x25 + X(4)*x25 + X(5)*x25 + X(6)*x26 + X(7)*x25 + X(8)*x26 + X(9)*x26);


    x0 = 0.00013612213614898791*X(0) + 0.24994102282436673*X(1) + 0.75007714496081457*X(10) + 0.99972775572710437*X(11) + 0.99986387786355213*X(12) + X(13) + 0.25007714496081457*X(2) + 0.25021326709726244*X(3) + 0.49986387786355219*X(4) + 0.5*X(5) + 0.50001816778518127*X(6) + 0.50013612213644787*X(7) + 0.50015428992162914*X(8) + 0.7499410228243667*X(9);

    x1 = ((x0)*(x0));

    x2 = 1.0/x1;

    x3 = X(1) + X(12) + X(4);

    x4 = 4.0*X(11) + x3;

    x5 = std::sqrt(T);

    x6 = 2.1299999999999999e-27*x5;

    x7 = x4*x6;

    x8 = 1.0/T;

    x9 = std::exp(-102000.0*x8);

    x10 = X(8)*x9;

    x11 = 3.1438547368704001e-21*std::exp((0.34999999999999998)*std::log(std::abs(T)));

    x12 = x10*x11;

    x13 = 2.73*z + 2.73;

    x14 = 5.6500000000000001e-36*((((z + 1.0)*(z + 1.0)))*(((z + 1.0)*(z + 1.0))));

    x15 = x14*(T - x13);

    x16 = T <= 10;

    x17 = 1.5499999999999999e-26*((x16) ? (
   2.3157944032250755
)
: (
   std::exp((0.36470000000000002)*std::log(std::abs(T)))
));

    x18 = X(12)*x17;

    x19 = std::sqrt(T);

    x20 = ((x16) ? (
   std::sqrt(10)
)
: (
   x19
));

    x21 = 0.0031622776601683794*x20 + 1.0;

    x22 = 1.0/x21;

    x23 = X(2)*x22;

    x24 = ((x16) ? (
   1.0/10.0
)
: (
   x8
));

    x25 = std::exp(-118348.0*x24);

    x26 = 7.4999999999999996e-19*x25;

    x27 = x23*x26;

    x28 = 6.3095734448019361e-5*((x16) ? (
   5.011872336272722
)
: (
   std::exp((0.69999999999999996)*std::log(std::abs(T)))
)) + 1.0;

    x29 = 1.0/x28;

    x30 = ((x16) ? (
   0.63095734448019325
)
: (
   std::exp((-0.20000000000000001)*std::log(std::abs(T)))
));

    x31 = x29*x30;

    x32 = x20*x31;

    x33 = 3.4635323838154264e-26*x32;

    x34 = X(1)*x33;

    x35 = 1.3854129535261706e-25*x32;

    x36 = X(11)*x35;

    x37 = X(0)*X(12);

    x38 = std::exp((-1.5)*std::log(std::abs(T)));

    x39 = ((x16) ? (
   0.031622776601683791
)
: (
   x38
));

    x40 = 1.0 + 0.29999999999999999*std::exp(-94000.0*x24);

    x41 = std::exp(-470000.0*x24);

    x42 = 1.24e-13*x40*x41;

    x43 = x39*x42;

    x44 = X(10) + X(2) + X(3) + X(9);

    x45 = X(1) + 2.0*X(6) + 2.0*X(8) + x44;

    x46 = 1.0/x45;

    x47 = 1.0/x5;

    x48 = std::exp((-2)*std::log(std::abs(T)));

    x49 = std::exp(-160000.0*x48);

    x50 = X(2)*x49;

    x51 = std::exp(-12000.0/(T + 1200.0));

    x52 = X(8)*x51;

    x53 = 1.0/(1.6000000000000001*x50 + 1.3999999999999999*x52);

    x54 = x47*x53;

    x55 = x46*x54;

    x56 = 1.0/(1000000.0*x55 + 1.0);

    x57 = X(0)*x22;

    x58 = std::exp(-473638.0*x24);

    x59 = x58*((x16) ? (
   0.4008667176273028
)
: (
   std::exp((-0.39700000000000002)*std::log(std::abs(T)))
));

    x60 = 5.5399999999999998e-17*x59;

    x61 = x57*x60;

    x62 = ((x16) ? (
   0.67810976749343443
)
: (
   std::exp((-0.16869999999999999)*std::log(std::abs(T)))
));

    x63 = std::exp(-55338.0*x24);

    x64 = x62*x63;

    x65 = 5.0099999999999997e-27*x64;

    x66 = ((X(0))*(X(0)));

    x67 = X(12)*x22;

    x68 = x66*x67;

    x69 = std::exp(-13179.0*x24);

    x70 = x62*x69;

    x71 = 9.1000000000000001e-27*x70;

    x72 = std::exp(-631515.0*x24);

    x73 = 4.9500000000000001e-22*x72;

    x74 = X(12)*x73;

    x75 = x20*x57;

    x76 = std::exp(-285335.40000000002*x24);

    x77 = 9.3799999999999993e-22*x76;

    x78 = X(13)*x77;

    x79 = std::exp(-157809.10000000001*x24);

    x80 = x20*x79;

    x81 = 1.2700000000000001e-21*x80;

    x82 = x23*x81;

    x83 = ((X(2))*(X(2))*(X(2)));

    x84 = std::exp((-0.25)*std::log(std::abs(T)));

    x85 = 2.0000000000000002e-31*x47 + 6.0000000000000001e-32*x84;

    x86 = ((X(2))*(X(2)));

    x87 = 2.5000000000000002e-32*x47 + 7.5000000000000001e-33*x84;

    x88 = 1.3500000000000001e-9*std::exp((0.098492999999999997)*std::log(std::abs(T))) + 4.4350199999999998e-10*std::exp((0.55610000000000004)*std::log(std::abs(T))) + 3.7408500000000004e-16*std::exp((2.1825999999999999)*std::log(std::abs(T)));

    x89 = 0.0061910000000000003*std::exp((1.0461)*std::log(std::abs(T))) + 8.9711999999999997e-11*std::exp((3.0424000000000002)*std::log(std::abs(T))) + 3.2575999999999999e-14*std::exp((3.7740999999999998)*std::log(std::abs(T))) + 1.0;

    x90 = 1.0/x89;

    x91 = std::sqrt(M_PI);

    x92 = 1.0/x91;

    x93 = 1.3806479999999999e-16*X(0) + 1.3806479999999999e-16*X(1) + 1.3806479999999999e-16*X(10) + 1.3806479999999999e-16*X(11) + 1.3806479999999999e-16*X(12) + 1.3806479999999999e-16*X(13) + 1.3806479999999999e-16*X(2) + 1.3806479999999999e-16*X(3) + 1.3806479999999999e-16*X(4) + 1.3806479999999999e-16*X(5) + 1.3806479999999999e-16*X(6) + 1.3806479999999999e-16*X(7) + 1.3806479999999999e-16*X(8) + 1.3806479999999999e-16*X(9);

    x94 = 9.1093818800000008e-28*X(0) + 1.6726215800000001e-24*X(1) + 5.01956503638e-24*X(10) + 6.6902431600000005e-24*X(11) + 6.6911540981899994e-24*X(12) + 6.6920650363799998e-24*X(13) + 1.6735325181900001e-24*X(2) + 1.6744434563800001e-24*X(3) + 3.3451215800000003e-24*X(4) + 3.3460325181899999e-24*X(5) + 3.3461540981899999e-24*X(6) + 3.3469434563800003e-24*X(7) + 3.3470650363800003e-24*X(8) + 5.0186540981899997e-24*X(9);

    x95 = 1.0/x94;

    x96 = std::exp((-1.0/2.0)*std::log(std::abs(x95)));

    x97 = ((X(8))*(X(8)));

    x98 = 1.1800000000000001e-10*std::exp(-69500.0*x8);

    x99 = std::log(0.0001*T);

    x100 = M_LN10;

    x101 = 1.0/x100;

    x102 = std::exp((-2)*std::log(std::abs(x100)));

    x103 = std::exp((1.3*x101*x99 - 1.6200000000000001*x102*((x99)*(x99)) - 4.8449999999999998)*std::log(std::abs(10.0)));

    x104 = x103*x45;

    x105 = x104 + 1.0;

    x106 = 1.0/x105;

    x107 = 1.0*x106;

    x108 = std::exp((x107)*std::log(std::abs(x98)));

    x109 = 1.0 - std::exp(-6000.0*x8);

    x110 = 52000.0*x8;

    x111 = std::exp(-x110);

    x112 = x109*x111;

    x113 = 8.1250000000000003e-8*x112*x47;

    x114 = 1.0 - x107;

    x115 = std::exp((x114)*std::log(std::abs(x113)));

    x116 = x108*x115;

    x117 = x116*x97;

    x118 = 7.1777505408000004e-12*x117;

    x119 = std::log(T);

    x120 = ((x119)*(x119));

    x121 = x102*x120;

    x122 = -4.8909149999999997*x101*x119 + 0.47490300000000002*x121 - 133.82830000000001*x8;

    x123 = std::exp((x122 + 14.82123)*std::log(std::abs(10.0)));

    x124 = 1.0/x123;

    x125 = x124*x45;

    x126 = std::exp(-0.0022727272727272726*T);

    x127 = std::exp(-0.00054054054054054055*T);

    x128 = -2.0563129999999998*x126 + 0.58640729999999996*x127 + 0.82274429999999998;

    x129 = std::exp((x128)*std::log(std::abs(x125)));

    x130 = x129 + 1.0;

    x131 = 1.0/x130;

    x132 = x101*x119;

    x133 = 16780.950000000001*x8 + 1.0;

    x134 = amrex::Math::powi<-3>(x100);

    x135 = ((x119)*(x119)*(x119))*x134;

    x136 = 40870.379999999997*x8 + 1.0;

    x137 = -69.700860000000006*x101*std::log(x136) + 4.6331670000000003*x135;

    x138 = 19.734269999999999*x101*std::log(x133) + 37.886913*x102*x120 - 14.509090000000008*x132 - x137 - 307.31920000000002;

    x139 = std::exp((x122 + 13.656822)*std::log(std::abs(10.0)));

    x140 = 1.0/x139;

    x141 = x140*x45;

    x142 = std::exp((x128)*std::log(std::abs(x141)));

    x143 = x142 + 1.0;

    x144 = 1.0/x143;

    x145 = std::exp((43.20243*x102*x120 - x131*x138 - 68.422430000000006*x132 - x137 - 2080.4099999999999*x144*x8 - 23705.700000000001*x8 - 178.4239)*std::log(std::abs(10.0)));

    x146 = -2.4640089999999999*x101*x119 + 0.19859550000000001*x121 + 743.05999999999995*x8;

    x147 = std::exp((x146 + 9.3055640000000004)*std::log(std::abs(10.0)));

    x148 = 1.0/x147;

    x149 = x148*x45;

    x150 = 2.9375070000000001*x126 + 0.23588480000000001*x127 + 0.75022860000000002;

    x151 = std::exp((x150)*std::log(std::abs(x149)));

    x152 = x151 + 1.0;

    x153 = 1.0/x152;

    x154 = 14254.549999999999*x8 + 1.0;

    x155 = 27535.310000000001*x8 + 1.0;

    x156 = -21.360939999999999*x101*std::log(x155) + 0.25820969999999999*x135;

    x157 = 70.138370000000009*x101*x119 + 11.28215*x101*std::log(x154) - 4.7035149999999994*x121 - x156 - 203.11568;

    x158 = std::exp((x146 + 8.1313220000000008)*std::log(std::abs(10.0)));

    x159 = 1.0/x158;

    x160 = x159*x45;

    x161 = std::exp((x150)*std::log(std::abs(x160)));

    x162 = x161 + 1.0;

    x163 = 1.0/x162;

    x164 = std::exp((42.707410000000003*x101*x119 - 2.0273650000000001*x121 - x153*x157 - x156 - 1657.4099999999999*x163*x8 - 21467.790000000001*x8 - 142.7664)*std::log(std::abs(10.0)));

    x165 = 7.1777505408000004e-12*x145 + 7.1777505408000004e-12*x164;

    x166 = X(8)*x165;

    x167 = T >= 10000.0;

    x168 = std::log(((x167) ? (
   10000.0
)
: (
   T
)));

    x169 = std::exp((-4)*std::log(std::abs(x100)));

    x170 = ((((x168)*(x168)))*(((x168)*(x168))));

    x171 = ((x168)*(x168)*(x168));

    x172 = ((x168)*(x168));

    x173 = X(2) <= 0.01;

    x174 = ((x173) ? (
   false
)
: (
   X(2) >= 10000000000.0
));

    x175 = std::log(((x174) ? (
   10000000000.0
)
: (
   ((x173) ? (
      0.01
   )
   : (
      X(2)
   ))
)));

    x176 = ((((x175)*(x175)))*(((x175)*(x175))));

    x177 = ((x175)*(x175)*(x175));

    x178 = ((x175)*(x175));

    x179 = x102*x168;

    x180 = amrex::Math::powi<-5>(x100);

    x181 = x176*x180;

    x182 = x170*x180;

    x183 = x169*x177;

    x184 = x169*x171;

    x185 = x134*x178;

    x186 = x134*x172;

    x187 = std::exp((-8)*std::log(std::abs(x100)));

    x188 = x170*x187;

    x189 = amrex::Math::powi<-7>(x100);

    x190 = x171*x189;

    x191 = x170*x189;

    x192 = std::exp((-6)*std::log(std::abs(x100)));

    x193 = x172*x192;

    x194 = x171*x192;

    x195 = x170*x192;

    x196 = x177*x180;

    x197 = x171*x180;

    x198 = x169*x178;

    x199 = std::exp((21.93385*x101*x168 + 0.92432999999999998*x101*x175 - 10.19097*x102*x172 + 0.54962*x102*x178 + 2.1990599999999998*x134*x171 - 0.076759999999999995*x134*x177 - 0.0036600000000000001*x168*x181 + 0.11864*x168*x183 - 1.06447*x168*x185 - 0.17333999999999999*x169*x170 + 0.0027499999999999998*x169*x176 - 0.073660000000000003*x172*x196 + 0.62343000000000004*x172*x198 + 0.77951999999999999*x175*x179 - 0.0083499999999999998*x175*x182 + 0.11711000000000001*x175*x184 - 0.54262999999999995*x175*x186 + 6.1920000000000003e-5*x176*x188 - 0.00066631000000000004*x176*x190 + 0.0025140000000000002*x176*x193 - 0.001482*x177*x191 + 0.017590000000000001*x177*x194 + 0.0106*x178*x195 - 0.13768*x178*x197 - 42.567880000000002)*std::log(std::abs(10.0)));

    x200 = X(10)*x199;

    x201 = T >= x13;

    x202 = X(6) + X(8);

    x203 = X(0) + X(11) + X(13) + X(5) + X(7) + x202 + x3 + x44;

    x204 = x203 <= 9.9999999999999993e-41;

    x205 = x94 >= 9.9999999999999998e-13;

    x206 = x94 >= 0.5;

    x207 = x94 <= 9.9999999999999993e-41;

    x208 = x19*x91;

    x209 = x208*x94;

    x210 = std::exp((2.1498900000000001 - 0.69317629274152892*x101)*std::log(std::abs(10.0)))*x209;

    x211 = 1.0000420000000001*x101;

    x212 = std::exp((x211*std::log(x94) + 2.1498900000000001)*std::log(std::abs(10.0)))*x209;

    x213 = 1.0/std::fabs(x0);

    x214 = std::sqrt(x203);

    x215 = std::sqrt(x2*x203);

    x216 = ((x204 && x205 && x206 && x207) ? (
   4.8339620236294848e-32/((x210 + 2.1986273043946046e-56)*(x210 + 2.1986273043946046e-56)) >= 1.0
)
: (
   ((x204 && x205 && x207) ? (
      4.8339620236294848e-32/((x212 + 2.1986273043946046e-56)*(x212 + 2.1986273043946046e-56)) >= 1.0
   )
   : (
      ((x204 && x207) ? (
         true
      )
      : (
         ((x204 && x205 && x206) ? (
            216.48287161311649/((x210*x213 + 1.471335691176954e-39)*(x210*x213 + 1.471335691176954e-39)) >= 1.0
         )
         : (
            ((x204 && x205) ? (
               216.48287161311649/((x212*x213 + 1.471335691176954e-39)*(x212*x213 + 1.471335691176954e-39)) >= 1.0
            )
            : (
               ((x204) ? (
                  true
               )
               : (
                  ((x205 && x206 && x207) ? (
                     4.833962023629485e-72/((x210*x214 + 2.1986273043946045e-76)*(x210*x214 + 2.1986273043946045e-76)) >= 1.0
                  )
                  : (
                     ((x205 && x207) ? (
                        4.833962023629485e-72/((x212*x214 + 2.1986273043946045e-76)*(x212*x214 + 2.1986273043946045e-76)) >= 1.0
                     )
                     : (
                        ((x207) ? (
                           true
                        )
                        : (
                           ((x205 && x206) ? (
                              2.1648287161311648e-38/((x210*x215 + 1.471335691176954e-59)*(x210*x215 + 1.471335691176954e-59)) >= 1.0
                           )
                           : (
                              ((x205) ? (
                                 2.1648287161311648e-38/((x212*x215 + 1.471335691176954e-59)*(x212*x215 + 1.471335691176954e-59)) >= 1.0
                              )
                              : (
                                 true
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
));

    x217 = std::exp((x211*std::log(((x206) ? (
   0.5
)
: (
   x94
))) + 2.1498900000000001)*std::log(std::abs(10.0)));

    x218 = ((x205) ? (
   x217
)
: (
   0.0
));

    x219 = ((x204) ? (
   9.9999999999999993e-41
)
: (
   x203
));

    x220 = ((x207) ? (
   1.0e+80
)
: (
   2.232953576238777e+46*x2
));

    x221 = std::sqrt(x219*x220);

    x222 = x218*x221;

    x223 = x209*x222;

    x224 = x223 + 2.1986273043946046e-36;

    x225 = ((x216) ? (
   1.0
)
: (
   483396202.36294854/((x224)*(x224))
));

    x226 = ((((T)*(T)))*(((T)*(T))));

    x227 = x218*x226;

    x228 = x225*x227;

    x229 = 0.00022681492*x94;

    x230 = T < 2.0;

    x231 = 1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9) <= 9.9999999999999993e-41;

    x232 = 28601.610899577994*std::exp((-0.45000000000000001)*std::log(std::abs(x203)));

    x233 = ((x231) ? (
   true
)
: (
   x232 >= 1.0
));

    x234 = ((x233) ? (
   1.0
)
: (
   ((x231) ? (
      1.000000000000001e+18
   )
   : (
      x232
   ))
));

    x235 = std::exp((25.0*x101)*std::log(std::abs(T)));

    x236 = 1.0/x235;

    x237 = 1.0/(2.3538526683701997e+17*x236 + 10.0);

    x238 = 1.0/(1.6889118802245084e-48*x235 + 10.0);

    x239 = std::exp((20000.0*x237*x238 - 200.0)*std::log(std::abs(10.0)));

    x240 = std::log(0.001*T);

    x241 = ((x240)*(x240)*(x240)*(x240)*(x240));

    x242 = x180*x241;

    x243 = ((((x240)*(x240)))*(((x240)*(x240))));

    x244 = x169*x243;

    x245 = ((x240)*(x240)*(x240));

    x246 = ((x240)*(x240));

    x247 = x102*x246;

    x248 = std::exp((2.0943374000000001*x101*x240 + 0.43693353000000001*x134*x245 - 0.033638326000000003*x242 - 0.14913216000000001*x244 - 0.77151435999999995*x247 - 23.962112000000001)*std::log(std::abs(10.0)));

    x249 = x239*x248;

    x250 = X(8)*x249;

    x251 = x101*x240;

    x252 = x134*x245;

    x253 = std::exp((0.19191374999999999*x242 - 0.16596184*x244 - 0.81520437999999995*x247 + 2.1892372*x251 + 0.29036281000000003*x252 - 23.689236999999999)*std::log(std::abs(10.0)));

    x254 = X(13)*x253;

    x255 = T <= 10000.0;

    x256 = T > 10.0;

    x257 = x255 && x256;

    x258 = std::exp((16.666666666666664*x101)*std::log(std::abs(T)));

    x259 = 1.0/x258;

    x260 = 1.0/(785.77199422741614*x259 + 10.0);

    x261 = 1.0/(5.0592917094448065e-34*x258 + 10.0);

    x262 = std::exp((20000.0*x260*x261 - 200.0)*std::log(std::abs(10.0)));

    x263 = 1.002560385050777e-22*x262;

    x264 = X(13)*x263;

    x265 = std::exp((0.32168730000000001*x242 - 0.51002221000000003*x244 + 0.015391166*x247 + 1.5714710999999999*x251 - 0.23619984999999999*x252 - 22.089523)*std::log(std::abs(10.0)));

    x266 = X(1)*x265;

    x267 = 1.1825091393820599e-21*x262;

    x268 = X(1)*x267;

    x269 = std::exp((3.8479610000000002*x242 + 20.159831000000001*x244 + 58.145166000000003*x247 + 37.383713*x251 + 48.656103000000002*x252 - 16.818342000000001)*std::log(std::abs(10.0)));

    x270 = X(2)*x269;

    x271 = T <= 100.0;

    x272 = std::exp((3.5692468000000002*x101*x240 - 4.2519023000000002*x242 - 21.328264000000001*x244 - 11.33286*x247 - 27.850082*x252 - 24.311209000000002)*std::log(std::abs(10.0)));

    x273 = X(2)*x272;

    x274 = T <= 1000.0;

    x275 = std::exp((1.5538288*x242 - 5.5108049000000001*x244 - 3.7209846*x247 + 4.6450521*x251 + 5.9369081000000001*x252 - 24.311209000000002)*std::log(std::abs(10.0)));

    x276 = X(2)*x275;

    x277 = T <= 6000.0;

    x278 = std::exp((17.997580222853362*x101)*std::log(std::abs(T)));

    x279 = 1.0/x278;

    x280 = 1.0/(2973.7534532281375*x279 + 10.0);

    x281 = 1.0/(1.3368457736780898e-34*x278 + 10.0);

    x282 = 1.8623144679125181e-22*std::exp((20000.0*x280*x281 - 200.0)*std::log(std::abs(10.0)));

    x283 = X(2)*x282;

    x284 = std::exp((8)*std::log(std::abs(x240)));

    x285 = x187*x284;

    x286 = ((x240)*(x240)*(x240)*(x240)*(x240)*(x240)*(x240));

    x287 = x189*x286;

    x288 = std::exp((6)*std::log(std::abs(x240)));

    x289 = x192*x288;

    x290 = std::exp((983.67575999999997*x242 + 734.71650999999997*x244 + 96.743155000000002*x247 + 16.815729999999999*x251 + 343.1918*x252 + 70.609154000000004*x285 + 364.14445999999998*x287 + 801.81246999999996*x289 - 21.928795999999998)*std::log(std::abs(10.0)));

    x291 = X(0)*x290;

    x292 = T <= 500.0;

    x293 = T > 100;

    x294 = x292 && x293;

    x295 = std::exp((-8.8077017000000009*x242 - 4.7274035999999997*x244 + 0.93310621999999999*x247 + 1.6802758*x251 + 4.0406627000000004*x252 - 6.3701156000000001*x285 + 6.4380698000000001*x287 + 8.9167182999999994*x289 - 22.921188999999998)*std::log(std::abs(10.0)));

    x296 = X(0)*x295;

    x297 = T > 500.0;

    x298 = x239*((x294) ? (
   x291
)
: ((x297) ? (
   x296
)
: (
   0
)));

    x299 = x250 + x298 + ((x257) ? (
   x254
)
: (
   x264
)) + ((x257) ? (
   x266
)
: (
   x268
)) + ((x271) ? (
   x270
)
: ((x274) ? (
   x273
)
: ((x277) ? (
   x276
)
: (
   x283
))));

    x300 = std::exp(-11700.0*x8);

    x301 = std::exp(-5860.0*x8);

    x302 = std::exp(-510.0*x8);

    x303 = 6.0142468035272636e-8*std::exp((2.1000000000000001)*std::log(std::abs(T))) + 1.0;

    x304 = ((T)*(T)*(T));

    x305 = 1.0/x304;

    x306 = std::exp(-2197000.0*x305);

    x307 = x306/x303;

    x308 = 4.985670872372847e-33*std::exp((3.7599999999999998)*std::log(std::abs(T)))*x307 + 1.6e-18*x300 + 6.7e-19*x301 + 3.0e-24*x302;

    x309 = T < 2000.0;

    x310 = std::exp((5.0194035000000001*x101*x240 + 2.4714160999999999*x169*x243 + 5.4710749999999999*x180*x241 + 1.8161874*x187*x284 - 1.5738805*x247 - 4.7155769000000003*x252 - 2.2148338000000001*x287 - 3.9467355999999998*x289 - 20.584225)*std::log(std::abs(10.0)));

    x311 = 0.00020000000000000001*T;

    x312 = x311 - 6.0;

    x313 = x312 >= 300.0;

    x314 = std::exp(((x313) ? (
   300.0
)
: (
   x312
)));

    x315 = x314 + 1.0;

    x316 = ((x309) ? (
   x308
)
: ((x255) ? (
   x310
)
: (
   5.5313336794064847e-19/x315
)));

    x317 = x299 + x316;

    x318 = 1.0/x317;

    x319 = x316*x318;

    x320 = x308 >= 1.0e-99;

    x321 = x239*x291;

    x322 = x250 + x270;

    x323 = x254 + x266;

    x324 = x322 + x323;

    x325 = x321 + x324 >= 1.0e-99;

    x326 = x250 + x323;

    x327 = x273 + x326;

    x328 = x321 + x327 >= 1.0e-99;

    x329 = x276 + x326;

    x330 = x321 + x329 >= 1.0e-99;

    x331 = x283 + x326;

    x332 = x321 + x331 >= 1.0e-99;

    x333 = x264 + x268;

    x334 = x322 + x333;

    x335 = x321 + x334 >= 1.0e-99;

    x336 = x250 + x333;

    x337 = x273 + x336;

    x338 = x321 + x337 >= 1.0e-99;

    x339 = x276 + x336;

    x340 = x321 + x339 >= 1.0e-99;

    x341 = x283 + x336;

    x342 = x321 + x341 >= 1.0e-99;

    x343 = x239*x296;

    x344 = x324 + x343 >= 1.0e-99;

    x345 = x327 + x343 >= 1.0e-99;

    x346 = x329 + x343 >= 1.0e-99;

    x347 = x331 + x343 >= 1.0e-99;

    x348 = x334 + x343 >= 1.0e-99;

    x349 = x337 + x343 >= 1.0e-99;

    x350 = x339 + x343 >= 1.0e-99;

    x351 = x341 + x343 >= 1.0e-99;

    x352 = x324 >= 1.0e-99;

    x353 = x327 >= 1.0e-99;

    x354 = x329 >= 1.0e-99;

    x355 = x331 >= 1.0e-99;

    x356 = x334 >= 1.0e-99;

    x357 = x337 >= 1.0e-99;

    x358 = x339 >= 1.0e-99;

    x359 = x341 >= 1.0e-99;

    x360 = x310 >= 1.0e-99;

    x361 = 5.5313336794064847e-19/(0.0024787521766663585*std::exp(x311) + 1.0) >= 1.0e-99;

    x362 = ((x255 && x256 && x271 && x292 && x293 && x309) ? (
   x320 && x325
)
: (
   ((x255 && x256 && x274 && x292 && x293 && x309) ? (
      x320 && x328
   )
   : (
      ((x255 && x256 && x277 && x292 && x293 && x309) ? (
         x320 && x330
      )
      : (
         ((x255 && x256 && x292 && x293 && x309) ? (
            x320 && x332
         )
         : (
            ((x271 && x292 && x293 && x309) ? (
               x320 && x335
            )
            : (
               ((x274 && x292 && x293 && x309) ? (
                  x320 && x338
               )
               : (
                  ((x277 && x292 && x293 && x309) ? (
                     x320 && x340
                  )
                  : (
                     ((x292 && x293 && x309) ? (
                        x320 && x342
                     )
                     : (
                        ((x255 && x256 && x271 && x297 && x309) ? (
                           x320 && x344
                        )
                        : (
                           ((x255 && x256 && x274 && x297 && x309) ? (
                              x320 && x345
                           )
                           : (
                              ((x255 && x256 && x277 && x297 && x309) ? (
                                 x320 && x346
                              )
                              : (
                                 ((x255 && x256 && x297 && x309) ? (
                                    x320 && x347
                                 )
                                 : (
                                    ((x271 && x297 && x309) ? (
                                       x320 && x348
                                    )
                                    : (
                                       ((x274 && x297 && x309) ? (
                                          x320 && x349
                                       )
                                       : (
                                          ((x277 && x297 && x309) ? (
                                             x320 && x350
                                          )
                                          : (
                                             ((x297 && x309) ? (
                                                x320 && x351
                                             )
                                             : (
                                                ((x255 && x256 && x271 && x309) ? (
                                                   x320 && x352
                                                )
                                                : (
                                                   ((x255 && x256 && x274 && x309) ? (
                                                      x320 && x353
                                                   )
                                                   : (
                                                      ((x255 && x256 && x277 && x309) ? (
                                                         x320 && x354
                                                      )
                                                      : (
                                                         ((x255 && x256 && x309) ? (
                                                            x320 && x355
                                                         )
                                                         : (
                                                            ((x271 && x309) ? (
                                                               x320 && x356
                                                            )
                                                            : (
                                                               ((x274 && x309) ? (
                                                                  x320 && x357
                                                               )
                                                               : (
                                                                  ((x277 && x309) ? (
                                                                     x320 && x358
                                                                  )
                                                                  : (
                                                                     ((x309) ? (
                                                                        x320 && x359
                                                                     )
                                                                     : (
                                                                        ((x255 && x256 && x271 && x292 && x293) ? (
                                                                           x325 && x360
                                                                        )
                                                                        : (
                                                                           ((x255 && x256 && x274 && x292 && x293) ? (
                                                                              x328 && x360
                                                                           )
                                                                           : (
                                                                              ((x255 && x256 && x277 && x292 && x293) ? (
                                                                                 x330 && x360
                                                                              )
                                                                              : (
                                                                                 ((x255 && x256 && x292 && x293) ? (
                                                                                    x332 && x360
                                                                                 )
                                                                                 : (
                                                                                    ((x255 && x271 && x292 && x293) ? (
                                                                                       x335 && x360
                                                                                    )
                                                                                    : (
                                                                                       ((x255 && x274 && x292 && x293) ? (
                                                                                          x338 && x360
                                                                                       )
                                                                                       : (
                                                                                          ((x255 && x277 && x292 && x293) ? (
                                                                                             x340 && x360
                                                                                          )
                                                                                          : (
                                                                                             ((x255 && x292 && x293) ? (
                                                                                                x342 && x360
                                                                                             )
                                                                                             : (
                                                                                                ((x255 && x256 && x271 && x297) ? (
                                                                                                   x344 && x360
                                                                                                )
                                                                                                : (
                                                                                                   ((x255 && x256 && x274 && x297) ? (
                                                                                                      x345 && x360
                                                                                                   )
                                                                                                   : (
                                                                                                      ((x255 && x256 && x277 && x297) ? (
                                                                                                         x346 && x360
                                                                                                      )
                                                                                                      : (
                                                                                                         ((x255 && x256 && x297) ? (
                                                                                                            x347 && x360
                                                                                                         )
                                                                                                         : (
                                                                                                            ((x255 && x271 && x297) ? (
                                                                                                               x348 && x360
                                                                                                            )
                                                                                                            : (
                                                                                                               ((x255 && x274 && x297) ? (
                                                                                                                  x349 && x360
                                                                                                               )
                                                                                                               : (
                                                                                                                  ((x255 && x277 && x297) ? (
                                                                                                                     x350 && x360
                                                                                                                  )
                                                                                                                  : (
                                                                                                                     ((x255 && x297) ? (
                                                                                                                        x351 && x360
                                                                                                                     )
                                                                                                                     : (
                                                                                                                        ((x255 && x256 && x271) ? (
                                                                                                                           x352 && x360
                                                                                                                        )
                                                                                                                        : (
                                                                                                                           ((x255 && x256 && x274) ? (
                                                                                                                              x353 && x360
                                                                                                                           )
                                                                                                                           : (
                                                                                                                              ((x255 && x256 && x277) ? (
                                                                                                                                 x354 && x360
                                                                                                                              )
                                                                                                                              : (
                                                                                                                                 ((x257) ? (
                                                                                                                                    x355 && x360
                                                                                                                                 )
                                                                                                                                 : (
                                                                                                                                    ((x255 && x271) ? (
                                                                                                                                       x356 && x360
                                                                                                                                    )
                                                                                                                                    : (
                                                                                                                                       ((x255 && x274) ? (
                                                                                                                                          x357 && x360
                                                                                                                                       )
                                                                                                                                       : (
                                                                                                                                          ((x255 && x277) ? (
                                                                                                                                             x358 && x360
                                                                                                                                          )
                                                                                                                                          : (
                                                                                                                                             ((x255) ? (
                                                                                                                                                x359 && x360
                                                                                                                                             )
                                                                                                                                             : (
                                                                                                                                                ((x313 && (x271 || x313) && (x274 || x313) && (x277 || x313) && (x292 || x313) && (x293 || x313) && (x297 || x313) && (x271 || x274 || x313) && (x271 || x277 || x313) && (x271 || x292 || x313) && (x271 || x293 || x313) && (x271 || x297 || x313) && (x274 || x277 || x313) && (x274 || x292 || x313) && (x274 || x293 || x313) && (x274 || x297 || x313) && (x277 || x292 || x313) && (x277 || x293 || x313) && (x277 || x297 || x313) && (x292 || x293 || x313) && (x293 || x297 || x313) && (x271 || x274 || x277 || x313) && (x271 || x274 || x292 || x313) && (x271 || x274 || x293 || x313) && (x271 || x274 || x297 || x313) && (x271 || x277 || x292 || x313) && (x271 || x277 || x293 || x313) && (x271 || x277 || x297 || x313) && (x271 || x292 || x293 || x313) && (x271 || x293 || x297 || x313) && (x274 || x277 || x292 || x313) && (x274 || x277 || x293 || x313) && (x274 || x277 || x297 || x313) && (x274 || x292 || x293 || x313) && (x274 || x293 || x297 || x313) && (x277 || x292 || x293 || x313) && (x277 || x293 || x297 || x313) && (x271 || x274 || x277 || x292 || x313) && (x271 || x274 || x277 || x293 || x313) && (x271 || x274 || x277 || x297 || x313) && (x271 || x274 || x292 || x293 || x313) && (x271 || x274 || x293 || x297 || x313) && (x271 || x277 || x292 || x293 || x313) && (x271 || x277 || x293 || x297 || x313) && (x274 || x277 || x292 || x293 || x313) && (x274 || x277 || x293 || x297 || x313) && (x271 || x274 || x277 || x292 || x293 || x313) && (x271 || x274 || x277 || x293 || x297 || x313)) ? (
                                                                                                                                                   false
                                                                                                                                                )
                                                                                                                                                : (
                                                                                                                                                   ((x271 && x292 && x293) ? (
                                                                                                                                                      x335 && x361
                                                                                                                                                   )
                                                                                                                                                   : (
                                                                                                                                                      ((x274 && x292 && x293) ? (
                                                                                                                                                         x338 && x361
                                                                                                                                                      )
                                                                                                                                                      : (
                                                                                                                                                         ((x277 && x292 && x293) ? (
                                                                                                                                                            x340 && x361
                                                                                                                                                         )
                                                                                                                                                         : (
                                                                                                                                                            ((x294) ? (
                                                                                                                                                               x342 && x361
                                                                                                                                                            )
                                                                                                                                                            : (
                                                                                                                                                               ((x271 && x297) ? (
                                                                                                                                                                  x348 && x361
                                                                                                                                                               )
                                                                                                                                                               : (
                                                                                                                                                                  ((x274 && x297) ? (
                                                                                                                                                                     x349 && x361
                                                                                                                                                                  )
                                                                                                                                                                  : (
                                                                                                                                                                     ((x277 && x297) ? (
                                                                                                                                                                        x350 && x361
                                                                                                                                                                     )
                                                                                                                                                                     : (
                                                                                                                                                                        x351 && x361
                                                                                                                                                                     ))
                                                                                                                                                                  ))
                                                                                                                                                               ))
                                                                                                                                                            ))
                                                                                                                                                         ))
                                                                                                                                                      ))
                                                                                                                                                   ))
                                                                                                                                                ))
                                                                                                                                             ))
                                                                                                                                          ))
                                                                                                                                       ))
                                                                                                                                    ))
                                                                                                                                 ))
                                                                                                                              ))
                                                                                                                           ))
                                                                                                                        ))
                                                                                                                     ))
                                                                                                                  ))
                                                                                                               ))
                                                                                                            ))
                                                                                                         ))
                                                                                                      ))
                                                                                                   ))
                                                                                                ))
                                                                                             ))
                                                                                          ))
                                                                                       ))
                                                                                    ))
                                                                                 ))
                                                                              ))
                                                                           ))
                                                                        ))
                                                                     ))
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
));

    x363 = ((x362) ? (
   x299*x319
)
: (
   0
));

    x364 = x234*x363;

    x365 = x2*(0.00084373771595996178*T*x92*x93*x96 - X(0)*x12 - X(0)*x15 - X(0)*x18 - X(0)*x27 - X(0)*x34 - X(0)*x36 - X(0)*x7 - X(0)*x82 - X(12)*x61 + 5.6556829037999995e-12*X(2)*X(3)*x56*x88*x90 + 1.75918975308e-21*X(2)*X(6)*x56 - X(2)*x166 + 7.1777505408000004e-12*X(8)*x56*x86*x87 - x118 - x228*x229 - x37*x43 + 7.1777505408000004e-12*x56*x83*x85 - x65*x68 - x68*x71 - x74*x75 - x75*x78 - ((x230) ? (
   0
)
: (
   X(8)*x364
)) - ((x201) ? (
   x200
)
: (
   0
)));

    x366 = X(12)*x57;

    x367 = -1.1649047900646892e-19*T*x92*x96;

    x368 = x20*x22;

    x369 = 2.3026818015679518*x101*x217*((x206) ? (
   2.0
)
: (
   x95
));

    x370 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      9.1093818800000008e-28
   ))
)
: (
   0
));

    x371 = x225*x226*x229;

    x372 = x208*x222;

    x373 = 2*x209*x221;

    x374 = (1.0/2.0)*x220*((x204) ? (
   0
)
: (
   1
));

    x375 = amrex::Math::powi<-3>(x0);

    x376 = (1.0/2.0)*x219;

    x377 = 2*x223*((x207) ? (
   9.9999999999999996e-81
)
: (
   4.4783734451139649e-47*x1
))*((x204) ? (
   1.0e+40
)
: (
   1.0/x203
));

    x378 = 483396202.36294854/((x224)*(x224)*(x224));

    x379 = x227*x229;

    x380 = X(8)*x363*((x233) ? (
   0
)
: (
   ((x231) ? (
      0
   )
   : (
      -12870.724904810098*std::exp((-1.45)*std::log(std::abs(x203)))
   ))
));

    x381 = ((x294) ? (
   x290
)
: ((x297) ? (
   x295
)
: (
   0
)));

    x382 = x299*x316/((x317)*(x317));

    x383 = X(8)*x234;

    x384 = X(0)*x6;

    x385 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      1.6726215800000001e-24
   ))
)
: (
   0
));

    x386 = ((x257) ? (
   x265
)
: (
   x267
));

    x387 = x142*x8/((x143)*(x143));

    x388 = 4790.3210533157426*x387;

    x389 = x139*x140;

    x390 = x128*x46;

    x391 = x389*x390;

    x392 = x129*x138/((x130)*(x130));

    x393 = 2.3025850929940459*x392;

    x394 = x123*x124;

    x395 = x390*x394;

    x396 = x161*x8/((x162)*(x162));

    x397 = 3816.3275589792611*x396;

    x398 = x158*x159;

    x399 = x150*x46;

    x400 = x398*x399;

    x401 = x151*x157/((x152)*(x152));

    x402 = 2.3025850929940459*x401;

    x403 = x147*x148;

    x404 = x399*x403;

    x405 = 7.1777505408000004e-12*X(8);

    x406 = X(2)*x405;

    x407 = x406*(x145*(x388*x391 + x393*x395) + x164*(x397*x400 + x402*x404));

    x408 = std::exp((-2)*std::log(std::abs(x105)));

    x409 = x408*std::log(x113);

    x410 = x103*x118;

    x411 = x409*x410;

    x412 = std::log(x98);

    x413 = std::exp((-2)*std::log(std::abs(0.5*X(1) + 0.5*X(10) + 0.5*X(2) + 0.5*X(3) + 0.5*X(9) + x202)));

    x414 = std::exp((-2)*std::log(std::abs(x55 + 9.9999999999999995e-7)));

    x415 = -1.4139207259499998e-18*X(2)*X(3)*x413*x414*x47*x53*x88*x90 - 4.3979743826999997e-28*X(2)*X(6)*x413*x414*x47*x53 - 1.7944376352000002e-18*X(8)*x413*x414*x47*x53*x86*x87 - 7.1777505408000004e-12*x103*x108*x115*x408*x412*x97 + x407 + x411 - 1.7944376352000002e-18*x413*x414*x47*x53*x83*x85;

    x416 = x92*x96;

    x417 = T*x416;

    x418 = 1.1649047900646892e-19*x417;

    x419 = ((x271) ? (
   x269
)
: ((x274) ? (
   x272
)
: ((x277) ? (
   x275
)
: (
   x282
))));

    x420 = ((x174) ? (
   0
)
: (
   ((x173) ? (
      0
   )
   : (
      1
   ))
))*((x174) ? (
   1.0e-10
)
: (
   ((x173) ? (
      100.0
   )
   : (
      1.0/X(2)
   ))
));

    x421 = x102*x175;

    x422 = x168*x420;

    x423 = x134*x175;

    x424 = x175*x420;

    x425 = x169*x172;

    x426 = x177*x420;

    x427 = x178*x420;

    x428 = x172*x180;

    x429 = 1.75918975308e-21*x56;

    x430 = x413*x54;

    x431 = x46*x47/((x50 + 0.87499999999999989*x52)*(x50 + 0.87499999999999989*x52));

    x432 = x414*(250000.0*x430 + 624999.99999999988*x431*x49);

    x433 = 7.1777505407999997e-24*x432;

    x434 = x83*x85;

    x435 = 1.4355501081600001e-11*X(8);

    x436 = X(2)*X(6);

    x437 = 1.7591897530800001e-33*x436;

    x438 = X(3)*x88*x90;

    x439 = 5.6556829037999995e-12*x56;

    x440 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      1.6735325181900001e-24
   ))
)
: (
   0
));

    x441 = X(8)*x86*x87;

    x442 = X(2)*x438;

    x443 = 5.6556829037999991e-24*x442;

    x444 = x2*x417*x93*x94;

    x445 = x408*x412;

    x446 = -x407 + x410*x445 - x411;

    x447 = X(2)*x439*x90;

    x448 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      1.6744434563800001e-24
   ))
)
: (
   0
));

    x449 = x414*x430;

    x450 = x434*x449;

    x451 = x436*x449;

    x452 = x441*x449;

    x453 = x442*x449;

    x454 = ((x230) ? (
   0
)
: (
   x380
));

    x455 = x418 - x454;

    x456 = x446 + 1.7944376352000002e-18*x450 + 4.3979743826999997e-28*x451 + 1.7944376352000002e-18*x452 + 1.4139207259499998e-18*x453 + x455;

    x457 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      3.3451215800000003e-24
   ))
)
: (
   0
));

    x458 = x367 + x454;

    x459 = x384 + x458;

    x460 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      3.3460325181899999e-24
   ))
)
: (
   0
));

    x461 = x406*(x145*(9580.6421066314851*x387*x391 + 4.6051701859880918*x392*x395) + x164*(7632.6551179585222*x396*x400 + 4.6051701859880918*x401*x404));

    x462 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      3.3461540981899999e-24
   ))
)
: (
   0
));

    x463 = 1.4355501081600001e-11*x103*x117;

    x464 = x409*x463;

    x465 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      3.3469434563800003e-24
   ))
)
: (
   0
));

    x466 = 500000.0*x430 + 546874.99999999988*x431*x51;

    x467 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      3.3470650363800003e-24
   ))
)
: (
   0
));

    x468 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      5.0186540981899997e-24
   ))
)
: (
   0
));

    x469 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      5.01956503638e-24
   ))
)
: (
   0
));

    x470 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      6.6902431600000005e-24
   ))
)
: (
   0
));

    x471 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      6.6911540981899994e-24
   ))
)
: (
   0
));

    x472 = x22*x66;

    x473 = ((x205) ? (
   x369*((x206) ? (
      0
   )
   : (
      6.6920650363799998e-24
   ))
)
: (
   0
));

    x474 = ((x257) ? (
   x253
)
: (
   x263
));

    x475 = 2.0860422997526066e-16*x95;

    x476 = 3.4767371836380304e-16*x95;

    x477 = X(0)*x10;

    x478 = ((x16) ? (
   0
)
: (
   -x48
));

    x479 = x37*x39*x478;

    x480 = 3.4635323838154264e-26*X(1);

    x481 = 1.0/x19;

    x482 = ((x16) ? (
   0
)
: (
   (1.0/2.0)*x481
));

    x483 = X(0)*x482;

    x484 = x31*x483;

    x485 = 1.3854129535261706e-25*X(11);

    x486 = X(0)*x20;

    x487 = x29*x486*((x16) ? (
   0
)
: (
   -0.20000000000000001*std::exp((-1.2)*std::log(std::abs(T)))
));

    x488 = std::exp((-2.5)*std::log(std::abs(T)));

    x489 = x482*x57;

    x490 = X(0)*x25;

    x491 = x482/((x21)*(x21));

    x492 = X(2)*x491;

    x493 = x23*x478;

    x494 = x68*((x16) ? (
   0
)
: (
   -0.16869999999999999*std::exp((-1.1687000000000001)*std::log(std::abs(T)))
));

    x495 = x30*x486*((x16) ? (
   0
)
: (
   0.69999999999999996*std::exp((-0.30000000000000004)*std::log(std::abs(T)))
))/((x28)*(x28));

    x496 = std::exp((-1.25)*std::log(std::abs(T)));

    x497 = x37*x491;

    x498 = X(12)*x491*x66;

    x499 = x478*x68;

    x500 = x478*x75;

    x501 = X(13)*x76;

    x502 = X(0)*x80;

    x503 = x414*(500000.0*x38*x46*x53 - 390624.99999999994*x431*(-512000.0*x305*x50 - 0.011666666666666665*x52/((0.00083333333333333339*T + 1)*(0.00083333333333333339*T + 1))));

    x504 = x102*x8;

    x505 = 1.0*x104*(2.9933606208922598*x101*x8 - 7.460375701300709*x504*x99);

    x506 = ((x167) ? (
   0
)
: (
   1
))*((x167) ? (
   0.0001
)
: (
   x8
));

    x507 = x168*x506;

    x508 = x176*x506;

    x509 = x175*x506;

    x510 = x177*x506;

    x511 = x178*x506;

    x512 = x101*x8;

    x513 = x119*x504;

    x514 = x134*x8;

    x515 = x120*x514;

    x516 = x101*x48;

    x517 = x516/x136;

    x518 = 0.0046734386363636356*x126 - 0.00031697691891891889*x127;

    x519 = x128*(11.261747970100974*x101*x8 - 308.15104860073512*x48 - 2.1870091368363029*x513);

    x520 = x516/x155;

    x521 = -0.0066761522727272725*x126 - 0.0001275052972972973*x127;

    x522 = x150*(1710.9588792001557*x48 + 5.6735903924031659*x512 - 0.91456607567139814*x513);

    x523 = x240*x504;

    x524 = x187*x286*x8;

    x525 = x189*x288*x8;

    x526 = x192*x241*x8;

    x527 = x180*x243*x8;

    x528 = x169*x245*x8;

    x529 = x246*x514;

    x530 = ((x309) ? (
   3.2860556719809434e-26*std::exp((-0.24000000000000021)*std::log(std::abs(T)))*x307 + 1.8746122480121903e-32*std::exp((2.7599999999999998)*std::log(std::abs(T)))*x307 - 6.2968615725975507e-40*std::exp((4.8599999999999994)*std::log(std::abs(T)))*x306/((x303)*(x303)) + 1.8719999999999998e-14*x300*x48 + 3.9261999999999998e-15*x301*x48 + 1.53e-21*x302*x48
)
: ((x255) ? (
   x310*(11.55760367482214*x512 - 7.2479875549080308*x523 + 33.455408266588918*x524 - 35.698903039375494*x525 - 54.526167351293466*x526 + 62.988078688261993*x527 + 22.762583481781927*x528 - 32.574051224421225*x529)
)
: (
   -5.5313336794064847e-19*x314*((x313) ? (
      0
   )
   : (
      0.00020000000000000001
   ))/((x315)*(x315))
)));

    x531 = 4.8910985889961177e-12*x101*x236*x238*x8/((x236 + 4.2483542552915895e-17)*(x236 + 4.2483542552915895e-17)) - 1.9444316593927493e-44*x235*x237*x512/((1.6889118802245085e-49*x235 + 1)*(1.6889118802245085e-49*x235 + 1));

    x532 = 976.7825399351309*x101*x259*x261*x8/((x259 + 0.012726338013398102)*(x259 + 0.012726338013398102)) - 3.8831498904253243e-30*x258*x260*x512/((5.0592917094448061e-35*x258 + 1)*(5.0592917094448061e-35*x258 + 1));

    x533 = x239*((x294) ? (
   x291*(38.719649225812766*x512 + 445.51869310442481*x523 + 1300.6686834345674*x524 + 5869.3152370465659*x525 + 11077.448644792414*x526 + 11324.985706577943*x527 + 6766.9891340104432*x528 + 2370.6849681533818*x529)
)
: ((x297) ? (
   x296*(3.8689780091986448*x512 + 4.297112944704045*x523 - 117.34186576967058*x524 + 103.76942484394611*x525 + 123.18901581604325*x526 - 101.40241318979159*x527 - 43.540996231705549*x528 + 27.91190909651122*x529)
)
: (
   0
))) + x250*x531 + x250*(4.8223900769399082*x101*x8 + 3.0182298984217999*x134*x246*x8 - 3.5529549287336835*x523 - 0.3872755400043702*x527 - 1.3735579540080118*x528) + x298*x531 + ((x257) ? (
   x254*(5.0409049417480247*x512 - 3.7541549062629067*x523 + 2.2094886994529301*x527 - 1.528565035159452*x528 + 2.0057552335975877*x529)
)
: (
   x264*x532
)) + ((x257) ? (
   x266*(3.6184459289309552*x512 + 0.0708789387907936*x523 + 3.7035619079275177*x527 - 4.6974781513675152*x528 - 1.6316107607322889*x529)
)
: (
   x268*x532
)) + ((x271) ? (
   x270*(86.079180274567719*x512 + 267.76838492252847*x523 + 44.301288185112313*x527 + 185.67890535151699*x528 + 336.10445235294861*x529)
)
: ((x274) ? (
   x273*(8.2184944748967013*x101*x8 - 52.189748993977005*x523 - 48.951834264235494*x527 - 196.44057098336626*x528 - 192.38155095558542*x529)
)
: ((x277) ? (
   x276*(10.695627721640689*x512 - 17.135767342440825*x523 + 17.889115159724135*x527 - 50.756388852554174*x528 + 41.010708268606813*x529)
)
: (
   x283*(278.71147075841589*x101*x279*x281*x8/((x279 + 0.003362753556164708)*(x279 + 0.003362753556164708)) - 1.1080034428212589e-30*x278*x280*x512/((1.3368457736780897e-35*x278 + 1)*(1.3368457736780897e-35*x278 + 1)))
))));

    jac(15,1) = -2.0340826846270714e+19*x365 + x95*(8581161392004762.0*T*x2*x92*x93*x94*x96 - X(12)*x43 - x12 - x15 - x18 - 2.0661437223616499e-31*x228 - x27 - x34 - x36 - 1.0019999999999999e-26*x366*x64 - 1.82e-26*x366*x70 - x367 - x368*x74 - x368*x78 - x370*x371 - x379*((x216) ? (
   0
)
: (
   x378*(-x370*x373 - 1.8218763760000002e-27*x372 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -6.0790882143828848e+42*x375
   ))))
)) - x60*x67 - x7 - x82 - ((x230) ? (
   0
)
: (
   x380 + x383*((x362) ? (
      x239*x316*x318*x381 - x239*x381*x382
   )
   : (
      0
   ))
)));


    jac(15,2) = -3.7348863387551538e+22*x365 + x95*(1.5756322344156688e+19*T*x2*x92*x93*x94*x96 - X(0)*x33 - 3.7937552985797361e-28*x228 - x367 - x371*x385 - x379*((x216) ? (
   0
)
: (
   x378*(-3.3452431600000003e-24*x372 - x373*x385 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -1.116213401528895e+46*x375
   ))))
)) - x384 - x415 - ((x230) ? (
   0
)
: (
   x380 + x383*((x362) ? (
      x316*x318*x386 - x382*x386
   )
   : (
      0
   ))
)));


    jac(15,3) = -3.7369204214442467e+22*x365 + x95*(X(2)*x435*x56*x87 + X(6)*x429 - x166 - 3.7958214423066343e-28*x228 - x26*x57 - x371*x440 - x379*((x216) ? (
   0
)
: (
   x378*(-3.3470650363800003e-24*x372 - x373*x440 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -1.1168213103516679e+46*x375
   ))))
)) + x418 + x432*x437 + x432*x443 + x433*x434 + x433*x441 + x438*x439 + 1.5764903505567533e+19*x444 + x446 + 2.1533251622400001e-11*x56*x85*x86 - x57*x81 - ((x230) ? (
   0
)
: (
   x380 + x383*((x362) ? (
      x316*x318*x419 - x382*x419
   )
   : (
      0
   ))
)) - ((x201) ? (
   x200*(2.1283484790071863*x101*x420 + 1.7949111316907187*x179*x420 - 0.019226585526500282*x182*x420 + 0.025328436022934504*x183*x420 + 0.26965574024053274*x184*x420 - 0.53023929521466884*x185*x420 - 1.249451749011359*x186*x420 + 0.00057030427583276537*x188*x426 - 0.006136941893251451*x190*x426 - 0.010237293323451529*x191*x427 + 0.023154795695148129*x193*x426 + 0.12150741535729581*x194*x427 + 0.048814803971473773*x195*x424 - 0.033709845761432836*x196*x422 - 0.63403983120684049*x197*x424 + 0.81953608629844088*x198*x422 + 2.5310936376227748*x420*x421 - 4.9020655078787438*x422*x423 + 2.8710012490505563*x424*x425 - 0.50882525384982424*x427*x428)
)
: (
   0
)));


    jac(15,4) = -3.7389545041333399e+22*x365 + x95*(-3.7978875860335321e-28*x228 - x371*x448 - x379*((x216) ? (
   0
)
: (
   x378*(-3.3488869127600003e-24*x372 - x373*x448 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -1.117429219174441e+46*x375
   ))))
)) + 1.5773484666978378e+19*x444 + x447*x88 + x456);


    jac(15,5) = -7.4695011950145084e+22*x365 + x95*(3.151149938820873e+19*T*x2*x92*x93*x94*x96 - 7.5872348355797369e-28*x228 - x371*x457 - x379*((x216) ? (
   0
)
: (
   x378*(-6.6902431600000005e-24*x372 - x373*x457 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -2.2323456674160042e+46*x375
   ))))
)) - x459);


    jac(15,6) = -7.4715352777036004e+22*x365 + x95*(3.1520080549619573e+19*T*x2*x92*x93*x94*x96 - 7.5893009793066334e-28*x228 - x371*x460 - x379*((x216) ? (
   0
)
: (
   x378*(-6.6920650363799998e-24*x372 - x373*x460 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -2.232953576238777e+46*x375
   ))))
)) - x458);


    jac(15,7) = -7.4718067601993997e+22*x365 + x95*(X(2)*x429 - 7.5895767408863695e-28*x228 - x371*x462 - x379*((x216) ? (
   0
)
: (
   x378*(-6.6923081963799998e-24*x372 - x373*x462 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -2.2330347118805627e+46*x375
   ))))
)) + 3.1521225849724215e+19*x444 + x445*x463 + 3.5888752704000004e-18*x450 + 8.7959487653999994e-28*x451 + 3.5888752704000004e-18*x452 + 2.8278414518999996e-18*x453 + x455 - x461 - x464);


    jac(15,8) = -7.4735693603926949e+22*x365 + x95*(3.1528661711030424e+19*T*x2*x92*x93*x94*x96 - 7.5913671230335325e-28*x228 - x371*x465 - x379*((x216) ? (
   0
)
: (
   x378*(-6.6938869127600005e-24*x372 - x373*x465 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -2.23356148506155e+46*x375
   ))))
)) - x458);


    jac(15,9) = -7.4738408428884933e+22*x365 + x95*(3.1529807011135066e+19*T*x2*x92*x93*x94*x96 - X(0)*x11*x9 + 5.6556829037999991e-24*X(2)*X(3)*x414*x466*x88*x90 + 1.7591897530800001e-33*X(2)*X(6)*x414*x466 - X(2)*x165 + 7.1777505407999997e-24*X(8)*x414*x466*x86*x87 + 1.4355501081600001e-11*x103*x108*x115*x408*x412*x97 - x116*x435 - 7.5916428846132686e-28*x228 - x367 - x371*x467 - x379*((x216) ? (
   0
)
: (
   x378*(-6.6941300727600005e-24*x372 - x373*x467 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -2.2336426207033358e+46*x375
   ))))
)) + 7.1777505407999997e-24*x414*x466*x83*x85 - x461 - x464 + 7.1777505408000004e-12*x56*x86*x87 - ((x230) ? (
   0
)
: (
   x364 + x380 + x383*((x362) ? (
      x239*x248*x316*x318 - x249*x382
   )
   : (
      0
   ))
)));


    jac(15,10) = -1.1206421616458753e+23*x365 + x95*(-1.1383056277886369e-27*x228 - x371*x468 - x379*((x216) ? (
   0
)
: (
   x378*(-1.0037308196379999e-23*x372 - x373*x468 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -3.3491669777676719e+46*x375
   ))))
)) + 4.7276402893776257e+19*x444 + x456);


    jac(15,11) = -1.1208455699147847e+23*x365 + x95*(4.7284984055187104e+19*T*x2*x92*x93*x94*x96 - 1.1385122421613269e-27*x228 - x371*x469 - x379*((x216) ? (
   0
)
: (
   x378*(-1.003913007276e-23*x372 - x373*x469 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -3.3497748865904447e+46*x375
   ))))
)) - x415 - x458 - ((x201) ? (
   x199
)
: (
   0
)));


    jac(15,12) = -1.4939002390029017e+23*x365 + x95*(6.302299877641746e+19*T*x2*x92*x93*x94*x96 - X(0)*x35 - 8.5199999999999994e-27*X(0)*x5 - 1.5174469671159474e-27*x228 - x371*x470 - x379*((x216) ? (
   0
)
: (
   x378*(-1.3380486320000001e-23*x372 - x373*x470 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -4.4646913348320083e+46*x375
   ))))
)) - x458);


    jac(15,13) = -1.4941036472718107e+23*x365 + x95*(6.3031579937828299e+19*T*x2*x92*x93*x94*x96 - X(0)*x17 - X(0)*x43 - 1.5176535814886368e-27*x228 - x371*x471 - x379*((x216) ? (
   0
)
: (
   x378*(-1.3382308196379999e-23*x372 - x373*x471 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -4.4652992436547811e+46*x375
   ))))
)) - x459 - x472*x65 - x472*x71 - x61 - x73*x75);


    jac(15,14) = -1.4943070555407201e+23*x365 + x95*(6.3040161099239145e+19*T*x2*x92*x93*x94*x96 - 1.5178601958613267e-27*x228 - x367 - x371*x473 - x379*((x216) ? (
   0
)
: (
   x378*(-1.338413007276e-23*x372 - x373*x473 - x377*(x374 + x376*((x207) ? (
      0
   )
   : (
      -4.4659071524775539e+46*x375
   ))))
)) - x75*x77 - ((x230) ? (
   0
)
: (
   x380 + x383*((x362) ? (
      x316*x318*x474 - x382*x474
   )
   : (
      0
   ))
)));


    jac(15,15) = x95*(-3.2067318316078082e-16*std::exp((-1.6499999999999999)*std::log(std::abs(T)))*x477 - 1.10034915790464e-21*std::exp((-0.65000000000000002)*std::log(std::abs(T)))*x477 - X(0)*x14 - 1.0649999999999999e-27*X(0)*x4*x47 + 2.185341195413336e-30*X(1)*x495 + 8.741364781653344e-30*X(11)*x495 + 3.12599925e-16*X(12)*x500*x72 + X(2)*X(3)*x439*x88*(-0.0064764051000000007*std::exp((0.04610000000000003)*std::log(std::abs(T))) - 2.7293978880000002e-10*std::exp((2.0424000000000002)*std::log(std::abs(T))) - 1.229450816e-13*std::exp((2.7740999999999998)*std::log(std::abs(T))))/((x89)*(x89)) + X(3)*x447*(1.3296555000000001e-10*std::exp((-0.90150700000000006)*std::log(std::abs(T))) + 2.466314622e-10*std::exp((-0.44389999999999996)*std::log(std::abs(T))) + 8.1647792100000001e-16*std::exp((1.1825999999999999)*std::log(std::abs(T)))) - x118*(69500.0*x106*x48 - x445*x505) - x118*(x409*x505 + 12307692.307692308*x114*x5*(0.0042250000000000005*x109*x111*x488 - 4.0625000000000001e-8*x112*x38 - 0.00048750000000000003*x488*std::exp(-58000.0*x8))*std::exp(x110)/x109) + 1.5653274417833479e-24*x20*x497*x72 - 0.00090725967999999999*x218*x225*x304*x94 - 1.2700000000000001e-21*x23*x483*x79 + 2.62395452e-11*x366*x478*x59 - 5.5399999999999998e-17*x366*x58*((x16) ? (
   0
)
: (
   -0.39700000000000002*std::exp((-1.397)*std::log(std::abs(T)))
)) - x37*x42*((x16) ? (
   0
)
: (
   -1.5*x488
)) - 1.5499999999999999e-26*x37*((x16) ? (
   0
)
: (
   0.36470000000000002*std::exp((-0.63529999999999998)*std::log(std::abs(T)))
)) - x379*((x216) ? (
   0
)
: (
   -x222*x378*x481*x91*x94
)) + 5.8280000000000003e-8*x40*x41*x479 + x405*x56*x86*(-1.2500000000000001e-32*x38 - 1.875e-33*x496) - x406*(x145*(-2.3025850929940459*x131*(75.773826*x102*x119*x8 - 14.509090000000008*x512 - 13.899501000000001*x515 - 2848700.6345267999*x517 - 331159.79815649998*x516/x133) + 4790.3210533157426*x144*x48 + x388*(x389*x519 + x518*std::log(x141)) + x393*(x394*x519 + x518*std::log(x125)) + 54584.391438988954*x48 - 157.54846734442862*x512 + 198.95454259823751*x513 - 32.004783802655837*x515 - 6559375.6154640894*x517) + x164*(-2.3025850929940459*x153*(70.138370000000009*x101*x8 - 9.4070299999999989*x513 - 0.77462909999999996*x515 - 588180.10479140002*x520 - 160821.97128249999*x516/x154) + 3816.3275589792611*x163*x48 + x397*(x398*x522 + x521*std::log(x160)) + x402*(x403*x522 + x521*std::log(x149)) + 49431.413233526648*x48 + 98.337445626384849*x512 - 9.3363608541157479*x513 - 1.783649418259394*x515 - 1354334.7412883535*x520)) + 0.00084373771595996178*x416*x93 + 7.1777505407999997e-24*x434*x503 + x437*x503 + 7.1777505407999997e-24*x441*x503 + x443*x503 + 3.4968000000000002e-9*x479*std::exp(-564000.0*x24) - x480*x484 - x480*x487 - x484*x485 - x485*x487 + 2.9662164452379397e-24*x486*x491*x501 - x489*x74 - x489*x78 + 2.3717082451262844e-21*x490*x492 + 8.8760999999999989e-14*x490*x493 + 4.0160926284138423e-24*x492*x502 + 2.0041755700000002e-16*x493*x502 - 5.0099999999999997e-27*x494*x63 - 9.1000000000000001e-27*x494*x69 + 1.7519018237332822e-19*x497*x59 + 1.5843011077443579e-29*x498*x64 + 2.8776726707532255e-29*x498*x70 + 2.7724337999999999e-22*x499*x64 + 1.199289e-22*x499*x70 + 2.6764460520000001e-16*x500*x501 + 7.1777505408000004e-12*x56*x83*(-1.0000000000000001e-31*x38 - 1.5e-32*x496) - ((x230) ? (
   0
)
: (
   x383*((x362) ? (
      x299*x318*x530 + x319*x533 + x382*(-x530 - x533)
   )
   : (
      0
   ))
)) - ((x201) ? (
   x200*(50.504556041967454*x101*x506 + 0.011577397847574064*x168*x192*x508 + 0.00057030427583276537*x171*x187*x508 - 0.0046027064199385889*x172*x189*x508 - 46.931151210299063*x179*x506 - 0.0084274614403582089*x181*x506 + 0.27317869543281359*x183*x506 - 1.5965204000783517*x184*x506 - 2.4510327539393719*x185*x506 + 15.190568323798459*x186*x506 - 0.013649724431268705*x190*x510 + 0.12150741535729581*x193*x510 + 0.097629607942947547*x194*x511 - 0.33921683589988288*x196*x507 - 0.076906342106001127*x197*x509 + 2.8710012490505563*x198*x507 + 1.7949111316907187*x421*x506 - 2.4989034980227181*x423*x507 + 0.80896722072159821*x425*x509 - 0.95105974681026062*x428*x511)
)
: (
   0
)))/(X(0)*x475 + X(1)*x475 + X(10)*x476 + X(11)*x475 + X(12)*x475 + X(13)*x475 + X(2)*x475 + X(3)*x475 + X(4)*x475 + X(5)*x475 + X(6)*x476 + X(7)*x475 + X(8)*x476 + X(9)*x476);




}



template<class MatrixType>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
void actual_jac(const burn_t& state, MatrixType& jac)
{
    Real z = redshift;

    Array1D<Real, 0, NumSpec-1> X;
    for (int i = 0; i < NumSpec; ++i) {
        X(i) = state.xn[i];
    }
    // Species Jacobian elements with respect to other species

    jac_nuc(state, jac, X, z);

}


AMREX_INLINE
void actual_rhs_init () {


}


#endif
