#ifndef actual_rhs_H
#define actual_rhs_H

#include <AMReX_REAL.H>
#include <AMReX_Array.H>

#include <extern_parameters.H>
#include <actual_network.H>
#include <burn_type.H>
#include <jacobian_utilities.H>

using namespace amrex;
using namespace ArrayUtil;
using namespace network_rp;
using namespace network;



AMREX_GPU_HOST_DEVICE AMREX_INLINE
void rhs_specie(const burn_t& state,
             Array1D<Real, 1, neqs>& ydot,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const user_crate, Real const /*user_Av*/,
             Real const /*user_ionH*/, Real const /*user_ionH2*/,
             Real const /*user_dissH2*/, Real const /*user_ionC*/,
             Real const /*user_ionO*/, Real const /*user_dissCO*/,
             Real const user_dust2gas_ratio, Real const Tdust,
             Real const z) {


    using namespace Rates;

    Real T = state.T;

    Real x0 = std::max(T, 2.73*z + 2.73);

    Real x1 = ((x0)*(x0));

    Real x2 = 0.002*x0 + 1.0;

    Real x3 = std::sqrt(x0);

    Real x4 = user_dust2gas_ratio*x3;

    Real x5 = x4*(3.3470650363800003e-24*X(10) + 5.0186540981899997e-24*X(11) + 5.01956503638e-24*X(12) + 6.6902431600000005e-24*X(13) + 6.6911540981899994e-24*X(14) + 6.6920650363799998e-24*X(15) + 2.007528417094e-23*X(16) + 2.0076195109127999e-23*X(17) + 2.1749727627315999e-23*X(18) + 2.3423260145503998e-23*X(19) + 9.1093818800000008e-28*X(2) + 2.5096792663692001e-23*X(20) + 2.6767349207315999e-23*X(21) + 2.6768260145504001e-23*X(22) + 2.6770325181879997e-23*X(23) + 2.8440881725504001e-23*X(24) + 2.8441792663692003e-23*X(25) + 3.0114414243691998e-23*X(26) + 3.011532518188e-23*X(27) + 3.178794676188e-23*X(28) + 4.6843544316443998e-23*X(29) + 1.6726215800000001e-24*X(3) + 4.6844455254632e-23*X(30) + 5.3535609352819999e-23*X(31) + 5.3536520291008001e-23*X(32) + 7.3612715400136001e-23*X(33) + 1.6735325181900001e-24*X(4) + 1.6744434563800001e-24*X(5) + 3.3451215800000003e-24*X(6) + 3.3460325181899999e-24*X(7) + 3.3461540981899999e-24*X(8) + 3.3469434563800003e-24*X(9))/(8.0000000000000013e-6*x1 + x2 + 0.040000000000000008*std::sqrt(x0 + 1));

    Real x6 = 1195783.1580871048*x5 + 2.0e-99;

    Real x7 = X(16)*X(32);

    Real x8 = 4.5299999999999999e-10*x7;

    Real x9 = std::sqrt(x0);

    Real x10 = 1.0/x0;

    Real x11 = 1.6974097914175e-15*x9*std::exp(-7550.0*x10) + 1.0e-99;

    Real x12 = X(10)*X(33);

    Real x13 = x11*x12;

    Real x14 = 3.0*user_crate + 1.0e-99;

    Real x15 = 5.0*user_crate + 1.0e-99;

    Real x16 = 7.5e-10*X(29)*X(4);

    Real x17 = 1.0e-99 + 2.8e-11*std::exp(-26500.0*x10);

    Real x18 = X(22)*X(33);

    Real x19 = 1.0e-99 + 4.1999999999999999e-12*std::exp(-24000.0*x10);

    Real x20 = X(30)*X(32);

    Real x21 = x17*x18 - x19*x20;

    Real x22 = 1.0e-13*X(25)*X(30);

    Real x23 = 1.0e-99 + 2.54e-10*std::exp(-13300.0*x10);

    Real x24 = X(33)*X(4);

    Real x25 = -x22 + x23*x24;

    Real x26 = std::pow(x0, -0.34000000000000002);

    Real x27 = ((x0 <= 1052.0) ? (
   3.2682787072746432e-10*x26
)
: (
   0
)) + 1.0e-99;

    Real x28 = X(17)*X(32);

    Real x29 = ((x0 > 1052.0) ? (
   3.7991369449339675e-16*std::pow(x0, 1.54)*std::exp(613.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x30 = x27*x28 + x28*x29;

    Real x31 = x0 <= 10.0;

    Real x32 = ((x31) ? (
   7.0509999999999997e-11
)
: (
   0
)) + 1.0e-99;

    Real x33 = X(17)*X(25);

    Real x34 = x0 > 10.0;

    Real x35 = ((x34) ? (
   1.5557027645121538e-10*std::pow(x0, -0.33900000000000002)*std::exp(-0.108*x10)
)
: (
   0
)) + 1.0e-99;

    Real x36 = 1.0e-99 + 1.02e-10*std::exp(-914.0*x10);

    Real x37 = X(18)*X(22);

    Real x38 = x32*x33 + x33*x35 + x36*x37;

    Real x39 = -X(30)*x14 - X(30)*x15 - X(30)*x6 + x13 + x16 + x21 + x25 + x30 + x38 + x8;

    Real x40 = 1491378.0618531078*x5 + 2.0e-99;

    Real x41 = 970.0*user_crate + 1.0e-99;

    Real x42 = ((X(25))*(X(25)));

    Real x43 = std::pow(x0, 1.1399999999999999)*std::exp(-50.0*x10);

    Real x44 = x42*(2.4749459212614312e-15*x43 + 1.0e-99);

    Real x45 = ((x31) ? (
   4.2020000000000002e-8
)
: (
   0
)) + 1.0e-99;

    Real x46 = X(27)*X(3);

    Real x47 = 1.0/x9;

    Real x48 = ((x34) ? (
   1.2730571616977901e-7*x47 + 1.767e-9
)
: (
   0
)) + 1.0e-99;

    Real x49 = -x45*x46 - x46*x48;

    Real x50 = 3.5999999999999998e-16*std::pow(T, 1.52)*std::exp(-1740.0*x10) + 1.0e-99;

    Real x51 = X(10)*X(25);

    Real x52 = 1.8706148721743872e-6*x47 + 1.0e-99;

    Real x53 = X(2)*X(28);

    Real x54 = 6.3600000000000002e-14*x0*std::exp(-9610.0*x10) + 1.0e-99;

    Real x55 = X(27)*X(4);

    Real x56 = x50*x51 + x52*x53 - x54*x55;

    Real x57 = -X(27)*x40 - X(27)*x41 + x13 + x44 + x49 + x56;

    Real x58 = 1.0/x3;

    Real x59 = 5.7884371785482823e-10*x58*std::pow(0.00060040841663220993*x3 + 1.0, -1.7524)*std::pow(0.32668576019240059*x3 + 1.0, -0.24759999999999999) + 1.0e-99;

    Real x60 = X(13)*X(2);

    Real x61 = -x59*x60;

    Real x62 = 7.1999999999999996e-8*x58 + 1.0e-99;

    Real x63 = X(11)*X(2);

    Real x64 = -x62*x63;

    Real x65 = 9.7355109978586414e-8*std::pow(x0, -0.47999999999999998) + 1.0e-99;

    Real x66 = X(2)*X(24);

    Real x67 = -x65*x66;

    Real x68 = std::pow(x0, -0.75);

    Real x69 = 2.5950363272655348e-10*x68 + 1.0e-99;

    Real x70 = 2*X(2)*X(6);

    Real x71 = -x69*x70;

    Real x72 = std::log(x0);

    Real x73 = 0.10684732509875319*x72 - 1;

    Real x74 = ((x73)*(x73));

    Real x75 = ((x73)*(x73)*(x73));

    Real x76 = ((((x73)*(x73)))*(((x73)*(x73))));

    Real x77 = ((x73)*(x73)*(x73)*(x73)*(x73));

    Real x78 = std::exp((6)*std::log(std::abs(x73)));

    Real x79 = ((x73)*(x73)*(x73)*(x73)*(x73)*(x73)*(x73));

    Real x80 = std::exp((8)*std::log(std::abs(x73)));

    Real x81 = std::pow(x0, 23.915965629999999)*std::exp(-941.91483008144996*x74 + 2506.9866529060901*x75 - 4361.9927099007555*x76 + 4879.7345146260486*x77 - 3366.4639698826941*x78 + 1300.3028484326148*x79 - 214.82451513312137*x80);

    Real x82 = 4.3524079114767552e-117*x81 + 1.0e-99;

    Real x83 = X(15)*X(2);

    Real x84 = -x82*x83;

    Real x85 = std::pow(x0, 2.360852208681)*std::exp(-24.766609674457612*x74 + 13.307984239358756*x75 - 258.18559308467116*x76 + 846.15238706523724*x77 - 1113.0879095147111*x78 + 671.95094388835207*x79 - 154.90262957142161*x80);

    Real x86 = 3.7903999274394518e-18*x85 + 1.0e-99;

    Real x87 = X(2)*X(5);

    Real x88 = -x86*x87;

    Real x89 = 1.3300135414628029e-18*std::pow(x0, 0.94999999999999996)*std::exp(-0.00010729613733905579*x0) + 1.0e-99;

    Real x90 = X(2)*X(7);

    Real x91 = -x89*x90;

    Real x92 = std::pow(x0, 0.25);

    Real x93 = 1.0/x92;

    Real x94 = 130666.72639118577*x10;

    Real x95 = x93*std::exp(-x94)/(x94 + 0.193);

    Real x96 = 1.3023623244766063e-6*x95 + 1.0e-99;

    Real x97 = X(17)*X(2);

    Real x98 = -x96*x97;

    Real x99 = 157821.26811013557*x10;

    Real x100 = x26*std::exp(-x99)/(x99 + 0.072999999999999995);

    Real x101 = 2.1012161411986507e-6*x100 + 1.0e-99;

    Real x102 = X(2)*X(22);

    Real x103 = -x101*x102;

    Real x104 = 0.93000000000000005*user_crate + 1.0e-99;

    Real x105 = X(10)*x104;

    Real x106 = std::pow(x0, 0.34999999999999998)*std::exp(-102000.0*x10);

    Real x107 = 4.3799999999999999e-10*x106 + 1.0e-99;

    Real x108 = X(10)*X(2);

    Real x109 = std::pow(x0, 43.933476326349997)*std::exp(-1618.789587733125*x74 + 3854.4033653120221*x75 - 5902.1601240760483*x76 + 5825.9326359379538*x77 - 3578.1439181805955*x78 + 1242.7294446825149*x79 - 186.35635455381879*x80);

    Real x110 = X(14)*X(2);

    Real x111 = std::pow(x0, 13.536555999999999)*std::exp(-502.72883252679094*x74 + 1281.477767828706*x75 - 2207.4643501257692*x76 + 2500.8077583366976*x77 - 1768.8867461266502*x78 + 704.19926629500367*x79 - 120.0438480494693*x80);

    Real x112 = X(2)*X(4);

    Real x113 = ((x0 <= 1160.0) ? (
   1.4643482606109061e-16*std::pow(x0, 1.78186)
)
: (
   0
));

    Real x114 = x113 + 1.0e-99;

    Real x115 = X(4)*X(5);

    Real x116 = ((x73)*(x73)*(x73)*(x73)*(x73)*(x73)*(x73)*(x73)*(x73));

    Real x117 = ((x0 > 1160.0) ? (
   3.3178155742407601e-14*std::pow(x0, 1.139449335841631)*std::exp(-44.454280878123605*x116 - 12.447178055372776*x74 + 6.9391784778399117*x75 - 10.993097527150175*x76 + 14.449862906216714*x77 + 58.228375789703179*x78 - 162.59852239006702*x79 + 144.55426734953477*x80)
)
: (
   0
));

    Real x118 = x117 + 1.0e-99;

    Real x119 = 4.4686910835277033e-6*x47 + 1.0e-99;

    Real x120 = -x119*x53 - x52*x53;

    Real x121 = 117.0*user_crate + 1.0e-99;

    Real x122 = std::pow(x0, -0.69999999999999996);

    Real x123 = X(2)*X(31);

    Real x124 = X(32)*x121 + x123*(-1.0568649366703787e-5*x122 - 1.0e-99);

    Real x125 = 1.4895636945092344e-6*x47 + 1.0e-99;

    Real x126 = X(2)*X(26);

    Real x127 = 6.7549981495186206e-7*x47 + 1.0e-99;

    Real x128 = -x125*x126 - x126*x127;

    Real x129 = x0 <= 10000.0;

    Real x130 = ((x129) ? (
   -5.5279999999999998e-28*((x0)*(x0)*(x0)*(x0)*(x0)) + 3.3467999999999999e-23*((((x0)*(x0)))*(((x0)*(x0)))) - 7.5474000000000004e-19*((x0)*(x0)*(x0)) - 2.3088e-11*x0 + 7.3427999999999993e-15*x1 + 4.2277999999999996e-8
)
: (
   0
));

    Real x131 = X(2)*X(8);

    Real x132 = 1.0e-8*std::pow(x0, -0.40000000000000002) + 1.0e-99;

    Real x133 = X(3)*X(5);

    Real x134 = x131*(-x130 - 1.0e-99) + x132*x133;

    Real x135 = 2.7999999999999998*user_crate + 1.0e-99;

    Real x136 = ((x0 <= 400.0) ? (
   1.2999999999999999e-10*std::pow(x0, -0.64000000000000001)
)
: (
   0
)) + 1.0e-99;

    Real x137 = X(2)*X(21);

    Real x138 = std::pow(x0, -1.5);

    Real x139 = ((x0 > 400.0) ? (
   1.41e-10*std::pow(x0, -0.66000000000000003) + 0.00073999999999999999*x138*(1.0 + 0.062*std::exp(-145000.0*x10))*std::exp(-175000.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x140 = X(22)*x135 - x136*x137 - x137*x139;

    Real x141 = 2.6534040307116387e-9*std::pow(x0, -0.10000000000000001) + 1.0e-99;

    Real x142 = X(4)*X(9);

    Real x143 = X(5)*X(7);

    Real x144 = x141*x142 + x141*x143;

    Real x145 = 0.5*user_crate + 1.0e-99;

    Real x146 = 1.4981088130721367e-10*std::pow(x0, -0.63529999999999998);

    Real x147 = x0 > 2.73;

    Real x148 = ((x147 && x0 <= 9280.0) ? (
   x146
)
: (
   0
)) + 1.0e-99;

    Real x149 = x0 <= 100000000.0;

    Real x150 = ((x149 && x0 > 9280.0) ? (
   1250086.112245841*x138*(1.5400000000000001e-9 + 4.6200000000000001e-10*std::exp(-93988.701501924661*x10))*std::exp(-469943.50750964211*x10) + x146
)
: (
   0
)) + 1.0e-99;

    Real x151 = 3.8571873359681448e-209*x109 + 1.0e-99;

    Real x152 = X(15)*x145 - x110*x148 - x110*x150 - x110*x151;

    Real x153 = 6.3350403285625223e-6*std::pow(x0, -0.55000000000000004) + 1.0e-99;

    Real x154 = X(2)*X(29);

    Real x155 = X(30)*x14 - x153*x154;

    Real x156 = 1020.0*user_crate + 1.0e-99;

    Real x157 = ((x0 <= 7950.0) ? (
   1.4308352583277889e-10*std::pow(x0, -0.59999999999999998)
)
: (
   0
)) + 1.0e-99;

    Real x158 = X(16)*X(2);

    Real x159 = ((x0 > 21140.0) ? (
   0.00023813936486848612*std::pow(x0, -1.3700000000000001)*std::exp(-115786.2*x10)
)
: (
   0
)) + 1.0e-99;

    Real x160 = ((x0 <= 21140.0 && x0 > 7950.0) ? (
   8.3535906003219973e-24*std::pow(x0, 2.4900000000000002)*std::exp(21845.599999999999*x10)
)
: (
   0
)) + 1.0e-99;

    Real x161 = X(17)*x156 - x157*x158 - x158*x159 - x158*x160;

    Real x162 = 0.46000000000000002*user_crate + 1.0e-99;

    Real x163 = ((x147 && x0 <= 5500.0) ? (
   x146
)
: (
   0
)) + 1.0e-99;

    Real x164 = X(2)*X(3);

    Real x165 = ((x149 && x0 > 5500.0) ? (
   3.2867337024382733e-10*std::pow(x0, -0.7241125657826851)*std::exp(-1.6921001126637108*x116 - 1.7746868094247411*x74 - 1.9518356165136789*x75 - 2.4649195146505537*x76 - 1.0207737270119371*x77 + 3.3530579587656565*x78 + 3.6203127646377788*x79 - 1.0930705283186734*x80)
)
: (
   0
)) + 1.0e-99;

    Real x166 = X(4)*x162 - x163*x164 - x164*x165;

    Real x167 = 35.5*std::pow(x0, -2.2799999999999998)*std::exp(-46707.0*x10) + 1.0e-99;

    Real x168 = (1.3500000000000001e-9*std::pow(x0, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(x0, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(x0, 2.1825999999999999))/(0.0061910000000000003*std::pow(x0, 1.0461) + 8.9711999999999997e-11*std::pow(x0, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(x0, 3.7740999999999998) + 1.0) + 1.0e-99;

    Real x169 = -x107*x108 - x108*x167 + x115*x168;

    Real x170 = 5.9082438637265071e-70*x111 + 1.0e-99;

    Real x171 = 1.4000000000000001e-18*std::pow(x0, 0.92800000000000005)*std::exp(-6.1728395061728397e-5*x0) + 1.0e-99;

    Real x172 = -x112*x170 - x112*x171;

    Real x173 = 7.9674337148168363e-7*x47 + 1.0e-99;

    Real x174 = X(3)*X(9);

    Real x175 = -x173*x174;

    Real x176 = 2.0000000000000001e-9*X(3)*X(32);

    Real x177 = -x176;

    Real x178 = 2.8833736969617052e-16*x92 + 1.0e-99;

    Real x179 = X(14)*X(4);

    Real x180 = ((x0 > 10000.0) ? (
   4.0000000000000003e-37*std::pow(x0, 4.7400000000000002)
)
: (
   0
)) + 1.0e-99;

    Real x181 = X(15)*X(3);

    Real x182 = ((x129) ? (
   1.26e-9*x68*std::exp(-127500.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x183 = x178*x179 - x180*x181 - x181*x182;

    Real x184 = 6.3999999999999996e-10*X(11)*X(4);

    Real x185 = M_LN10;

    Real x186 = 1.0/x185;

    Real x187 = x186*x72;

    Real x188 = ((x72)*(x72));

    Real x189 = std::exp((-2)*std::log(std::abs(x185)));

    Real x190 = x188*x189;

    Real x191 = 8.4600000000000008e-10*x187 - 1.3700000000000002e-10*x190 + 4.1700000000000001e-10;

    Real x192 = X(10)*X(6);

    Real x193 = 1.0e-99 + 1.0000000000000001e-9*std::exp(-457.0*x10);

    Real x194 = X(12)*X(3);

    Real x195 = x184 + x191*x192 - x193*x194;

    Real x196 = 0.00029999999999999997*user_crate + 1.0e-99;

    Real x197 = ((x34 && x0 <= 100000.0) ? (
   -7.7700000000000002e-13*x0 + 2.5000000000000002e-10*x3 + 2.96e-6*x58 - 1.73e-9
)
: (
   0
));

    Real x198 = X(10)*x196 - x132*x133 + x133*(-x197 - 1.0e-99);

    Real x199 = std::pow(10.0, -0.12690000000000001*amrex::Math::powi<-3>(x185)*((x72)*(x72)*(x72)) + 1.1180000000000001*amrex::Math::powi<-2>(x185)*((x72)*(x72)) - 1.5229999999999999*x187 - 19.379999999999999) + 1.0e-99;

    Real x200 = -x199;

    Real x201 = X(3)*X(7);

    Real x202 = x0 > 50.0;

    Real x203 = ((x202) ? (
   2.0000000000000001e-10*std::pow(x0, 0.40200000000000002)*std::exp(-37.100000000000001*x10) - 3.3099999999999998e-17*std::pow(x0, 1.48)
)
: (
   0
)) + 1.0e-99;

    Real x204 = ((x202) ? (
   2.0299999999999998e-9*std::pow(x0, -0.33200000000000002) + 2.0600000000000001e-10*std::pow(x0, 0.39600000000000002)*std::exp(-33.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x205 = X(4)*X(6);

    Real x206 = x200*x201 - x201*x203 + x204*x205;

    Real x207 = 8.7882738061352424e-22*std::pow(x0, 1.96)*std::exp(-170000.0*x10) + 1.0e-99;

    Real x208 = X(16)*X(4);

    Real x209 = 3.8999999999999998e-16*std::pow(x0, 0.21299999999999999) + 1.0e-99;

    Real x210 = X(17)*X(3);

    Real x211 = x207*x208 - x209*x210;

    Real x212 = ((x31) ? (
   3.7450000000000001e-8
)
: (
   0
)) + 1.0e-99;

    Real x213 = X(25)*X(3);

    Real x214 = ((x34) ? (
   1.1352943524561152e-7*x47 + 1.55e-9
)
: (
   0
)) + 1.0e-99;

    Real x215 = -x212*x213 - x213*x214;

    Real x216 = 7.5399999999999998e-10*std::pow(x0, -0.45800000000000002) + 4.9899999999999997e-11*std::pow(x0, 0.40500000000000003) + 1.0e-99;

    Real x217 = X(21)*X(4);

    Real x218 = (4.0000000000000001e-10*std::pow(x0, 0.0066899999999999998) + 1.0799999999999999e-11*std::pow(x0, 0.51700000000000002))*std::exp(-227.0*x10) + 1.0e-99;

    Real x219 = X(22)*X(3);

    Real x220 = x216*x217 - x218*x219;

    Real x221 = 6.0e-10*X(4)*X(8);

    Real x222 = ((x72)*(x72)*(x72));

    Real x223 = ((((x72)*(x72)))*(((x72)*(x72))));

    Real x224 = ((x72)*(x72)*(x72)*(x72)*(x72));

    Real x225 = ((x0 <= 30000.0 && x0 > 100.0) ? (
   (-1.4491368e-7*x188 + 3.4172804999999998e-8*x222 - 4.7813727999999997e-9*x223 + 3.9731542e-10*x224 + 3.5311931999999998e-13*((x72)*(x72)*(x72)*(x72)*(x72)*(x72)*(x72)) - 1.8171411000000001e-11*std::exp((6)*std::log(std::abs(x72))) + 3.3735381999999997e-7*x72 - 3.3232183000000002e-7)*std::exp(-21237.150000000001*x10)
)
: (
   0
)) + 1.0e-99;

    Real x226 = X(10)*X(3);

    Real x227 = x221 - x225*x226;

    Real x228 = x222/((x185)*(x185)*(x185));

    Real x229 = ((x0 > 30.0) ? (
   std::pow(10, -3.194*x187 + 1.786*x188*x189 - 0.2072*x228 - 18.199999999999999)
)
: (
   0
)) + 1.0e-99;

    Real x230 = X(3)*X(4);

    Real x231 = std::pow(x0, -0.14999999999999999);

    Real x232 = ((x0 <= 30.0) ? (
   3.4977396723747635e-20*x231
)
: (
   0
)) + 1.0e-99;

    Real x233 = -x229*x230 - x230*x232;

    Real x234 = 6.3999999999999996e-10*X(10)*X(26);

    Real x235 = -x184;

    Real x236 = ((X(10))*(X(10)));

    Real x237 = std::log(T);

    Real x238 = 2.0*X(1) + 2.0*X(10) + X(11) + X(12) + X(18) + 2.0*X(19) + 3.0*X(20) + 4.0*X(23) + X(24) + X(25) + 2.0*X(26) + 3.0*X(28) + X(3) + X(4) + X(5) + 2.0*X(8);

    Real x239 = 1.0/(std::pow(10.0, 1.3*x186*(x237 - 9.2103403719761836) - 137.42519902360013*x189*((0.10857362047581294*x237 - 1)*(0.10857362047581294*x237 - 1)) - 4.8449999999999998)*x238 + 1.0);

    Real x240 = std::pow(1.1800000000000001e-10*std::exp(-69500.0*x10), x239)*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0*x10))*std::exp(-52000.0*x10), 1.0 - x239);

    Real x241 = 2*x240 + 2.0e-99;

    Real x242 = ((X(4))*(X(4))*(X(4)));

    Real x243 = 0.25820969999999999*x228;

    Real x244 = std::log(27535.310000000001*x10 + 1.0);

    Real x245 = 743.05999999999995*x10 - 2.4640089999999999*x186*x72 + 0.19859550000000001*x190;

    Real x246 = std::exp(-0.0022727272727272726*x0);

    Real x247 = std::exp(-0.00054054054054054055*x0);

    Real x248 = 2.9375070000000001*x246 + 0.23588480000000001*x247 + 0.75022860000000002;

    Real x249 = std::pow(10.0, -21467.790000000001*x10 - 1657.4099999999999*x10/(std::pow(std::pow(10.0, -x245 - 8.1313220000000008)*x238, x248) + 1.0) + 21.360939999999999*x186*x244 + 42.707410000000003*x186*x72 - 2.0273650000000001*x190 - x243 - 142.7664 - (21.360939999999999*x186*x244 + 11.28215*x186*std::log(14254.549999999999*x10 + 1.0) + 70.138370000000009*x187 - 4.7035149999999994*x190 - x243 - 203.11568)/(std::pow(std::pow(10.0, -x245 - 9.3055640000000004)*x238, x248) + 1.0));

    Real x250 = 4.6331670000000003*x228;

    Real x251 = std::log(40870.379999999997*x10 + 1.0);

    Real x252 = -133.82830000000001*x10 - 4.8909149999999997*x186*x72 + 0.47490300000000002*x190;

    Real x253 = -2.0563129999999998*x246 + 0.58640729999999996*x247 + 0.82274429999999998;

    Real x254 = std::pow(10.0, -23705.700000000001*x10 - 2080.4099999999999*x10/(std::pow(std::pow(10.0, -x252 - 13.656822)*x238, x253) + 1.0) + 69.700860000000006*x186*x251 - 68.422430000000006*x187 + 43.20243*x188*x189 - x250 - 178.4239 - (69.700860000000006*x186*x251 + 19.734269999999999*x186*std::log(16780.950000000001*x10 + 1.0) - 14.509090000000008*x187 + 37.886913*x190 - x250 - 307.31920000000002)/(std::pow(std::pow(10.0, -x252 - 14.82123)*x238, x253) + 1.0));

    Real x255 = X(10)*X(4);

    Real x256 = 5.0000000000000004e-32*x47 + 1.5e-32*x93 + 2.0e-99;

    Real x257 = X(10)*((X(4))*(X(4)));

    Real x258 = X(4)*x238*x4/((1.0 + 10000.0*std::exp(-600.0/(Tdust + 9.9999999999999993e-41)))*(7.9999999999999996e-6*x1 + x2 + 0.040000000000000001*std::sqrt(Tdust + x0)));

    Real x259 = 1.1194685000500219e-20*std::pow(x0, 2.7400000000000002)*std::exp(-4740.0*x10) + 1.0e-99;

    Real x260 = X(10)*X(20);

    Real x261 = 2.1555555555555562e-20*((x0)*(x0)*(x0))*std::exp(-4045.0*x10) + 1.0e-99;

    Real x262 = X(23)*X(4);

    Real x263 = x259*x260 - x261*x262;

    Real x264 = 1.9643512449766835e-11*std::pow(x0, 0.17000000000000001)*std::exp(-6400.0*x10) + 1.0e-99;

    Real x265 = X(10)*X(19);

    Real x266 = 1.0e-99 + 1.0e-10*std::exp(-7600.0*x10);

    Real x267 = X(20)*X(4);

    Real x268 = x264*x265 - x266*x267;

    Real x269 = 2.1999999999999999e-10*X(19)*X(4);

    Real x270 = 1.0e-99 + 5.4599999999999998e-10*std::exp(-1943.0*x10);

    Real x271 = X(10)*X(18);

    Real x272 = -x269 + x270*x271;

    Real x273 = 1.69e-9*X(10)*X(21);

    Real x274 = x212*x213 + x213*x214 + x273;

    Real x275 = x22 - x23*x24;

    Real x276 = 6.1739095063118665e-10*std::pow(x0, 0.40999999999999998) + 1.0e-99;

    Real x277 = -x276;

    Real x278 = -x141;

    Real x279 = x142*x277 + x142*x278 + x143*x276;

    Real x280 = 1.01e-9*X(10)*X(24);

    Real x281 = x280 + x45*x46 + x46*x48;

    Real x282 = x200*x205 + x201*x203 - x204*x205;

    Real x283 = 1.0e-99 + 6.6399999999999998e-10*std::exp(-11700.0*x10);

    Real x284 = X(10)*X(17);

    Real x285 = 1.0e-99 + 1.3100000000000001e-10*std::exp(-80.0*x10);

    Real x286 = X(18)*X(4);

    Real x287 = x283*x284 - x285*x286;

    Real x288 = x105 - x221 + x225*x226;

    Real x289 = -x216*x217 + x218*x219;

    Real x290 = ((x0 <= 1167.4796423742259) ? (
   std::pow(10, 5.8888600000000002*x187 + 7.1969200000000004*x190 + 2.2506900000000001*x228 - 56.473700000000001 - 2.1690299999999998*x223/((((x185)*(x185)))*(((x185)*(x185)))) + 0.31788699999999998*x224/((x185)*(x185)*(x185)*(x185)*(x185)))
)
: (
   0
)) + 1.0e-99;

    Real x291 = X(10)*X(7);

    Real x292 = ((x0 > 1167.4796423742259) ? (
   3.1699999999999999e-10*std::exp(-5207.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x293 = ((x0 > 200.0) ? (
   5.25e-11*std::exp(-4430.0*x10 + 173900.0/x1)
)
: (
   0
)) + 1.0e-99;

    Real x294 = X(12)*X(4);

    Real x295 = x290*x291 + x291*x292 - x293*x294;

    Real x296 = -x178*x179 + x180*x181 + x181*x182;

    Real x297 = ((x31) ? (
   1.371e-8
)
: (
   0
)) + 1.0e-99;

    Real x298 = X(16)*X(25);

    Real x299 = ((x34) ? (
   4.1551773299893819e-8*x47 + 5.673e-10
)
: (
   0
)) + 1.0e-99;

    Real x300 = -x16 + x297*x298 + x298*x299;

    Real x301 = x108*x167 - x114*x115 - x115*x118 - x115*x168;

    Real x302 = -x207*x208 + x209*x210;

    Real x303 = ((x0 <= 150.0) ? (
   4.9970000000000003e-11
)
: (
   0
)) + 1.0e-99;

    Real x304 = X(22)*X(25);

    Real x305 = ((x0 > 150.0) ? (
   2.4000000000000001e-11*std::exp(110.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x306 = 1.0e-99 + 3.1319999999999996e-10*std::exp(-8156.0*x10);

    Real x307 = X(32)*X(4);

    Real x308 = x303*x304 + x304*x305 - x306*x307;

    Real x309 = 1.0e-25*X(4)*X(7);

    Real x310 = x173*x174 - x309 + x62*x63;

    Real x311 = 730.0*user_crate + 1.0e-99;

    Real x312 = 1.0000000000000001e-17*X(17);

    Real x313 = X(4)*x312;

    Real x314 = X(18)*x311 - x313;

    Real x315 = 1.0e-99 + 1.46e-12*std::exp(-9650.0*x10);

    Real x316 = X(10)*X(22);

    Real x317 = ((x0 > 280.0) ? (
   5.4499999999999998e-17
)
: (
   0
)) + 1.0e-99;

    Real x318 = X(25)*X(4);

    Real x319 = ((x0 <= 280.0) ? (
   8.1009819130659227e-21*std::pow(x0, 2.7999999999999998)*std::exp(-1950.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x320 = X(27)*x41 + x125*x126 + x315*x316 - x317*x318 - x318*x319;

    Real x321 = 510.0*user_crate + 1.0e-99;

    Real x322 = 8.648509591313017e-18*std::pow(x0, -0.38) + 1.0e-99;

    Real x323 = X(22)*X(4);

    Real x324 = X(25)*x321 - x322*x323 + x65*x66;

    Real x325 = 4.9999999999999996e-6*x58 + 1.0e-99;

    Real x326 = X(5)*X(8);

    Real x327 = x242*(2.0000000000000002e-31*x47 + 6.0000000000000001e-32*x93 + 1.0e-99) + x255*(-x249 - x254 - 3.0000000000000001e-99) + x325*x326;

    Real x328 = -x325*x326;

    Real x329 = x142*x276 + x143*x277 + x143*x278;

    Real x330 = X(6)*X(9);

    Real x331 = x330*(-9.8726896031426014e-7*x47 - 1.0e-99);

    Real x332 = -x191*x192 + x193*x194;

    Real x333 = -x290*x291 - x291*x292 + x293*x294;

    Real x334 = -x280;

    Real x335 = -x11*x12;

    Real x336 = -x234;

    Real x337 = -x273;

    Real x338 = -x259*x260 + x261*x262;

    Real x339 = -x264*x265 + x266*x267;

    Real x340 = x269 - x270*x271;

    Real x341 = X(10)*x312;

    Real x342 = -x283*x284 + x285*x286 - x341;

    Real x343 = -x50*x51 + x54*x55;

    Real x344 = x126*x127 - x315*x316 + x317*x318 + x318*x319;

    Real x345 = X(17)*X(31);

    Real x346 = 5.2000000000000001e-11*x345;

    Real x347 = x346 - 7.9500000000000005e-10*x7;

    Real x348 = -x297*x298 - x298*x299;

    Real x349 = ((x0 <= 300.0) ? (
   2.5000000000000002e-18
)
: (
   0
)) + 1.0e-99;

    Real x350 = X(16)*X(22);

    Real x351 = ((x0 > 300.0) ? (
   7.3875058242066447e-18*x231*std::exp(-68.0*x10)
)
: (
   0
)) + 1.0e-99;

    Real x352 = -x349*x350 - x350*x351;

    Real x353 = -1.04e-10*x345;

    Real x354 = -x27*x28 - x28*x29;

    Real x355 = -x32*x33 - x33*x35;

    Real x356 = X(30)*x15 + x153*x154;

    Real x357 = -x36*x37;

    Real x358 = ((X(22))*(X(22)));

    Real x359 = std::pow(x0, 1.5800000000000001);

    Real x360 = -x17*x18 + x19*x20;

    Real x361 = x346 + 3.4200000000000001e-10*x7;

    Real x362 = -x303*x304 - x304*x305 + x306*x307;

    ydot(1) = X(30)*x6 + x39;

    ydot(2) = X(27)*x40 + x57;

    ydot(3) = x102*(4.2024322823973014e-6*x100 + 2.0e-99) + x103 + 2*x105 + x107*x108 + x110*(7.7143746719362896e-209*x109 + 2.0e-99) + x112*(1.1816487727453014e-69*x111 + 2.0e-99) + x114*x115 + x115*x118 + x120 + x124 + x128 + x134 + x140 + x144 + x152 + x155 + x161 + x166 + x169 + x172 + x61 + x64 + x67 + x71 + x83*(8.7048158229535104e-117*x81 + 2.0e-99) + x84 + x87*(7.5807998548789035e-18*x85 + 2.0e-99) + x88 + x91 + x97*(2.6047246489532126e-6*x95 + 2.0e-99) + x98;

    ydot(4) = x105 + x112*x170 + x16 + x166 + x175 + x177 + x183 + x195 + x198 + x206 + x211 + x215 + x220 + x227 + x233 + x49;

    ydot(5) = X(10)*(0.20000000000000001*user_crate + 2.0e-99) - X(4)*x162 + x108*(8.7599999999999997e-10*x106 + 2.0e-99) + x115*(2*x113 + 2.0e-99) + x115*(2*x117 + 2.0e-99) + x131*(2*x130 + 2.0e-99) + x133*(2*x197 + 2.0e-99) + x163*x164 + x164*x165 + x172 + x176 + x233 + x234 + x235 + x236*x241 + x242*(-6.0000000000000005e-31*x47 - 1.8e-31*x93 - 3.0000000000000001e-99) + x255*(3*x249 + 3*x254 + 9.0000000000000006e-99) - x256*x257 - 5.9999999999999997e-18*x258 + x263 + x268 + x272 + x274 + x275 + x279 + x281 + x282 + x287 + x288 + x289 + x295 + x296 + x300 + x301 + x302 + x308 + x310 + x314 + x320 + x324 + x327 + x38 + x53*(8.9373821670554065e-6*x47 + 2.0e-99) + x56 + x86*x87;

    ydot(6) = x112*x171 + x198 + x301 + x328 + x329 + x88;

    ydot(7) = x282 + x331 + x332 + x71;

    ydot(8) = x206 + x310 + x329 + x330*(1.9745379206285203e-6*x47 + 2.0e-99) + x333 + x69*x70 + x91;

    ydot(9) = x134 + x229*x230 + x230*x232 + x288 + x328;

    ydot(10) = x175 + x279 + x331 + x89*x90;

    ydot(11) = -2*X(10)*x104 - X(10)*x196 + X(10)*(-0.10000000000000001*user_crate - 1.0e-99) + x169 + x227 - x236*x241 + x236*(x240 + 1.0e-99) + x256*x257 + x257*(-2.5000000000000002e-32*x47 - 7.5000000000000001e-33*x93 - 1.0e-99) + 2.9999999999999998e-18*x258 + x327 + x332 + x333 + x334 + x335 + x336 + x337 + x338 + x339 + x340 + x342 + x343 + x344;

    ydot(12) = x199*x201 + x199*x205 + x235 + x64;

    ydot(13) = x144 + x195 + x295 + x309;

    ydot(14) = x110*x151 + x61;

    ydot(15) = x152 + x296 + x59*x60 + x82*x83;

    ydot(16) = -X(15)*x145 + x110*x148 + x110*x150 + x183 + x84;

    ydot(17) = x161 + x302 + x347 + x348 + x352 + x96*x97;

    ydot(18) = -X(17)*x156 + x157*x158 + x158*x159 + x158*x160 + x211 + x314 + x342 + x353 + x354 + x355 + x356 + x98;

    ydot(19) = -X(18)*x311 + x287 + x313 + x340 + x357;

    ydot(20) = x272 + x339 + x341;

    ydot(21) = x268 + x338;

    ydot(22) = x101*x102 + x140 + x289 + x337 + x8;

    ydot(23) = -X(22)*x135 + X(32)*(1500.0*user_crate + 2.0e-99) + x103 + x123*(2.1137298733407573e-5*x122 + 2.0e-99) + x136*x137 + x137*x139 + x220 + x30 + x324 + x344 + x352 + x356 + x357 + x358*(-1.1950181274729681e-23*x359 - 2.0e-99) + x360 + x361 + x362 + x44;

    ydot(24) = x263;

    ydot(25) = x274 + x334 + x67;

    ydot(26) = -X(25)*x321 + x119*x53 + x215 + x25 + x320 + x322*x323 + x343 + x348 + x355 + x362 + x42*(-4.9498918425228625e-15*x43 - 2.0e-99);

    ydot(27) = x128 + x281 + x336;

    ydot(28) = 2.0e-99*X(1) + x57;

    ydot(29) = x120 + x234;

    ydot(30) = x155 + x300 + x349*x350 + x350*x351 + x361;

    ydot(31) = 2.0e-99*X(0) + x39;

    ydot(32) = x124 + x176 + x353;

    ydot(33) = -X(32)*x121 + X(32)*(-750.0*user_crate - 1.0e-99) + x177 + x21 + x308 + x347 + x354 + x358*(5.9750906373648406e-24*x359 + 1.0e-99);

    ydot(34) = x275 + x335 + x360;



}


AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real rhs_eint(const burn_t& state,
             const Array1D<Real, 0, NumSpec-1>& X,
             Real const user_crate, Real const /*user_Av*/,
             Real const /*user_ionH*/, Real const /*user_ionH2*/,
             Real const /*user_dissH2*/, Real const /*user_ionC*/,
             Real const /*user_ionO*/, Real const /*user_dissCO*/,
             Real const user_dust2gas_ratio, Real const Tdust,
             Real const dustSemenov_cooling, Real const z, Real const Z) {

    using namespace Rates;

    Real T = state.T;
        Real x0 = 3.3470650363800003e-24*X(10) + 5.0186540981899997e-24*X(11) + 5.01956503638e-24*X(12) + 6.6902431600000005e-24*X(13) + 6.6911540981899994e-24*X(14) + 6.6920650363799998e-24*X(15) + 2.007528417094e-23*X(16) + 2.0076195109127999e-23*X(17) + 2.1749727627315999e-23*X(18) + 2.3423260145503998e-23*X(19) + 9.1093818800000008e-28*X(2) + 2.5096792663692001e-23*X(20) + 2.6767349207315999e-23*X(21) + 2.6768260145504001e-23*X(22) + 2.6770325181879997e-23*X(23) + 2.8440881725504001e-23*X(24) + 2.8441792663692003e-23*X(25) + 3.0114414243691998e-23*X(26) + 3.011532518188e-23*X(27) + 3.178794676188e-23*X(28) + 4.6843544316443998e-23*X(29) + 1.6726215800000001e-24*X(3) + 4.6844455254632e-23*X(30) + 5.3535609352819999e-23*X(31) + 5.3536520291008001e-23*X(32) + 7.3612715400136001e-23*X(33) + 1.6735325181900001e-24*X(4) + 1.6744434563800001e-24*X(5) + 3.3451215800000003e-24*X(6) + 3.3460325181899999e-24*X(7) + 3.3461540981899999e-24*X(8) + 3.3469434563800003e-24*X(9);

    Real x1 = 1.0/x0;

    Real x2 = 3.2043529200000002e-11*X(10);

    Real x3 = 0.93000000000000005*user_crate + 1.0e-99;

    Real x4 = 3.2043529200000002e-11*X(30);

    Real x5 = 3.2043529200000002e-11*X(32);

    Real x6 = X(14) + X(3) + X(6);

    Real x7 = 2.73*z + 2.73;

    Real x8 = std::max(T, x7);

    Real x9 = std::sqrt(x8);

    Real x10 = 1.0/x8;

    Real x11 = 7.1777505408000004e-12*X(10);

    Real x12 = T <= 10 && x7 <= 10;

    Real x13 = T >= x7;

    Real x14 = z + 1;

    Real x15 = X(14)*X(2);

    Real x16 = ((x12) ? (
   1.0/10.0
)
: ((x13) ? (
   1.0/T
)
: (
   1.0/x7
)));

    Real x17 = std::sqrt(T);

    Real x18 = std::sqrt(x14);

    Real x19 = 1.6522711641858305*x18;

    Real x20 = ((x12) ? (
   std::sqrt(10)
)
: ((x13) ? (
   x17
)
: (
   x19
)));

    Real x21 = 1.0/(0.0031622776601683794*x20 + 1.0);

    Real x22 = X(2)*x21;

    Real x23 = X(4)*x22;

    Real x24 = M_LN10;

    Real x25 = 1.0/x24;

    Real x26 = std::log(std::max(9.9999999999999993e-41, X(10)));

    Real x27 = x25*x26;

    Real x28 = std::exp((-4)*std::log(std::abs(x24)));

    Real x29 = amrex::Math::powi<-3>(x24);

    Real x30 = std::exp((-2)*std::log(std::abs(x24)));

    Real x31 = X(2)*x20*((x12) ? (
   0.63095734448019325
)
: ((x13) ? (
   std::pow(T, -0.20000000000000001)
)
: (
   0.81802668403695478*std::pow(x14, -0.20000000000000001)
)))/(6.3095734448019361e-5*((x12) ? (
   5.011872336272722
)
: ((x13) ? (
   std::pow(T, 0.69999999999999996)
)
: (
   2.0198255098866533*std::pow(x14, 0.69999999999999996)
))) + 1.0);

    Real x32 = x15*x21;

    Real x33 = X(14)*((X(2))*(X(2)))*x21*((x12) ? (
   0.67810976749343443
)
: ((x13) ? (
   std::pow(T, -0.16869999999999999)
)
: (
   0.8441494880969781*std::pow(x14, -0.16869999999999999)
)));

    Real x34 = 1.0/x9;

    Real x35 = X(11) + X(12) + X(18) + X(24) + X(25) + X(5);

    Real x36 = 2.0*X(1) + 2.0*X(10) + 2.0*X(19) + 3.0*X(20) + 4.0*X(23) + 2.0*X(26) + 3.0*X(28) + X(3) + X(4) + 2.0*X(8) + x35;

    Real x37 = 1.0/x36;

    Real x38 = ((x8)*(x8));

    Real x39 = 1.0/(1000000.0*x34*x37/(1.3999999999999999*X(10)*x37*std::exp(-12000.0/(x8 + 1200.0)) + 1.6000000000000001*X(4)*x37*std::exp(-160000.0/x38)) + 1.0);

    Real x40 = X(4)*x39;

    Real x41 = std::pow(x8, -0.25);

    Real x42 = 7.1777505408000004e-12*x39;

    Real x43 = std::log(T);

    Real x44 = 1.0/(std::pow(10.0, 1.3*x25*(x43 - 9.2103403719761836) - 137.42519902360013*x30*((0.10857362047581294*x43 - 1)*(0.10857362047581294*x43 - 1)) - 4.8449999999999998)*x36 + 1.0);

    Real x45 = std::pow(1.1800000000000001e-10*std::exp(-69500.0*x10), x44)*std::pow(8.1250000000000003e-8*std::pow(T, -0.5)*(1.0 - std::exp(-6000.0*x10))*std::exp(-52000.0*x10), 1.0 - x44) + 1.0e-99;

    Real x46 = std::sqrt(M_PI);

    Real x47 = std::log(std::min(10000000000.0, std::max(0.01, X(4))));

    Real x48 = ((((x47)*(x47)))*(((x47)*(x47))));

    Real x49 = ((x47)*(x47)*(x47));

    Real x50 = ((x47)*(x47));

    Real x51 = std::log(std::min(10000.0, x8));

    Real x52 = ((((x51)*(x51)))*(((x51)*(x51))));

    Real x53 = ((x51)*(x51)*(x51));

    Real x54 = ((x51)*(x51));

    Real x55 = amrex::Math::powi<-5>(x24);

    Real x56 = std::exp((-8)*std::log(std::abs(x24)));

    Real x57 = amrex::Math::powi<-7>(x24);

    Real x58 = std::exp((-6)*std::log(std::abs(x24)));

    Real x59 = std::log(x8);

    Real x60 = ((x59)*(x59)*(x59));

    Real x61 = x29*x60;

    Real x62 = 0.25820969999999999*x61;

    Real x63 = ((x59)*(x59));

    Real x64 = x30*x63;

    Real x65 = std::log(27535.310000000001*x10 + 1.0);

    Real x66 = 743.05999999999995*x10 - 2.4640089999999999*x25*x59 + 0.19859550000000001*x64;

    Real x67 = std::exp(-0.0022727272727272726*x8);

    Real x68 = std::exp(-0.00054054054054054055*x8);

    Real x69 = 2.9375070000000001*x67 + 0.23588480000000001*x68 + 0.75022860000000002;

    Real x70 = x25*x59;

    Real x71 = 4.6331670000000003*x61;

    Real x72 = std::log(40870.379999999997*x10 + 1.0);

    Real x73 = -133.82830000000001*x10 - 4.8909149999999997*x25*x59 + 0.47490300000000002*x64;

    Real x74 = -2.0563129999999998*x67 + 0.58640729999999996*x68 + 0.82274429999999998;

    Real x75 = x0 >= 0.5;

    Real x76 = 1.0000420000000001*x25;

    Real x77 = x0 >= 9.9999999999999998e-13;

    Real x78 = ((x77) ? (
   std::pow(10.0, x76*std::log(((x75) ? (
      0.5
   )
   : (
      x0
   ))) + 2.1498900000000001)
)
: (
   0.0
));

    Real x79 = X(10) + X(4);

    Real x80 = X(0) + X(1) + X(13) + X(15) + X(16) + X(17) + X(19) + X(2) + X(20) + X(21) + X(22) + X(23) + X(26) + X(27) + X(28) + X(29) + X(30) + X(31) + X(32) + X(33) + X(7) + X(8) + X(9) + x35 + x6 + x79;

    Real x81 = x80 <= 9.9999999999999993e-41;

    Real x82 = x0 <= 9.9999999999999993e-41;

    Real x83 = std::pow(10.0, 2.1498900000000001 - 0.69317629274152892*x25);

    Real x84 = x0*x46;

    Real x85 = x17*x84;

    Real x86 = x83*x85;

    Real x87 = std::pow(10.0, x76*std::log(x0) + 2.1498900000000001);

    Real x88 = x85*x87;

    Real x89 = x18*x84;

    Real x90 = x83*x89;

    Real x91 = x87*x89;

    Real x92 = 0.045468571811084373*X(10) + 0.068176456620437725*X(11) + 0.068188831360114804*X(12) + 0.090884341429791085*X(13) + 0.09089671616946815*X(14) + 0.090909090909145243*X(15) + 0.27271489798762283*X(16) + 0.27272727272727271*X(17) + 0.29546155863278772*X(18) + 0.31819584453830274*X(19) + 1.2374739649915389e-5*X(2) + 0.34093013044381776*X(20) + 0.36362398889671371*X(21) + 0.36363636363636365*X(22) + 0.36366441634933278*X(23) + 0.38635827480222873*X(24) + 0.38637064954187872*X(25) + 0.40909256070774375*X(26) + 0.40910493544739368*X(27) + 0.43182684661325876*X(28) + 0.63635126162398636*X(29) + 0.0227219111658651*X(3) + 0.63636363636363635*X(30) + 0.7272603525330773*X(31) + 0.72727272727272729*X(32) + X(33) + 0.022734285905542186*X(4) + 0.022746660645219272*X(5) + 0.045442170714895543*X(6) + 0.045454545454572622*X(7) + 0.045456197071407287*X(8) + 0.045466920194249714*X(9);

    Real x93 = 1.0/std::fabs(x92);

    Real x94 = std::sqrt(x80);

    Real x95 = std::exp((-2)*std::log(std::abs(x92)));

    Real x96 = std::sqrt(x80*x95);

    Real x97 = 4.985670872372847e-33*std::pow(x8, 3.7599999999999998)*std::exp(-2197000.0/((x8)*(x8)*(x8)))/(6.0142468035272636e-8*std::pow(x8, 2.1000000000000001) + 1.0) + 1.6e-18*std::exp(-11700.0*x10) + 6.7e-19*std::exp(-5860.0*x10) + 3.0e-24*std::exp(-510.0*x10);

    Real x98 = x8 < 2000.0;

    Real x99 = x59 - 6.9077552789821368;

    Real x100 = 0.14476482730108395*x59 - 1;

    Real x101 = ((x100)*(x100))*x30;

    Real x102 = ((x100)*(x100)*(x100));

    Real x103 = x102*x29;

    Real x104 = ((((x100)*(x100)))*(((x100)*(x100))));

    Real x105 = ((x100)*(x100)*(x100)*(x100)*(x100));

    Real x106 = std::exp((6)*std::log(std::abs(x100)))*x58;

    Real x107 = ((x100)*(x100)*(x100)*(x100)*(x100)*(x100)*(x100))*x57;

    Real x108 = std::exp((8)*std::log(std::abs(x100)));

    Real x109 = std::pow(10, std::min(300.0, -75.100986441619156*x101 - 1554.3387057364687*x103 + 5627.2167698544854*x104*x28 + 86051.290034608537*x105*x55 - 428804.85473346239*x106 - 1662263.0320406025*x107 + 9415777.8988952208*x108*x56 + 5.0194035000000001*x25*x99 - 20.584225));

    Real x110 = x8 <= 10000.0;

    Real x111 = 5.5313336794064847e-19/(std::exp(std::min(300.0, 0.00020000000000000001*x8 - 6.0)) + 1.0);

    Real x112 = ((x98) ? (
   x97
)
: ((x110) ? (
   x109
)
: (
   x111
)));

    Real x113 = std::pow(x8, 25.0*x25);

    Real x114 = std::pow(10.0, -200.0 + 20000.0/((10.0 + 2.3538526683701997e+17/x113)*(1.6889118802245084e-48*x113 + 10.0)));

    Real x115 = x104*x28;

    Real x116 = x105*x55;

    Real x117 = std::pow(10, -36.814414747418546*x101 + 144.02112655888752*x102*x29 - 339.5619991617852*x115 - 529.07725573213918*x116 + 2.0943374000000001*x25*x99 - 23.962112000000001)*X(10)*x114;

    Real x118 = x25*x99;

    Real x119 = std::pow(10, -38.89917505778142*x101 + 95.70878894783884*x103 - 377.88183430702219*x115 + 3018.4974183098116*x116 + 2.1892372*x118 - 23.689236999999999)*X(15);

    Real x120 = x8 > 10.0;

    Real x121 = x110 && x120;

    Real x122 = std::pow(x8, 16.666666666666664*x25);

    Real x123 = std::pow(10.0, -200.0 + 20000.0/((10.0 + 785.77199422741614/x122)*(5.0592917094448065e-34*x122 + 10.0)));

    Real x124 = 1.002560385050777e-22*X(15)*x123;

    Real x125 = std::pow(10, 0.73442154540113413*x101 - 77.855706084264682*x103 - 1161.2797752309887*x115 + 5059.6285287169567*x116 + 1.5714710999999999*x118 - 22.089523)*X(3);

    Real x126 = 1.1825091393820599e-21*X(3)*x123;

    Real x127 = std::pow(10, 2774.5177117396752*x101 + 16037.924047681272*x103 + 45902.322591745004*x115 + 60522.293708798054*x116 + 37.383713*x118 - 16.818342000000001)*X(4);

    Real x128 = x8 <= 100.0;

    Real x129 = std::pow(10, -540.77102118284597*x101 - 9179.8864335208946*x103 - 48562.751069188118*x115 - 66875.646562351845*x116 + 3.5692468000000002*x25*x99 - 24.311209000000002)*X(4);

    Real x130 = x8 <= 1000.0;

    Real x131 = std::pow(10, -177.55453097873294*x101 + 1956.911370108365*x103 - 12547.661945180447*x115 + 24439.250555499191*x116 + 4.6450521*x118 - 24.311209000000002)*X(4);

    Real x132 = x8 <= 6000.0;

    Real x133 = std::pow(x8, 17.997580222853362*x25);

    Real x134 = 1.8623144679125181e-22*std::pow(10.0, -200.0 + 20000.0/((10.0 + 2973.7534532281375/x133)*(1.3368457736780898e-34*x133 + 10.0)))*X(4);

    Real x135 = x108*x56;

    Real x136 = std::pow(10, std::min(300.0, 4616.3011562659685*x101 + 113122.17137872758*x103 + 87115306.05744876*x106 + 273295393.17143697*x107 + 1672890.7229183144*x115 + 15471651.937466398*x116 + 16.815729999999999*x118 + 366063607.58415633*x135 - 21.928795999999998))*X(2);

    Real x137 = x8 <= 500.0;

    Real x138 = x8 > 100;

    Real x139 = x137 && x138;

    Real x140 = std::pow(10, 44.525106942242758*x101 + 1331.8748828877385*x103 + 968783.44101153011*x106 + 4831859.3594864924*x107 - 10763.919849753534*x115 - 138531.11016116844*x116 + 1.6802758*x118 - 33025002.640084207*x135 - 22.921188999999998)*X(2);

    Real x141 = x8 > 500.0;

    Real x142 = x114*((x139) ? (
   x136
)
: ((x141) ? (
   x140
)
: (
   0
))) + x117 + ((x121) ? (
   x119
)
: (
   x124
)) + ((x121) ? (
   x125
)
: (
   x126
)) + ((x128) ? (
   x127
)
: ((x130) ? (
   x129
)
: ((x132) ? (
   x131
)
: (
   x134
))));

    Real x143 = x97 >= 1.0e-99;

    Real x144 = x114*x136;

    Real x145 = x117 + x127;

    Real x146 = x119 + x125;

    Real x147 = x145 + x146;

    Real x148 = x144 + x147 >= 1.0e-99;

    Real x149 = x117 + x146;

    Real x150 = x129 + x149;

    Real x151 = x144 + x150 >= 1.0e-99;

    Real x152 = x131 + x149;

    Real x153 = x144 + x152 >= 1.0e-99;

    Real x154 = x134 + x149;

    Real x155 = x144 + x154 >= 1.0e-99;

    Real x156 = x124 + x126;

    Real x157 = x145 + x156;

    Real x158 = x144 + x157 >= 1.0e-99;

    Real x159 = x117 + x156;

    Real x160 = x129 + x159;

    Real x161 = x144 + x160 >= 1.0e-99;

    Real x162 = x131 + x159;

    Real x163 = x144 + x162 >= 1.0e-99;

    Real x164 = x134 + x159;

    Real x165 = x144 + x164 >= 1.0e-99;

    Real x166 = x114*x140;

    Real x167 = x147 + x166 >= 1.0e-99;

    Real x168 = x150 + x166 >= 1.0e-99;

    Real x169 = x152 + x166 >= 1.0e-99;

    Real x170 = x154 + x166 >= 1.0e-99;

    Real x171 = x157 + x166 >= 1.0e-99;

    Real x172 = x160 + x166 >= 1.0e-99;

    Real x173 = x162 + x166 >= 1.0e-99;

    Real x174 = x164 + x166 >= 1.0e-99;

    Real x175 = x147 >= 1.0e-99;

    Real x176 = x150 >= 1.0e-99;

    Real x177 = x152 >= 1.0e-99;

    Real x178 = x154 >= 1.0e-99;

    Real x179 = x157 >= 1.0e-99;

    Real x180 = x160 >= 1.0e-99;

    Real x181 = x162 >= 1.0e-99;

    Real x182 = x164 >= 1.0e-99;

    Real x183 = x109 >= 1.0e-99;

    Real x184 = x111 >= 1.0e-99;

    Real x185 = 1.0/(1 + 91635868.75882785*std::exp(-0.00066666666666666675*x8));

    Real x186 = x25*std::log(T);

    Real x187 = x186 >= 4.0 && x186 <= 4.02118929906994;

    Real x188 = x186 >= 4.02118929906994 && x186 <= 4.0413926851582298;

    Real x189 = x186 >= 4.0413926851582298 && x186 <= 4.0644579892269199;

    Real x190 = x186 >= 4.0644579892269199 && x186 <= 4.0863598306747502;

    Real x191 = x186 >= 4.0863598306747502 && x186 <= 4.1072099696478697;

    Real x192 = x186 >= 4.1072099696478697 && x186 <= 4.1271047983648099;

    Real x193 = x186 >= 4.1271047983648099 && x186 <= 4.1492191126553797;

    Real x194 = x186 >= 4.1492191126553797 && x186 <= 4.1702617153949602;

    Real x195 = x186 >= 4.1702617153949602 && x186 <= 4.1903316981702901;

    Real x196 = x186 >= 4.1903316981702901 && x186 <= 4.2121876044039599;

    Real x197 = x186 >= 4.2121876044039599 && x186 <= 4.2329961103921496;

    Real x198 = x186 >= 4.2329961103921496 && x186 <= 4.25527250510331;

    Real x199 = x186 >= 4.25527250510331 && x186 <= 4.2764618041732403;

    Real x200 = x186 >= 4.2764618041732403 && x186 <= 4.2988530764097099;

    Real x201 = x186 >= 4.2988530764097099 && x186 <= 4.3201462861110498;

    Real x202 = x186 >= 4.3201462861110498 && x186 <= 4.3424226808222102;

    Real x203 = x186 >= 4.3424226808222102 && x186 <= 4.3636119798921396;

    Real x204 = x186 >= 4.3636119798921396 && x186 <= 4.3856062735983103;

    Real x205 = x186 >= 4.3856062735983103 && x186 <= 4.40823996531185;

    Real x206 = x186 >= 4.40823996531185 && x186 <= 4.4297522800024103;

    Real x207 = x186 >= 4.4297522800024103 && x186 <= 4.4517864355242898;

    Real x208 = x186 >= 4.4517864355242898 && x186 <= 4.4742162640762597;

    Real x209 = x186 >= 4.4742162640762597 && x186 <= 4.4969296480732197;

    Real x210 = x186 >= 4.4969296480732197 && x186 <= 4.5185139398778897;

    Real x211 = x186 >= 4.5185139398778897 && x186 <= 4.5403294747908696;

    Real x212 = x186 >= 4.5403294747908696 && x186 <= 4.5622928644564702;

    Real x213 = x186 >= 4.5622928644564702 && x186 <= 4.5843312243675296;

    Real x214 = x186 >= 4.5843312243675296 && x186 <= 4.6063813651106003;

    Real x215 = x186 >= 4.6063813651106003 && x186 <= 4.6294095991027202;

    Real x216 = x186 >= 4.6294095991027202 && x186 <= 4.65127801399814;

    Real x217 = x186 >= 4.65127801399814 && x186 <= 4.6730209071289002;

    Real x218 = x186 >= 4.6730209071289002 && x186 <= 4.6954816764901999;

    Real x219 = x186 >= 4.6954816764901999 && x186 <= 4.7176705030022603;

    Real x220 = x186 >= 4.7176705030022603 && x186 <= 4.7395723444500897;

    Real x221 = x186 >= 4.7395723444500897 && x186 <= 4.7619278384205304;

    Real x222 = x186 >= 4.7619278384205304 && x186 <= 4.7839035792727396;

    Real x223 = x186 >= 4.7839035792727396 && x186 <= 4.8061799739838902;

    Real x224 = x186 >= 4.8061799739838902 && x186 <= 4.8286598965353198;

    Real x225 = x186 >= 4.8286598965353198 && x186 <= 4.8506462351830697;

    Real x226 = x186 >= 4.8506462351830697 && x186 <= 4.87273882747267;

    Real x227 = x186 >= 4.87273882747267 && x186 <= 4.8954225460394101;

    Real x228 = x186 >= 4.8954225460394101 && x186 <= 4.9175055095525497;

    Real x229 = x186 >= 4.9175055095525497 && x186 <= 4.93951925261862;

    Real x230 = x186 >= 4.93951925261862 && x186 <= 4.96189547366785;

    Real x231 = x186 >= 4.96189547366785 && x186 <= 4.98407703390283;

    Real x232 = x186 >= 4.98407703390283 && x186 <= 5.0086001717619197;

    Real x233 = x186 >= 5.0086001717619197 && x186 <= 5.0293837776852097;

    Real x234 = x186 >= 5.0293837776852097 && x186 <= 5.0492180226701802;

    Real x235 = x186 >= 5.0492180226701802 && x186 <= 5.0718820073061304;

    Real x236 = x186 >= 5.0718820073061304 && x186 <= 5.0934216851622303;

    Real x237 = x186 >= 5.0934216851622303 && x186 <= 5.11727129565576;

    Real x238 = x186 >= 5.11727129565576 && x186 <= 5.1398790864012396;

    Real x239 = x186 >= 5.1398790864012396 && x186 <= 5.1613680022349797;

    Real x240 = x186 >= 5.1613680022349797 && x186 <= 5.1846914308176002;

    Real x241 = x186 >= 5.1846914308176002 && x186 <= 5.20682587603185;

    Real x242 = x186 >= 5.20682587603185 && x186 <= 5.2278867046136703;

    Real x243 = x186 >= 5.2278867046136703 && x186 <= 5.2504200023088901;

    Real x244 = x186 >= 5.2504200023088901 && x186 <= 5.2741578492636796;

    Real x245 = x186 >= 5.2741578492636796 && x186 <= 5.29666519026153;

    Real x246 = x186 >= 5.29666519026153 && x186 <= 5.3180633349627602;

    Real x247 = x186 >= 5.3180633349627602 && x186 <= 5.3404441148401203;

    Real x248 = x186 >= 5.3404441148401203 && x186 <= 5.3617278360175904;

    Real x249 = x186 >= 5.3617278360175904 && x186 <= 5.3838153659804302;

    Real x250 = x186 >= 5.3838153659804302 && x186 <= 5.4065401804339599;

    Real x251 = x186 >= 5.4065401804339599 && x186 <= 5.4297522800024103;

    Real x252 = x186 >= 5.4297522800024103 && x186 <= 5.4517864355242898;

    Real x253 = x186 >= 5.4517864355242898 && x186 <= 5.4742162640762597;

    Real x254 = x186 >= 5.4742162640762597 && x186 <= 5.4955443375464501;

    Real x255 = x186 >= 5.4955443375464501 && x186 <= 5.5185139398778897;

    Real x256 = x186 >= 5.5185139398778897 && x186 <= 5.5403294747908696;

    Real x257 = x186 >= 5.5403294747908696 && x186 <= 5.5634810853944101;

    Real x258 = x186 >= 5.5634810853944101 && x186 <= 5.5854607295085001;

    Real x259 = x186 >= 5.5854607295085001 && x186 <= 5.60745502321467;

    Real x260 = x186 >= 5.60745502321467 && x186 <= 5.6294095991027202;

    Real x261 = x186 >= 5.6294095991027202 && x186 <= 5.6522463410033197;

    Real x262 = x186 >= 5.6522463410033197 && x186 <= 5.6739419986340902;

    Real x263 = x186 >= 5.6739419986340902 && x186 <= 5.6963563887333297;

    Real x264 = x186 >= 5.6963563887333297 && x186 <= 5.7185016888672697;

    Real x265 = x186 >= 5.7185016888672697 && x186 <= 5.7411515988517898;

    Real x266 = x186 >= 5.7411515988517898 && x186 <= 5.7634279935629404;

    Real x267 = x186 >= 5.7634279935629404 && x186 <= 5.7853298350107698;

    Real x268 = x186 >= 5.7853298350107698 && x186 <= 5.8082109729242202;

    Real x269 = x186 >= 5.8082109729242202 && x186 <= 5.8299466959416399;

    Real x270 = x186 >= 5.8299466959416399 && x186 <= 5.8524799936368597;

    Real x271 = x186 >= 5.8524799936368597 && x186 <= 5.8744818176994702;

    Real x272 = x186 >= 5.8744818176994702 && x186 <= 5.8970770032094197;

    Real x273 = x186 >= 5.8970770032094197 && x186 <= 5.9190780923760702;

    Real x274 = x186 >= 5.9190780923760702 && x186 <= 5.9415114326343996;

    Real x275 = x186 >= 5.9415114326343996 && x186 <= 5.96378782734556;

    Real x276 = x186 >= 5.96378782734556 && x186 <= 5.98632377705077;

    Real x277 = x186 >= 5.98632377705077 && x186 <= 6.0086001717619197;

    Real x278 = x186 >= 6.0086001717619197 && x186 <= 6.0293837776852097;

    Real x279 = x186 >= 6.0293837776852097 && x186 <= 6.0530784434834199;

    Real x280 = x186 >= 6.0530784434834199 && x186 <= 6.0755469613925301;

    Real x281 = x186 >= 6.0755469613925301 && x186 <= 6.0969100130080598;

    Real x282 = x186 >= 6.0969100130080598 && x186 <= 6.1205739312058496;

    Real x283 = x186 >= 6.1205739312058496 && x186 <= 6.1430148002540896;

    Real x284 = x186 >= 6.1430148002540896 && x186 <= 6.1643528557844398;

    Real x285 = x186 >= 6.1643528557844398 && x186 <= 6.18752072083646;

    Real x286 = x186 >= 6.18752072083646 && x186 <= 6.2095150145426299;

    Real x287 = x186 >= 6.2095150145426299 && x186 <= 6.2304489213782697;

    Real x288 = x186 >= 6.2304489213782697 && x186 <= 6.2528530309798898;

    Real x289 = x186 >= 6.2528530309798898 && x186 <= 6.2764618041732403;

    Real x290 = x186 >= 6.2764618041732403 && x186 <= 6.2988530764097099;

    Real x291 = x186 >= 6.2988530764097099 && x186 <= 6.3201462861110498;

    Real x292 = x186 >= 6.3201462861110498 && x186 <= 6.3424226808222102;

    Real x293 = x186 >= 6.3424226808222102 && x186 <= 6.3654879848909003;

    Real x294 = x186 >= 6.3654879848909003 && x186 <= 6.3873898263387296;

    Real x295 = x186 >= 6.3873898263387296 && x186 <= 6.4099331233312897;

    Real x296 = x186 >= 6.4099331233312897;

    Real x297 = x186 >= 6.4313637641589896;

    Real x298 = x186 <= 6.4533183400470397;

    Real x299 = x186 <= 6.4313637641589896;

    Real x300 = x186 >= 6.4533183400470397 && x186 <= 6.47567118832443;

    Real x301 = x186 >= 6.47567118832443 && x186 <= 6.4983105537896;

    Real x302 = x186 >= 6.4983105537896 && x186 <= 6.5211380837040398;

    Real x303 = x186 >= 6.5211380837040398 && x186 <= 6.5428254269591797;

    Real x304 = x186 >= 6.5428254269591797 && x186 <= 6.5658478186735199;

    Real x305 = x186 >= 6.5658478186735199 && x186 <= 6.5877109650189096;

    Real x306 = x186 >= 6.5877109650189096 && x186 <= 6.6095944092252203;

    Real x307 = x186 >= 6.6095944092252203 && x186 <= 6.6324572921847196;

    Real x308 = x186 >= 6.6324572921847196 && x186 <= 6.6541765418779599;

    Real x309 = x186 >= 6.6541765418779599 && x186 <= 6.6766936096248699;

    Real x310 = x186 >= 6.6766936096248699 && x186 <= 6.6989700043360196;

    Real x311 = x186 >= 6.6989700043360196 && x186 <= 6.6998377258672503;

    Real x312 = x186 >= 6.6998377258672503 && x186 <= 6.7201593034059597;

    Real x313 = x186 >= 6.7201593034059597 && x186 <= 6.7403626894942397;

    Real x314 = x186 >= 6.7403626894942397 && x186 <= 6.7596678446896297;

    Real x315 = x186 >= 6.7596678446896297 && x186 <= 6.7803173121401503;

    Real x316 = x186 >= 6.7803173121401503 && x186 <= 6.8000293592441299;

    Real x317 = x186 >= 6.8000293592441299 && x186 <= 6.8202014594856397;

    Real x318 = x186 >= 6.8202014594856397 && x186 <= 6.8401060944567602;

    Real x319 = x186 >= 6.8401060944567602 && x186 <= 6.8597385661971497;

    Real x320 = x186 >= 6.8597385661971497 && x186 <= 6.8802417758954801;

    Real x321 = x186 >= 6.8802417758954801 && x186 <= 6.8998205024271;

    Real x322 = x186 >= 6.8998205024271 && x186 <= 6.92012332629072;

    Real x323 = x186 >= 6.92012332629072 && x186 <= 6.9400181550076603;

    Real x324 = x186 >= 6.9400181550076603 && x186 <= 6.95999483832842;

    Real x325 = x186 >= 6.95999483832842 && x186 <= 6.9800033715837504;

    Real x326 = x186 >= 6.9800033715837504 && x186 <= 7.0;

    Real x327 = x186 >= 7.0 && x186 <= 7.02118929906994;

    Real x328 = x186 >= 7.02118929906994 && x186 <= 7.0413926851582298;

    Real x329 = x186 >= 7.0413926851582298 && x186 <= 7.06069784035361;

    Real x330 = x186 >= 7.06069784035361 && x186 <= 7.0791812460476304;

    Real x331 = x186 >= 7.0791812460476304 && x186 <= 7.1003705451175598;

    Real x332 = x186 >= 7.1003705451175598 && x186 <= 7.1205739312058496;

    Real x333 = x186 >= 7.1205739312058496 && x186 <= 7.1398790864012396;

    Real x334 = x186 >= 7.1398790864012396 && x186 <= 7.1613680022349797;

    Real x335 = x186 >= 7.1613680022349797 && x186 <= 7.1789769472931697;

    Real x336 = x186 >= 7.1789769472931697 && x186 <= 7.1986570869544204;

    Real x337 = x186 >= 7.1986570869544204 && x186 <= 7.2201080880400497;

    Real x338 = x186 >= 7.2201080880400497 && x186 <= 7.2405492482826004;

    Real x339 = x186 >= 7.2405492482826004 && x186 <= 7.2600713879850796;

    Real x340 = x186 >= 7.2600713879850796 && x186 <= 7.2810333672477299;

    Real x341 = x186 >= 7.2810333672477299 && x186 <= 7.3010299956639804;

    Real x342 = x186 >= 7.3010299956639804 && x186 <= 7.3201462861110498;

    Real x343 = x186 >= 7.3201462861110498 && x186 <= 7.3404441148401203;

    Real x344 = x186 >= 7.3404441148401203 && x186 <= 7.3598354823398902;

    Real x345 = x186 >= 7.3598354823398902 && x186 <= 7.3802112417116099;

    Real x346 = x186 >= 7.3802112417116099 && x186 <= 7.3996737214810402;

    Real x347 = x186 >= 7.3996737214810402 && x186 <= 7.4199557484897598;

    Real x348 = x186 >= 7.4199557484897598 && x186 <= 7.4393326938302602;

    Real x349 = x186 >= 7.4393326938302602 && x186 <= 7.4593924877592297;

    Real x350 = x186 >= 7.4593924877592297 && x186 <= 7.4800069429571501;

    Real x351 = x186 >= 7.4800069429571501 && x186 <= 7.4996870826183999;

    Real x352 = x186 >= 7.4996870826183999 && x186 <= 7.5198279937757198;

    Real x353 = x186 >= 7.5198279937757198 && x186 <= 7.5403294747908696;

    Real x354 = x186 >= 7.5403294747908696 && x186 <= 7.5599066250361098;

    Real x355 = x186 >= 7.5599066250361098 && x186 <= 7.5797835966168101;

    Real x356 = x186 >= 7.5797835966168101 && x186 <= 7.5998830720736903;

    Real x357 = x186 >= 7.5998830720736903 && x186 <= 7.6201360549737602;

    Real x358 = x186 >= 7.6201360549737602 && x186 <= 7.6404814369704201;

    Real x359 = x186 >= 7.6404814369704201 && x186 <= 7.6599162000698504;

    Real x360 = x186 >= 7.6599162000698504 && x186 <= 7.6803355134145601;

    Real x361 = x186 >= 7.6803355134145601 && x186 <= 7.6998377258672503;

    Real x362 = x186 >= 7.6998377258672503 && x186 <= 7.7201593034059597;

    Real x363 = x186 >= 7.7201593034059597 && x186 <= 7.7403626894942397;

    Real x364 = x186 >= 7.7403626894942397 && x186 <= 7.7596678446896297;

    Real x365 = x186 >= 7.7596678446896297 && x186 <= 7.7803173121401503;

    Real x366 = x186 >= 7.7803173121401503 && x186 <= 7.8000293592441299;

    Real x367 = x186 >= 7.8000293592441299 && x186 <= 7.8202014594856397;

    Real x368 = x186 >= 7.8202014594856397 && x186 <= 7.8401060944567602;

    Real x369 = x186 >= 7.8401060944567602 && x186 <= 7.8597385661971497;

    Real x370 = x186 >= 7.8597385661971497 && x186 <= 7.8802417758954801;

    Real x371 = x186 >= 7.8802417758954801 && x186 <= 7.8998205024271;

    Real x372 = x186 >= 7.8998205024271 && x186 <= 7.92012332629072;

    Real x373 = x186 >= 7.92012332629072 && x186 <= 7.9400181550076603;

    Real x374 = x186 >= 7.9400181550076603 && x186 <= 7.95999483832842;

    Real x375 = x186 >= 7.95999483832842 && x186 <= 7.9800033715837504;

    Real x376 = x186 >= 7.9800033715837504 && x186 <= 8.0;

    Real x377 = user_dust2gas_ratio > 0;

    Real x378 = std::exp(-91.200000000000003*x10);

    Real x379 = std::max(0.0, X(2));

    Real x380 = x34*x379;

    Real x381 = std::max(0.0, X(4));

    Real x382 = x381*std::pow(x8, 0.070000000000000007);

    Real x383 = 5.6000000000000006e-6*x378*x380 + 1.1590975361199841e-9*x378*x382;

    Real x384 = 3.8e-6*x380 + 0.00017013;

    Real x385 = 7.7999999999999999e-6*x380*std::exp(-38574.400000000001*x10);

    Real x386 = 2.4999999999999998e-6*x380 + 1.3e-7;

    Real x387 = 5.2000000000000002e-6*x380*std::exp(-38603.199999999997*x10);

    Real x388 = 1.6666666666666665e-6*x380*std::exp(-28.800000000000001*x10);

    Real x389 = -1.3e-6*x380 - x388 - 5.1e-5;

    Real x390 = X(21)/(x385*(-x384 - x388) + x386*(-x387 + x388) + x389*(x384 + x387));

    Real x391 = std::max(0.0, X(3));

    Real x392 = x391*((x8 <= 2090.0) ? (
   2.03e-11*std::pow(x8, 0.56000000000000005)
)
: (
   3.43e-10*std::pow(x8, 0.19)
));

    Real x393 = x381*std::pow(x8, 0.44);

    Real x394 = x379*std::pow(x8, 0.92600000000000005);

    Real x395 = x392 + 1.4500824124120476e-11*x393 + 1.08e-14*x394;

    Real x396 = x395 + 1.8e-5;

    Real x397 = std::exp(-330.0*x10);

    Real x398 = x379*std::pow(x8, -0.025999999999999999);

    Real x399 = 9.7199999999999998e-11*x397*x398;

    Real x400 = std::pow(x8, 0.80000000000000004);

    Real x401 = x381*x400;

    Real x402 = 2.160222331098239e-13*x397*x401;

    Real x403 = x391*((x8 <= 511.0) ? (
   6.1000000000000003e-13*std::pow(x8, 1.1000000000000001)
)
: ((x8 <= 7510.0) ? (
   2.1199999999999999e-12*std::pow(x8, 0.90000000000000002)
)
: (
   4.49e-10*std::pow(x8, 0.29999999999999999)
)));

    Real x404 = 0.20000000000000001*x397*x403;

    Real x405 = x399 + x402 + x404;

    Real x406 = std::exp(-230.0*x10);

    Real x407 = x379*std::pow(x8, -0.074999999999999997);

    Real x408 = x381*std::pow(x8, 0.67000000000000004);

    Real x409 = x391*((x8 <= 194.0) ? (
   6.3800000000000002e-11*std::pow(x8, 0.40000000000000002)
)
: ((x8 <= 3686.0) ? (
   7.7500000000000007e-12*x400
)
: (
   2.6500000000000002e-10*std::pow(x8, 0.37)
)));

    Real x410 = 3.0719999999999998e-10*x406*x407 + 2.5231268066741097e-12*x406*x408 + 0.59999999999999998*x406*x409;

    Real x411 = x395 + 4.8599999999999998e-10*x398 + 1.0801111655491194e-12*x401 + x403 + 1.8000129999999999e-5;

    Real x412 = std::exp(-100.0*x10);

    Real x413 = 0.33333333333333331*x392*x412 + 4.8336080413734914e-12*x393*x412 + 3.6000000000000001e-15*x394*x412;

    Real x414 = -5.1199999999999999e-10*x407 - 4.2052113444568494e-12*x408 - x409 - x413 - 8.8999999999999995e-5;

    Real x415 = X(22)/(x396*(-x399 - x402 - x404 + x413) + x410*(-x411 - x413) + x414*(x405 + x411));

    Real x416 = x381*std::pow(x8, 0.26000000000000001);

    Real x417 = std::max(0.0, 0.75*X(10));

    Real x418 = std::exp(-0.0028661507595299516*x8);

    Real x419 = std::max(0.0, 0.25*X(10));

    Real x420 = std::exp(-0.0079776625448743522*x8);

    Real x421 = std::exp(-0.0039888312724371761*x8);

    Real x422 = ((((x59)*(x59)))*(((x59)*(x59))));

    Real x423 = x379*((x130) ? (
   1.0173250550588591e-9*x34*std::exp(0.00235272*x422 - 0.57443*x59 - 0.041816600000000002*x60 + 0.35826400000000003*x63)
)
: (
   9.0467979597705753e+161*x34*std::exp(0.097857299999999994*x422 - 202.19200000000001*x59 - 3.1926800000000002*x60 + 38.504899999999999*x63)
));

    Real x424 = x8 <= 5000.0;

    Real x425 = x391*((x424) ? (
   std::pow(x8, 0.69999999999999996)*(1.7e-18*x38 - 2.2000000000000001e-14*x8 + 1.0e-10)
)
: (
   9.1999999999999997e-9*std::pow(x8, 0.053499999999999999)
));

    Real x426 = x417*(2.8999999999999998e-10 - 1.8999999999999999e-10*x418) + x419*(1.8e-10*x420 - 2.5999999999999998e-10*x421 + 2.7e-10) + x423 + x425;

    Real x427 = 8.7578599891658458e-11*x416 + x426 + 2.7000000000000001e-7;

    Real x428 = std::exp(-63.0*x10);

    Real x429 = 1.3891777913849274e-10*x416*x428;

    Real x430 = std::exp(-0.0025819777949909629*x8);

    Real x431 = x417*x428*(6.0e-10 - 3.0499999999999998e-10*x430);

    Real x432 = std::exp(-0.0089686098654708519*x8);

    Real x433 = std::exp(-0.0044843049327354259*x8);

    Real x434 = x419*x428*(4.35e-10*x432 - 4.3000000000000001e-10*x433 + 5.4999999999999996e-10);

    Real x435 = x391*((x424) ? (
   x8*(3.9000000000000001e-20*x38 - 5.9999999999999999e-16*x8 + 3.1000000000000001e-12)
)
: (
   2.2999999999999999e-9*std::pow(x8, 0.096500000000000002)
));

    Real x436 = 5.0*x428;

    Real x437 = x435*x436;

    Real x438 = x379*((x130) ? (
   7.8546976572722417e-10*x34*std::exp(0.0070527699999999999*x422 - 1.3074300000000001*x59 - 0.11133800000000001*x60 + 0.69763799999999998*x63)
)
: (
   3.2033184029538206e+146*x34*std::exp(0.093813800000000003*x422 - 187.47399999999999*x59 - 3.0328300000000001*x60 + 36.180300000000003*x63)
));

    Real x439 = x436*x438;

    Real x440 = x429 + x431 + x434 + x437 + x439;

    Real x441 = std::exp(-24.0*x10);

    Real x442 = x381*std::pow(x8, 0.14000000000000001);

    Real x443 = std::exp(-0.01582278481012658*x8);

    Real x444 = std::exp(-0.0079113924050632899*x8);

    Real x445 = std::exp(-0.0091617040769583144*x8);

    Real x446 = std::exp(-0.0045808520384791572*x8);

    Real x447 = x391*((x424) ? (
   std::pow(x8, 0.45000000000000001)*(1.8999999999999999e-18*x38 - 1.7999999999999999e-14*x8 + 9.6000000000000005e-11)
)
: (
   8.9000000000000003e-10*std::pow(x8, 0.11700000000000001)
));

    Real x448 = 3.0*x441;

    Real x449 = x379*((x130) ? (
   2.7641154276543743e-10*x34*std::exp(-0.00065632500000000003*x422 - 0.77378199999999997*x59 - 0.015089200000000001*x60 + 0.36118400000000001*x63)
)
: (
   3.5214306661991335e+187*x34*std::exp(0.10508000000000001*x422 - 227.91300000000001*x59 - 3.4762*x60 + 42.594999999999999*x63)
));

    Real x450 = x417*x441*(1.9800000000000001e-10*x445 - 1.9800000000000001e-10*x446 + 2.6099999999999998e-10) + x419*x441*(3.9e-10*x443 - 2.6099999999999998e-10*x444 + 2.3700000000000001e-10) + 2.5190758091989079e-10*x441*x442 + x447*x448 + x448*x449;

    Real x451 = 1.1536215571935701e-10*x416 + x417*(1.2e-10 - 6.0999999999999996e-11*x430) + x419*(8.6999999999999997e-11*x432 - 8.6e-11*x433 + 1.0999999999999999e-10) + x426 + x435 + x438 + 2.7000002100000003e-7;

    Real x452 = std::exp(-39.0*x10);

    Real x453 = 1.6666666666666667*x452;

    Real x454 = 1.459643331527641e-10*x416*x452 + x417*x452*(4.8333333333333332e-10 - 3.1666666666666666e-10*x418) + x419*x452*(3.0e-10*x420 - 4.3333333333333334e-10*x421 + 4.5e-10) + x423*x453 + x425*x453;

    Real x455 = -x417*(6.6000000000000005e-11*x445 - 6.6000000000000005e-11*x446 + 8.6999999999999997e-11) - x419*(1.2999999999999999e-10*x443 - 8.6999999999999997e-11*x444 + 7.8999999999999999e-11) - 8.3969193639963598e-11*x442 - x447 - x449 - x454 - 7.9000000000000006e-8;

    Real x456 = X(17)/(x427*(-x429 - x431 - x434 - x437 - x439 + x454) + x450*(-x451 - x454) + x455*(x440 + x451));

    Real x457 = std::max(9.9999999999999993e-41, x79);

    Real x458 = x25*std::log(x457);

    Real x459 = std::min(11.999880000000001, x458);

    Real x460 = x459 < 2.0;

    Real x461 = std::min(2.9999700000000002, x70);

    Real x462 = x461 < 1.0;

    Real x463 = (1.0/2.0)*x59 - std::log(std::max(9.9999999999999993e-41, x0)) + (1.0/2.0)*std::log(std::max(9.9999999999999993e-41, x80)) - 10.69132076561309 + (1.0/2.0)*std::log(M_PI);

    Real x464 = std::min(18.99981, x25*(x463 + std::log(std::max(9.9999999999999993e-41, X(25)))));

    Real x465 = ((x459)*(x459));

    Real x466 = ((x459)*(x459)*(x459));

    Real x467 = ((((x459)*(x459)))*(((x459)*(x459))));

    Real x468 = ((x459)*(x459)*(x459)*(x459)*(x459));

    Real x469 = std::exp((6)*std::log(std::abs(x459)));

    Real x470 = ((x459)*(x459)*(x459)*(x459)*(x459)*(x459)*(x459));

    Real x471 = std::exp((8)*std::log(std::abs(x459)));

    Real x472 = ((x459)*(x459)*(x459)*(x459)*(x459)*(x459)*(x459)*(x459)*(x459));

    Real x473 = ((x461)*(x461));

    Real x474 = ((x461)*(x461)*(x461));

    Real x475 = ((((x461)*(x461)))*(((x461)*(x461))));

    Real x476 = ((x461)*(x461)*(x461)*(x461)*(x461));

    Real x477 = std::exp((6)*std::log(std::abs(x461)));

    Real x478 = ((x461)*(x461)*(x461)*(x461)*(x461)*(x461)*(x461));

    Real x479 = std::exp((8)*std::log(std::abs(x461)));

    Real x480 = ((x461)*(x461)*(x461)*(x461)*(x461)*(x461)*(x461)*(x461)*(x461));

    Real x481 = x459*x461;

    Real x482 = x461*x465;

    Real x483 = x461*x466;

    Real x484 = x461*x467;

    Real x485 = x461*x468;

    Real x486 = x461*x469;

    Real x487 = x461*x470;

    Real x488 = x461*x471;

    Real x489 = x459*x473;

    Real x490 = x459*x474;

    Real x491 = x459*x475;

    Real x492 = x459*x476;

    Real x493 = x459*x477;

    Real x494 = x459*x478;

    Real x495 = x459*x479;

    Real x496 = x465*x473;

    Real x497 = x466*x473;

    Real x498 = x467*x473;

    Real x499 = x468*x473;

    Real x500 = x469*x473;

    Real x501 = x470*x473;

    Real x502 = x465*x474;

    Real x503 = x466*x474;

    Real x504 = x467*x474;

    Real x505 = x468*x474;

    Real x506 = x469*x474;

    Real x507 = x465*x475;

    Real x508 = x466*x475;

    Real x509 = x467*x475;

    Real x510 = x468*x475;

    Real x511 = x465*x476;

    Real x512 = x466*x476;

    Real x513 = x467*x476;

    Real x514 = x465*x477;

    Real x515 = x466*x477;

    Real x516 = x465*x478;

    Real x517 = ((x464)*(x464));

    Real x518 = ((x464)*(x464)*(x464));

    Real x519 = ((((x464)*(x464)))*(((x464)*(x464))));

    Real x520 = ((x464)*(x464)*(x464)*(x464)*(x464));

    Real x521 = std::exp((6)*std::log(std::abs(x464)));

    Real x522 = ((x464)*(x464)*(x464)*(x464)*(x464)*(x464)*(x464));

    Real x523 = std::exp((8)*std::log(std::abs(x464)));

    Real x524 = x459*x464;

    Real x525 = x459*x518;

    Real x526 = x459*x520;

    Real x527 = x464*x465;

    Real x528 = x464*x467;

    Real x529 = x464*x469;

    Real x530 = x461*x517;

    Real x531 = x461*x518;

    Real x532 = x461*x519;

    Real x533 = x461*x521;

    Real x534 = x461*x522;

    Real x535 = x464*x473;

    Real x536 = x464*x476;

    Real x537 = x464*x478;

    Real x538 = x465*x517;

    Real x539 = x465*x518;

    Real x540 = x465*x520;

    Real x541 = x466*x517;

    Real x542 = x466*x518;

    Real x543 = x468*x517;

    Real x544 = x473*x519;

    Real x545 = x474*x517;

    Real x546 = x474*x520;

    Real x547 = x475*x517;

    Real x548 = x475*x519;

    Real x549 = x476*x517;

    Real x550 = std::min(18.99981, x25*(x463 + std::log(std::max(9.9999999999999993e-41, X(27)))));

    Real x551 = ((x550)*(x550));

    Real x552 = ((x550)*(x550)*(x550));

    Real x553 = ((((x550)*(x550)))*(((x550)*(x550))));

    Real x554 = ((x550)*(x550)*(x550)*(x550)*(x550));

    Real x555 = std::exp((6)*std::log(std::abs(x550)));

    Real x556 = ((x550)*(x550)*(x550)*(x550)*(x550)*(x550)*(x550));

    Real x557 = std::exp((8)*std::log(std::abs(x550)));

    Real x558 = std::min(13.99986, x458);

    Real x559 = std::min(3.9999600000000002, x70);

    Real x560 = std::min(24.999750000000002, x25*(x463 + std::log(std::max(9.9999999999999993e-41, X(30)))));

    Real x561 = ((x558)*(x558));

    Real x562 = ((x558)*(x558)*(x558));

    Real x563 = ((((x558)*(x558)))*(((x558)*(x558))));

    Real x564 = ((x558)*(x558)*(x558)*(x558)*(x558));

    Real x565 = std::exp((6)*std::log(std::abs(x558)));

    Real x566 = ((x558)*(x558)*(x558)*(x558)*(x558)*(x558)*(x558));

    Real x567 = std::exp((8)*std::log(std::abs(x558)));

    Real x568 = ((x558)*(x558)*(x558)*(x558)*(x558)*(x558)*(x558)*(x558)*(x558));

    Real x569 = ((x559)*(x559));

    Real x570 = ((x559)*(x559)*(x559));

    Real x571 = ((((x559)*(x559)))*(((x559)*(x559))));

    Real x572 = ((x559)*(x559)*(x559)*(x559)*(x559));

    Real x573 = std::exp((6)*std::log(std::abs(x559)));

    Real x574 = ((x559)*(x559)*(x559)*(x559)*(x559)*(x559)*(x559));

    Real x575 = std::exp((8)*std::log(std::abs(x559)));

    Real x576 = ((x559)*(x559)*(x559)*(x559)*(x559)*(x559)*(x559)*(x559)*(x559));

    Real x577 = x564*x569;

    Real x578 = ((x560)*(x560));

    Real x579 = ((x560)*(x560)*(x560));

    Real x580 = ((((x560)*(x560)))*(((x560)*(x560))));

    Real x581 = ((x560)*(x560)*(x560)*(x560)*(x560));

    Real x582 = std::exp((6)*std::log(std::abs(x560)));

    Real x583 = ((x560)*(x560)*(x560)*(x560)*(x560)*(x560)*(x560));

    Real x584 = std::exp((8)*std::log(std::abs(x560)));

    Real x585 = ((x560)*(x560)*(x560)*(x560)*(x560)*(x560)*(x560)*(x560)*(x560));

    Real x586 = x560*x561;

    Real x587 = x560*x562;

    Real x588 = x561*x578;

    Real x589 = x569*x582;

    Real x590 = x572*x580;

    Real x591 = x559*x560;

    Real x592 = x558*x579;

    Real x593 = x558*x582;

    Real x594 = x558*x583;

    Real x595 = x559*x565;

    Real x596 = x558*x560;

    Real x597 = x561*x579;

    Real x598 = x562*x578;

    Real x599 = x562*x579;

    Real x600 = x564*x579;

    Real x601 = x558*x578;

    Real x602 = x570*x579;

    Real x603 = x560*x570;

    Real x604 = x563*x569;

    Real x605 = x561*x570;

    Real x606 = x570*x578;


    return (x1*(-7.1777505408000004e-12*((X(10))*(X(10)))*x45 + X(10)*((X(4))*(X(4)))*x42*(2.5000000000000002e-32*x34 + 7.5000000000000001e-33*x41 + 1.0e-99) + 1.60217646e-12*X(10)*x3*((X(10) > 10000000000.0) ? (
   18.021719523307954
)
: ((X(10) >= 1.0366017494884676e-5 && X(10) < 100000.0) ? (
   1.4510849135088*x27 + 7.23277032061136
)
: ((X(10) < 1.0366017494884676e-5) ? (
   0.0
)
: (
   0.00242079494592405*((((x26)*(x26)))*(((x26)*(x26))))*x28 - 0.071028410105510906*((x26)*(x26)*(x26))*x29 + 0.60127161756007097*((x26)*(x26))*x30 - 0.44312014506849401*x27 + 9.1462198642561994
)))) - 1.3854129535261706e-25*X(13)*x31 - 9.3799999999999993e-22*X(15)*x20*x22*std::exp(-285335.40000000002*x16) + 6.8893587779999996e-12*X(15)*(0.5*user_crate + 1.0e-99) + 3.2043529200000002e-11*X(17)*(1020.0*user_crate + 1.0e-99) + 3.2043529200000002e-11*X(18)*(730.0*user_crate + 1.0e-99) - X(2)*x11*(4.3799999999999999e-10*std::pow(x8, 0.34999999999999998)*std::exp(-102000.0*x10) + 1.0e-99) - 2.1299999999999999e-27*X(2)*x9*(4.0*X(13) + x6) - 5.6500000000000001e-36*X(2)*(-x7 + x8)*((((z + 1.0)*(z + 1.0)))*(((z + 1.0)*(z + 1.0)))) + 3.2043529200000002e-11*X(22)*(2.7999999999999998*user_crate + 1.0e-99) + 3.2043529200000002e-11*X(25)*(510.0*user_crate + 1.0e-99) + 3.2043529200000002e-11*X(27)*(970.0*user_crate + 1.0e-99) - 3.4635323838154264e-26*X(3)*x31 + ((X(4))*(X(4))*(X(4)))*x42*(2.0000000000000002e-31*x34 + 6.0000000000000001e-32*x41 + 1.0e-99) + 4.8065293799999994e-30*X(4)*user_dust2gas_ratio*x36*std::sqrt(x8)*(4.2000000000000002*x39 + 0.20000000000000001)/((1.0 + 10000.0*std::exp(-600.0/(Tdust + 9.9999999999999993e-41)))*(7.9999999999999996e-6*x38 + 0.002*x8 + 0.040000000000000001*std::sqrt(Tdust + x8) + 1.0)) - X(4)*x11*(std::pow(10.0, -23705.700000000001*x10 - 2080.4099999999999*x10/(std::pow(std::pow(10.0, -x73 - 13.656822)*x36, x74) + 1.0) + 69.700860000000006*x25*x72 + 43.20243*x30*x63 - 68.422430000000006*x70 - x71 - 178.4239 - (69.700860000000006*x25*x72 + 19.734269999999999*x25*std::log(16780.950000000001*x10 + 1.0) + 37.886913*x64 - 14.509090000000008*x70 - x71 - 307.31920000000002)/(std::pow(std::pow(10.0, -x73 - 14.82123)*x36, x74) + 1.0)) + std::pow(10.0, -21467.790000000001*x10 - 1657.4099999999999*x10/(std::pow(std::pow(10.0, -x66 - 8.1313220000000008)*x36, x69) + 1.0) + 42.707410000000003*x25*x59 + 21.360939999999999*x25*x65 - x62 - 2.0273650000000001*x64 - 142.7664 - (21.360939999999999*x25*x65 + 11.28215*x25*std::log(14254.549999999999*x10 + 1.0) - x62 - 4.7035149999999994*x64 + 70.138370000000009*x70 - 203.11568)/(std::pow(std::pow(10.0, -x66 - 9.3055640000000004)*x36, x69) + 1.0)) + 3.0000000000000001e-99) + 6.8893587779999996e-12*X(4)*(0.46000000000000002*user_crate + 1.0e-99) + 5.6556829037999995e-12*X(5)*x40*((1.3500000000000001e-9*std::pow(x8, 0.098492999999999997) + 4.4350199999999998e-10*std::pow(x8, 0.55610000000000004) + 3.7408500000000004e-16*std::pow(x8, 2.1825999999999999))/(0.0061910000000000003*std::pow(x8, 1.0461) + 8.9711999999999997e-11*std::pow(x8, 3.0424000000000002) + 3.2575999999999999e-14*std::pow(x8, 3.7740999999999998) + 1.0) + 1.0e-99) + 1.75918975308e-21*X(8)*x40 - 0.00022681492*x0*x78*((((x8)*(x8)))*(((x8)*(x8))))*((((x13 && x75 && x77 && x81 && x82) ? (
   4.8339620236294848e-32/((x86 + 2.1986273043946046e-56)*(x86 + 2.1986273043946046e-56)) >= 1.0
)
: (
   ((x13 && x77 && x81 && x82) ? (
      4.8339620236294848e-32/((x88 + 2.1986273043946046e-56)*(x88 + 2.1986273043946046e-56)) >= 1.0
   )
   : (
      ((x13 && x81 && x82) ? (
         true
      )
      : (
         ((x75 && x77 && x81 && x82) ? (
            1.7706820599375401e-32/((x90 + 1.3306697786970064e-56)*(x90 + 1.3306697786970064e-56)) >= 1.0
         )
         : (
            ((x77 && x81 && x82) ? (
               1.7706820599375401e-32/((x91 + 1.3306697786970064e-56)*(x91 + 1.3306697786970064e-56)) >= 1.0
            )
            : (
               ((x81 && x82) ? (
                  true
               )
               : (
                  ((x13 && x75 && x77 && x81) ? (
                     26194.42746515579/((x86*x93 + 1.6184692602936822e-38)*(x86*x93 + 1.6184692602936822e-38)) >= 1.0
                  )
                  : (
                     ((x13 && x77 && x81) ? (
                        26194.42746515579/((x88*x93 + 1.6184692602936822e-38)*(x88*x93 + 1.6184692602936822e-38)) >= 1.0
                     )
                     : (
                        ((x13 && x81) ? (
                           true
                        )
                        : (
                           ((x75 && x77 && x81) ? (
                              9595.028375514943/((x90*x93 + 9.7954215710784709e-39)*(x90*x93 + 9.7954215710784709e-39)) >= 1.0
                           )
                           : (
                              ((x77 && x81) ? (
                                 9595.028375514943/((x91*x93 + 9.7954215710784709e-39)*(x91*x93 + 9.7954215710784709e-39)) >= 1.0
                              )
                              : (
                                 ((x81) ? (
                                    true
                                 )
                                 : (
                                    ((x13 && x75 && x77 && x82) ? (
                                       4.833962023629485e-72/((x86*x94 + 2.1986273043946045e-76)*(x86*x94 + 2.1986273043946045e-76)) >= 1.0
                                    )
                                    : (
                                       ((x13 && x77 && x82) ? (
                                          4.833962023629485e-72/((x88*x94 + 2.1986273043946045e-76)*(x88*x94 + 2.1986273043946045e-76)) >= 1.0
                                       )
                                       : (
                                          ((x13 && x82) ? (
                                             true
                                          )
                                          : (
                                             ((x75 && x77 && x82) ? (
                                                1.7706820599375401e-72/((x90*x94 + 1.3306697786970064e-76)*(x90*x94 + 1.3306697786970064e-76)) >= 1.0
                                             )
                                             : (
                                                ((x77 && x82) ? (
                                                   1.7706820599375401e-72/((x91*x94 + 1.3306697786970064e-76)*(x91*x94 + 1.3306697786970064e-76)) >= 1.0
                                                )
                                                : (
                                                   ((x82) ? (
                                                      true
                                                   )
                                                   : (
                                                      ((x13 && x75 && x77) ? (
                                                         2.6194427465155784e-36/((x86*x96 + 1.618469260293682e-58)*(x86*x96 + 1.618469260293682e-58)) >= 1.0
                                                      )
                                                      : (
                                                         ((x13 && x77) ? (
                                                            2.6194427465155784e-36/((x88*x96 + 1.618469260293682e-58)*(x88*x96 + 1.618469260293682e-58)) >= 1.0
                                                         )
                                                         : (
                                                            ((x13) ? (
                                                               true
                                                            )
                                                            : (
                                                               ((x75 && x77) ? (
                                                                  9.5950283755149395e-37/((x90*x96 + 9.7954215710784688e-59)*(x90*x96 + 9.7954215710784688e-59)) >= 1.0
                                                               )
                                                               : (
                                                                  ((x77) ? (
                                                                     9.5950283755149395e-37/((x91*x96 + 9.7954215710784688e-59)*(x91*x96 + 9.7954215710784688e-59)) >= 1.0
                                                                  )
                                                                  : (
                                                                     true
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))
))) ? (
   1.0
)
: (
   483396202.36294854/((x78*x84*std::sqrt(((x81) ? (
      9.9999999999999993e-41
   )
   : (
      x80
   ))*((x82) ? (
      1.0e+80
   )
   : (
      1.8454161787119389e+44*x95
   )))*((x13) ? (
      x17
   )
   : (
      x19
   )) + 2.1986273043946046e-36)*(x78*x84*std::sqrt(((x81) ? (
      9.9999999999999993e-41
   )
   : (
      x80
   ))*((x82) ? (
      1.0e+80
   )
   : (
      1.8454161787119389e+44*x95
   )))*((x13) ? (
      x17
   )
   : (
      x19
   )) + 2.1986273043946046e-36))
)) - 1.24e-13*x15*(1.0 + 0.29999999999999999*std::exp(-94000.0*x16))*((x12) ? (
   0.031622776601683791
)
: ((x13) ? (
   std::pow(T, -1.5)
)
: (
   0.22169506691164925*std::pow(x14, -1.5)
)))*std::exp(-470000.0*x16) - 1.5499999999999999e-26*x15*((x12) ? (
   2.3157944032250755
)
: ((x13) ? (
   std::pow(T, 0.36470000000000002)
)
: (
   1.4423428878129001*std::pow(x14, 0.36470000000000002)
))) + x2*x3 + x2*x45 + x2*(0.00029999999999999997*user_crate + 1.0e-99) + x2*(0.10000000000000001*user_crate + 1.0e-99) - 1.2700000000000001e-21*x20*x23*std::exp(-157809.10000000001*x16) - 4.9500000000000001e-22*x20*x32*std::exp(-631515.0*x16) - 7.4999999999999996e-19*x23*std::exp(-118348.0*x16) - 5.5399999999999998e-17*x32*((x12) ? (
   0.4008667176273028
)
: ((x13) ? (
   std::pow(T, -0.39700000000000002)
)
: (
   0.67118683452634376*std::pow(x14, -0.39700000000000002)
)))*std::exp(-473638.0*x16) - 5.0099999999999997e-27*x33*std::exp(-55338.0*x16) - 9.1000000000000001e-27*x33*std::exp(-13179.0*x16) + x4*(3.0*user_crate + 1.0e-99) + x4*(5.0*user_crate + 1.0e-99) + x5*(117.0*user_crate + 1.0e-99) + x5*(750.0*user_crate + 1.0e-99) - ((x8 < 2.0) ? (
   0
)
: (
   X(10)*((((x110 && x120 && x128 && x137 && x138 && x98) ? (
      x143 && x148
   )
   : (
      ((x110 && x120 && x130 && x137 && x138 && x98) ? (
         x143 && x151
      )
      : (
         ((x110 && x120 && x132 && x137 && x138 && x98) ? (
            x143 && x153
         )
         : (
            ((x110 && x120 && x137 && x138 && x98) ? (
               x143 && x155
            )
            : (
               ((x128 && x137 && x138 && x98) ? (
                  x143 && x158
               )
               : (
                  ((x130 && x137 && x138 && x98) ? (
                     x143 && x161
                  )
                  : (
                     ((x132 && x137 && x138 && x98) ? (
                        x143 && x163
                     )
                     : (
                        ((x137 && x138 && x98) ? (
                           x143 && x165
                        )
                        : (
                           ((x110 && x120 && x128 && x141 && x98) ? (
                              x143 && x167
                           )
                           : (
                              ((x110 && x120 && x130 && x141 && x98) ? (
                                 x143 && x168
                              )
                              : (
                                 ((x110 && x120 && x132 && x141 && x98) ? (
                                    x143 && x169
                                 )
                                 : (
                                    ((x110 && x120 && x141 && x98) ? (
                                       x143 && x170
                                    )
                                    : (
                                       ((x128 && x141 && x98) ? (
                                          x143 && x171
                                       )
                                       : (
                                          ((x130 && x141 && x98) ? (
                                             x143 && x172
                                          )
                                          : (
                                             ((x132 && x141 && x98) ? (
                                                x143 && x173
                                             )
                                             : (
                                                ((x141 && x98) ? (
                                                   x143 && x174
                                                )
                                                : (
                                                   ((x110 && x120 && x128 && x98) ? (
                                                      x143 && x175
                                                   )
                                                   : (
                                                      ((x110 && x120 && x130 && x98) ? (
                                                         x143 && x176
                                                      )
                                                      : (
                                                         ((x110 && x120 && x132 && x98) ? (
                                                            x143 && x177
                                                         )
                                                         : (
                                                            ((x110 && x120 && x98) ? (
                                                               x143 && x178
                                                            )
                                                            : (
                                                               ((x128 && x98) ? (
                                                                  x143 && x179
                                                               )
                                                               : (
                                                                  ((x130 && x98) ? (
                                                                     x143 && x180
                                                                  )
                                                                  : (
                                                                     ((x132 && x98) ? (
                                                                        x143 && x181
                                                                     )
                                                                     : (
                                                                        ((x98) ? (
                                                                           x143 && x182
                                                                        )
                                                                        : (
                                                                           ((x110 && x120 && x128 && x137 && x138) ? (
                                                                              x148 && x183
                                                                           )
                                                                           : (
                                                                              ((x110 && x120 && x130 && x137 && x138) ? (
                                                                                 x151 && x183
                                                                              )
                                                                              : (
                                                                                 ((x110 && x120 && x132 && x137 && x138) ? (
                                                                                    x153 && x183
                                                                                 )
                                                                                 : (
                                                                                    ((x110 && x120 && x137 && x138) ? (
                                                                                       x155 && x183
                                                                                    )
                                                                                    : (
                                                                                       ((x110 && x128 && x137 && x138) ? (
                                                                                          x158 && x183
                                                                                       )
                                                                                       : (
                                                                                          ((x110 && x130 && x137 && x138) ? (
                                                                                             x161 && x183
                                                                                          )
                                                                                          : (
                                                                                             ((x110 && x132 && x137 && x138) ? (
                                                                                                x163 && x183
                                                                                             )
                                                                                             : (
                                                                                                ((x110 && x137 && x138) ? (
                                                                                                   x165 && x183
                                                                                                )
                                                                                                : (
                                                                                                   ((x110 && x120 && x128 && x141) ? (
                                                                                                      x167 && x183
                                                                                                   )
                                                                                                   : (
                                                                                                      ((x110 && x120 && x130 && x141) ? (
                                                                                                         x168 && x183
                                                                                                      )
                                                                                                      : (
                                                                                                         ((x110 && x120 && x132 && x141) ? (
                                                                                                            x169 && x183
                                                                                                         )
                                                                                                         : (
                                                                                                            ((x110 && x120 && x141) ? (
                                                                                                               x170 && x183
                                                                                                            )
                                                                                                            : (
                                                                                                               ((x110 && x128 && x141) ? (
                                                                                                                  x171 && x183
                                                                                                               )
                                                                                                               : (
                                                                                                                  ((x110 && x130 && x141) ? (
                                                                                                                     x172 && x183
                                                                                                                  )
                                                                                                                  : (
                                                                                                                     ((x110 && x132 && x141) ? (
                                                                                                                        x173 && x183
                                                                                                                     )
                                                                                                                     : (
                                                                                                                        ((x110 && x141) ? (
                                                                                                                           x174 && x183
                                                                                                                        )
                                                                                                                        : (
                                                                                                                           ((x110 && x120 && x128) ? (
                                                                                                                              x175 && x183
                                                                                                                           )
                                                                                                                           : (
                                                                                                                              ((x110 && x120 && x130) ? (
                                                                                                                                 x176 && x183
                                                                                                                              )
                                                                                                                              : (
                                                                                                                                 ((x110 && x120 && x132) ? (
                                                                                                                                    x177 && x183
                                                                                                                                 )
                                                                                                                                 : (
                                                                                                                                    ((x121) ? (
                                                                                                                                       x178 && x183
                                                                                                                                    )
                                                                                                                                    : (
                                                                                                                                       ((x110 && x128) ? (
                                                                                                                                          x179 && x183
                                                                                                                                       )
                                                                                                                                       : (
                                                                                                                                          ((x110 && x130) ? (
                                                                                                                                             x180 && x183
                                                                                                                                          )
                                                                                                                                          : (
                                                                                                                                             ((x110 && x132) ? (
                                                                                                                                                x181 && x183
                                                                                                                                             )
                                                                                                                                             : (
                                                                                                                                                ((x110) ? (
                                                                                                                                                   x182 && x183
                                                                                                                                                )
                                                                                                                                                : (
                                                                                                                                                   ((x128 && x137 && x138) ? (
                                                                                                                                                      x158 && x184
                                                                                                                                                   )
                                                                                                                                                   : (
                                                                                                                                                      ((x130 && x137 && x138) ? (
                                                                                                                                                         x161 && x184
                                                                                                                                                      )
                                                                                                                                                      : (
                                                                                                                                                         ((x132 && x137 && x138) ? (
                                                                                                                                                            x163 && x184
                                                                                                                                                         )
                                                                                                                                                         : (
                                                                                                                                                            ((x139) ? (
                                                                                                                                                               x165 && x184
                                                                                                                                                            )
                                                                                                                                                            : (
                                                                                                                                                               ((x128 && x141) ? (
                                                                                                                                                                  x171 && x184
                                                                                                                                                               )
                                                                                                                                                               : (
                                                                                                                                                                  ((x130 && x141) ? (
                                                                                                                                                                     x172 && x184
                                                                                                                                                                  )
                                                                                                                                                                  : (
                                                                                                                                                                     ((x132 && x141) ? (
                                                                                                                                                                        x173 && x184
                                                                                                                                                                     )
                                                                                                                                                                     : (
                                                                                                                                                                        ((x141) ? (
                                                                                                                                                                           x174 && x184
                                                                                                                                                                        )
                                                                                                                                                                        : (
                                                                                                                                                                           ((x128) ? (
                                                                                                                                                                              x179 && x184
                                                                                                                                                                           )
                                                                                                                                                                           : (
                                                                                                                                                                              ((x130) ? (
                                                                                                                                                                                 x180 && x184
                                                                                                                                                                              )
                                                                                                                                                                              : (
                                                                                                                                                                                 ((x132) ? (
                                                                                                                                                                                    x181 && x184
                                                                                                                                                                                 )
                                                                                                                                                                                 : (
                                                                                                                                                                                    x182 && x184
                                                                                                                                                                                 ))
                                                                                                                                                                              ))
                                                                                                                                                                           ))
                                                                                                                                                                        ))
                                                                                                                                                                     ))
                                                                                                                                                                  ))
                                                                                                                                                               ))
                                                                                                                                                            ))
                                                                                                                                                         ))
                                                                                                                                                      ))
                                                                                                                                                   ))
                                                                                                                                                ))
                                                                                                                                             ))
                                                                                                                                          ))
                                                                                                                                       ))
                                                                                                                                    ))
                                                                                                                                 ))
                                                                                                                              ))
                                                                                                                           ))
                                                                                                                        ))
                                                                                                                     ))
                                                                                                                  ))
                                                                                                               ))
                                                                                                            ))
                                                                                                         ))
                                                                                                      ))
                                                                                                   ))
                                                                                                ))
                                                                                             ))
                                                                                          ))
                                                                                       ))
                                                                                    ))
                                                                                 ))
                                                                              ))
                                                                           ))
                                                                        ))
                                                                     ))
                                                                  ))
                                                               ))
                                                            ))
                                                         ))
                                                      ))
                                                   ))
                                                ))
                                             ))
                                          ))
                                       ))
                                    ))
                                 ))
                              ))
                           ))
                        ))
                     ))
                  ))
               ))
            ))
         ))
      ))
   ))) ? (
      x112*x142/(x112 + x142)
   )
   : (
      0
   ))*std::min(1.0, std::pow(std::max(9.9999999999999993e-41, 1.2500000000000001e-10*X(0) + 1.2500000000000001e-10*X(1) + 1.2500000000000001e-10*X(10) + 1.2500000000000001e-10*X(11) + 1.2500000000000001e-10*X(12) + 1.2500000000000001e-10*X(13) + 1.2500000000000001e-10*X(14) + 1.2500000000000001e-10*X(15) + 1.2500000000000001e-10*X(16) + 1.2500000000000001e-10*X(17) + 1.2500000000000001e-10*X(18) + 1.2500000000000001e-10*X(19) + 1.2500000000000001e-10*X(2) + 1.2500000000000001e-10*X(20) + 1.2500000000000001e-10*X(21) + 1.2500000000000001e-10*X(22) + 1.2500000000000001e-10*X(23) + 1.2500000000000001e-10*X(24) + 1.2500000000000001e-10*X(25) + 1.2500000000000001e-10*X(26) + 1.2500000000000001e-10*X(27) + 1.2500000000000001e-10*X(28) + 1.2500000000000001e-10*X(29) + 1.2500000000000001e-10*X(3) + 1.2500000000000001e-10*X(30) + 1.2500000000000001e-10*X(31) + 1.2500000000000001e-10*X(32) + 1.2500000000000001e-10*X(33) + 1.2500000000000001e-10*X(4) + 1.2500000000000001e-10*X(5) + 1.2500000000000001e-10*X(6) + 1.2500000000000001e-10*X(7) + 1.2500000000000001e-10*X(8) + 1.2500000000000001e-10*X(9)), -0.45000000000000001))
)) - ((x7 <= x8) ? (
   std::pow(10.0, 0.92432999999999998*x25*x47 + 21.93385*x25*x51 + 0.11711000000000001*x28*x47*x53 + 0.0027499999999999998*x28*x48 + 0.11864*x28*x49*x51 + 0.62343000000000004*x28*x50*x54 - 0.17333999999999999*x28*x52 - 0.54262999999999995*x29*x47*x54 - 0.076759999999999995*x29*x49 - 1.06447*x29*x50*x51 + 2.1990599999999998*x29*x53 + 0.77951999999999999*x30*x47*x51 + 0.54962*x30*x50 - 10.19097*x30*x54 - 0.0083499999999999998*x47*x52*x55 - 0.0036600000000000001*x48*x51*x55 + 6.1920000000000003e-5*x48*x52*x56 - 0.00066631000000000004*x48*x53*x57 + 0.0025140000000000002*x48*x54*x58 - 0.001482*x49*x52*x57 + 0.017590000000000001*x49*x53*x58 - 0.073660000000000003*x49*x54*x55 + 0.0106*x50*x52*x58 - 0.13768*x50*x53*x55 - 42.567880000000002)*X(12)
)
: (
   0
)) - ((x377) ? (
   16.0*x185*(std::pow(10, ((x187) ? (
      21.754701117084799*x186 - 116.63708847273
   )
   : ((x188) ? (
      21.654524283752401*x186 - 116.23425846251899
   )
   : ((x189) ? (
      18.5204063550573*x186 - 103.56805719106799
   )
   : ((x190) ? (
      18.464966359964599*x186 - 103.34272366009
   )
   : ((x191) ? (
      18.4738710236347*x186 - 103.379111320018
   )
   : ((x192) ? (
      18.496102204755299*x186 - 103.47041944875301
   )
   : ((x193) ? (
      16.054373436314101*x186 - 93.393148932214004
   )
   : ((x194) ? (
      16.272829224597899*x186 - 94.2995698642317
   )
   : ((x195) ? (
      16.129118889353101*x186 - 93.700260155053897
   )
   : ((x196) ? (
      14.122013026334299*x186 - 85.289820835661899
   )
   : ((x197) ? (
      14.409888024284299*x186 - 86.502404333645202
   )
   : ((x198) ? (
      12.72751073123*x186 - 79.380907795934903
   )
   : ((x199) ? (
      12.854828907526301*x186 - 79.922681330927801
   )
   : ((x200) ? (
      11.5954693312581*x186 - 74.537078205297803
   )
   : ((x201) ? (
      11.6072033454627*x186 - 74.587521008359502
   )
   : ((x202) ? (
      10.4043963894105*x186 - 69.391219004261998
   )
   : ((x203) ? (
      10.0401485348532*x186 - 67.809500859189896
   )
   : ((x204) ? (
      8.8791085408720392*x186 - 62.743172832321797
   )
   : ((x205) ? (
      7.3959289430042601*x186 - 56.238531083038701
   )
   : ((x206) ? (
      6.3207533825905102*x186 - 51.498899207896102
   )
   : ((x207) ? (
      4.3981723244085096*x186 - 42.982341381924897
   )
   : ((x208) ? (
      2.6062918523723502*x186 - 35.005272202434803
   )
   : ((x209) ? (
      1.0829193289553101*x186 - 28.189374081916
   )
   : ((x210) ? (
      -23.3195620450633
   )
   : ((x211) ? (
      -0.68343477309326806*x186 - 20.2314524958447
   )
   : ((x212) ? (
      -1.0448841649842999*x186 - 18.590353168197002
   )
   : ((x213) ? (
      -0.93857251371400696*x186 - 19.0753780561963
   )
   : ((x214) ? (
      -0.48633999740536599*x186 - 21.148561701384999
   )
   : ((x215) ? (
      0.38886362957714499*x186 - 25.180083379393199
   )
   : ((x216) ? (
      1.74487735737534*x186 - 31.457626347376401
   )
   : ((x217) ? (
      3.3281355809456299*x186 - 38.821800513152098
   )
   : ((x218) ? (
      4.6061329573167296*x186 - 44.793908972190401
   )
   : ((x219) ? (
      5.6429036178622001*x186 - 49.662046611502802
   )
   : ((x220) ? (
      6.4322416927964197*x186 - 53.385883564516902
   )
   : ((x221) ? (
      6.5177996180557303*x186 - 53.791391540924501
   )
   : ((x222) ? (
      6.31944631516944*x186 - 52.846847426068997
   )
   : ((x223) ? (
      5.7618800359940696*x186 - 50.1795041074392
   )
   : ((x224) ? (
      4.9558188961754004*x186 - 46.3054291994358
   )
   : ((x225) ? (
      4.0940010586316502*x186 - 42.144003969169702
   )
   : ((x226) ? (
      2.9053814770816202*x186 - 36.378430870859098
   )
   : ((x227) ? (
      1.6364882433366601*x186 - 30.1954455428722
   )
   : ((x228) ? (
      0.57957990015472705*x186 - 25.021432610563402
   )
   : ((x229) ? (
      -0.37722629739323599*x186 - 20.316332862546901
   )
   : ((x230) ? (
      -1.0785413526091401*x186 - 16.852173645155698
   )
   : ((x231) ? (
      -1.60938500361908*x186 - 14.218182935985199
   )
   : ((x232) ? (
      -1.78758716733068*x186 - 13.3300096244384
   )
   : ((x233) ? (
      -2.2700140615443201*x186 - 10.913726199217299
   )
   : ((x234) ? (
      -2.5341768927707999*x186 - 9.5851499411792194
   )
   : ((x235) ? (
      -2.2864086101139902*x186 - 10.8361860194154
   )
   : ((x236) ? (
      -2.36319341360604*x186 - 10.4467425561506
   )
   : ((x237) ? (
      -2.2038598336806698*x186 - 11.258295667315901
   )
   : ((x238) ? (
      -2.1995190626624899*x186 - 11.280508570249401
   )
   : ((x239) ? (
      -2.3142598583085601*x186 - 10.6907547543515
   )
   : ((x240) ? (
      -2.0228191377754001*x186 - 12.194987563858399
   )
   : ((x241) ? (
      -2.2107322889946799*x186 - 11.220715858995399
   )
   : ((x242) ? (
      -2.1936659362015698*x186 - 11.309577386327
   )
   : ((x243) ? (
      -1.96521634754163*x186 - 12.5038859535562
   )
   : ((x244) ? (
      -1.73340869575622*x186 - 13.720973485178501
   )
   : ((x245) ? (
      -1.88707409957794*x186 - 12.9105178894524
   )
   : ((x246) ? (
      -1.89274422539165*x186 - 12.880485131430801
   )
   : ((x247) ? (
      -1.83489006530021*x186 - 13.188157218986801
   )
   : ((x248) ? (
      -1.76014293823027*x186 - 13.5873400738501
   )
   : ((x249) ? (
      -1.6626036087568501*x186 - 14.1103194117941
   )
   : ((x250) ? (
      -1.58129253681238*x186 - 14.5480832103522
   )
   : ((x251) ? (
      -1.4926049531937899*x186 - 15.027576194692299
   )
   : ((x252) ? (
      -1.5114512632196699*x186 - 14.925245399858801
   )
   : ((x253) ? (
      -1.4516059476316101*x186 - 15.2515092796129
   )
   : ((x254) ? (
      -1.44395612367339*x186 - 15.293386070343301
   )
   : ((x255) ? (
      -1.3258910340154*x186 - 15.942218005274301
   )
   : ((x256) ? (
      -1.3032756985248899*x186 - 16.0670210494327
   )
   : ((x257) ? (
      -1.2147875556861401*x186 - 16.5572745153722
   )
   : ((x258) ? (
      -1.2196320624352699*x186 - 16.530322193704698
   )
   : ((x259) ? (
      -1.1416925189096201*x186 - 16.9656504533441
   )
   : ((x260) ? (
      -1.13067926484268*x186 - 17.027406780183799
   )
   : ((x261) ? (
      -1.0682101260908901*x186 - 17.3790711495203
   )
   : ((x262) ? (
      -1.0501935059121501*x186 - 17.480905525003401
   )
   : ((x263) ? (
      -0.41275239741184999*x186 - 21.0977094021782
   )
   : ((x264) ? (
      -0.91231033068379497*x186 - 18.252049377442699
   )
   : ((x265) ? (
      -0.93551361062486604*x186 - 18.119361381912299
   )
   : ((x266) ? (
      -0.94606988055807095*x186 - 18.058756235906898
   )
   : ((x267) ? (
      -0.896384524888163*x186 - 18.345114205644698
   )
   : ((x268) ? (
      -0.84122149387258105*x186 - 18.664250534770002
   )
   : ((x269) ? (
      -0.80056567602309803*x186 - 18.900388102116299
   )
   : ((x270) ? (
      -0.80446638937769399*x186 - 18.8776471511819
   )
   : ((x271) ? (
      -0.72505392685775405*x186 - 19.342406999326201
   )
   : ((x272) ? (
      -0.66514126907691196*x186 - 19.694362818109798
   )
   : ((x273) ? (
      -0.63567972071018597*x186 - 19.868099837462101
   )
   : ((x274) ? (
      -0.57153470317143695*x186 - 20.2477792055106
   )
   : ((x275) ? (
      -0.593071610313473*x186 - 20.119817425502301
   )
   : ((x276) ? (
      -0.52801073197974802*x186 - 20.507826699745198
   )
   : ((x277) ? (
      -0.46979925674099798*x186 - 20.8562994380645
   )
   : ((x278) ? (
      -0.51597713271462498*x186 - 20.578835044557302
   )
   : ((x279) ? (
      -0.38588345232369597*x186 - 21.3632197706856
   )
   : ((x280) ? (
      -0.33183685767562598*x186 - 21.6903680476935
   )
   : ((x281) ? (
      -0.35510482470181198*x186 - 21.549002421331402
   )
   : ((x282) ? (
      -0.32627708059271798*x186 - 21.7247625830414
   )
   : ((x283) ? (
      -0.262119181450089*x186 - 22.117445748014699
   )
   : ((x284) ? (
      -0.27945128201577102*x186 - 22.010974397719998
   )
   : ((x285) ? (
      -0.17357119112580199*x186 - 22.663656638367701
   )
   : ((x286) ? (
      -0.18454134199941999*x186 - 22.5957786025274
   )
   : ((x287) ? (
      -0.195718275294439*x186 - 22.526375267415499
   )
   : ((x288) ? (
      -0.092088487356022597*x186 - 23.172035367899301
   )
   : ((x289) ? (
      -0.17603455025471201*x186 - 22.6471329740634
   )
   : ((x290) ? (
      -0.093473451786849196*x186 - 23.165324555106999
   )
   : ((x291) ? (
      -0.098769754173417795*x186 - 23.131963924526602
   )
   : ((x292) ? (
      -23.756203219546499
   )
   : ((x293) ? (
      -0.0916250359027799*x186 - 23.1750785137056
   )
   : ((x294) ? (
      -23.7583165788601
   )
   : ((x295) ? (
      -23.758316578859201
   )
   : (((x296 || x297) && (x296 || x298) && (x297 || x299) && (x298 || x299)) ? (
      -23.7583165788601
   )
   : ((x300) ? (
      0.094545414847061707*x186 - 24.368448238459699
   )
   : ((x301) ? (
      -23.756203219546499
   )
   : ((x302) ? (
      0.0921310845128573*x186 - 24.354899618367199
   )
   : ((x303) ? (
      0.19255196936796901*x186 - 25.0097580749953
   )
   : ((x304) ? (
      0.17965853582722999*x186 - 24.925398590184201
   )
   : ((x305) ? (
      0.18739974916320501*x186 - 24.9762262188815
   )
   : ((x306) ? (
      0.0929547420082599*x186 - 24.354049809656299
   )
   : ((x307) ? (
      0.26444436207134497*x186 - 25.4875266436648
   )
   : ((x308) ? (
      0.18344929257977999*x186 - 24.950330304384799
   )
   : ((x309) ? (
      0.17534071884347199*x186 - 24.896374423240601
   )
   : ((x310) ? (
      0.26286770031606499*x186 - 25.480765261107098
   )
   : ((x311) ? (
      -23.719822421582599
   )
   : ((x312) ? (
      0.18996659121990001*x186 - 24.992567756089599
   )
   : ((x313) ? (
      0.28346947226873498*x186 - 25.620922012067201
   )
   : ((x314) ? (
      0.19562119620559301*x186 - 25.028792769753601
   )
   : ((x315) ? (
      0.27138121268399101*x186 - 25.540905317055099
   )
   : ((x316) ? (
      0.187506936264072*x186 - 24.972211108603901
   )
   : ((x317) ? (
      0.271954725207252*x186 - 25.546458552738802
   )
   : ((x318) ? (
      0.27217103152884198*x186 - 25.5479338054311
   )
   : ((x319) ? (
      0.27254430592620299*x186 - 25.550487041911801
   )
   : ((x320) ? (
      0.257793610827321*x186 - 25.4493011298628
   )
   : ((x321) ? (
      0.26672013863549199*x186 - 25.510717799401402
   )
   : ((x322) ? (
      0.25415159849489999*x186 - 25.4239971284542
   )
   : ((x323) ? (
      0.34109312725649898*x186 - 26.025643229659199
   )
   : ((x324) ? (
      0.251333081394705*x186 - 25.402706881785001
   )
   : ((x325) ? (
      0.24806513642010899*x186 - 25.379962001630702
   )
   : ((x326) ? (
      0.326598415643502*x186 - 25.928124555390198
   )
   : ((x327) ? (
      0.30364902511269098*x186 - 25.7674788216755
   )
   : ((x328) ? (
      0.39156134499853601*x186 - 26.384727861312101
   )
   : ((x329) ? (
      0.40244894051784302*x186 - 26.461391696761002
   )
   : ((x330) ? (
      0.41295357257149601*x186 - 26.535561729617299
   )
   : ((x331) ? (
      0.35399730258495798*x186 - 26.1181996087935
   )
   : ((x332) ? (
      0.36496841849043399*x186 - 26.196098597014501
   )
   : ((x333) ? (
      0.449940914598983*x186 - 26.801151537676599
   )
   : ((x334) ? (
      0.33077927491262898*x186 - 25.950351838576399
   )
   : ((x335) ? (
      0.47583381883919201*x186 - 26.989140808031198
   )
   : ((x336) ? (
      0.34862735234924003*x186 - 26.075928517551802
   )
   : ((x337) ? (
      0.37726341485836201*x186 - 26.282069711876801
   )
   : ((x338) ? (
      0.38865860364944599*x186 - 26.364344206633199
   )
   : ((x339) ? (
      0.39964405616001403*x186 - 26.4438849165508
   )
   : ((x340) ? (
      0.36562478549376498*x186 - 26.1969025829458
   )
   : ((x341) ? (
      0.37662883760390298*x186 - 26.277023453532799
   )
   : ((x342) ? (
      0.38725746066734201*x186 - 26.354623349332499
   )
   : ((x343) ? (
      0.35860233859102703*x186 - 26.144863663888799
   )
   : ((x344) ? (
      0.36917779762143299*x186 - 26.222492229888299
   )
   : ((x345) ? (
      0.40271077993679699*x186 - 26.4692894629625
   )
   : ((x346) ? (
      0.35514459093678902*x186 - 26.118240940179
   )
   : ((x347) ? (
      0.33545503376080898*x186 - 25.972544641355899
   )
   : ((x348) ? (
      0.40281094705665099*x186 - 26.4723225374109
   )
   : ((x349) ? (
      0.32803653589985499*x186 - 25.916050815831099
   )
   : ((x350) ? (
      0.314445735562003*x186 - 25.814671701888098
   )
   : ((x351) ? (
      0.37815752055462298*x186 - 26.291236295979601
   )
   : ((x352) ? (
      0.414682051846057*x186 - 26.565158851504702
   )
   : ((x353) ? (
      0.39970178784710703*x186 - 26.4525098429312
   )
   : ((x354) ? (
      0.35988322371804299*x186 - 26.152264750186099
   )
   : ((x355) ? (
      0.39817279188127902*x186 - 26.441730310214599
   )
   : ((x356) ? (
      0.38671733854766899*x186 - 26.354900452943198
   )
   : ((x357) ? (
      0.37703797494805302*x186 - 26.281338421375001
   )
   : ((x358) ? (
      0.32308221855055302*x186 - 25.870188216675199
   )
   : ((x359) ? (
      0.38037124230777403*x186 - 26.307903939235999
   )
   : ((x360) ? (
      0.31179964733701099*x186 - 25.782651268054899
   )
   : ((x361) ? (
      0.32174532218346003*x186 - 25.8590373877832
   )
   : ((x362) ? (
      0.304374840933406*x186 - 25.725287500936201
   )
   : ((x363) ? (
      0.30185624255250298*x186 - 25.705843520214302
   )
   : ((x364) ? (
      0.26728586673743798*x186 - 25.438256273093401
   )
   : ((x365) ? (
      0.24695100363146599*x186 - 25.280464489724199
   )
   : ((x366) ? (
      0.25569260325596599*x186 - 25.348476908618998
   )
   : ((x367) ? (
      0.24699463413776401*x186 - 25.280632494132099
   )
   : ((x368) ? (
      0.20642312374434399*x186 - 24.9633551093393
   )
   : ((x369) ? (
      0.207323288943144*x186 - 24.970412500000698
   )
   : ((x370) ? (
      0.19667532416269801*x186 - 24.886722280563799
   )
   : ((x371) ? (
      0.163403741551292*x186 - 24.624534165317499
   )
   : ((x372) ? (
      0.15642366770180199*x186 - 24.569392834813701
   )
   : ((x373) ? (
      0.15847268149263999*x186 - 24.5856212767339
   )
   : ((x374) ? (
      0.117620139421206*x186 - 24.2612513510085
   )
   : ((x375) ? (
      0.15559538445018001*x186 - 24.563534105424001
   )
   : ((x376) ? (
      0.077427480804772103*x186 - 23.939753970784299
   )
   : (
      -9.9999999999999997e+98
   ))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) + std::pow(10, ((x187) ? (
      2.93326303855088*x186 - 34.858441143158402
   )
   : ((x188) ? (
      2.9412722431245601*x186 - 34.890647670884398
   )
   : ((x189) ? (
      2.56669738238736*x186 - 33.376843568657499
   )
   : ((x190) ? (
      2.52371857917433*x186 - 33.202158028569102
   )
   : ((x191) ? (
      2.5917911951007699*x186 - 33.480327231859498
   )
   : ((x192) ? (
      2.72370456532667*x186 - 34.022123141182398
   )
   : ((x193) ? (
      2.4670363083973799*x186 - 32.962826346421899
   )
   : ((x194) ? (
      2.5584967274005499*x186 - 33.3423156650015
   )
   : ((x195) ? (
      2.5461946466152798*x186 - 33.291012768482702
   )
   : ((x196) ? (
      2.0488420441586199*x186 - 31.206940393240998
   )
   : ((x197) ? (
      1.63567014261275*x186 - 29.466582831060801
   )
   : ((x198) ? (
      1.1806405542702101*x186 - 27.540444353494401
   )
   : ((x199) ? (
      0.86289765826336395*x186 - 26.188361744423698
   )
   : ((x200) ? (
      0.56265183697246401*x186 - 24.9043719578112
   )
   : ((x201) ? (
      0.55364747214684895*x186 - 24.865663516378799
   )
   : ((x202) ? (
      0.530067235381807*x186 - 24.763793444092698
   )
   : ((x203) ? (
      0.70626361876998101*x186 - 25.528912615597601
   )
   : ((x204) ? (
      0.91330605119549102*x186 - 26.432365454074901
   )
   : ((x205) ? (
      1.1364977363308499*x186 - 27.411196308620699
   )
   : ((x206) ? (
      1.4273279400174499*x186 - 28.693245635631701
   )
   : ((x207) ? (
      1.60660732583608*x186 - 29.487408903718499
   )
   : ((x208) ? (
      1.7241382767553*x186 - 30.010631596775099
   )
   : ((x209) ? (
      1.8405988654025101*x186 - 30.5317014566244
   )
   : ((x210) ? (
      2.00636090105013*x186 - 31.277121669252701
   )
   : ((x211) ? (
      2.0766266686417798*x186 - 31.594618519612599
   )
   : ((x212) ? (
      2.1055476263965098*x186 - 31.725929196544701
   )
   : ((x213) ? (
      2.1206678994118402*x186 - 31.794912310231702
   )
   : ((x214) ? (
      2.0681491225742499*x186 - 31.5541488417084
   )
   : ((x215) ? (
      1.9431479613642799*x186 - 30.9783458220945
   )
   : ((x216) ? (
      2.05657373686677*x186 - 31.5034401959911
   )
   : ((x217) ? (
      1.9996974842122199*x186 - 31.238892932500701
   )
   : ((x218) ? (
      1.9353186995018601*x186 - 30.938049525572801
   )
   : ((x219) ? (
      1.8764948502316701*x186 - 30.661843219184401
   )
   : ((x220) ? (
      1.8476148800607499*x186 - 30.525597035782098
   )
   : ((x221) ? (
      1.74703872538521*x186 - 30.048909074570499
   )
   : ((x222) ? (
      1.7321135872356299*x186 - 29.977836643723101
   )
   : ((x223) ? (
      1.6021313147378999*x186 - 29.356013985079699
   )
   : ((x224) ? (
      1.5381019612034399*x186 - 29.048277388374999
   )
   : ((x225) ? (
      1.45157467866989*x186 - 28.630466569249599
   )
   : ((x226) ? (
      1.2972328154280599*x186 - 27.8818087913833
   )
   : ((x227) ? (
      1.15329138198717*x186 - 27.1804197797737
   )
   : ((x228) ? (
      1.1215547707139399*x186 - 27.0250556574128
   )
   : ((x229) ? (
      1.01840908159215*x186 - 26.517836162870498
   )
   : ((x230) ? (
      0.92272259671210599*x186 - 26.045190928589399
   )
   : ((x231) ? (
      0.83372798800292003*x186 - 25.603608982454698
   )
   : ((x232) ? (
      0.54375987608625598*x186 - 24.158385575286999
   )
   : ((x233) ? (
      0.26777430271999902*x186 - 22.776084185120499
   )
   : ((x234) ? (
      -0.051498455835144299*x186 - 21.170338952585599
   )
   : ((x235) ? (
      -0.27800168012061*x186 - 20.026674790331501
   )
   : ((x236) ? (
      -0.35713542850248797*x186 - 19.6253177557419
   )
   : ((x237) ? (
      -0.20055317060939601*x186 - 20.422857223607
   )
   : ((x238) ? (
      0.0049179296178181202*x186 - 21.4743085868859
   )
   : ((x239) ? (
      0.21946625207999701*x186 - 22.5770610225327
   )
   : ((x240) ? (
      0.37033984879133203*x186 - 23.355775176980401
   )
   : ((x241) ? (
      0.44156034872162297*x186 - 23.725031492667799
   )
   : ((x242) ? (
      0.48350154352135599*x186 - 23.943411991022
   )
   : ((x243) ? (
      0.38971187416564101*x186 - 23.453090225567401
   )
   : ((x244) ? (
      0.33868894996362497*x186 - 23.1851984437608
   )
   : ((x245) ? (
      0.322702410666238*x186 - 23.100882912042799
   )
   : ((x246) ? (
      0.34002456808514098*x186 - 23.192632580264199
   )
   : ((x247) ? (
      0.29125790095929499*x186 - 22.933288355853598
   )
   : ((x248) ? (
      0.17829221455576799*x186 - 22.330001420721601
   )
   : ((x249) ? (
      -0.111369316280047*x186 - 20.7769151278153
   )
   : ((x250) ? (
      -0.58568062507549701*x186 - 18.223310615264399
   )
   : ((x251) ? (
      -1.2361127484671199*x186 - 14.706723205502399
   )
   : ((x252) ? (
      -2.1008525824407802*x186 - 10.011400120375599
   )
   : ((x253) ? (
      -2.7420796120589999*x186 - 6.51556729821095
   )
   : ((x254) ? (
      -3.2044944260569501*x186 - 3.9842086026737902
   )
   : ((x255) ? (
      -2.8708036109349*x186 - 5.8180212722081697
   )
   : ((x256) ? (
      -2.5116421712830301*x186 - 7.8000586835942203
   )
   : ((x257) ? (
      -1.80460257799325*x186 - 11.717290982141099
   )
   : ((x258) ? (
      -1.2668672637651099*x186 - 14.708971231798399
   )
   : ((x259) ? (
      -0.79591022376939702*x186 - 17.3394832839804
   )
   : ((x260) ? (
      -0.46499057072071498*x186 - 19.195100354748298
   )
   : ((x261) ? (
      -0.209402348965568*x186 - 20.6339111437137
   )
   : ((x262) ? (
      -0.13502175230019001*x186 - 21.054328599057001
   )
   : ((x263) ? (
      -0.10531027470347*x186 - 21.222909799636
   )
   : ((x264) ? (
      -0.15176894728551801*x186 - 20.958264643260001
   )
   : ((x265) ? (
      -0.30720854742526199*x186 - 20.069383027344902
   )
   : ((x266) ? (
      -0.40714833571678399*x186 - 19.495613552005999
   )
   : ((x267) ? (
      -0.57307801426975402*x186 - 18.539289797670801
   )
   : ((x268) ? (
      -0.45188722753414401*x186 - 19.2404184719007
   )
   : ((x269) ? (
      -0.34095283423994299*x186 - 19.884748832307199
   )
   : ((x270) ? (
      -0.101391790148568*x186 - 21.2813769497834
   )
   : ((x271) ? (
      0.091439489485424005*x186 - 22.409918155988599
   )
   : ((x272) ? (
      0.15775940896867299*x186 - 22.799513317144399
   )
   : ((x273) ? (
      0.291644453598565*x186 - 23.589043734905299
   )
   : ((x274) ? (
      0.218813788443072*x186 - 23.157953340330099
   )
   : ((x275) ? (
      0.15493263193206999*x186 - 22.778402718590801
   )
   : ((x276) ? (
      0.0130504257608663*x186 - 21.932247344509101
   )
   : ((x277) ? (
      -0.115959060276282*x186 - 21.159954790779899
   )
   : ((x278) ? (
      -0.286559975286309*x186 - 20.134882103548101
   )
   : ((x279) ? (
      -0.37967673216280701*x186 - 19.573445440206299
   )
   : ((x280) ? (
      -0.49173461909697402*x186 - 18.895150260382302
   )
   : ((x281) ? (
      -0.61785251318155998*x186 - 18.128915072198701
   )
   : ((x282) ? (
      -0.61044633705080298*x186 - 18.1740698616095
   )
   : ((x283) ? (
      -0.72608077731592902*x186 - 17.4663207209733
   )
   : ((x284) ? (
      -0.95925614440489004*x186 - 16.0339209898912
   )
   : ((x285) ? (
      -1.0585422967578799*x186 - 15.4218861130948
   )
   : ((x286) ? (
      -1.2909283589043501*x186 - 13.983992538329399
   )
   : ((x287) ? (
      -1.64666769221208*x186 - 11.775023806891101
   )
   : ((x288) ? (
      -1.8492714166259201*x186 - 10.5127116506501
   )
   : ((x289) ? (
      -1.94508032434487*x186 - 9.9136326316238392
   )
   : ((x290) ? (
      -2.22025076248815*x186 - 8.1865358869808897
   )
   : ((x291) ? (
      -2.4512780810855501*x186 - 6.7313287504994204
   )
   : ((x292) ? (
      -2.26962366535906*x186 - 7.8794112314080804
   )
   : ((x293) ? (
      -2.0863839597168399*x186 - 9.0415948965010102
   )
   : ((x294) ? (
      -2.0848607637183201*x186 - 9.0512907823276691
   )
   : ((x295) ? (
      -1.8841149811578399*x186 - 10.3335323515357
   )
   : ((x296 && x299) ? (
      -1.8564586978613999*x186 - 10.510807277904901
   )
   : ((x297 && x298) ? (
      -1.76263611112745*x186 - 11.1142144624864
   )
   : ((x300) ? (
      -1.67510434343274*x186 - 11.6790848242872
   )
   : ((x301) ? (
      -1.6102512791394501*x186 - 12.0990519442057
   )
   : ((x302) ? (
      -1.48362476308819*x186 - 12.921910369851499
   )
   : ((x303) ? (
      -1.4592525975119801*x186 - 13.0808446269721
   )
   : ((x304) ? (
      -1.2166884622729399*x186 - 14.6678994186832
   )
   : ((x305) ? (
      -1.1168280984404599*x186 - 15.323567370724
   )
   : ((x306) ? (
      -0.94975625448296297*x186 - 16.4241883891073
   )
   : ((x307) ? (
      -0.77301335024833395*x186 - 17.5923873008078
   )
   : ((x308) ? (
      -0.62030387509435103*x186 - 18.605226372878899
   )
   : ((x309) ? (
      -0.44263947976116902*x186 - 19.787436624632399
   )
   : ((x310) ? (
      -0.30863893367848*x186 - 20.682117214349098
   )
   : ((x311) ? (
      0.37799839210128999*x186 - 25.2818800635869
   )
   : ((x312) ? (
      -0.17008626540336999*x186 - 21.609801798284899
   )
   : ((x313) ? (
      -0.089932065606262795*x186 - 22.148450789758499
   )
   : ((x314) ? (
      -0.045716866684188097*x186 - 22.446477266881601
   )
   : ((x315) ? (
      0.082793220446092206*x186 - 23.315162770575601
   )
   : ((x316) ? (
      0.13282407330507301*x186 - 23.654387828356398
   )
   : ((x317) ? (
      0.192971992959656*x186 - 24.0633954479054
   )
   : ((x318) ? (
      0.222438706333833*x186 - 24.264364369464602
   )
   : ((x319) ? (
      0.21749138057339201*x186 - 24.230524136379199
   )
   : ((x320) ? (
      0.235681934338345*x186 - 24.355306579581299
   )
   : ((x321) ? (
      0.22767478025889401*x186 - 24.300215423578301
   )
   : ((x322) ? (
      0.21777025474716499*x186 - 24.231875975386199
   )
   : ((x323) ? (
      0.086589758180480203*x186 - 23.324090761140699
   )
   : ((x324) ? (
      0.018425597582336199*x186 - 22.851030249067701
   )
   : ((x325) ? (
      -0.095740459339140202*x186 - 22.0564350821824
   )
   : ((x326) ? (
      -0.19764335706258901*x186 - 21.3451525125001
   )
   : ((x327) ? (
      -0.27723294135057602*x186 - 20.7880254224829
   )
   : ((x328) ? (
      -0.44605006323922702*x186 - 19.602728452778099
   )
   : ((x329) ? (
      -0.63447531976157701*x186 - 18.275952229802002
   )
   : ((x330) ? (
      -0.80470115977163903*x186 - 17.0740390088704
   )
   : ((x331) ? (
      -0.85228441879371497*x186 - 16.737188493977602
   )
   : ((x332) ? (
      -1.07382341232483*x186 - 15.1641795497126
   )
   : ((x333) ? (
      -1.2872963153461101*x186 - 13.6441299614416
   )
   : ((x334) ? (
      -1.31951487512265*x186 - 13.414093340298701
   )
   : ((x335) ? (
      -1.7572218101702199*x186 - 10.2795129012902
   )
   : ((x336) ? (
      -1.69560023572603*x186 - 10.721892763684099
   )
   : ((x337) ? (
      -1.6364113886490901*x186 - 11.1479729771627
   )
   : ((x338) ? (
      -1.78567380621826*x186 - 10.070282188830801
   )
   : ((x339) ? (
      -1.75913482356214*x186 - 10.2624389997509
   )
   : ((x340) ? (
      -1.65756359686497*x186 - 10.999853356538599
   )
   : ((x341) ? (
      -1.72248569929138*x186 - 10.5271533625
   )
   : ((x342) ? (
      -1.60840358124801*x186 - 11.3600703283028
   )
   : ((x343) ? (
      -1.4513062849268901*x186 - 12.5100455185275
   )
   : ((x344) ? (
      -1.4253694049277801*x186 - 12.700433736674301
   )
   : ((x345) ? (
      -1.32755370412065*x186 - 13.420341202203399
   )
   : ((x346) ? (
      -1.1339262834819701*x186 - 14.849352468705501
   )
   : ((x347) ? (
      -1.1065551671515499*x186 - 15.0518897989423
   )
   : ((x348) ? (
      -1.02493254608726*x186 - 15.657526035314699
   )
   : ((x349) ? (
      -0.95072251267038199*x186 - 16.209599163123102
   )
   : ((x350) ? (
      -0.82715174397685598*x186 - 17.131362026822899
   )
   : ((x351) ? (
      -0.79508175467935904*x186 - 17.371245769430999
   )
   : ((x352) ? (
      -0.67255991518800295*x186 - 18.2901212263987
   )
   : ((x353) ? (
      -0.63615655344483502*x186 - 18.563868245106299
   )
   : ((x354) ? (
      -0.626142986893228*x186 - 18.639373836120299
   )
   : ((x355) ? (
      -0.57224466133448004*x186 - 19.046840144590501
   )
   : ((x356) ? (
      -0.52916107670284895*x186 - 19.373404392665201
   )
   : ((x357) ? (
      -0.43011151089876898*x186 - 20.126169511116998
   )
   : ((x358) ? (
      -0.42072025584502598*x186 - 20.197732152355499
   )
   : ((x359) ? (
      -0.41661671872566303*x186 - 20.229085151537198
   )
   : ((x360) ? (
      -0.32955265151235802*x186 - 20.895988610429399
   )
   : ((x361) ? (
      -0.359007884565472*x186 - 20.669762537956601
   )
   : ((x362) ? (
      -0.29562802081954898*x186 - 21.157777203889101
   )
   : ((x363) ? (
      -0.26861239577874602*x186 - 21.366342132883801
   )
   : ((x364) ? (
      -0.27526591225455399*x186 - 21.314841502198799
   )
   : ((x365) ? (
      -0.22452734703983901*x186 - 21.708555915181901
   )
   : ((x366) ? (
      -0.228001616232405*x186 - 21.681524998437499
   )
   : ((x367) ? (
      -0.19406547980656799*x186 - 21.946227858898101
   )
   : ((x368) ? (
      -0.19896475340806299*x186 - 21.9079145523283
   )
   : ((x369) ? (
      -0.144045171554808*x186 - 22.338489900721498
   )
   : ((x370) ? (
      -0.18771268698606*x186 - 21.995274645596499
   )
   : ((x371) ? (
      -0.181371750917833*x186 - 22.045242754900801
   )
   : ((x372) ? (
      -0.15006926117553099*x186 - 22.292526805144
   )
   : ((x373) ? (
      -0.097468143190098999*x186 - 22.7091341466876
   )
   : ((x374) ? (
      -0.174341062052463*x186 - 22.098761775292601
   )
   : ((x375) ? (
      -0.12709908463625699*x186 - 22.4748076716787
   )
   : ((x376) ? (
      -0.173189984009014*x186 - 22.107002139286099
   )
   : (
      -9.9999999999999997e+98
   ))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))*Z)*((0.5*X(1) + 0.5*X(10) + 0.25*X(11) + 0.25*X(12) + 0.25*X(18) + 0.5*X(19) + 0.75*X(20) + X(23) + 0.25*X(24) + 0.25*X(25) + 0.5*X(26) + 0.75*X(28) + 0.25*X(3) + 0.25*X(4) + 0.25*X(5) + 0.5*X(8))*(0.5*X(1) + 0.5*X(10) + 0.25*X(11) + 0.25*X(12) + 0.25*X(18) + 0.5*X(19) + 0.75*X(20) + X(23) + 0.25*X(24) + 0.25*X(25) + 0.5*X(26) + 0.75*X(28) + 0.25*X(3) + 0.25*X(4) + 0.25*X(5) + 0.5*X(8))) + (1 - x185)*(((x460 || x462 || x464 < 9.0) ? (
      0.0
   )
   : (
      std::pow(10, -20.360212905100301*x459*x517 - 0.52797032562909996*x459*x519 - 0.0012516455574000001*x459*x521 + 2.45492893e-5*x459*x522 - 2.0491730000000001e-7*x459*x523 - 3.4429418092545001*x459*x530 - 0.55036731592760002*x459*x531 + 0.097706870306800003*x459*x532 + 0.0001978699223*x459*x533 - 2.1488524999999999e-6*x459*x534 - 100.1540946139759*x459*x535 - 0.1220236291332*x459*x536 - 0.0007440436186*x459*x537 + 0.049613747445099998*x459*x544 + 4.8520959300000001e-5*x459*x546 + 0.35426903937339999*x459*x547 - 4.3161844299999999e-5*x459*x548 - 0.060202510145399998*x459*x549 + 20.3649299915947*x459 - 75.299695359826899*x461*x464 - 0.0076851140205*x461*x520 - 3.209781e-7*x461*x523 + 54.085098837550902*x461*x524 - 0.0065739247922000001*x461*x526 + 19.184854295220699*x461*x527 + 0.1615293342819*x461*x528 - 5.6870301499999997e-5*x461*x529 + 0.00014410438979999999*x461*x540 + 0.00026475764900000002*x461*x543 - 47.559803051881197*x461 + 1.1940279999999999e-7*((x464)*(x464)*(x464)*(x464)*(x464)*(x464)*(x464)*(x464)*(x464)) - 3.0836667989033999*x464*x466 - 0.040347262524199998*x464*x468 - 6.5481524799999998e-5*x464*x470 + 8.6699919999999998e-7*x464*x471 + 47.556044042082497*x464*x474 - 86.020612066646194*x464*x475 - 22.2802823459682*x464*x477 - 0.13464931496829999*x464*x479 - 2.8556552777972999*x464*x483 - 0.002904776222*x464*x485 + 2.6345508e-6*x464*x487 + 12.8360066029064*x464*x490 + 0.0278872971314*x464*x493 - 0.044769368153399998*x464*x503 + 0.0048337398222999999*x464*x504 - 7.7849984599999994e-5*x464*x505 - 0.0096135394491999992*x464*x508 - 7.5822643719078*x464 - 0.043497398505999998*x465*x519 - 3.4867000999999999e-5*x465*x521 + 3.5333219999999999e-7*x465*x522 - 2.4301583262415001*x465*x530 + 0.1712810070345*x465*x531 - 0.0064759322805000002*x465*x532 - 1.6696918e-6*x465*x533 + 3.5133050137291*x465*x535 - 0.00070595390469999997*x465*x544 + 0.00077362074520000005*x465*x549 - 56.915400919787402*x465 + 0.0016854860852*x466*x519 - 3.3478540799999997e-5*x466*x520 + 1.697195e-7*x466*x521 + 0.28173719990879997*x466*x530 - 0.0137884415355*x466*x531 + 0.00029133323910000001*x466*x532 + 0.074096619680599995*x466*x535 + 0.00020615397360000001*x466*x536 + 3.6266469e-6*x466*x544 + 12.6066721363912*x466 - 0.032618157779500001*x467*x517 + 0.001902687729*x467*x518 - 6.0232547200000002e-5*x467*x519 + 7.8674779999999999e-7*x467*x520 - 0.0135100513841*x467*x530 + 0.00049797288530000004*x467*x531 - 6.7732749e-6*x467*x532 - 0.014159748673100001*x467*x535 - 8.5587269900000006e-5*x467*x545 - 2.7928933908445002*x467 - 4.87054635e-5*x468*x518 + 5.6505170000000002e-7*x468*x519 - 5.2183217e-6*x468*x531 + 0.00040007346859999998*x468*x535 + 0.34205790108779999*x468 - 4.61090426e-5*x469*x517 + 7.1519579999999996e-7*x469*x518 - 2.0907143999999999e-6*x469*x530 - 3.8957497000000001e-6*x469*x535 - 0.024213057736899999*x469 + 4.5347009999999999e-7*x470*x517 + 0.00095884092259999995*x470 - 1.7797473799999999e-5*x471 + 6.9368000000000003e-8*x472 - 14.1815605361866*x473*x517 - 2.7554623671076999*x473*x518 + 0.0075222770970999999*x473*x520 - 0.0004669134188*x473*x521 + 8.1984912999999997e-6*x473*x522 - 1.0905152389177999*x473*x525 + 0.0242714411203*x473*x539 + 0.013369313361399999*x473*x541 - 0.00049248667509999998*x473*x542 + 6.3431601000000002e-6*x473*x543 + 0.90563183927519997*x473 + 1.6463007811879999*x474*x518 - 0.16362513598780001*x474*x519 - 6.1688840300000002e-5*x474*x521 + 0.042057431356300003*x474*x525 + 0.0033260418458999999*x474*x527 + 0.00033784509460000001*x474*x539 + 33.569263775829498*x474 + 0.46079059024460001*x475*x518 + 6.0713992099999998e-5*x475*x520 - 1.8297653193047001*x475*x524 + 0.0034593370547*x475*x525 - 0.089280005816900002*x475*x527 + 1.11981398e-5*x475*x528 - 0.017098171269000002*x475*x538 + 5.7414321999999997e-5*x475*x539 + 0.00031254232230000002*x475*x541 - 17.3552073528923*x475 - 0.10105727851019999*x476*x518 - 0.0007373397229*x476*x519 - 0.00028850397480000001*x476*x525 + 0.086398191443600003*x476*x527 - 57.703059324335001*x476 - 0.1921360560176*x477*x517 + 0.0115453052291*x477*x518 - 0.0093329110050999996*x477*x527 + 47.789440447875599*x477 - 0.0196095956543*x478*x517 - 22.2858836676964*x478 + 5.3339578239099001*x479 - 0.51041682043059999*x480 + 14.164582630669701*x481 - 83.354317190196298*x482 - 1.6101414000000001e-6*x483*x520 + 15.0991587239831*x483 - 1.2258681523532999*x484 + 0.059113880622099997*x485 - 0.0017177123872999999*x486 + 2.5732575999999999e-5*x487 - 1.925221e-7*x488 + 14.8241641825581*x489*x517 - 0.0010489094365*x489*x520 + 6.7124765000000004e-6*x489*x521 + 61.439278554514303*x489 - 1.6009057790223*x490*x517 - 0.0024989369339000001*x490*x519 + 66.325985989249105*x490 - 7.8551891148808997*x491 - 12.244271306143601*x492 + 0.0051192934768000001*x493*x517 + 6.4011003727495996*x493 - 1.0865832613576001*x494 + 0.056776674990399997*x495 - 0.52947614193869996*x496*x517 + 8.3381011e-6*x496*x520 + 1.311635494626*x496 - 2.7623083129385999*x497 - 0.00039222307050000002*x498*x517 + 1.5185419100000001e-5*x498*x518 + 0.27348164083190002*x498 - 0.019100980547200001*x499 + 0.00074922383839999996*x500 - 1.22400281e-5*x501 + 0.049242766990500002*x502*x517 + 7.3490350000000004e-7*x502*x519 + 1.7166022505292999*x502 + 0.0011489194243000001*x503*x517 - 3.0581260599999998e-5*x503*x518 + 0.50309367074760003*x503 + 0.0013474467272000001*x504 + 0.0003300557909*x505 - 1.7934860499999999e-5*x506 - 3.6187820926523999*x507 - 0.090943285887500003*x508 - 0.0111295294489*x509 + 0.0002140404241*x510 + 1.8509211874314*x511 + 0.056834102826200002*x512 + 0.00043558306989999998*x513 - 0.56101466485609996*x514 - 0.0058434230991000003*x515 + 0.060192127702100001*x516 - 23.741334917810999*x517 + 10.4159294438888*x518 - 2.0869172860516998*x519 + 0.22605546648569999*x520 - 0.014638487079*x521 + 0.00057260663920000003*x522 - 1.25535688e-5*x523 + 23.837391969558599*x524 + 4.6242788943301996*x525 + 0.034087068909300001*x526 + 27.377460699605798*x527 + 0.44068107103589998*x528 + 0.0021941995751000001*x529 + 8.1723278893797993*x530 + 1.276214911337*x531 + 0.031193196973900002*x532 + 7.4001529100000004e-5*x533 + 1.16367671e-5*x534 + 39.764294983229803*x535 + 72.523921027240604*x536 + 3.0795133468160998*x537 - 5.8011752165720996*x538 + 0.66942669331799998*x539 + 0.0016319787938*x540 + 0.42168773563220002*x541 - 0.037291536482600002*x542 + 0.0016101104869*x543 + 0.094683646925100007*x544 + 21.686787075207999*x545 + 0.0046026070559999997*x546 - 18.068679356687898*x547 + 0.0024703528802999999*x548 + 3.3120227111728*x549 + 168.09888262271619)*X(25)*x457
   )) + ((x460 || x462 || x550 < 9.0) ? (
      0.0
   )
   : (
      std::pow(10, -15.6735419271706*x459*x550 + 8.5045766567269006*x459*x551 - 1.4972563957478*x459*x552 + 0.13047868949079999*x459*x553 - 0.0062773436733000003*x459*x554 + 0.00017407734850000001*x459*x555 - 2.9054825999999999e-6*x459*x556 + 2.7458599999999999e-8*x459*x557 - 9.8760835772856996*x459 + 5.4586553412771002*x461*x550 + 1.9760786678008*x461*x551 - 0.67472957414050005*x461*x552 + 0.17540631800670001*x461*x553 - 0.022834960298200001*x461*x554 + 0.0014418794812000001*x461*x555 - 4.4932579099999998e-5*x461*x556 + 5.6193980000000003e-7*x461*x557 + 4.5634379481376*x461 - 3.5528602795922*x465*x550 - 0.74231825885180003*x465*x551 + 0.21099124651350001*x465*x552 - 0.019394333998500001*x465*x553 + 0.00084390984799999997*x465*x554 - 1.7576673099999998e-5*x465*x555 + 1.400519e-7*x465*x556 + 20.9658337145544*x465 + 1.3758733773666001*x466*x550 - 0.053043503323299997*x466*x551 - 0.0076961297644000002*x466*x552 + 0.00082299662219999996*x466*x553 - 2.7446162600000001e-5*x466*x554 + 2.9510110000000001e-7*x466*x555 - 5.8665160212550997*x466 - 0.13655529547520001*x467*x550 + 0.006878461933*x467*x551 + 6.2950829000000007e-5*x467*x552 - 1.5859306199999999e-5*x467*x553 + 3.5343039999999998e-7*x467*x554 + 0.59960535355900002*x467 + 0.0071954965516000001*x468*x550 - 0.00025848591050000002*x468*x551 + 1.5560391e-6*x468*x552 + 5.4168300000000002e-8*x468*x553 - 0.0278172887885*x468 - 0.00024943263539999998*x469*x550 + 5.1790795999999998e-6*x469*x551 + 2.6661200000000001e-8*x469*x552 + 0.00013591247090000001*x469 + 5.2732847e-6*x470*x550 - 9.1609499999999997e-8*x470*x551 + 3.0908317500000001e-5*x470 - 3.8680900000000002e-8*x471*x550 + 1.494538e-7*x471 - 4.7120000000000001e-8*x472 + 1.3440244509784001*x473*x550 - 2.6323935986257001*x473*x551 - 0.63586010955950001*x473*x552 + 0.14674619922349999*x473*x553 - 0.0096970290444000004*x473*x554 + 0.00029708562290000002*x473*x555 - 3.6368400999999998e-6*x473*x556 + 2.5161884420602001*x473 - 1.0237576973172*x474*x550 + 6.1535122772876996*x474*x551 - 0.76291955278949997*x474*x552 + 0.0265998154454*x474*x553 - 0.00051001248800000001*x474*x554 + 4.4068406999999997e-6*x474*x555 + 2.4341312509119*x474 - 8.5623467147410999*x475*x550 - 0.2813319983316*x475*x551 + 0.1577743012293*x475*x552 - 0.0037305896661000001*x475*x553 + 3.8073638100000003e-5*x475*x554 - 0.53967782227049999*x475 + 3.3110368609715*x476*x550 - 0.50249921046150003*x476*x551 - 0.0115254870206*x476*x552 + 8.8841644699999995e-5*x476*x553 - 3.3247503247040999*x476 + 0.3220442657109*x477*x550 + 0.1148838792372*x477*x551 + 0.0006791871357*x477*x552 + 2.1452691279259999*x477 - 0.2464800834019*x478*x550 - 0.0100100109153*x478*x551 - 1.397474402394*x478 + 0.030497966722699998*x479*x550 + 0.38181813023950001*x479 - 0.039390464892000002*x480 - 17.595716520764402*x481*x550 + 4.3434614562203002*x481*x551 - 0.55339310618509996*x481*x552 + 0.042667300411499999*x481*x553 - 0.0020317800997999998*x481*x554 + 5.7698430099999997e-5*x481*x555 - 7.6956910000000005e-7*x481*x556 - 11.099775151034899*x481 + 1.6907992647648*x482*x550 - 0.90218066191159996*x482*x551 + 0.1063179056835*x482*x552 - 0.0055157020021999997*x482*x553 + 0.00013315511249999999*x482*x554 - 1.1633197e-6*x482*x555 + 18.1536876840762*x482 - 0.32374948483510002*x483*x550 + 0.091257030742499995*x483*x551 - 0.0074216902436000003*x483*x552 + 0.0002384532436*x483*x553 - 2.6686475000000001e-6*x483*x554 - 1.2096109992180999*x483 + 0.023144128920999998*x484*x550 - 0.0040382879026999996*x484*x551 + 0.00023255522560000001*x484*x552 - 4.0639182000000001e-6*x484*x553 + 0.051205700689499999*x484 - 0.00088091977179999997*x485*x550 + 5.9579273200000003e-5*x485*x551 - 1.7863086e-6*x485*x552 - 0.0035559076976*x485 + 2.83458978e-5*x486*x550 - 4.0861769999999998e-7*x486*x551 + 0.00068851345740000001*x486 - 3.6354329999999999e-7*x487*x550 - 5.5323727700000002e-5*x487 + 1.4514925000000001e-6*x488 + 5.4673964678251004*x489*x550 + 1.0660139132327*x489*x551 - 0.23292294092970001*x489*x552 + 0.015672395274900001*x489*x553 - 0.00050902837310000002*x489*x554 + 7.1523700999999999e-6*x489*x555 - 0.1628147174764*x489 - 15.963263559048499*x490*x550 + 1.8055455053091001*x490*x551 - 0.084817027749599996*x490*x552 + 0.0022681696148999998*x490*x553 - 3.0409404800000001e-5*x490*x554 + 18.501865221499301*x490 + 0.59703124368659999*x491*x550 - 0.1527626342914*x491*x551 + 0.0026212163114*x491*x552 + 1.4218711e-5*x491*x553 + 12.4406982350406*x491 + 0.2981554850184*x492*x550 + 0.018278996070200001*x492*x551 - 0.00035799879249999997*x492*x552 - 2.6159083748851*x492 - 0.094078833140799997*x493*x550 + 5.5556733700000001e-5*x493*x551 - 0.57547145134050004*x493 + 0.0053807608027000003*x494*x550 + 0.30498502561469998*x494 - 0.0301525351682*x495 + 3.9298735211797999*x496*x550 - 0.48456767114499999*x496*x551 + 0.028480890781399999*x496*x552 - 0.00077447721980000001*x496*x553 + 6.8596344999999997e-6*x496*x554 - 22.845731870181901*x496 - 0.34414960089390001*x497*x550 + 0.0282438466058*x497*x551 - 0.0010344421251*x497*x552 + 1.4952163600000001e-5*x497*x553 + 1.8754275566329*x497 + 0.0146909729356*x498*x550 - 0.00075693974790000005*x498*x551 + 1.28837281e-5*x498*x552 - 0.096485453374899999*x498 - 0.00027764600010000002*x499*x550 + 7.3709799999999997e-6*x499*x551 + 3.4704941499999997e-5*x499 + 2.1562743999999999e-6*x500*x550 + 0.00015311135120000001*x500 - 4.4968760000000003e-6*x501 + 0.65217956369329999*x502*x550 - 0.050484721527699998*x502*x551 + 0.0016061902897999999*x502*x552 - 1.23009568e-5*x502*x553 + 5.4283657019531004*x502 - 0.021749987409700001*x503*x550 + 0.0012715116938*x503*x551 - 3.2741474300000002e-5*x503*x552 - 0.063783476515700002*x503 + 0.0001901837358*x504*x550 - 9.4105437999999996e-6*x504*x551 + 0.013330079761100001*x504 - 5.5285418999999996e-6*x505*x550 - 0.00027119803169999999*x505 + 2.9662535000000002e-6*x506 - 0.0099310448876000004*x507*x550 + 0.000450542098*x507*x551 - 1.2332561399999999e-5*x507*x552 - 3.9627091042916001*x507 + 0.00049523192299999995*x508*x550 + 5.8076977699999998e-5*x508*x551 + 0.018026677275599999*x508 + 4.15462625e-5*x509*x550 - 0.0026947914996999999*x509 + 3.1513558400000001e-5*x510 - 0.00073381158360000004*x511*x550 - 0.00014651520950000001*x511*x551 + 1.2170419193973001*x511 - 0.00036387813799999998*x512*x550 + 0.0029760547547000001*x512 + 9.7334827099999994e-5*x513 + 0.0011345025923*x514*x550 - 0.20926143712279999*x514 - 2.6366922300000002e-5*x515 + 0.0136346787342*x516 - 3.5612899999999997e-8*((x550)*(x550)*(x550)*(x550)*(x550)*(x550)*(x550)*(x550)*(x550)) - 0.118672054406*x550 - 0.050008209197199997*x551 - 0.85938724395099997*x552 + 0.25027983039980001*x553 - 0.0340585153781*x554 + 0.002684927785*x555 - 0.0001252971097*x556 + 3.2291785999999998e-6*x557 - 10.717982853902399)*X(27)*x457
   )) + ((x558 < -2.0 || x559 < 0.47712125 || x560 < -18.0) ? (
      0.0
   )
   : (
      std::pow(10, -3.5355e-9*std::exp((10)*std::log(std::abs(x558))) + 0.0019497087522999999*x558*x559*x578 + 2.5033869e-6*x558*x559*x580 + 2.425819e-7*x558*x559*x581 + 2.74e-11*x558*x559*x584 - 0.25171915905909997*x558*x559 + 0.16154758856199999*x558*x560*x569 + 0.10319386725309999*x558*x560*x571 + 0.0091058356367999995*x558*x560*x573 + 7.0547189099999996e-5*x558*x560*x575 + 0.028910314039899999*x558*x560 + 0.00031554761819999999*x558*x569*x579 + 6.9799317000000001e-6*x558*x569*x580 - 8.3654700000000001e-8*x558*x569*x581 - 0.13936594077190001*x558*x569 + 0.0031773255127*x558*x570*x578 - 2.2029417000000002e-6*x558*x570*x580 + 3.32601e-8*x558*x570*x581 + 1.1211e-9*x558*x570*x582 + 0.40330227063039997*x558*x570 + 7.7272750100000005e-5*x558*x571*x579 + 4.3411179999999998e-7*x558*x571*x580 - 2.2911000000000001e-9*x558*x571*x581 + 0.053531392101600003*x558*x571 + 0.00074114505229999996*x558*x572*x578 - 0.4569416534031*x558*x572 + 7.4963150000000001e-7*x558*x573*x579 + 0.3477567512959*x558*x573 + 1.1028151899999999e-5*x558*x574*x578 - 0.11816708728189999*x558*x574 + 0.019397806516399999*x558*x575 - 0.0012520513382999999*x558*x576 + 0.00089752818999999998*x558*x578 + 8.7854088899999995e-5*x558*x579 - 1.36574957e-5*x558*x580 - 9.4252039999999997e-7*x558*x581 + 2.2287e-8*x558*x582 + 2.0822000000000001e-9*x558*x583 - 1.6900000000000001e-11*x558*x584 - 1.1e-12*x558*x585 - 5.0747599999999997e-8*x558*x590 - 0.092472151351600002*x558*x591 - 0.00022388895510000001*x558*x602 + 0.1098450355633*x558 + 0.0028626466126000002*std::exp((10)*std::log(std::abs(x559))) + 0.036943070713000001*x559*x560*x561 + 9.9116502200000001e-5*x559*x560*x564 + 1.5874459999999999e-7*x559*x560*x566 + 0.0208809736142*x559*x560 + 0.00074934921520000003*x559*x561*x578 - 2.1007040000000002e-6*x559*x561*x580 + 2.3848400000000001e-8*x559*x561*x581 + 1.7461e-9*x559*x561*x582 - 9.6999999999999995e-12*x559*x561*x583 + 0.12448499329609999*x559*x561 + 1.706318e-7*x559*x562*x580 - 2.0289999999999999e-9*x559*x562*x581 - 6.3199999999999999e-11*x559*x562*x582 + 0.0021851183530000001*x559*x562 + 9.2263300000000005e-6*x559*x563*x578 + 5.5200690000000001e-7*x559*x563*x579 - 7.8312e-9*x559*x563*x580 + 9.6999999999999995e-12*x559*x563*x581 + 0.0025381599434999998*x559*x563 - 2.020005e-7*x559*x564*x578 + 1.5340000000000001e-10*x559*x564*x580 - 0.0004386554592*x559*x564 + 9.9660000000000005e-10*x559*x565*x579 + 3.4105511399999997e-5*x559*x565 + 8.7899999999999996e-10*x559*x566*x578 - 5.5643800000000001e-8*x559*x566 - 2.6524680000000001e-7*x559*x567 + 1.29712e-8*x559*x568 + 0.12116895857649999*x559*x578 + 0.0042852113657000004*x559*x579 - 0.00031917813630000003*x559*x580 - 4.8222189999999996e-6*x559*x581 + 4.3293909999999998e-7*x559*x582 - 6.8428000000000004e-9*x559*x583 - 3.6380000000000003e-10*x559*x584 + 1.2200000000000001e-11*x559*x585 - 0.0001724768049*x559*x592 - 1.85014e-8*x559*x593 - 4.3599999999999999e-10*x559*x594 - 2.1681996300000001e-5*x559*x597 - 7.3379559800000005e-5*x559*x598 - 1.2760957e-6*x559*x599 - 3.5007499999999998e-8*x559*x600 + 2.3160339913389998*x559 - 9.0e-13*std::exp((10)*std::log(std::abs(x560))) + 0.0242280835853*x560*x561*x570 - 0.0073688190838000003*x560*x561*x571 + 0.00093238064600000004*x560*x561*x572 + 2.1883406499999999e-5*x560*x561*x573 - 1.1538743700000001e-5*x560*x561*x574 + 0.0027944244039999999*x560*x562*x569 + 0.00066004885729999997*x560*x562*x571 + 8.2064122999999992e-6*x560*x562*x573 + 0.00015823084750000001*x560*x563*x569 + 6.7963485999999997e-6*x560*x563*x570 - 4.6492789999999997e-6*x560*x563*x571 - 1.2901950000000001e-7*x560*x563*x572 + 0.00082868593670000002*x560*x563 + 1.112603e-6*x560*x564*x570 + 1.7737910000000001e-7*x560*x564*x571 - 5.5623862100000002e-5*x560*x564 + 9.0303320000000002e-7*x560*x565*x569 - 4.6753752e-6*x560*x565 - 1.2193400000000001e-8*x560*x566*x569 + 8.5708430000000003e-7*x560*x566 - 4.4505500000000001e-8*x560*x567 + 8.0859999999999998e-10*x560*x568 - 0.21663723691590001*x560*x569 + 0.1920547245942*x560*x570 + 0.11056734301350001*x560*x571 - 0.24899279055580001*x560*x572 + 0.15351117027309999*x560*x573 - 0.046268182456999998*x560*x574 + 0.0069910235136000001*x560*x575 - 0.00042396606349999998*x560*x576 - 2.02893876e-5*x560*x577 - 5.7396302000000004e-6*x560*x595 + 0.032905353185900002*x560 + 9.5462233999999995e-6*x561*x569*x579 + 2.5328600000000001e-7*x561*x569*x580 + 1.2e-9*x561*x569*x581 - 0.51226978719009997*x561*x569 + 0.00056809192320000001*x561*x570*x578 + 0.62437751308199996*x561*x570 + 1.7199399999999999e-8*x561*x571*x580 - 0.37407109166519997*x561*x571 + 4.1850417199999998e-5*x561*x572*x578 + 2.5775619999999998e-7*x561*x572*x579 + 0.11685657299130001*x561*x572 - 0.018009935602*x561*x573 + 0.00098798154369999992*x561*x574 + 2.0669974100000001e-5*x561*x575 + 1.3096201499999999e-5*x561*x579 + 1.7933759000000001e-6*x561*x580 - 2.9679800000000001e-8*x561*x581 - 4.7500000000000001e-10*x561*x582 + 6.1000000000000003e-12*x561*x583 - 2.9999999999999998e-13*x561*x584 - 2.0799999999999999e-11*x561*x589 - 1.7803739999999999e-7*x561*x602 + 0.063963953049699998*x561 - 1.1496e-9*x562*x569*x580 + 5.2320000000000001e-10*x562*x569*x581 + 0.017505307428100001*x562*x569 + 2.5435716e-6*x562*x570*x578 + 5.5091469999999995e-7*x562*x570*x579 - 1.7527e-9*x562*x570*x580 - 0.024079071690400002*x562*x570 + 0.018071886233*x562*x571 + 3.1931600000000003e-8*x562*x572*x578 - 0.0067334926452*x562*x572 + 0.0011495771008*x562*x573 - 7.1535481699999996e-5*x562*x574 + 9.6953757399999995e-5*x562*x578 + 4.3347996999999997e-6*x562*x579 + 3.7136899999999998e-8*x562*x580 + 1.5729999999999999e-10*x562*x581 - 2.5189999999999998e-10*x562*x582 - 9.0e-13*x562*x583 - 0.00042506434070000001*x562*x591 - 0.0020141106596*x562*x603 - 0.0090247676379999996*x562 + 2.7279999999999998e-10*x563*x569*x580 + 0.00013082126980000001*x563*x569 + 1.08747e-8*x563*x570*x579 - 9.8150547299999998e-5*x563*x570 + 1.7071000000000001e-8*x563*x571*x578 + 0.0002125030906*x563*x571 - 3.7537003600000001e-5*x563*x572 - 3.6726384000000002e-6*x563*x573 - 9.1657204000000005e-6*x563*x578 - 8.2257539999999999e-7*x563*x579 - 7.8846999999999995e-9*x563*x580 + 5.4019999999999995e-10*x563*x581 + 1.64e-11*x563*x582 - 0.00078838830499999998*x563*x591 - 1.14912e-7*x563*x606 - 0.0063418789521999998*x563 + 1.5290449999999999e-7*x564*x569*x578 - 1.9481793299999999e-5*x564*x570 + 1.7275312500000001e-5*x564*x571 + 2.6860743999999999e-6*x564*x572 + 9.0077900000000002e-8*x564*x578 + 3.12127e-8*x564*x579 - 1.026e-10*x564*x580 - 2.6600000000000001e-11*x564*x581 - 8.9480000000000001e-9*x564*x606 + 0.00074280899980000003*x564 - 1.8155e-9*x565*x569*x578 + 4.5213379300000001e-5*x565*x569 - 8.7344791e-6*x565*x570 - 1.3962928e-6*x565*x571 + 3.7880400000000001e-8*x565*x578 + 9.688e-10*x565*x579 + 1.1300000000000001e-11*x565*x580 - 6.0539900000000006e-8*x565*x603 - 2.2511410100000002e-5*x565 - 4.928726e-7*x566*x569 + 5.4556329999999998e-7*x566*x570 - 1.7335000000000001e-9*x566*x578 - 6.4400000000000005e-11*x566*x579 + 1.04782484e-5*x566 - 6.3537600000000001e-8*x567*x569 + 1.7300000000000001e-11*x567*x578 - 1.7361e-9*x567*x591 - 2.1144599000000001e-6*x567 + 1.4765149999999999e-7*x568 - 0.23243336161629999*x569*x578 - 0.0060047590352000002*x569*x579 + 0.00040085503570000001*x569*x580 + 7.2740530000000001e-6*x569*x581 - 1.2737000000000001e-9*x569*x583 - 1.7799999999999999e-11*x569*x584 - 0.041127044175299998*x569*x586 - 0.00070136213949999996*x569*x588 - 7.0284000000000003e-9*x569*x593 - 7.2e-12*x569*x594 - 5.9143245999999997e-6*x569*x598 - 1.1470484e-6*x569*x599 - 7.1189999999999999e-10*x569*x600 - 0.0035571581033999999*x569*x601 + 1.1160026329971999*x569 + 0.2431257553817*x570*x578 + 0.0041151083692999996*x570*x579 - 0.00027830134009999998*x570*x580 - 3.1120835000000001e-6*x570*x581 + 7.7286200000000006e-8*x570*x582 + 3.1390000000000002e-10*x570*x583 - 0.16738748127719999*x570*x596 - 0.55519169578280003*x570 - 0.15397014495149999*x571*x578 - 0.0016821148905000001*x571*x579 + 0.00010047376289999999*x571*x580 + 5.953574e-7*x571*x581 - 9.8590000000000008e-9*x571*x582 - 0.00021914885569999999*x571*x588 - 1.1690754000000001e-6*x571*x597 - 2.37214e-8*x571*x598 - 9.4609900000000006e-8*x571*x599 - 0.0020150238596*x571*x601 - 1.0529487515022*x571 + 0.0612481890093*x572*x578 + 0.0004202885447*x572*x579 - 4.5542200000000003e-8*x572*x581 - 0.0001096246207*x572*x587 - 1.27390263e-5*x572*x592 - 0.039115478906500002*x572*x596 + 0.13827178873939999*x572 - 0.014958490725999999*x573*x578 - 5.9086323300000002e-5*x573*x579 + 1.4636716e-6*x573*x580 - 3.3338918999999998e-6*x573*x588 - 0.0001417281462*x573*x601 + 1.0378186719538001*x573 + 0.0020487853523*x574*x578 + 3.5730467999999999e-6*x574*x579 - 0.0012093420751*x574*x596 - 0.83956762642930005*x574 - 0.0001203960609*x575*x578 + 0.28381726714819999*x575 - 0.045602120043099999*x576 - 0.00034135580390000001*x577 - 2.4955399999999999e-8*x578*x595 - 1.5002941e-6*x578*x604 - 0.030726740117700001*x578 - 4.8511999999999998e-8*x579*x604 - 0.0014092586279*x579 - 9.52185e-8*x580*x605 + 0.00019874633390000001*x580 - 1.8476999999999999e-9*x581*x605 + 4.6423740000000004e-6*x581 - 7.9429120000000001e-7*x582 - 1.0256300000000001e-8*x583 + 1.4564000000000001e-9*x584 + 7.7999999999999999e-12*x585 - 0.0142476868124*x586 - 0.0020219335184000001*x587 - 0.000655172836*x588 - 1.821314e-7*x589 - 1.88829785e-5*x590 - 27.169728828167202)*X(30)*x457
   )) + ((x377) ? (
      dustSemenov_cooling
   )
   : (
      0
   )) + ((X(16) >= 1.0000000000000001e-15) ? (
      -3.0219623423999999e-20*X(16)*x383/(-2.8000000000000003e-6*x380 - 5.7954876805999204e-10*x382 - x383 - 2.3999999999999999e-6)
   )
   : (
      0
   )) + ((X(21) >= 1.0000000000000001e-15) ? (
      2.7161410787712002e-16*x390*(-x384*x385 - x386*x387) + 9.0605684176581105e-16*x390*(-1.2999999999999999e-11*((x379)*(x379))*1.0/x8*std::exp(-38603.200000000004*x10) + x387*x389)
   )
   : (
      0
   )) + ((X(22) >= 1.0000000000000001e-15) ? (
      2.8261864559999996e-18*x415*(-x396*x405 - x410*x411) + 2.4852256297992001e-19*x415*(x405*x414 - x410*x413)
   )
   : (
      0
   )) + ((X(17) >= 1.0000000000000001e-15) ? (
      2.6177086079999999e-22*x456*(-x427*x440 - x450*x451) + 1.4538225266597305e-21*x456*(x440*x455 - x450*x454)
   )
   : (
      0
   )))
)
: (
   0
)) + 0.00084373771595996178*x8*(1.3806479999999999e-16*X(0) + 1.3806479999999999e-16*X(1) + 1.3806479999999999e-16*X(10) + 1.3806479999999999e-16*X(11) + 1.3806479999999999e-16*X(12) + 1.3806479999999999e-16*X(13) + 1.3806479999999999e-16*X(14) + 1.3806479999999999e-16*X(15) + 1.3806479999999999e-16*X(16) + 1.3806479999999999e-16*X(17) + 1.3806479999999999e-16*X(18) + 1.3806479999999999e-16*X(19) + 1.3806479999999999e-16*X(2) + 1.3806479999999999e-16*X(20) + 1.3806479999999999e-16*X(21) + 1.3806479999999999e-16*X(22) + 1.3806479999999999e-16*X(23) + 1.3806479999999999e-16*X(24) + 1.3806479999999999e-16*X(25) + 1.3806479999999999e-16*X(26) + 1.3806479999999999e-16*X(27) + 1.3806479999999999e-16*X(28) + 1.3806479999999999e-16*X(29) + 1.3806479999999999e-16*X(3) + 1.3806479999999999e-16*X(30) + 1.3806479999999999e-16*X(31) + 1.3806479999999999e-16*X(32) + 1.3806479999999999e-16*X(33) + 1.3806479999999999e-16*X(4) + 1.3806479999999999e-16*X(5) + 1.3806479999999999e-16*X(6) + 1.3806479999999999e-16*X(7) + 1.3806479999999999e-16*X(8) + 1.3806479999999999e-16*X(9))/(std::sqrt(x1)*x46)));
}


AMREX_GPU_HOST_DEVICE AMREX_INLINE
Real interpolate_2d(Real const x, Real const y, const Array1D<Real, 1, 10>& xArray, const Array1D<Real, 1, 1000>& yArray, const Array2D<Real, 1, 10, 1, 1000>& zArray) {

    // Helper function to perform binary search
    auto binary_search = [](const auto& arr, Real value) {
        int low = 1;
        int high = arr.size();
        while (low <= high) {
            int mid = low + (high - low) / 2;
            if (value < arr(mid)) {
                high = mid - 1;
            } else if (value > arr(mid + 1)) {
                low = mid + 1;
            } else {
                return std::make_pair(mid, mid + 1);
            }
        }
        // If the exact range is not found, return the closest valid indices
        return std::make_pair(high, high + 1);
    };

    // Find the right x indices using binary search
    auto [x1_idx, x2_idx] = binary_search(xArray, x);

    // Find the right y indices using binary search
    auto [y1_idx, y2_idx] = binary_search(yArray, y);

    // Interpolate in x direction
    Real x1 = xArray(x1_idx);
    Real x2 = xArray(x2_idx);

    Real z_x1_y1 = zArray(x1_idx, y1_idx);
    Real z_x2_y1 = zArray(x2_idx, y1_idx);
    Real z_x_y1 = (z_x2_y1 - z_x1_y1) / (x2 - x1) * (x - x1) + z_x1_y1;

    Real z_x1_y2 = zArray(x1_idx, y2_idx);
    Real z_x2_y2 = zArray(x2_idx, y2_idx);
    Real z_x_y2 = (z_x2_y2 - z_x1_y2) / (x2 - x1) * (x - x1) + z_x1_y2;

    // Interpolate in y direction
    Real y1 = yArray(y1_idx);
    Real y2 = yArray(y2_idx);
    Real z_xy = (z_x_y2 - z_x_y1) / (y2 - y1) * (y - y1) + z_x_y1;

    return z_xy;
}

AMREX_GPU_HOST_DEVICE AMREX_INLINE
std::pair<Real, Real> compute_Semenov_Tdust(Real Tgas, const Array1D<Real, 0, NumSpec-1>& composition, Real const user_dust2gas_ratio, Real const z,
                                                Real krome_Semenov_Tdust, Array1D<Real, 1, 10>& s_x, Array1D<Real, 1, 1000>& s_y,
                                                Array2D<Real, 1, 10, 1, 1000>& s_z) {

    Real dustSemenov_cooling = 0.0;

    if (user_dust2gas_ratio == 0) {
        return std::make_pair(krome_Semenov_Tdust, dustSemenov_cooling);
    }

    Tgas = std::max(Tgas, 2.73 * (1.0 + z));

    Array1D<Real, 0, NumSpec-1> mass;
    mass(0)  = 0.0;
    mass(1)  = 0.0;
    mass(2)  = 9.10938188e-28;
    mass(3)  = 1.67262158e-24;
    mass(4)  = 1.673532518188e-24;
    mass(5)  = 1.6744434563759998e-24;
    mass(6)  = 3.34512158e-24;
    mass(7)  = 3.346032518188e-24;
    mass(8)  = 3.346154098188e-24;
    mass(9)  = 3.346943456376e-24;
    mass(10) = 3.347065036376e-24;
    mass(11) = 5.0186540981880006e-24;
    mass(12) = 5.0195650363760004e-24;
    mass(13) = 6.690243159999999e-24;
    mass(14) = 6.691154098188e-24;
    mass(15) = 6.692065036376e-24;
    mass(16) = 2.007528417094e-23;
    mass(17) = 2.0076195109128e-23;
    mass(18) = 2.1749727627316e-23;
    mass(19) = 2.3423260145503998e-23;
    mass(20) = 2.5096792663692e-23;
    mass(21) = 2.6767349207316e-23;
    mass(22) = 2.6768260145504e-23;
    mass(23) = 2.677032518188e-23;
    mass(24) = 2.8440881725504e-23;
    mass(25) = 2.8441792663692003e-23;
    mass(26) = 3.0114414243692e-23;
    mass(27) = 3.011532518188e-23;
    mass(28) = 3.178794676188e-23;
    mass(29) = 4.6843544316444e-23;
    mass(30) = 4.6844455254632e-23;
    mass(31) = 5.353560935282e-23;
    mass(32) = 5.3536520291008e-23;
    mass(33) = 7.3612715400136e-23;

    Real rhogas = 0.0;
    Real sum_comp = 0.0;
    for (int i = 0; i < NumSpec; ++i) {
        rhogas += composition(i) * mass(i);
        sum_comp += composition(i);
    }
    rhogas = std::max(rhogas, 1e-40);

    Real nH = 0.0;
    nH = composition(3) + composition(4) + composition(5) + composition(10) * 2.0 + composition(8) * 2.0 +
         composition(25) + composition(18) + composition(19) * 2.0 + composition(20) * 3.0 +
         composition(23) * 4.0 + composition(24) + composition(26) * 2.0 +
         composition(28) * 3.0 + composition(11) + composition(12) + composition(1) * 2.0;

    //std::cout << "compute semenov tdust nH: " << nH << std::endl;

    Real clipped_x = std::max(-18.0, std::min(std::log10(rhogas), -7.0));
    Real clipped_y = std::max(1e1, std::min(Tgas, 1e4));

    auto kappaP = interpolate_2d(clipped_x, clipped_y, s_x, s_y, s_z);
    //std::cout << "compute semenov clipx = " << clipped_x << ", clipy = " << clipped_y << ", " << "kappaP = " << kappaP << std::endl;

    Real mu = rhogas / std::max(sum_comp, 1e-40) * (1.0/C::m_p);
    Real ljeans = std::sqrt(M_PI * C::k_B * Tgas / rhogas / C::m_p / C::Gconst / mu);

    Real tau_d = rhogas * kappaP * user_dust2gas_ratio;
    Real tau_g = 0.0;
    Real tau = (tau_d + tau_g) * ljeans;

    Real besc = (tau < 1.0) ? 1.0 : amrex::Math::powi<-2>(tau);

    Real const alpha_gd = 3.2e-34;
    Real const aR = 4 * C::sigma_SB / C::c_light;

    kappaP *= besc;

    Real intJRad = 0.0;

    Real A = rhogas * kappaP * user_dust2gas_ratio * aR * C::c_light;
    Real B = std::pow(Tgas, 0.5) * amrex::Math::powi<2>(nH) * alpha_gd * user_dust2gas_ratio;
    Real phys_Tcmb = 2.73 * (1.0 + z);
    Real C = -1.0 * (intJRad + A * amrex::Math::powi<4>(phys_Tcmb) + std::pow(Tgas, 1.5) * amrex::Math::powi<2>(nH) * alpha_gd * user_dust2gas_ratio);

    Real Tdold = krome_Semenov_Tdust;
    Real Tdnew = 0.0;

    for (int iterr = 0; iterr <= 1001; ++iterr) {
        Real fx = A * amrex::Math::powi<4>(Tdold) + B * Tdold + C;
        Real fdash_x = 4.0 * A * amrex::Math::powi<3>(Tdold) + B;

        Tdnew = Tdold - fx / fdash_x;
        Real rel_t = std::abs((Tdnew - Tdold) / Tdold);
        Real abs_t = std::abs(Tdnew - Tdold);
        Tdold = Tdnew;

        if (abs_t < 1e-8 || rel_t < 1e-5) {
            break;
        }

        if (iterr > 1000) {
            amrex::Error("Maximum iterations reached in dust temperature NR-solver. Tgas = " +
                                     std::to_string(Tgas) +
                                     ", Tdold_start = " +
                                     std::to_string(krome_Semenov_Tdust) +
                                     ", Tdnew = " +
                                     std::to_string(Tdnew));
        }
    }

    dustSemenov_cooling = A * amrex::Math::powi<4>(Tdnew) - intJRad - A * amrex::Math::powi<4>(phys_Tcmb);

    return std::make_pair(Tdnew, dustSemenov_cooling);
}

AMREX_GPU_HOST_DEVICE AMREX_INLINE
void actual_rhs (burn_t& state, Array1D<Real, 1, neqs>& ydot)
{

    Real z = redshift;
    Real Z = metallicity;

    Array1D<Real, 0, NumSpec-1> X;
    for (int i = 0; i < NumSpec; ++i) {
           X(i) = state.xn[i];
    }

    Real krome_Semenov_Tdust = state.aux[0];

    // Call the compute_Semenov_Tdust function
    auto result = compute_Semenov_Tdust(state.T, X, dust2gas_ratio, z, krome_Semenov_Tdust, semenov_x, semenov_y, semenov_z);
    // compute Tdust
    Real Tdust = result.first;
    // store Tdust in aux
    state.aux[0] = result.first;
    Real dustSemenov_cooling = result.second;

    // YDOTS

    rhs_specie(state, ydot, X, crate, Av, ionH, ionH2, dissH2,
               ionC, ionO, dissCO, dust2gas_ratio, Tdust, z);

    // Edot

    Real edot = rhs_eint(state, X, crate, Av, ionH, ionH2, dissH2,
                         ionC, ionO, dissCO, dust2gas_ratio, Tdust, dustSemenov_cooling, z, Z);

    // Append the energy equation (this is erg/g/s)

    ydot(net_ienuc) = edot;

}


template<class MatrixType>
AMREX_GPU_HOST_DEVICE AMREX_INLINE
void actual_jac(const burn_t& state, MatrixType& jac)
{

    Array1D<Real, 0, NumSpec-1> X;
    for (int i = 0; i < NumSpec; ++i) {
        X(i) = state.xn[i];
    }

    // initialize
    jac.zero();

}


AMREX_INLINE
void actual_rhs_init () {


}


#endif
