#include <AMReX_Array.H>
#include <string>
#include <table_rates.H>
#include <AMReX_Print.H>

#include <partition_functions.H>

namespace part_fun {

    // this is T9

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> temp_array_1= {
        0.01, 0.15, 0.2, 0.3, 0.4,
        0.5, 0.6, 0.7, 0.8, 0.9,
        1.0, 1.5, 2.0, 2.5, 3.0,
        3.5, 4.0, 4.5, 5.0, 6.0,
        7.0, 8.0, 9.0, 10.0, 12.0,
        14.0, 16.0, 18.0, 20.0, 22.0,
        24.0, 26.0, 28.0, 30.0, 35.0,
        40.0, 45.0, 50.0, 55.0, 60.0,
        65.0, 70.0, 75.0, 80.0, 85.0,
        90.0, 95.0, 100.0, 105.0, 110.0,
        115.0, 120.0, 125.0, 130.0, 135.0,
        140.0, 145.0, 150.0, 155.0, 160.0,
        165.0, 170.0, 175.0, 180.0, 190.0,
        200.0, 210.0, 220.0, 230.0, 240.0,
        250.0, 275.0,
    };


    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> O16_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.012837224705172217,
        0.037426497940623665, 0.07188200730612536, 0.12057393120584989, 0.1846914308175988, 0.26245108973042947,
        0.3463529744506387, 0.437750562820388, 0.534026106056135, 0.6344772701607315, 0.8981764834976765,
        1.1760912590556813, 1.4668676203541096, 1.7641761323903307, 2.0644579892269186, 2.367355921026019,
        2.667452952889954, 2.9656719712201065, 3.2624510897304293, 3.5550944485783194, 3.845098040014257,
        4.133538908370218, 4.419955748489758, 4.704150516839799, 4.986771734266245, 5.267171728403014,
        5.547774705387822, 5.8267225201689925, 6.103803720955957, 6.380211241711606, 6.6551384348113825,
        6.929929560084588, 7.204119982655925, 7.477121254719663, 7.748962861256161, 8.021189299069938,
        8.292256071356476, 8.562292864456476, 8.832508912706237, 9.100370545117563, 9.640481436970422,
        10.178976947293169, 10.714329759745233, 11.250420002308894, 11.785329835010767, 12.320146286111054,
        12.856124444242301, 14.195899652409233,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Ne20_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 6.9486561213582446e-06, 0.00016586881316040883, 0.0011034421778731533, 0.003892457497077877,
        0.00954097493969645, 0.01859524021829981, 0.031075444833369822, 0.04661767038571622, 0.0846241727916796,
        0.12822183093465686, 0.174311933665943, 0.22124805254602342, 0.2683385291343481, 0.36172783601759284,
        0.456366033129043, 0.5514499979728752, 0.6483600109809317, 0.7466341989375788, 0.8481891169913987,
        0.9532763366673044, 1.0644579892269184, 1.1789769472931695, 1.3031960574204888, 1.6434526764861874,
        2.0170333392987803, 2.4099331233312946, 2.8068580295188172, 3.2013971243204513, 3.5899496013257077,
        3.9731278535996988, 4.352182518111363, 4.725911632295048, 5.096910013008056, 5.465382851448418,
        5.830588668685144, 6.193124598354461, 6.556302500767287, 6.916980047320382, 7.276461804173244,
        7.6344772701607315, 7.991669007379948, 8.348304863048162, 8.703291378118662, 9.056904851336473,
        9.411619705963231, 9.763427993562937, 10.117271295655764, 10.46686762035411, 10.818225893613956,
        11.170261715394957, 11.519827993775719, 11.869231719730976, 12.217483944213907, 12.916453948549925,
        13.613841821876068, 14.3096301674259, 15.004321373782643, 15.702430536445526, 16.399673721481037,
        17.096910013008056, 18.838849090737256,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Na23_pf_array = {
        0.0, 0.0, 0.0, 0.0, 1.737174453219938e-06,
        2.3885539658322847e-05, 0.00013113713282427166, 0.0004423207528904243, 0.0010999766245234138, 0.0022321731976362837,
        0.003929471989446119, 0.021128907257497758, 0.0479649055541949, 0.07726249885377773, 0.10525805048344758,
        0.13079227003361296, 0.15390201926318714, 0.17503899265296466, 0.19472325248715508, 0.23147162936712465,
        0.26668504599022796, 0.3016913566252569, 0.33713446730536967, 0.37335950050705796, 0.4487063199050799,
        0.5314789170422551, 0.6211762817750351, 0.7218106152125465, 0.8344207036815325, 0.9590413923210935,
        1.0934216851622351, 1.2405492482825997, 1.3926969532596658, 1.551449997972875, 1.9628426812012425,
        2.383815365980431, 2.803457115648414, 3.220108088040055, 3.6344772701607315, 4.045322978786658,
        4.453318340047038, 4.857935264719429, 5.26245108973043, 5.664641975556125, 6.064457989226918,
        6.466867620354109, 6.867467487859051, 7.267171728403014, 7.666517980554881, 8.064457989226918,
        8.463892988985908, 8.861534410859038, 9.260071387985075, 9.656098202012831, 10.05307844348342,
        10.450249108319362, 10.846337112129806, 11.243038048686294, 11.638489256954637, 12.03342375548695,
        12.429752280002408, 12.826074802700827, 13.222716471147583, 13.6170003411209, 14.40823996531185,
        15.20139712432045, 15.993876914941211, 16.787460474518415, 17.582063362911708, 18.378397900948137,
        19.17609125905568, 21.173186268412273,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Mg24_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        4.3429426472042774e-07, 5.471765757979972e-05, 0.0007714899373308072, 0.0037633124724497638, 0.010764115210255056,
        0.022625058328435317, 0.039160607597355665, 0.05951911533271758, 0.08262238957783377, 0.13324118689139802,
        0.185518640557017, 0.2370005304649223, 0.2870228837145503, 0.3357157930198095, 0.43136376415898736,
        0.526339277389844, 0.6253124509616739, 0.7307822756663892, 0.8463371121298052, 0.9749719942980689,
        1.1172712956557642, 1.2741578492636798, 1.4424797690644486, 1.6232492903979006, 2.103803720955957,
        2.598790506763115, 3.089905111439398, 3.5774917998372255, 4.05307844348342, 4.52244423350632,
        4.984527313343793, 5.440909082065217, 5.894869656745253, 6.344392273685111, 6.791690649020118,
        7.235528446907549, 7.678518379040114, 8.12057393120585, 8.558708570533165, 8.99563519459755,
        9.431363764158988, 9.866287339084195, 10.301029995663981, 10.732393759822969, 11.164352855784436,
        11.594392550375426, 12.02530586526477, 12.453318340047037, 12.881384656770573, 13.3096301674259,
        13.736396502276643, 14.161368002234974, 14.588831725594208, 15.012837224705173, 15.86569605991607,
        16.715167357848458, 17.56466606425209, 18.413299764081252, 19.26245108973043, 20.113943352306837,
        20.96284268120124, 23.089905111439396,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Al27_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 8.685880952436748e-07, 3.4743419578801875e-06,
        1.0422942490878872e-05, 0.00032429686817590634, 0.0018833542475028369, 0.005477808032249926, 0.011239204769804155,
        0.018904286378932662, 0.028126564553716336, 0.03862016194970278, 0.05018673657450416, 0.07608019569340022,
        0.10530099179798433, 0.13774106877747655, 0.1734986149135784, 0.2127888058397363, 0.30319605742048883,
        0.4099331233312945, 0.5352941200427705, 0.6794278966121189, 0.8394780473741984, 1.0128372247051722,
        1.1958996524092338, 1.3873898263387294, 1.5843312243675307, 1.783903579272735, 2.287801729930226,
        2.7944880466591697, 3.296665190261531, 3.7944880466591697, 4.2878017299302265, 4.779596491257824,
        5.269512944217916, 5.7558748556724915, 6.2405492482825995, 6.725094521081469, 7.209515014542631,
        7.691081492122969, 8.173186268412275, 8.653212513775344, 9.133538908370218, 9.611723308007342,
        10.089905111439398, 10.568201724066995, 11.045322978786658, 11.521138083704036, 11.997386384397313,
        12.472756449317213, 12.947923619831727, 13.423245873936807, 13.89707700320942, 14.371067862271737,
        14.845098040014257, 15.320146286111054, 15.79309160017658, 16.267171728403014, 17.214843848047696,
        18.161368002234976, 19.110589710299248, 20.060697840353612, 21.012837224705173, 21.96284268120124,
        22.915927211697117, 25.305351369446623,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Si28_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 2.1714669808675565e-06, 7.121845527843468e-05, 0.0005624812393818786, 0.002223099674110693,
        0.0059171580771474625, 0.01228240711882553, 0.021577095617092278, 0.03370716078346824, 0.06502557053071237,
        0.10275227725738852, 0.14387160800291654, 0.18660350439861528, 0.23028079132683374, 0.3222192947339193,
        0.42324587393680785, 0.541579243946581, 0.6839471307515121, 0.8518696007297664, 1.0413926851582251,
        1.250420002308894, 1.4727564493172123, 1.7024305364455252, 1.9375178920173466, 2.531478917042255,
        3.12057393120585, 3.7024305364455254, 4.271841606536499, 4.834420703681532, 5.389166084364533,
        5.937517892017347, 6.481442628502305, 7.021189299069938, 7.557507201905658, 8.089905111439398,
        8.622214022966295, 9.14921911265538, 9.675778341674086, 10.198657086954423, 10.721810615212547,
        11.2405492482826, 11.75966784468963, 12.276461804173245, 12.791690649020119, 13.305351369446624,
        13.818225893613956, 14.330413773349191, 14.840733234611807, 15.350248018334163, 15.85913829729453,
        16.367355921026018, 16.8750612633917, 17.38201704257487, 17.88874096068289, 18.90036712865647,
        19.911157608739977, 20.921166050637737, 21.9304395947667, 22.93951925261862, 23.948901760970212,
        24.958563883221967, 27.48572142648158,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> P31_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        4.3429426472042774e-07, 4.820401221806151e-05, 0.0005624812393818786, 0.002468018295084159, 0.006670091319158333,
        0.013688955408210905, 0.023674199668938998, 0.0365510506801258, 0.05215275629691827, 0.09085986215557586,
        0.13887811232360858, 0.19608052467040618, 0.2628929908553992, 0.33982852740425823, 0.5237464668115644,
        0.7419390777291989, 0.9827233876685453, 1.235528446907549, 1.4899584794248346, 1.7442929831226763,
        1.9960736544852753, 2.24551266781415, 2.4913616938342726, 2.733999286538387, 3.330413773349191,
        3.9132839017604186, 4.48572142648158, 5.049218022670182, 5.608526033577194, 6.164352855784437,
        6.714329759745233, 7.264817823009537, 7.812913356642856, 8.359835482339887, 8.90687353472207,
        9.453318340047037, 9.997823080745725, 10.54282542695918, 11.086359830674748, 11.629409599102718,
        12.170261715394957, 12.712649701627212, 13.255272505103306, 13.79448804665917, 14.334453751150932,
        14.874481817699467, 15.414973347970818, 15.953276336667304, 16.492760389026838, 17.029383777685208,
        17.570542939881896, 18.10720996964787, 18.64738297011462, 19.187520720836464, 20.264817823009537,
        21.342422680822207, 22.42160392686983, 23.503790683057183, 24.5854607295085, 25.66931688056611,
        26.75511226639507, 29.477121254719663,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> S32_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 5.211502513843472e-06, 6.948155872801059e-05, 0.0003893875360542875,
        0.001336870159627728, 0.0033782324012585556, 0.00696337755678715, 0.012456734172197396, 0.030114157908450765,
        0.05748428585387722, 0.09500536995017458, 0.14295136988131382, 0.20165707691270435, 0.3521825181113625,
        0.5502283530550941, 0.787460474518415, 1.0569048513364727, 1.3404441148401183, 1.631443769013172,
        1.92272545799326, 2.2121876044039577, 2.4955443375464483, 2.7737864449811935, 3.44870631990508,
        4.096910013008056, 4.726727209026572, 5.3404441148401185, 5.944975908412048, 6.541579243946581,
        7.133538908370218, 7.720985744153739, 8.305351369446624, 8.888740960682892, 9.469822015978163,
        10.049218022670182, 10.628388930050312, 11.20682587603185, 11.78175537465247, 12.356025857193123,
        12.9304395947667, 13.502427119984432, 14.075546961392531, 14.645422269349092, 15.214843848047698,
        15.783903579272735, 16.352182518111363, 16.920123326290724, 17.487138375477187, 18.053078443483418,
        18.621176281775035, 19.187520720836464, 19.753583058892907, 20.318063334962762, 21.450249108319362,
        22.580924975675618, 23.71264970162721, 24.84385542262316, 25.976808337338067, 27.110589710299248,
        28.24551266781415, 31.08635983067475,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Cl35_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 1.8239985202970884e-05, 0.00020710907627919203, 0.0009431313908907785, 0.002698987769012708,
        0.005906875936599731, 0.010907713111778477, 0.017957319425972694, 0.027253766962590423, 0.0532486689285615,
        0.09021853774459236, 0.13964204799692437, 0.20296975189964025, 0.28111453407611076, 0.48000694295715063,
        0.7234556720351858, 0.9934362304976118, 1.2741578492636798, 1.5587085705331658, 1.841984804590114,
        2.123851640967086, 2.401400540781544, 2.678518379040114, 2.951823035315912, 3.6263403673750423,
        4.2878017299302265, 4.942008053022313, 5.588831725594207, 6.230448921378274, 6.870988813760575,
        7.509202522331103, 8.146128035678238, 8.781036938621131, 9.414973347970818, 10.049218022670182,
        10.681241237375588, 11.313867220369154, 11.943988875073773, 12.574031267727719, 13.204119982655925,
        13.831229693867064, 14.457881896733992, 15.086359830674748, 15.710963118995275, 16.33645973384853,
        16.96189547366785, 17.586587304671756, 18.212187604403958, 18.835056101720117, 19.45939248775923,
        20.08278537031645, 20.705863712283918, 21.33041377334919, 21.95375969173323, 23.20139712432045,
        24.450249108319362, 25.699837725867244, 26.950364854376122, 28.20139712432045, 29.456366033129044,
        30.71264970162721, 33.862131379313034,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Ar36_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 4.3429426472042774e-07, 2.3451268844214655e-05, 0.00023141729162330258, 0.0010622869460975197,
        0.0031540913067783544, 0.007135153007315866, 0.013474284663478431, 0.02245187936733961, 0.048771089883939175,
        0.08643600351808534, 0.13560900039779808, 0.1965840257248699, 0.2696980636423851, 0.45331834004703764,
        0.6848453616444125, 0.9585638832219674, 1.2624510897304295, 1.5809249756756194, 1.9057958803678685,
        2.230448921378274, 2.550228353055094, 2.8662873390841948, 3.1760912590556813, 3.929418925714293,
        4.657055852857104, 5.365487984890899, 6.060697840353612, 6.746634198937579, 7.426511261364575,
        8.100370545117563, 8.773054693364262, 9.442479769064448, 10.11058971029925, 10.77451696572855,
        11.437750562820389, 12.100370545117563, 12.758911892397974, 13.41664050733828, 14.071882007306126,
        14.727541257028557, 15.38201704257487, 16.03342375548695, 16.684845361644413, 17.33445375115093,
        17.983626287124533, 18.63144376901317, 19.27875360095283, 19.92582757462474, 20.57170883180869,
        21.217483944213907, 21.863322860120455, 22.50785587169583, 23.152288344383056, 24.440909082065218,
        25.72916478969277, 27.01703333929878, 28.305351369446623, 29.595496221825574, 30.885926339801433,
        32.17897694729317, 35.41329976408125,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> K39_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 3.908632748276029e-06, 3.4307908925770636e-05,
        0.00016282990201490303, 0.000539492815639634, 0.0014074368520356397, 0.0031075244141559894, 0.010846721573671133,
        0.028297088943748088, 0.060956829214686044, 0.11414775667614005, 0.1912997955319451, 0.4132997640812518,
        0.7015679850559274, 1.0170333392987803, 1.3384564936046048, 1.6599162000698502, 1.9772662124272926,
        2.292256071356476, 2.6020599913279625, 2.910090545594068, 3.214843848047698, 3.9684829485539352,
        4.710963118995275, 5.444044795918076, 6.173186268412274, 6.897627091290442, 7.619093330626742,
        8.338456493604605, 9.056904851336473, 9.771587480881255, 10.48572142648158, 11.198657086954423,
        11.907948521612273, 12.6170003411209, 13.324282455297693, 14.02938377768521, 14.733999286538387,
        15.437750562820389, 16.139879086401237, 16.839478047374197, 17.539076098792776, 18.238046103128795,
        18.936513742478894, 19.633468455579585, 20.33041377334919, 21.02530586526477, 21.723455672035186,
        22.418301291319747, 23.113943352306837, 23.809559714635267, 24.505149978319906, 25.89542254603941,
        27.285557309007775, 28.678518379040113, 30.071882007306126, 31.465382851448418, 32.860936620700095,
        34.25767857486918, 37.761927838420526,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Ca40_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 3.4743419578801875e-06,
        2.6056887215373325e-05, 0.00012419046343446514, 0.0004254001802063995, 0.0011532564515138496, 0.005324252203746658,
        0.016451245325404363, 0.039380405510556264, 0.07909980819723089, 0.1397280011737941, 0.33041377334919086,
        0.6063813651106049, 0.9385197251764918, 1.2988530764097066, 1.6693168805661123, 2.037426497940624,
        2.403120521175818, 2.761927838420529, 3.113943352306837, 3.459392487759231, 4.301029995663981,
        5.117271295655764, 5.9148718175400505, 6.701567985055927, 7.478566495593843, 8.250420002308894,
        9.01703333929878, 9.781036938621131, 10.540329474790873, 11.296665190261532, 12.049218022670182,
        12.801403710017356, 13.549003262025789, 14.294466226161592, 15.037426497940624, 15.779596491257825,
        16.518513939877888, 17.255272505103306, 17.99211148778695, 18.72591163229505, 19.45939248775923,
        20.19033169817029, 20.920645001406786, 21.650307523131936, 22.378397900948137, 23.10720996964787,
        23.832508912706235, 24.558708570533167, 25.285557309007775, 26.008600171761916, 27.45939248775923,
        28.907948521612273, 30.356025857193124, 31.804820678721164, 33.25285303097989, 34.704150516839796,
        36.15533603746506, 39.78816837114117,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Sc43_pf_array = {
        0.0, 1.737174453219938e-06, 3.213660262116793e-05, 0.0006088881229004689, 0.0026394223512168323,
        0.006348788305828209, 0.011375876688411649, 0.017242084547645732, 0.02355944464942603, 0.030067962575438752,
        0.03661053325876141, 0.06810122175372875, 0.09804672309111767, 0.12848424511267922, 0.16058766813472455,
        0.1946644458530261, 0.23055748142930874, 0.2679262754358927, 0.3064134462100847, 0.3856843680943845,
        0.4672642331672854, 0.5514418243762168, 0.6393550853495756, 0.7324654125012992, 0.9380190974762103,
        1.1760912590556813, 1.4456042032735976, 1.7371926427047373, 2.0453229787866576, 2.359835482339888,
        2.678518379040114, 3.0, 3.322219294733919, 3.6424645202421213, 4.439332693830263,
        5.230448921378274, 6.017033339298781, 6.8020892578817325, 7.585460729508501, 8.36735592102602,
        9.14921911265538, 9.929418925714293, 10.710117365111817, 11.489958479424836, 12.267171728403014,
        13.045322978786658, 13.822168079368018, 14.597695185925513, 15.371067862271737, 16.146128035678238,
        16.916453948549925, 17.687528961214635, 18.45788189673399, 19.227886704613674, 19.99694924849538,
        20.76492298464989, 21.532754378992497, 22.30102999566398, 23.068185861746162, 23.835690571492425,
        24.602059991327963, 25.369215857410143, 26.136720567156406, 26.903632516084237, 28.439332693830263,
        29.97497199429807, 31.511883360978874, 33.05307844348342, 34.59217675739587, 36.13672056715641,
        37.68214507637383, 41.55870857053316,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Ti44_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 4.3429426472042774e-07, 1.737174453219938e-06,
        7.382943437485088e-06, 0.0004987179011085027, 0.004043078170724821, 0.01413521502778782, 0.032426549056877405,
        0.058561151016688254, 0.09131586357749837, 0.1294359425571275, 0.17190802974603506, 0.2667731684215763,
        0.37035022176288673, 0.47788465213962983, 0.5860935485551829, 0.693748838923791, 0.9116901587538612,
        1.1522883443830565, 1.4409090820652177, 1.7788744720027396, 2.1522883443830563, 2.5415792439465807,
        2.9334872878487053, 3.322219294733919, 3.7041505168397992, 4.079181246047625, 4.996073654485276,
        5.885361220031512, 6.757396028793024, 7.619093330626742, 8.472756449317213, 9.32221929473392,
        10.167317334748176, 11.008600171761918, 11.85003325768977, 12.687528961214634, 13.52244423350632,
        14.354108439147401, 15.1846914308176, 16.012837224705173, 16.836956737059552, 17.65991620006985,
        18.481442628502304, 19.298853076409706, 20.117271295655765, 20.9329808219232, 21.746634198937578,
        22.559906625036113, 23.371067862271737, 24.181843587944773, 24.991226075692495, 25.799340549453582,
        26.60745502321467, 27.414973347970818, 28.220108088040057, 29.02530586526477, 30.63748972951251,
        32.247973266361804, 33.8561244442423, 35.46538285144842, 37.07554696139253, 38.68484536164441,
        40.29666519026153, 44.33041377334919,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> V47_pf_array = {
        2.518834949526704e-05, 0.0007584840322833457, 0.004226764680268442, 0.024475815916759108, 0.05998274311239668,
        0.1028026649155908, 0.14672973694476377, 0.18852098344730983, 0.22688178294786618, 0.2615226538586488,
        0.29260868165003595, 0.4071409645052156, 0.48021742410342627, 0.5329079468954852, 0.5750746363992424,
        0.6115960803783954, 0.6450760714077263, 0.6770396273057074, 0.708482088001612, 0.7725618227871047,
        0.8417322779915452, 0.9194240819892174, 1.0083997539725875, 1.110602503281611, 1.3560258571931227,
        1.651278013998144, 1.9813655090785445, 2.330413773349191, 2.6884198220027105, 3.0492180226701815,
        3.41161970596323, 3.7708520116421442, 4.127104798364807, 4.484299839346786, 5.365487984890899,
        6.238046103128795, 7.103803720955957, 7.967547976218862, 8.830588668685145, 9.69460519893357,
        10.557507201905658, 11.421603926869832, 12.285557309007773, 13.146128035678238, 14.008600171761918,
        14.869231719730976, 15.728353782021228, 16.586587304671756, 17.442479769064448, 18.298853076409706,
        19.152288344383056, 20.00432137378264, 20.85793526471943, 21.70926996097583, 22.559906625036113,
        23.409933123331296, 24.260071387985075, 25.10720996964787, 25.956648579205204, 26.804820678721164,
        27.652246341003323, 28.50105926221775, 29.34830486304816, 30.195899652409235, 31.891537457672566,
        33.588831725594204, 35.28555730900777, 36.985875357308394, 38.68752896121463, 40.39093510710338,
        42.096910013008056, 46.372912002970104,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Cr48_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 8.685880952436748e-07, 8.251516766996927e-06, 3.951899976600419e-05, 0.00013330794422173613,
        0.00035120219371925006, 0.006401856055765157, 0.02685304570895992, 0.0621531182513584, 0.10696594975266842,
        0.15598699109465686, 0.20581584444582904, 0.25471214514215257, 0.30198352738731143, 0.39152612205819926,
        0.47640596203905256, 0.5602400543128645, 0.6474755901642433, 0.7433846322638775, 0.983175072037813,
        1.3096301674258988, 1.7067177823367587, 2.1398790864012365, 2.5774917998372255, 3.012837224705172,
        3.437750562820388, 3.8549130223078554, 4.264817823009537, 4.666517980554881, 5.648360010980932,
        6.606381365110605, 7.550228353055094, 8.484299839346786, 9.414973347970818, 10.340444114840118,
        11.264817823009537, 12.1846914308176, 13.103803720955957, 14.021189299069938, 14.935003151453655,
        15.846337112129806, 16.75511226639507, 17.66181268553726, 18.565847818673518, 19.468347330412158,
        20.369215857410143, 21.267171728403014, 22.161368002234976, 23.056904851336473, 23.94939000664491,
        24.840733234611807, 25.73078227566639, 26.619093330626743, 27.50785587169583, 28.394451680826215,
        29.281033367247726, 30.164352855784436, 31.049218022670182, 31.934498451243567, 33.70156798505593,
        35.46834733041216, 37.23299611039215, 38.99913054128737, 40.764922984649886, 42.5327543789925,
        44.30102999566398, 48.727541257028555,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Mn51_pf_array = {
        0.0, 0.0, 4.3429426472042774e-07, 6.0362737871404116e-05, 0.0005954436481690332,
        0.0023527034524912656, 0.0058636025937444025, 0.011219737158250307, 0.018191443590229183, 0.026405776501228783,
        0.035473365577059296, 0.08393991903492294, 0.12694077261184436, 0.1626799839654217, 0.19356340377635364,
        0.22185561141496238, 0.24912127857304392, 0.27638918590325057, 0.30436276263857276, 0.36442247019537943,
        0.4326074417788098, 0.5117005179251304, 0.6041057952026397, 0.7115562776994953, 0.9717395908877783,
        1.287801729930226, 1.640481436970422, 2.0170333392987803, 2.403120521175818, 2.7944880466591697,
        3.1903316981702914, 3.5854607295085006, 3.9827233876685453, 4.380211241711606, 5.372912002970106,
        6.363611979892144, 7.354108439147401, 8.342422680822207, 9.328379603438737, 10.311753861055754,
        11.292256071356476, 12.269512944217917, 13.24551266781415, 14.214843848047698, 15.1846914308176,
        16.14921911265538, 17.110589710299248, 18.071882007306126, 19.029383777685208, 19.985426474083003,
        20.93851972517649, 21.88986172125819, 22.839478047374197, 23.787460474518415, 24.73399928653839,
        25.67942789661212, 26.6232492903979, 27.56702636615906, 28.5092025223311, 29.45178643552429,
        30.392696953259666, 31.33445375115093, 32.27415784926368, 33.2148438480477, 35.093421685162234,
        36.97451169273733, 38.8555191556678, 40.737192642704734, 42.620136054973756, 44.505149978319906,
        46.392696953259666, 51.12057393120585,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Fe52_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 1.737174453219938e-06, 9.554373504133797e-06, 3.778197643341552e-05,
        0.00011333607006293108, 0.0030242952161453874, 0.015422212189991185, 0.040215337130588114, 0.07478865660777631,
        0.11488541698288197, 0.15714990338033966, 0.19960737134331175, 0.24132628928072955, 0.3217032118192907,
        0.3993396534463543, 0.4778337814344742, 0.5623989859221217, 0.6594581913549248, 0.9153998352122699,
        1.2695129442179163, 1.6910814921229684, 2.143014800254095, 2.6009728956867484, 3.0569048513364727,
        3.503790683057181, 3.946452265013073, 4.383815365980431, 4.818225893613955, 5.888740960682893,
        6.944482672150168, 7.9898945637187735, 9.02938377768521, 10.060697840353612, 11.086359830674748,
        12.11058971029925, 13.127104798364808, 14.139879086401237, 15.14921911265538, 16.152288344383056,
        17.152288344383056, 18.14921911265538, 19.143014800254097, 20.133538908370216, 21.12057393120585,
        22.103803720955955, 23.08635983067475, 24.06445798922692, 25.041392685158225, 26.01703333929878,
        26.989449817666692, 27.960946195733833, 28.930949031167522, 29.899273187317604, 30.8668778143375,
        31.833784374656478, 32.79934054945358, 33.76417613239033, 34.72835378202123, 36.655138434811384,
        38.58092497567562, 40.505149978319906, 42.42975228000241, 44.3541084391474, 46.28103336724773,
        48.20682587603185, 53.02938377768521,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Co55_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 8.685880952436748e-07, 1.433148143464237e-05, 9.336327741651445e-05,
        0.00038114325769492564, 0.0011510907323373071, 0.0028275866787247843, 0.005986127810021806, 0.019727612600003868,
        0.049238961363648255, 0.10167663281566902, 0.18228879723157643, 0.29243817096179087, 0.5865873046717549,
        0.9449759084120479, 1.3324384599156054, 1.7363965022766426, 2.1492191126553797, 2.56702636615906,
        2.9912260756924947, 3.419955748489758, 3.851869600729766, 4.2878017299302265, 5.382017042574868,
        6.482873583608754, 7.5820633629117085, 8.677606952720494, 9.767155866082181, 10.85003325768977,
        11.927370363039023, 12.998695158311655, 14.064457989226918, 15.127104798364808, 16.181843587944773,
        17.232996110392154, 18.281033367247726, 19.32428245529769, 20.3654879848909, 21.401400540781545,
        22.436162647040756, 23.468347330412158, 24.4983105537896, 25.525044807036846, 26.550228353055093,
        27.57403126772772, 28.59659709562646, 29.6170003411209, 30.636487896353366, 31.65609820201283,
        32.673941998634085, 33.69108149212297, 34.70757017609794, 35.72427586960079, 37.75587485567249,
        39.786751422145564, 41.818225893613956, 43.850033257689766, 45.88309335857569, 47.91750550955255,
        49.954242509439325, 55.05690485133647,
    };

    // this is log10(partition function)

    AMREX_GPU_MANAGED amrex::Array1D<amrex::Real, 0, npts_1> Ni56_pf_array = {
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 0.0, 0.0, 0.0,
        0.0, 0.0, 4.3429426472042774e-07, 7.817230319428648e-06, 6.42708273977769e-05,
        0.0002904458650804842, 0.0009123622824012838, 0.0022498876258026487, 0.004694448751887299, 0.014735532704563181,
        0.03529042138996706, 0.07190703372466718, 0.13162956968664008, 0.2219004275849247, 0.5092025223311029,
        0.9132839017604184, 1.3747483460101038, 1.8555191556678001, 2.3404441148401185, 2.8221680793680175,
        3.303196057420489, 3.783903579272735, 4.26245108973043, 4.7419390777291985, 5.9344984512435675,
        7.117271295655764, 8.292256071356476, 9.456366033129044, 10.608526033577194, 11.750508394851346,
        12.88309335857569, 14.008600171761918, 15.123851640967086, 16.232996110392154, 17.33645973384853,
        18.432969290874407, 19.525044807036846, 20.612783856719737, 21.695481676490196, 22.773786444981194,
        23.8481891169914, 24.919078092376076, 25.987219229908003, 27.053078443483418, 28.113943352306837,
        29.17609125905568, 30.232996110392154, 31.287801729930226, 32.3424226808222, 33.39619934709574,
        34.44715803134222, 35.49692964807321, 36.54530711646582, 37.594392550375424, 39.68752896121463,
        41.77959649125783, 43.86981820797933, 45.959518376973, 48.04921802267018, 50.13987908640124,
        52.230448921378276, 57.462397997898954,
    };


}
