# a blend of CNO_extras and subch_simple

import pynucastro as pyna
from pynucastro.networks import AmrexAstroCxxNetwork

import he_burn_core


def create_network():

    extra_reactants = ["c13",
                       "o14", "o15", "o17", "o18",
                       "n14", "n15",
                       "f17", "f18", "f19",
                       "ne18", "ne19", "ne21", "ne22",
                       "na21", "na22", "na23"]

    subch = he_burn_core.get_core_library(include_n14_approx=False,
                                          remove_al27_alpha_links=False,
                                          include_zn=False,
                                          extra_nuclei=extra_reactants,
                                          do_detailed_balance=True)

    # create a modified rate to link Na22 to even Z nuclei
    rl = pyna.ReacLibLibrary()
    na22agal26 = rl.get_rate_by_name("na22(a,g)al26")
    na22_new = pyna.ModifiedRate(na22agal26, new_products=["si28"],
                                 stoichiometry={pyna.Nucleus("he4"): 1.5})
    subch.add_rate(na22_new)

    # approximate Mg24(p,g)Al25(e+nu)Mg25(p,a)Na22
    mg24pgal25 = rl.get_rate_by_name("mg24(p,g)al25")
    if pyna.Nucleus("mg25") in subch.get_nuclei():
        mg24_new = pyna.ModifiedRate(mg24pgal25,
                                     new_products=["mg25"])
    else:
        mg24_new = pyna.ModifiedRate(mg24pgal25,
                                     new_reactants=["p", "mg24"],
                                     new_products=["na22", "he4"],
                                     stoichiometry={pyna.Nucleus("p"): 2})

    subch.add_rate(mg24_new)

    net = AmrexAstroCxxNetwork(libraries=[subch])

    net.make_ap_pg_approx(intermediate_nuclei=["cl35", "k39", "sc43",
                                               "v47", "mn51", "co55"])
    net.remove_nuclei(["cl35", "k39", "sc43", "v47", "mn51", "co55"])

    return net


def doit():

    net = create_network()

    net.summary()

    fig = net.plot(rotated=True, hide_xalpha=True, curved_edges=False,
                   size=(1500, 450),
                   node_size=500, node_font_size=10,
                   Z_range=(1, 29),
                   highlight_filter_function=lambda r: isinstance(r, pyna.rates.TabularRate))

    net.write_network()

    fig.savefig("cno-he-burn-34am.png", bbox_inches="tight")


if __name__ == "__main__":
    doit()
