# Contributing to rpaleoclim

rpaleoclim is free and open source (FOSS) software maintained in the interests of open science.
Contributions of all types are welcome.

## Bug reports

To report a bug or problem, please create a new issue at https://github.com/joeroe/rpaleoclim/issues.
Please include as much information as possible and, if you can, a [minimal reproducible example](https://www.tidyverse.org/help/#reprex) ("reprex").

## Suggestions

To suggest an new feature or improvement, please create a new issue at https://github.com/joeroe/rpaleoclim/issues.

## Code

All contributions are welcome, but if possible please follow these conventions:

* For R code, follow the [tidyverse style guide](https://style.tidyverse.org/)
* For documentation, use [roxygen2](https://roxygen2.r-lib.org/)
* If you add new functionality, write unit tests for it with [testthat](https://testthat.r-lib.org/)
* Run `devtools::check()` to build the package and run tests before making a pull request

Then follow the [GitHub flow](https://docs.github.com/en/get-started/quickstart/github-flow) and make a pull request with your contributions. 

## Questions and comments

For any other questions or comments on this software, please feel free to email the maintainer at <joe@joeroe.io>.
