import re
import subprocess

# List of strategies to check
strategies = ["baseline.xml", "autoGenModel.xml", "Strategy_valencePeak.xml"]
strategy_names = {"baseline.xml": "Random", "autoGenModel.xml": "Data-driven",
                  "Strategy_valencePeak.xml": "High Valence"}

# Regex to extract requirement number and probability interval
req_pattern = re.compile(
    r"Verifying formula (\d+).*?\n.*?Result:.*?\[([0-9]*\.?[0-9]+),([0-9]*\.?[0-9]+)\]",
    re.DOTALL
)

for strat in strategies:
    print(f"Strategy {strategy_names[strat]}")
    # Run the verification script
    result = subprocess.run(
        ["./verify.sh", strat],
        capture_output=True,
        text=True
    )

    if result.returncode != 0:
        print(f"  Error running strategy {strat}: {result.stderr}")
        continue

    output = result.stdout

    # Find all requirements in the output
    matches = req_pattern.findall(output)

    if not matches:
        print("  No requirements found.")
        continue

    for req_num, low, high in matches:
        print(f"  Req {req_num}: [{low}, {high}]")

    print()  # extra newline between strategies
