clear all
close all
%%%%%%%%%%%%% Radius of the Retina Network %%%%%%%%%%
global params

addpath(genpath('Preprocessing'))
addpath(genpath('Flow'))
addpath(genpath('Transport'))
addpath(genpath('Postprocessing'))

%files should .ascii files written in amiramesh spatial graph format. to
%see the formatting see the example below

input_filename="retina_demo_network.am";

%% network creation
base_network=amReader(input_filename,"full");
base_network=makeConnectivityTable(base_network);
base_network=makeConsistentConnectivity(base_network);
current_network=base_network;

%% set up and solving the blood flow problem
%resistor orientation expressed in radian [0 2pi] give the orientation of
%the collector and injector points)
resistor_orientation=0;
current_network=setNetworkQuantityRetinaDoubleResistor(current_network,resistor_orientation);
current_network=computePressureMatrixStructure(current_network);

%option to include the resolution of the hematocrit field 1=enabled,
%0=disabled and hematocrit assumed to be constant 
params.solve_RBC=1;
current_network=computeFlow(current_network);

%% set up and solving the oxygen transport problem
%ensuring no inlet vessel exchqngeoxygen with the surrounding tissue
for k=1:length(current_network.segment)
    if current_network.segment(k).inlet==1
        current_network.segment(k).wall_permeability=0;
    end
end
%relaxation parameter to facilitate the resolution of the oxygen transport problem 
params.relaxation_factor=0.5;
current_tissue=setTissueQuantityRetina(current_network);
[current_network, current_tissue]=computeGreenFunctionPotential(current_network, current_tissue);
[current_network, current_tissue]=computeTransport(current_network,current_tissue);

%% displaying the results

plotNetworkGeometry(current_network,10,[],1);
plotNetwork(current_network);
plotTissue(current_network,current_tissue);








