function [current_network,current_tissue] = computeTransport(current_network,current_tissue)
%% This function computes the oxygen distribution inside the vessel and in the surrounding tissue

global params

%% creates the matrix necessary to solve the oxygen transport problem
current_network=computePartialFlux(current_network);
current_network=computeSegmentLinearTransportMatrixAndRightHandSide(current_network,current_tissue);
current_tissue=computeTissueLinearTransportMatrixAndRightHandSide(current_network,current_tissue);
linear_transport_matrix=[current_network.segment_linear_transport_matrix; current_tissue.grid.linear_transport_matrix];
linear_transport_right_hand_side=[current_network.segment_linear_transport_right_hand_side; current_tissue.grid.linear_transport_right_hand_side];

resTissue=inf;
resTissue2=inf;
var_max=inf;
%% Initialize the problem
if isfield(current_tissue.grid,'concentration')==0
    S=linear_transport_matrix\linear_transport_right_hand_side;%network.segment_transport_matrix\current_network.segment_transport_right_hand_side;
else
    S=[current_network.intra_concentration; current_network.extra_concentration; current_tissue.grid.concentration];
end
%% Solve the oxygen transport problem iteratively using a Newton Raphson algorithm
iteration_idx=0;
while var_max>-3 && iteration_idx<80
    current_network=computeSegmentNonLinearTransportMatrixAndRightHandSide(S,current_network,current_tissue);
    current_tissue=computeTissueNonLinearTransportMatrixAndRightHandSide(S,current_network,current_tissue); 
    
    non_linear_transport_matrix=[current_network.segment_non_linear_transport_matrix; current_tissue.grid.non_linear_transport_matrix];
    non_linear_transport_right_hand_side=[current_network.segment_non_linear_transport_right_hand_side; current_tissue.grid.non_linear_transport_right_hand_side];
    
    newton_jacobian_matrix=linear_transport_matrix+non_linear_transport_matrix;
    newton_right_hand_side=linear_transport_matrix*S-linear_transport_right_hand_side+non_linear_transport_right_hand_side;
    current_network.newton_jacobian_matrix=newton_jacobian_matrix;
    current_network.newton_right_hand_side=newton_right_hand_side;
    deltaS=-newton_jacobian_matrix\newton_right_hand_side;
    
    if(resTissue>-inf)
        r=params.relaxation_factor;
    else
        r=1;
    end
    
    S=S+r.*deltaS;
    nb_zero=0;
    for i=1:length(S)
        if S(i)<0
            S(i)=S(i)-0.9*r.*deltaS(i);
            i;
            nb_zero=nb_zero+1;
            zero_idx=i;
        end
    end
    S0=current_network.oxygen_inlet_concentration;
    resTissue=norm(newton_right_hand_side)/(S0*length(newton_right_hand_side));
    resTissue2=max(abs(newton_right_hand_side));
    [var_max idx]=max(abs(deltaS));
    resTissue=log10(resTissue);
    resTissue2=log10(resTissue2/S0);
    var_max=log10(var_max/S0);
    % verbose residual uncomment for tracking convergence
    %[iteration_idx nb_zero resTissue resTissue2 var_max norm(newton_right_hand_side)/length(newton_right_hand_side)]
    iteration_idx=iteration_idx+1;
end
%% compute the concentration of exoygen everywhere in the network and the tissue
current_network=computeSegmentConcentration(real(S),current_network);
current_tissue=computeTissueConcentration(real(S),current_tissue);
end

