function current_tissue=computeTissueLinearTransportMatrixAndRightHandSide(current_network,current_tissue)
%% This function computes the linear contribution to the extravascular oxygen transport problem, (diffusion and exchange between intra and extracellular spaces) from the tissue perspective

A1=zeros(length(current_tissue.grid.cell),length(current_network.node));
A2=eye(length(current_tissue.grid.cell),length(current_tissue.grid.cell));
tissue_linear_transport_matrix=[-current_tissue.grid.network_to_tissue_potential_matrix.*current_network.partial_flux' A1 current_tissue.grid.network_to_tissue_potential_matrix.*current_network.partial_flux' A2];
tissue_sparse_linear_transport_matrix=[-current_tissue.grid.network_to_tissue_potential_matrix.*current_network.partial_flux' A1 current_tissue.grid.network_to_tissue_potential_matrix.*current_network.partial_flux' A2];
current_tissue.grid.linear_transport_matrix=tissue_linear_transport_matrix;
current_tissue.grid.linear_sparse_transport_matrix=tissue_sparse_linear_transport_matrix;
rhs=zeros(length(current_tissue.grid.cell),1);
current_tissue.grid.linear_transport_right_hand_side=rhs;


end

