function current_network = computeSegmentLinearTransportMatrixAndRightHandSide(current_network,current_tissue)
%% This function compute the linear contribution (matrix and right hand side) to the oxygen transport problem, i.e. intravascular advection and diffusion  as well as exchanges between vessel and tissue
current_network=computeIntraSegmentLinearTransportMatrix(current_network,current_tissue);
current_network=computeExtraSegmentLinearTransportMatrix(current_network,current_tissue);
current_network.segment_linear_transport_matrix=[current_network.intra_segment_linear_transport_matrix ; current_network.extra_segment_linear_transport_matrix];

rhs=zeros(length(current_network.segment_linear_transport_matrix(:,1)),1);
for i=1:length(current_network.node)
    I=i+current_network.nb_inner_points;
    if(current_network.node(i).BC==1)
       if current_network.node(i).transport_BC_type==0
          rhs(I)=current_network.node(i).transport_BC_value;
       end
    end
end
current_network.segment_linear_transport_right_hand_side=rhs;
end

