function current_network= computePartialFlux(current_network)
%% This function computes the effective exchange coefficient at the basis of intra-extra vascular exchanges
partial_flux=zeros(current_network.nb_inner_points,1);
for i=1:length(current_network.segment)
    for j=1:length(current_network.segment(i).point_indices)
        I=current_network.segment(i).point_indices(j);
        K=current_network.segment(i).wall_permeability;
        D=current_network.diffusion_coefficient;
        Slat=current_network.segment(i).d*pi*current_network.segment(i).dL;
        partial_flux(I)=K*Slat/(1+(K*current_network.segment(i).d)/(8*D));
    end
end
current_network.partial_flux=partial_flux;
end

