function current_network=computeIntraSegmentNonLinearTransportMatrixAndRightHandSide(S,current_network,current_tissue)
%% This function computes the non-linear intravascular contribution of oxygen release into the blood stream 

intra_segment_non_linear_transport_matrix=zeros(current_network.nb_inner_points+current_network.nb_node,...
    2*current_network.nb_inner_points+current_network.nb_node+length(current_tissue.grid.cell));

intra_segment_non_linear_transport_right_hand_side=zeros(current_network.nb_inner_points+current_network.nb_node,1);

if current_network.inlet_discharge_hematocrit>0
    Istart=1;
    Iend=current_network.nb_inner_points+current_network.nb_node;
    C=S(Istart:Iend);
    C50=current_network.Hill_C50;
    co_alpha=current_network.co_alpha;
    n=current_network.Hill_n;
    dt=current_network.dt;
    Sat=(C.^n)./(C.^n+C50^n);
    Sat_derivative=n*C50^n*C.^(n-1)./(C.^n+C50^n).^2;

    for i=1:length(current_network.segment)
        Q=current_network.segment(i).Q;
        V=pi/4*current_network.segment(i).d*current_network.segment(i).d*current_network.segment(i).dL;
        Hd=current_network.segment(i).Hd;
        for j=1:length(current_network.segment(i).point_indices)
            I=current_network.segment(i).point_indices(j);
            if length(current_network.segment(i).point_indices)==1
                start_idx=current_network.segment(i).nodes(1)+current_network.nb_inner_points;
                end_idx=current_network.segment(i).nodes(2)+current_network.nb_inner_points;
                if current_network.segment(i).Q>=0
                    intra_segment_non_linear_transport_matrix(I,start_idx)=-Q*Hd*co_alpha*Sat_derivative(start_idx)*dt/V;
                    intra_segment_non_linear_transport_matrix(I,I)=Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                    intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I)-Sat(start_idx))*dt/V;
                else
                    intra_segment_non_linear_transport_matrix(I,end_idx)=Q*Hd*co_alpha*Sat_derivative(end_idx)*dt/V;
                    intra_segment_non_linear_transport_matrix(I,I)=-Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                    intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(end_idx)-Sat(I))*dt/V;
                end
            else
                if(j==1)
                    start_idx=current_network.segment(i).nodes(1)+current_network.nb_inner_points;
                    if current_network.segment(i).Q>=0
                        intra_segment_non_linear_transport_matrix(I,start_idx)=-Q*Hd*co_alpha*Sat_derivative(start_idx)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I)-Sat(start_idx))*dt/V;
                    else
                        intra_segment_non_linear_transport_matrix(I,I+1)=Q*Hd*co_alpha*Sat_derivative(I+1)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=-Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I+1)-Sat(I))*dt/V;
                    end
                elseif(j==length(current_network.segment(i).point_indices))
                    end_idx=current_network.segment(i).nodes(2)+current_network.nb_inner_points;
                    if current_network.segment(i).Q>=0
                        intra_segment_non_linear_transport_matrix(I,I-1)=-Q*Hd*co_alpha*Sat_derivative(I-1)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I)-Sat(I-1))*dt/V;
                    else
                        intra_segment_non_linear_transport_matrix(I,end_idx)=Q*Hd*co_alpha*Sat_derivative(end_idx)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=-Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(end_idx)-Sat(I))*dt/V;

                    end
                else
                    if current_network.segment(i).Q>=0
                        intra_segment_non_linear_transport_matrix(I,I-1)=-Q*Hd*co_alpha*Sat_derivative(I-1)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I)-Sat(I-1))*dt/V;
                    else
                        intra_segment_non_linear_transport_matrix(I,I+1)=Q*Hd*co_alpha*Sat_derivative(I+1)*dt/V;
                        intra_segment_non_linear_transport_matrix(I,I)=-Q*Hd*co_alpha*Sat_derivative(I)*dt/V;

                        intra_segment_non_linear_transport_right_hand_side(I)=Q*Hd*co_alpha*(Sat(I+1)-Sat(I))*dt/V;
                    end
                end
            end
        end
    end

    %%  bifurcation
    for i=1:length(current_network.node)
        I=i+current_network.nb_inner_points;
        if(current_network.node(i).BC==0)
            Vmean=0;
            for j=1:length(current_network.node(i).neigh_segments)
                neigh_segment=current_network.node(i).neigh_segments(j);
                V=pi/4*current_network.segment(neigh_segment).d*current_network.segment(neigh_segment).d*current_network.segment(neigh_segment).dL;
                Vmean=Vmean+V/length(current_network.node(i).neigh_segments);
            end

            for j=1:length(current_network.node(i).neigh_segments)
                neigh_segment=current_network.node(i).neigh_segments(j);
                V=Vmean;
                Q=current_network.segment(neigh_segment).Q;
                Hd=current_network.segment(neigh_segment).Hd;
                if(current_network.segment(neigh_segment).nodes(1)==i)
                    J=current_network.segment(neigh_segment).point_indices(1);
                else
                    J=current_network.segment(neigh_segment).point_indices(length(current_network.segment(neigh_segment).point_indices));
                end

                if (current_network.segment(neigh_segment).nodes(1)==i)
                    if(current_network.segment(neigh_segment).Q>=0)
                        intra_segment_non_linear_transport_matrix(I,I)=intra_segment_non_linear_transport_matrix(I,I)+Q*Hd*co_alpha*Sat_derivative(I)*dt/V;
                        intra_segment_non_linear_transport_right_hand_side(I)=intra_segment_non_linear_transport_right_hand_side(I)+Q*Hd*co_alpha*(Sat(I))*dt/V;
                    else
                        intra_segment_non_linear_transport_matrix(I,J)=intra_segment_non_linear_transport_matrix(I,J)+Q*Hd*co_alpha*Sat_derivative(J)*dt/V;
                        intra_segment_non_linear_transport_right_hand_side(I)=intra_segment_non_linear_transport_right_hand_side(I)+Q*Hd*co_alpha*(Sat(J))*dt/V;
                    end
                else
                    if(current_network.segment(neigh_segment).Q>=0)
                        intra_segment_non_linear_transport_matrix(I,J)=intra_segment_non_linear_transport_matrix(I,J)-Q*Hd*co_alpha*Sat_derivative(J)*dt/V;
                        intra_segment_non_linear_transport_right_hand_side(I)=intra_segment_non_linear_transport_right_hand_side(I)-  Q*Hd*co_alpha*(Sat(J))*dt/V;
                    else
                        intra_segment_non_linear_transport_matrix(I,I)=intra_segment_non_linear_transport_matrix(I,I)-Q*Hd*co_alpha*Sat_derivative(I)*dt/V;
                        intra_segment_non_linear_transport_right_hand_side(I)=intra_segment_non_linear_transport_right_hand_side(I)-Q*Hd*co_alpha*(Sat(I))*dt/V;
                    end
                end
            end    
        end
    end
end
current_network.intra_segment_non_linear_transport_matrix=intra_segment_non_linear_transport_matrix;
current_network.intra_segment_non_linear_transport_right_hand_side=intra_segment_non_linear_transport_right_hand_side;


end