function  current_network=computeIntraSegmentLinearTransportMatrix(current_network,current_tissue)
%% This function compute the linear contribution to the intravascular oxygen transport problem, (advection and diffusion  and exchanges between vessel and tissue)

%% Advection diffusion in the segments
intra_segment_linear_transport_matrix=zeros(current_network.nb_inner_points+length(current_network.node),2*current_network.nb_inner_points+length(current_network.node)+length(current_tissue.grid.cell));
intra_segment_linear_transport_matrix_uncoupled=zeros(current_network.nb_inner_points+length(current_network.node),current_network.nb_inner_points+length(current_network.node));
dt=current_network.dt;
for i=1:length(current_network.segment)
    S=0.25*current_network.segment(i).d^2*pi;
    V=S*current_network.segment(i).dL;
    dL=current_network.segment(i).dL;
    Q=current_network.segment(i).Q;
    D=current_network.diffusion_coefficient;
    for j=1:length(current_network.segment(i).point_indices)
        I=current_network.segment(i).point_indices(j);
        if length(current_network.segment(i).point_indices)==1
            start_idx=current_network.segment(i).nodes(1)+current_network.nb_inner_points;
            end_idx=current_network.segment(i).nodes(2)+current_network.nb_inner_points;
            intra_segment_linear_transport_matrix(I,I)=4*D*S/dL*dt/V;
            intra_segment_linear_transport_matrix(I,start_idx)=-2*D*S/dL*dt/V;
            intra_segment_linear_transport_matrix(I,end_idx)=-2*D*S/dL*dt/V;
            if current_network.segment(i).Q>=0
                intra_segment_linear_transport_matrix(I,start_idx)=intra_segment_linear_transport_matrix(I,start_idx)-Q*dt/V;
                intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+Q*dt/V;
            else
                intra_segment_linear_transport_matrix(I,end_idx)=intra_segment_linear_transport_matrix(I,end_idx)+Q*dt/V;
                intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)-Q*dt/V;
            end
            
        else
            if(j==1)
                start_idx=current_network.segment(i).nodes(1)+current_network.nb_inner_points;
                intra_segment_linear_transport_matrix(I,I)=3*D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,start_idx)=-2*D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,I+1)=-D*S/dL*dt/V;
                if current_network.segment(i).Q>=0
                    intra_segment_linear_transport_matrix(I,start_idx)=intra_segment_linear_transport_matrix(I,start_idx)-Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+Q*dt/V;
                else
                    intra_segment_linear_transport_matrix(I,I+1)=intra_segment_linear_transport_matrix(I,I+1)+Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)-Q*dt/V;
                end
            elseif(j==length(current_network.segment(i).point_indices))
                end_idx=current_network.segment(i).nodes(2)+current_network.nb_inner_points;
                intra_segment_linear_transport_matrix(I,I)=3*D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,I-1)=-D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,end_idx)=-2*D*S/dL*dt/V;
                if current_network.segment(i).Q>=0
                    intra_segment_linear_transport_matrix(I,I-1)=intra_segment_linear_transport_matrix(I,I-1)-Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+Q*dt/V;
                else
                    intra_segment_linear_transport_matrix(I,end_idx)=intra_segment_linear_transport_matrix(I,end_idx)+Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)-Q*dt/V;
                end
            else
                intra_segment_linear_transport_matrix(I,I)=2*D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,I-1)=-D*S/dL*dt/V;
                intra_segment_linear_transport_matrix(I,I+1)=-D*S/dL*dt/V;
                if current_network.segment(i).Q>=0
                    intra_segment_linear_transport_matrix(I,I-1)=intra_segment_linear_transport_matrix(I,I-1)-Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+Q*dt/V;
                else
                    intra_segment_linear_transport_matrix(I,I+1)=intra_segment_linear_transport_matrix(I,I+1)+Q*dt/V;
                    intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)-Q*dt/V;
                end
            end
        end
    end
end

%% Exchange with tissue
for i=1:length(current_network.segment)
    for j=1:length(current_network.segment(i).point_indices)
        Slat=current_network.segment(i).d*pi*current_network.segment(i).dL;
        S=0.25*current_network.segment(i).d^2*pi;
        D=current_network.diffusion_coefficient;
        V=S*current_network.segment(i).dL;
        dL=current_network.segment(i).dL;
        K=current_network.segment(i).wall_permeability;
        I=current_network.segment(i).point_indices(j);
        J=current_network.nb_inner_points+length(current_network.node)+current_network.segment(i).point_indices(j);
        intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+K*Slat/(1+(K*current_network.segment(i).d)/(8*D))*dt/V;
        intra_segment_linear_transport_matrix(I,J)=-K*Slat/(1+(K*current_network.segment(i).d)/(8*D))*dt/V;
        current_network.segment(i).effective_permeability=K/(1+(K*current_network.segment(i).d)/(8*D));
    end
end

%% Advection diffusion in bifurcation
for i=1:length(current_network.node)
    I=i+current_network.nb_inner_points;
    if(current_network.node(i).BC==1)
       if(current_network.node(i).transport_BC_type==0)
          intra_segment_linear_transport_matrix(I,I)=1; 
       else
           neigh_segment=current_network.node(i).neigh_segments(1);
           if(current_network.segment(neigh_segment).nodes(1)==i)
              J=current_network.segment(neigh_segment).point_indices(1);
           else
              J=current_network.segment(neigh_segment).point_indices(length(current_network.segment(neigh_segment).point_indices));
           end
           S=0.25*current_network.segment(neigh_segment).d^2*pi;
           V=S*current_network.segment(neigh_segment).dL;
           dL=current_network.segment(neigh_segment).dL;
           D=current_network.diffusion_coefficient;
           
           intra_segment_linear_transport_matrix(I,I)=S*D/dL*dt/V;
           intra_segment_linear_transport_matrix(I,J)=-S*D/dL*dt/V;
       end
    else
       Vmean=0;
       for j=1:length(current_network.node(i).neigh_segments)
           neigh_segment=current_network.node(i).neigh_segments(j);
           S=0.25*current_network.segment(neigh_segment).d^2*pi;
           V=S*current_network.segment(neigh_segment).dL;
           Vmean=Vmean+V/length(current_network.node(i).neigh_segments);
       end
       
       for j=1:length(current_network.node(i).neigh_segments)
           neigh_segment=current_network.node(i).neigh_segments(j);
           S=0.25*current_network.segment(neigh_segment).d^2*pi;
           V=Vmean;
           Q=current_network.segment(neigh_segment).Q;
           D=current_network.diffusion_coefficient;
           
           if(current_network.segment(neigh_segment).nodes(1)==i)
              J=current_network.segment(neigh_segment).point_indices(1);
           else
              J=current_network.segment(neigh_segment).point_indices(length(current_network.segment(neigh_segment).point_indices));
           end
           intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+2*D*S/dL*dt/V;
           intra_segment_linear_transport_matrix(I,J)=-2*D*S/dL*dt/V;
           if (current_network.segment(neigh_segment).nodes(1)==i)
               if(current_network.segment(neigh_segment).Q>=0)
                  intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)+Q*dt/V;
               else
                  intra_segment_linear_transport_matrix(I,J)=intra_segment_linear_transport_matrix(I,J)+Q*dt/V; 
               end
           else
               if(current_network.segment(neigh_segment).Q>=0)
                  intra_segment_linear_transport_matrix(I,J)=intra_segment_linear_transport_matrix(I,J)-Q*dt/V;
               else
                  intra_segment_linear_transport_matrix(I,I)=intra_segment_linear_transport_matrix(I,I)-Q*dt/V;
               end
           end
       end
    end
end

current_network.intra_segment_linear_transport_matrix=intra_segment_linear_transport_matrix;

end

