function [current_network, current_tissue]=computeGreenFunctionPotential(current_network,current_tissue)
%% This function creates the green function matrix, i.e. the cross influence of all source (exchange from the vessel) and sinks (from the tissue)


%% Network to tissue and tissue to network (transpose)
diffusion_coefficient=current_tissue.diffusion_coefficient;
network_to_tissue_potential_matrix=zeros(length(current_tissue.grid.cell),current_network.nb_inner_points);

local_point_idx=0;
points_coordinates=zeros(current_network.nb_inner_points,length(current_network.node(1).coords));
diameter_list=zeros(current_network.nb_segment);
for i=1:length(current_network.segment)
    diameter_list(i)=current_network.segment(i).d;
    for j=1:current_network.segment(i).nb_subsegments
        local_point_idx=local_point_idx+1;
        if(current_network.segment(i).nb_subsegments>1)
            points_coordinates(local_point_idx,:)=current_network.segment(i).point_coords(j,:);
        else
            points_coordinates(local_point_idx,:)=current_network.segment(i).point_coords(:);  
        end
    end
end

for k=1:length(current_tissue.grid.cell)
    point_idx=0;
    cell_position=current_tissue.grid.cell(k).position;
    for j=1:length(current_network.segment)
        local_diametre=diameter_list(j);
        for i=1:current_network.segment(j).nb_subsegments
            point_idx=point_idx+1;
            inner_point_coordinates=points_coordinates(point_idx,:);
            d=norm(cell_position-inner_point_coordinates);

            if d<=min(current_tissue.grid.space_step_list)
               potential=0;
               dX=current_tissue.grid.space_step_list(1);
               dY=current_tissue.grid.space_step_list(2);
               dZ=current_tissue.grid.space_step_list(3);

               n_subcell=4;
               dx=dX/n_subcell;
               dy=dY/n_subcell;
               dz=dZ/n_subcell;
               for u=1:n_subcell
                   for v=1:n_subcell
                       for w=1:n_subcell
                           x=cell_position(1)-dX/2+dx/2+(u-1)*dx;
                           y=cell_position(2)-dY/2+dy/2+(v-1)*dy;
                           z=cell_position(3)-dZ/2+dz/2+(w-1)*dz;
                           position=[x y z];
                           d=norm(position-inner_point_coordinates);
                           d=max(d,local_diametre);
                           local_potential=1/(4*pi*diffusion_coefficient*d);
                           
                           potential=potential+(dx*dy*dz)/(dX*dY*dZ)*local_potential;
                       end
                   end
               end
               point_potential=potential;
            else
               d=max(d,local_diametre);
               point_potential=1/(4*pi*diffusion_coefficient*d);
            end
            network_to_tissue_potential_matrix(k,point_idx)=point_potential;

        end
    end
end
tissue_to_network_potential_matrix=network_to_tissue_potential_matrix';

%% Tissue to tissue potential matrix
tissue_to_tissue_potential_matrix=zeros(length(current_tissue.grid.cell),length(current_tissue.grid.cell));
potential_reference=zeros(length(current_tissue.grid.cell));
for k=1:length(current_tissue.grid.cell)
    if k==1
        dX=current_tissue.grid.space_step_list(1);
        dY=current_tissue.grid.space_step_list(2);
        dZ=current_tissue.grid.space_step_list(3);
        n_subcell=4;
        dx=dX/n_subcell;
        dy=dY/n_subcell;
        dz=dZ/n_subcell;
        position_center=[dX/2 dY/2 dZ/2];
        potential=0;
        for u=1:n_subcell
            for v=1:n_subcell
                for w=1:n_subcell
                    x=dx/2+(u-1)*dx;
                    y=dy/2+(v-1)*dy;
                    z=dz/2+(w-1)*dz;
                    position=[x y z];
                    d=norm(position_center-position);
                    local_potential=1/(4*pi*diffusion_coefficient*d);

                    potential=potential+(dx*dy*dz)/(dX*dY*dZ)*local_potential;
                end
            end
        end
    else
        d=norm(current_tissue.grid.cell(1).position-current_tissue.grid.cell(k).position);
        potential=1/(4*pi*diffusion_coefficient*d);
    end
    potential_reference(k)=potential;
end

nb_cell_width=current_tissue.grid.nb_cell_list(1);
nb_cell_height=current_tissue.grid.nb_cell_list(2);
nb_cell_depth=current_tissue.grid.nb_cell_list(3);
for i=1:nb_cell_width
    for j=1:nb_cell_height
        for k=1:nb_cell_depth
            local_cell_idx=i+nb_cell_width*(j-1)+nb_cell_width*nb_cell_height*(k-1);
            for l=i:nb_cell_width
                distant_cell_idx=local_cell_idx+l-i;
                reference_cell_idx=l-i+1;
                potential=potential_reference(reference_cell_idx);
                tissue_to_tissue_potential_matrix(local_cell_idx,distant_cell_idx)=potential;
            end
            distant_cell_idx=nb_cell_width*j;
            for m=j+1:nb_cell_height
                for l=1:nb_cell_width
                    distant_cell_idx=distant_cell_idx+1;
                    reference_cell_idx=1+abs(i-l)+nb_cell_width*(m-j);
                    tissue_to_tissue_potential_matrix(local_cell_idx,distant_cell_idx)=potential_reference(reference_cell_idx);
                end
            end
            
            distant_cell_idx=nb_cell_width*nb_cell_height*k;
            for n=k+1:nb_cell_depth
                for m=1:nb_cell_height
                    for l=1:nb_cell_width
                        distant_cell_idx=distant_cell_idx+1;
                        reference_cell_idx=1+abs(i-l)+nb_cell_width*abs(m-j)+nb_cell_width*nb_cell_height*(n-k);
                        tissue_to_tissue_potential_matrix(local_cell_idx,distant_cell_idx)=potential_reference(reference_cell_idx);
                    end
                end
            end
        end
    end
end

tissue_to_tissue_potential_matrix=tissue_to_tissue_potential_matrix+transpose(tissue_to_tissue_potential_matrix);
for i=1:length(tissue_to_tissue_potential_matrix)
    tissue_to_tissue_potential_matrix(i,i)=tissue_to_tissue_potential_matrix(i,i)/2;
end

%% Network to network potential matrix
network_potential_matrix=zeros(current_network.nb_inner_points,current_network.nb_inner_points);

local_point_idx=0;
for i=1:length(current_network.segment)
    for j=1:current_network.segment(i).nb_subsegments
        local_point_idx=local_point_idx+1;
        distant_point_idx=0;
        local_coords=points_coordinates(local_point_idx,:);
        for k=1:length(current_network.segment)
            for l=1:current_network.segment(k).nb_subsegments
              distant_point_idx=distant_point_idx+1;
              distant_coords=points_coordinates(distant_point_idx,:);
              if(local_point_idx<=distant_point_idx)
                if(local_point_idx==distant_point_idx)  
                    d=current_network.segment(i).d/2;
                else
                    d=norm(local_coords-distant_coords);
                    if d<=current_network.segment(i).d/2
                        d=current_network.segment(i).d/2;
                    end
                end
                potential_point=1/(4*pi*diffusion_coefficient*d);
                
                network_potential_matrix(local_point_idx,distant_point_idx)=potential_point;
                network_potential_matrix(distant_point_idx,local_point_idx)=network_potential_matrix(local_point_idx,distant_point_idx);
              end
            end
        end
    end
end
current_tissue.grid.network_to_tissue_potential_matrix=network_to_tissue_potential_matrix;
current_tissue.grid.tissue_to_network_potential_matrix=tissue_to_network_potential_matrix;
current_tissue.grid.tissue_to_tissue_potential_matrix=tissue_to_tissue_potential_matrix;

current_network.potential_matrix=network_potential_matrix;
end

