function current_network=computeExtraSegmentNonLinearTransportMatrixAndRightHandSide(S,current_network,current_tissue)
%% This function computes the non-linear extravascular contribution of oxygen metabolism

A1=zeros(current_network.nb_inner_points,current_network.nb_inner_points);
A2=zeros(current_network.nb_inner_points,length(current_network.node));

Istart=length(S)-length(current_tissue.grid.cell)+1;
Iend=length(S);
tissue_concentration=S(Istart:Iend);
non_linear_reaction=current_tissue.grid.cell_volume*current_tissue.grid.metabolism_rate_list.*(tissue_concentration)./(current_tissue.half_concentration+tissue_concentration);
non_linear_reaction_derivative=current_tissue.grid.cell_volume*current_tissue.grid.metabolism_rate_list.*(current_tissue.half_concentration)./(current_tissue.half_concentration+tissue_concentration).^2;

extra_segment_non_linear_transport_matrix=[A1 A2 A1 current_tissue.grid.tissue_to_network_potential_matrix.*non_linear_reaction_derivative'];
extra_segment_non_linear_right_hand_side=current_tissue.grid.tissue_to_network_potential_matrix*non_linear_reaction;

current_network.extra_segment_non_linear_transport_matrix=extra_segment_non_linear_transport_matrix;
current_network.extra_segment_non_linear_transport_right_hand_side=extra_segment_non_linear_right_hand_side;

end