function current_network = computeExtraSegmentLinearTransportMatrix(current_network,current_tissue)
%% This function computes the linear contribution to the extravascular oxygen transport problem, (diffusion and exchange between intra and extracellular spaces) from the network perspective
A1=zeros(current_network.nb_inner_points,length(current_network.node));
A2=zeros(current_network.nb_inner_points,length(current_tissue.grid.cell));
extra_segment_linear_transport_matrix=[-current_network.potential_matrix.*current_network.partial_flux' A1 current_network.potential_matrix.*current_network.partial_flux' A2];
for i=1:length(current_network.segment)
    for j=1:length(current_network.segment(i).point_indices)
        I=current_network.segment(i).point_indices(j);      
        J=current_network.nb_inner_points+length(current_network.node)+current_network.segment(i).point_indices(j);
        extra_segment_linear_transport_matrix(I,J)=extra_segment_linear_transport_matrix(I,J)+1;
    end
end
current_network.extra_segment_linear_transport_matrix=extra_segment_linear_transport_matrix;
end

