function current_tissue=setTissueQuantityRetina(current_network)
%% This function sets parameter for the tissue surrounding the blood vessel (geometry size, metabolic activity, discretization element)

tissue_length=current_network.X_max-current_network.X_min;
tissue_height=current_network.Y_max-current_network.Y_min;
tissue_depth=current_network.Z_max-current_network.Z_min;
tissue_dimensions=[tissue_length tissue_height tissue_depth];
nb_cell_length=50;
nb_cell_height=50;
nb_cell_depth=1;
nb_cell_list=[nb_cell_length nb_cell_height nb_cell_depth];
current_tissue=generateGrid(current_network.center_position,tissue_dimensions,nb_cell_list);
current_tissue.diffusion_coefficient=2e3;
current_tissue.baseline_metabolism_rate=40;
current_tissue.half_concentration=10;

metabolism_rate_list=zeros(length(current_tissue.grid.cell),1);
for i=1:length(current_tissue.grid.cell)
    current_tissue.grid.cell(i).metabolism_rate=current_tissue.baseline_metabolism_rate;
    metabolism_rate_list(i)=current_tissue.baseline_metabolism_rate; 
end
current_tissue.grid.metabolism_rate_list=metabolism_rate_list;

end