function current_network=setNetworkQuantityRetinaDoubleResistor(current_network,resistor_orientation)
%% This function sets various quantities accross the network, including boundary conditions

%% identifies the box around the network
X_min=inf;X_max=-inf;
Y_min=inf;Y_max=-inf;
Z_min=inf;Z_max=-inf;
for i=1:length(current_network.segment)
    for j=1:current_network.segment(i).nbpoints
        if(current_network.segment(i).pt_coords(j,1)<X_min)
            X_min=current_network.segment(i).pt_coords(j,1);
        end
        if (current_network.segment(i).pt_coords(j,1)>X_max)
            X_max=current_network.segment(i).pt_coords(j,1);
        end
        
        if(current_network.segment(i).pt_coords(j,2)<Y_min)
            Y_min=current_network.segment(i).pt_coords(j,2);
        end
        if (current_network.segment(i).pt_coords(j,2)>Y_max)
            Y_max=current_network.segment(i).pt_coords(j,2);
        end
        
        if(current_network.segment(i).pt_coords(j,3)<Z_min)
            Z_min=current_network.segment(i).pt_coords(j,3);
        end
        if (current_network.segment(i).pt_coords(j,3)>Z_max)
            Z_max=current_network.segment(i).pt_coords(j,3);
        end
    end
end

upper_plexus_distance=50;
if(Z_max==0)
   Z_max=upper_plexus_distance/2;
   Z_min=-upper_plexus_distance/2;   
end

current_network.X_min=X_min;current_network.X_max=X_max;
current_network.Y_min=Y_min;current_network.Y_max=Y_max;
current_network.Z_min=Z_min;current_network.Z_max=Z_max;
current_network.center_position=1/2*[X_max+X_min Y_max+Y_min Z_max+Z_min];
current_network.area=(current_network.X_max-current_network.X_min)*(current_network.Y_max-current_network.Y_min);

%% identifies if a node lies within the network or on the periphery
for i=1:length(current_network.node)
    cond=abs(current_network.node(i).coords(1)-X_min)>20;
    cond=cond*abs(current_network.node(i).coords(1)-X_max)>20;
    cond=cond*abs(current_network.node(i).coords(2)-Y_min)>20;
    cond=cond*abs(current_network.node(i).coords(2)-Y_max)>20;
    current_network.node(i).center_condition=cond;
end

for i=1:length(current_network.node)
    if current_network.node(i).BC==1
        if current_network.node(i).center_condition==1
            current_network.node(i).coords(3)=upper_plexus_distance;
            neigh_segment=current_network.node(i).neigh_segments(1);
            if current_network.segment(neigh_segment).nodes(1)==i
               for j=1:current_network.segment(neigh_segment).nbpoints
                   current_network.segment(neigh_segment).pt_coords(j,3)=upper_plexus_distance*(1-(j-1)/(current_network.segment(neigh_segment).nbpoints-1));
               end
            else
               for j=1:current_network.segment(neigh_segment).nbpoints
                   current_network.segment(neigh_segment).pt_coords(j,3)=upper_plexus_distance*((j-1)/(current_network.segment(neigh_segment).nbpoints-1));
               end                
            end
        end
    end
end

%% Parameter for the blood flow problem
Hd_inlet=0.4;
current_network.inlet_discharge_hematocrit=Hd_inlet;
mean_network_diameter=0;
for i=1:length(current_network.segment)
    current_network.segment(i).d=mean(current_network.segment(i).pt_D);
    if current_network.segment(i).d<3
        current_network.segment(i).d=3;
    end
    mean_network_diameter=mean_network_diameter+current_network.segment(i).d;
    L=0;
    pt_curv_coord=[L];
    for j=1:current_network.segment(i).nbpoints-1
        dL=norm(current_network.segment(i).pt_coords(j,:)-current_network.segment(i).pt_coords(j+1,:));
        L=L+dL;
        pt_curv_coord=[pt_curv_coord L];
    end
    current_network.segment(i).L=L;
    current_network.segment(i).pt_curv_coord=pt_curv_coord;
    
    current_network.segment(i).Hd=Hd_inlet;
    current_network.segment(i).inlet=0;
    current_network.segment(i).signQ=0;
end
mean_network_diameter=mean_network_diameter/length(current_network.segment);
current_network.dim_conductance=pi*10^4/(128*1e-3*50);

%% Boundary conditions for the blood flow problem inlet=injector point, Outlet=collector point
retina_area=6.3e6;
total_flowrate=5.8e7*current_network.area/retina_area;
nb_diving_vessel=0;
total_cross_section_area=0;
for i=1:length(current_network.node)
    if current_network.node(i).BC==1
        if current_network.node(i).center_condition
           nb_diving_vessel=nb_diving_vessel+1;
           neigh_segment=current_network.node(i).neigh_segments(1);
           total_cross_section_area=total_cross_section_area+pi*current_network.segment(neigh_segment).d^2/4;
        end
    end
end

position_resistor=current_network.center_position+785*[cos(resistor_orientation)  sin(resistor_orientation)  0];
for i=1:length(current_network.node)
    if current_network.node(i).BC==1
        if current_network.node(i).center_condition
           current_network.node(i).flow_BC_type=2;
           distance_to_resistor=norm(position_resistor-current_network.node(i).coords);
           neigh_segment=current_network.node(i).neigh_segments(1);
           neigh_diameter=mean_network_diameter;
           conductance_resistor=pi*neigh_diameter^4/(128*6e-3*distance_to_resistor);
           current_network.node(i).flow_BC_value(1)=conductance_resistor;
           current_network.node(i).flow_BC_value(2)=90*133;
        else
            distance_to_resistor=norm(position_resistor-current_network.node(i).coords);
            neigh_segment=current_network.node(i).neigh_segments(1);
            neigh_diameter=mean_network_diameter;current_network.segment(neigh_segment).d;
            conductance_resistor=pi*neigh_diameter^4/(128*6e-3*distance_to_resistor);
            current_network.node(i).flow_BC_type=2;
            current_network.node(i).flow_BC_value(1)=conductance_resistor;
            current_network.node(i).flow_BC_value(2)=20*133;
        end
    end
end

%% Discretization of segments for oxygen transport
point_idx=0;
% Size of the spacestep, here 10 microns
size_subsegments=10;
for i=1:length(current_network.segment)
    n_subsegments=floor(current_network.segment(i).L/size_subsegments);
    position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
    position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
    point_coords=[];
    point_indices=[];
    if n_subsegments>1
        new_size_subsegments=current_network.segment(i).L/n_subsegments;
        current_network.segment(i).dL=new_size_subsegments;
        for j=1:n_subsegments
            local_curv_coord_start=(j-1)*new_size_subsegments;
            local_curv_coord_end=j*new_size_subsegments;
            point_idx=point_idx+1;
            if j==1
                local_start_position=position_start;
            else
                local_start_position=convertCurvilinearToCartesian(local_curv_coord_start,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            end
  
            if(j==n_subsegments)
                local_end_position=position_end;
            else
                local_end_position=convertCurvilinearToCartesian(local_curv_coord_end,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            end
            local_coord=1/2*(local_start_position+local_end_position);
            point_coords=[point_coords; local_coord];
            point_indices=[point_indices point_idx];
        end
    else
        point_idx=point_idx+1;
        n_subsegments=1;
        current_network.segment(i).dL=current_network.segment(i).L;
        local_coord=1/2*(position_start+position_end);
        point_coords=[point_coords; local_coord];
        point_indices=[point_indices point_idx];
    end
    current_network.segment(i).nb_subsegments=n_subsegments;
    current_network.segment(i).point_coords=point_coords;
    current_network.segment(i).point_indices=point_indices;
end
current_network.nb_inner_points=point_idx;

%% Parameter for oxygen transport
current_network.Hill_C50=40.4;
current_network.co_alpha=0.5/(3.1e-5);
current_network.Hill_n=2.5;
current_network.C0=50;
current_network.dt=0.0393;
current_network.diffusion_coefficient=2e3;
for i=1:length(current_network.segment)
    current_network.segment(i).wall_permeability=1e3;
end

%% Boundary conditions for the oxygen transport problem inlet=Dirichlet, Outlet=Neumann
current_network.oxygen_inlet_concentration=95;
for i=1:length(current_network.node)
    if current_network.node(i).BC==1
        cond=abs(current_network.node(i).coords(1)-X_min)>20;
        cond=cond*abs(current_network.node(i).coords(1)-X_max)>20;
        cond=cond*abs(current_network.node(i).coords(2)-Y_min)>20;
        cond=cond*abs(current_network.node(i).coords(2)-Y_max)>20;
        if cond
            current_network.node(i).transport_BC_type=0;
            current_network.node(i).transport_BC_value=95;
        else
            current_network.node(i).transport_BC_type=1;
            current_network.node(i).transport_BC_value=0;
        end
    end
end

%% filter status necessary to run the simulations but useless in this context
for i=1:length(current_network.segment)
    current_network.segment(i).filter_status=0;
end

end

