function current_network = makeConsistentConnectivity(current_network)
%% This function makes the network connectivity compatible with the blood flow and oxygen transport solver, 
% i.e. ensure that there is no lone boundary node and no subnetwork without at least one boundary node

for i=1:length(current_network.node)
    current_network.node(i).BC=0;
    if length(current_network.node(i).neigh_nodes)<=1
        current_network.node(i).BC=1;
    end
end

for i=1:length(current_network.node)
    current_network.node(i).component=0;
end
nb_component=1;
for i=1:length(current_network.node)
    if current_network.node(i).BC==1
        if current_network.node(i).component==0
            current_network=exploreGraph(i,nb_component,current_network);
            nb_component=nb_component+1;
        end
    end
end
initial_nb_component=nb_component-1;

for i=1:initial_nb_component
    current_network.component(i).node_list=[];
end

node_without_component_list=[];
for i=1:length(current_network.node)
    component_idx=current_network.node(i).component;
    if component_idx>0
        current_network.component(component_idx).node_list=[current_network.component(component_idx).node_list i];
    else
        node_without_component_list=[node_without_component_list i];
    end
end

if ~isempty(node_without_component_list)
    for i=1:length(node_without_component_list)
        node_without_component=node_without_component_list(i);
        if current_network.node(node_without_component).component==0
            current_network=exploreGraph(node_without_component,nb_component,current_network);
            nb_component=nb_component+1;
        end
    end
    nb_component=nb_component-1;
    current_network.nb_component=nb_component;
    for i=initial_nb_component+1:nb_component
        current_network.component(i).node_list=[];
    end

    for i=1:length(current_network.node)
        component_idx=current_network.node(i).component;
        if component_idx>initial_nb_component
            current_network.component(component_idx).node_list=[current_network.component(component_idx).node_list i];
        end
    end

    for i=initial_nb_component+1:nb_component
        min_nb_neigh=inf;
        for j=1:length(current_network.component(i).node_list)
            local_node=current_network.component(i).node_list(j);
            if length(current_network.node(local_node).neigh_nodes)<min_nb_neigh
                min_nb_neigh=length(current_network.node(local_node).neigh_nodes);
                node_with_min_nb_neigh=local_node;
            end
        end
        current_network=addBoundaryNodeToComponent(current_network,i,current_network.node(node_with_min_nb_neigh).coords);
    end
end
current_network.nb_segment=length(current_network.segment);
current_network.nb_node=length(current_network.node);
end

