function current_network=makeConnectivityTable(current_network)
%% This function creates the connectivity table (i.e. neighborhood) associated with every node and every segment of the network
% along with identifying interior and boundary nodes

for i=1:length(current_network.node)
    current_network.node(i).neigh_segments=[];
end
for i=1:length(current_network.segment)
    if current_network.segment(i).nodes(1)~=current_network.segment(i).nodes(2)
        current_network.node(current_network.segment(i).nodes(1)).neigh_segments=[current_network.node(current_network.segment(i).nodes(1)).neigh_segments i];
        current_network.node(current_network.segment(i).nodes(2)).neigh_segments=[current_network.node(current_network.segment(i).nodes(2)).neigh_segments i]; 
    end
end
for i=1:length(current_network.node)
    current_network.node(i).neigh_nodes=[];
end
for i=1:length(current_network.node)
    for j=1:length(current_network.node(i).neigh_segments)
        neigh_segment_node=current_network.segment(current_network.node(i).neigh_segments(j)).nodes;
        for k=1:length(neigh_segment_node)
            if neigh_segment_node(k)~=i
               current_network.node(i).neigh_nodes=[current_network.node(i).neigh_nodes neigh_segment_node(k)]; 
            end
        end
    end
end

for i=1:length(current_network.node)
    l=length(current_network.node(i).neigh_nodes);
    if(l==1)
       current_network.node(i).BC=1;
    else
       current_network.node(i).BC=0;
    end
end

int_idx=0;
for i=1:length(current_network.node)
    if current_network.node(i).BC==0
        int_idx=int_idx+1;
        current_network.node(i).int_idx=int_idx;
    end
end


end

