function current_network=amReader(filename,status)
%% This function reads amiramesh SpatialGraph file format (.am)

fid = fopen(filename);
tline=fgets(fid);
string_array=strsplit(tline);
nb_fields=1;
while(strcmp(string_array{1,1},'@1')==0)
    str=string_array{1,1};
    if(status=="full")
        condition=strcmp(str,'VERTEX')||strcmp(str,'EDGE')||strcmp(str,'POINT');
    else
        condition=strcmp(str,'VERTEX')||strcmp(str,'EDGE');
    end
    if(condition)
        l=length(string_array);
        FIELDS{nb_fields,1}=string_array{1,1};
        FIELDS{nb_fields,2}=string_array{1,l-1};
        FIELDS{nb_fields,3}=string_array{1,l-3};
        nb_fields=nb_fields+1;
    end
    tline=fgets(fid);
    string_array=strsplit(tline);
end
key='@1';
ValSet=[1,1];
map=containers.Map(key,ValSet);
num_field=1;
i=1;
if status=="full"
    while (tline ~=-1)
        tline=fgets(fid);
        if(tline~=-1)
            string_array=strsplit(tline);
            if(strcmp(string_array{1,1},strcat('@',num2str(num_field+1))))
                map(key)=ValSet;
                num_field=num_field+1;
                key=strcat('@',num2str(num_field));
                ValSet=[];
                i=1;
            elseif(strcmp(string_array{1,1},''))
            else
                for k=1:length(string_array)-1
                    str2num(string_array{1,k});
                    ValSet(i,k)=str2num(string_array{1,k});
                end
                i=i+1;
            end
        end
    end
else
    while (key ~="@4")
        tline=fgets(fid);
        if(tline~=-1)
            string_array=strsplit(tline);
            if(strcmp(string_array{1,1},strcat('@',num2str(num_field+1))))
                map(key)=ValSet;
                num_field=num_field+1;
                key=strcat('@',num2str(num_field));
                ValSet=[];
                i=1;
            elseif(strcmp(string_array{1,1},''))
            else
                for k=1:length(string_array)-1
                    str2num(string_array{1,k});
                    ValSet(i,k)=str2num(string_array{1,k});
                end
                i=i+1;
            end
        end
    end
end
map(key)=ValSet;
for num_field=1:length(FIELDS)
    num_field;
    if (strcmp(FIELDS{num_field,1},'VERTEX'))
        
        if(strcmp(FIELDS{num_field,3},'VertexCoordinates'))
            ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.node(i).coords(1)=ValSet(i,1);
                current_network.node(i).coords(2)=ValSet(i,2);
                current_network.node(i).coords(3)=ValSet(i,3);
            end
        elseif(strcmp(FIELDS{num_field,3},'pressure') || strcmp(FIELDS{num_field,3},'Pressure'))
            
             ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.node(i).P=ValSet(i,1);
            end
        end
    elseif (strcmp(FIELDS{num_field,1},'EDGE'))
        if(strcmp(FIELDS{num_field,3},'EdgeConnectivity'))
            ValSet=map(FIELDS{num_field,2});
           for i=1:length(ValSet)
               current_network.segment(i).nodes(1)=ValSet(i,1)+1;
               current_network.segment(i).nodes(2)=ValSet(i,2)+1;
           end
        elseif(strcmp(FIELDS{num_field,3},'NumEdgePoints'))
           ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).nbpoints=ValSet(i,1);
            end
        elseif(strcmp(FIELDS{num_field,3},'thickness')||strcmp(FIELDS{num_field,3},'Thickness'))
             ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).thickness=ValSet(i,1);
            end
        elseif(strcmp(FIELDS{num_field,3},'flowrate')||strcmp(FIELDS{num_field,3},'FlowRate')||strcmp(FIELDS{num_field,3},'Flowrate'))
             ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).flowrate=ValSet(i,1);
            end
        elseif(strcmp(FIELDS{num_field,3},'EdgeArtificial'))
             ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).EdgeArtificial=ValSet(i,1);
            end
        elseif(strcmp(FIELDS{num_field,3},'Length')||strcmp(FIELDS{num_field,3},'length'))
             ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).length=ValSet(i,1);
            end
        elseif(strcmp(FIELDS{num_field,3},'ArtVenCap')||strcmp(FIELDS{num_field,3},'artvencap'))
            ValSet=map(FIELDS{num_field,2});
            for i=1:length(ValSet)
                current_network.segment(i).ArtVenCap=ValSet(i,1);
            end
        end
    end
end

for num_field=1:length(FIELDS)
    num_field;
    if (strcmp(FIELDS{num_field,1},'POINT'))
        ValSet=map(FIELDS{num_field,2});
        if(strcmp(FIELDS{num_field,3},'EdgePointCoordinates'))
            pt_idx=1;
            for k=1:length(current_network.segment)
                nb_pts=current_network.segment(k).nbpoints;
                rank_min=pt_idx;
                rank_max=pt_idx+nb_pts;
                p=1;
                while pt_idx<rank_max
                    current_network.segment(k).pt_coords(p,1)=ValSet(pt_idx,1);
                    current_network.segment(k).pt_coords(p,2)=ValSet(pt_idx,2);
                    current_network.segment(k).pt_coords(p,3)=ValSet(pt_idx,3);
                    pt_idx=pt_idx+1;
                    p=p+1;
                end
            end
        end
	if(strcmp(FIELDS{num_field,3},'Pressure'))
	   pt_idx=1;
	   for k=1:length(current_network.segment)
	       nb_pts=current_network.segment(k).nbpoints;
	       rank_min=pt_idx;
	       rank_max=pt_idx+nb_pts;
	       p=1;
	       while pt_idx<rank_max
	       	     current_network.segment(k).pt_P(p)=ValSet(pt_idx,1);
		     pt_idx=pt_idx+1;
		     p=p+1;
	       end
	   end
	end
	if(strcmp(FIELDS{num_field,3},'FlowRate'))
	  pt_idx=1;
	  for k=1:length(current_network.segment)
	      current_network.segment(k).Q=ValSet(pt_idx,1);
	      pt_idx=pt_idx+current_network.segment(k).nbpoints;
	  end
	end
	if(strcmp(FIELDS{num_field,3},'thickness'))
	   pt_idx=1;
	   for k=1:length(current_network.segment)
	       nb_pts=current_network.segment(k).nbpoints;
	       rank_min=pt_idx;
	       rank_max=pt_idx+nb_pts;
	       p=1;
	       while pt_idx<rank_max
	       	     current_network.segment(k).pt_D(p)=ValSet(pt_idx,1);
		     pt_idx=pt_idx+1;
		     p=p+1;
	       end
	   end
    end	
	if(strcmp(FIELDS{num_field,3},'Radii')||strcmp(FIELDS{num_field,3},'Radius'))
	   pt_idx=1;
	   for k=1:length(current_network.segment)
	       nb_pts=current_network.segment(k).nbpoints;
	       rank_min=pt_idx;
	       rank_max=pt_idx+nb_pts;
	       p=1;
	       while pt_idx<rank_max
	       	     current_network.segment(k).pt_D(p)=2*ValSet(pt_idx,1);
		     pt_idx=pt_idx+1;
		     p=p+1;
	       end
	   end
	end
    
    end
end


    
                    
end                 
               





