function plotTissue(current_network,current_tissue)
%% This function plots the oxygen concentration withing the network (node and segment) and tissue
k=1;
for j=1:current_tissue.grid.nb_cell_list(2)
    for i=1:current_tissue.grid.nb_cell_list(1)
        l=i+(j-1)*current_tissue.grid.nb_cell_list(1)+current_tissue.grid.nb_cell_list(1)*current_tissue.grid.nb_cell_list(2)*(k-1);
        X(i,j)=current_tissue.grid.cell_position_list(l,1);
        Y(i,j)=current_tissue.grid.cell_position_list(l,2);
        if current_tissue.grid.concentration(l)<0
           current_tissue.grid.concentration(l)
           current_tissue.grid.concentration(l)=0;
        end
        C1(i,j)=current_tissue.grid.concentration(l);
        if C1(i,j)>70
            C2(i,j)=0;
        else
            C2(i,j)=1;
        end
    end
end

figure
%colormap('cool')
local_color_2=rgb('DarkRed');
local_color_1=rgb('LavenderBlush');
n_step=50;
vec=local_color_2-local_color_1;
norm_color=norm(vec);
vec_norm=vec/norm_color;
Nsubcolor=50;
dColor=norm_color/Nsubcolor;
color_list=[];
for i=1:Nsubcolor
    local_color=local_color_1+(i-1)*dColor*vec_norm;
    color_list=[color_list; local_color];
end

colormap(color_list)%color_list
nb_color=1000;
n = length(X);
h=pcolor(X,Y,C1);
set(h,'edgecolor','none')
h.FaceColor = 'interp';
caxis([10 70])
%view(0,90)
colorbar
axis([ current_network.X_min-10 current_network.X_max+10 current_network.Y_min-10 current_network.Y_max+10])
hold on

c_array=copper(nb_color);
Cmax=0;
Cmin=inf;
for i=1:length(current_network.segment)
    for j=1:length(current_network.segment(i).point_indices)
        if(current_network.segment(i).intra_concentration(j)>Cmax)
            Cmax=current_network.segment(i).intra_concentration(j);
        end
        if(current_network.segment(i).intra_concentration(j)<Cmin)
           Cmin=current_network.segment(i).intra_concentration(j);
        end
    end
end
max_dC=Cmax-Cmin;
dCcolor=max_dC/nb_color;
for i=1:length(current_network.segment)
    position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
    position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
    if current_network.segment(i).nb_subsegments>1
        for j=1:current_network.segment(i).nb_subsegments
            if j==1
                local_start_position=position_start;
                local_end_position=1/2*(current_network.segment(i).point_coords(j,:)+current_network.segment(i).point_coords(j+1,:));
            elseif j==current_network.segment(i).nb_subsegments
                local_end_position=position_end;
                local_start_position=1/2*(current_network.segment(i).point_coords(j-1,:)+current_network.segment(i).point_coords(j,:));
            else
                local_start_position=1/2*(current_network.segment(i).point_coords(j-1,:)+current_network.segment(i).point_coords(j,:));
                local_end_position=1/2*(current_network.segment(i).point_coords(j,:)+current_network.segment(i).point_coords(j+1,:));
            end
            local_C=current_network.segment(i).intra_concentration(j);
            color_idx=min(floor((local_C-Cmin)/dCcolor)+1,nb_color);
            local_color=c_array(color_idx,:);
            plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/3,'Color',local_color)
            hold on
        end
    else
       local_C=current_network.segment(i).intra_concentration;
       color_idx=min(floor((local_C-Cmin)/dCcolor)+1,nb_color);
       local_color=c_array(color_idx,:);
       plot3([position_start(1) position_end(1)],[position_start(2) position_end(2)],[position_start(3) position_end(3)],'LineWidth',current_network.segment(i).d/5,'Color',local_color)
       hold on
    end
end
set(gca,'visible','off')
axis square
axis off
title('Oxygen level in tissue and network')







end

    