function plotNetworkGeometry(current_network,n_subsegments,segment_to_highlight_list,figtype)
%% This function plots the Network geometry, including the vessel and the boundary nodes
if(figtype==0)
    figure
    for i=1:length(current_network.segment)
        position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
        position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
        dX=current_network.segment(i).L/n_subsegments;
        local_start_idx=1;
        for j=1:n_subsegments
            l=0;
            for k=local_start_idx:length(current_network.segment(i).pt_D)-1
                dx=norm(current_network.segment(i).pt_coords(k+1,:)-current_network.segment(i).pt_coords(k,:));
                l=l+dx;
                if l>dX
                    local_end_idx=k+1;
                    break
                end

                if k+1==length(current_network.segment(i).pt_D)
                    local_end_idx=k+1;
                    break
                end
            end

            if local_start_idx==local_end_idx
                break
            end

            local_start_position=current_network.segment(i).pt_coords(local_start_idx,:);
            local_end_position=current_network.segment(i).pt_coords(local_end_idx,:);


            local_start_idx=local_end_idx;
            if any(i==segment_to_highlight_list)
                plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',4,'Color','r')
            else
                plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/3,'Color','k')
            end
            hold on
        end
    end
%     set(gca,'XTick',[])
%     set(gca,'YTick',[])
    view(2)
    axis square
elseif(figtype==1)

    figure
    for i=1:length(current_network.segment)
        position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
        position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
        dX=current_network.segment(i).L/n_subsegments;
        local_start_idx=1;
        for j=1:n_subsegments
            l=0;
            for k=local_start_idx:length(current_network.segment(i).pt_D)-1
                dx=norm(current_network.segment(i).pt_coords(k+1,:)-current_network.segment(i).pt_coords(k,:));
                l=l+dx;
                if l>dX
                    local_end_idx=k+1;
                    break
                end

                if k+1==length(current_network.segment(i).pt_D)
                    local_end_idx=k+1;
                    break
                end
            end

            if local_start_idx==local_end_idx
                break
            end

            local_start_position=current_network.segment(i).pt_coords(local_start_idx,:);
            local_end_position=current_network.segment(i).pt_coords(local_end_idx,:);


            local_start_idx=local_end_idx;
            if any(i==segment_to_highlight_list)
                plot([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],'LineWidth',4,'Color','r')
            else
                plot([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],'LineWidth',4,'Color','k')
            end
            hold on


        end
    end
    for i=1:length(current_network.node)
        if current_network.node(i).BC==1
            if current_network.node(i).center_condition==1
                plot(current_network.node(i).coords(1),current_network.node(i).coords(2),'o','MarkerSize',8,'MarkerEdgeColor','g','MarkerFaceColor','g')
                hold on
            else
                plot(current_network.node(i).coords(1),current_network.node(i).coords(2),'o','MarkerSize',8,'MarkerEdgeColor','m','MarkerFaceColor','m')
                hold on
            end
        end
    end
    set(gca,'XTick',[])
    set(gca,'YTick',[])
    axis([current_network.X_min-20 current_network.X_max+20 current_network.Y_min-20 current_network.Y_max+20])
    view(2)
    axis square

elseif(figtype==2)
    figure
    for i=1:length(current_network.segment)

        L=0;
        for j=1:current_network.segment(i).nbpoints-1
            dL=norm(current_network.segment(i).pt_coords(j,:)-current_network.segment(i).pt_coords(j+1,:));
            L=L+dL;
        end
        current_network.segment(i).L=L;

        position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
        position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
        dX=current_network.segment(i).L/n_subsegments;
        local_start_idx=1;
        for j=1:n_subsegments
            l=0;
            for k=local_start_idx:length(current_network.segment(i).pt_D)-1
                dx=norm(current_network.segment(i).pt_coords(k+1,:)-current_network.segment(i).pt_coords(k,:));
                l=l+dx;
                if l>dX
                    local_end_idx=k+1;
                    break
                end

                if k+1==length(current_network.segment(i).pt_D)
                    local_end_idx=k+1;
                    break
                end
            end

            if local_start_idx==local_end_idx
                break
            end

            local_start_position=current_network.segment(i).pt_coords(local_start_idx,:);
            local_end_position=current_network.segment(i).pt_coords(local_end_idx,:);

            local_start_idx=local_end_idx;
            if any(i==segment_to_highlight_list)
                plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',4,'Color','r')
            else
                plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',4,'Color','k')
            end
            hold on
        end
    end

    for i=1:length(current_network.node)
        if current_network.node(i).BC==1
            plot3(current_network.node(i).coords(1),current_network.node(i).coords(2),current_network.node(i).coords(3),'o','MarkerSize',8,'MarkerEdgeColor','g','MarkerFaceColor','g')
            hold on
        end
    end
    view(2)



end


