function plotNetwork(current_network)
%% This function plots the Pressure, absolute flowrate and discharge hematocrit fields solution of the blood flow problem


%% plot the pressure distribution
figure
nb_color=1000;
c_array=jet(nb_color);

Pmax=0;
Pmin=inf;
for i=1:length(current_network.node)
    if(current_network.node(i).P>Pmax)
        Pmax=current_network.node(i).P;
    end
    if(current_network.node(i).P<Pmin)
        Pmin=current_network.node(i).P;
    end
end
if Pmax>70*133
    Pmax=70*133;
end

max_dP=Pmax-Pmin;
dPcolor=max_dP/nb_color;

size_subsegments=20;
for i=1:length(current_network.segment)
    n_subsegments=floor(current_network.segment(i).L/size_subsegments);
    Pstart=current_network.node(current_network.segment(i).nodes(1)).P;
    position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
    Pend=current_network.node(current_network.segment(i).nodes(2)).P;
    position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
    dP=(Pend-Pstart);
    if n_subsegments>0
        for j=1:n_subsegments
            local_curv_coord_start=(j-1)*size_subsegments;
            local_curv_coord_end=j*size_subsegments;
            if j==1
                local_start_position=position_start;
            else
                local_start_position=convertCurvilinearToCartesian(local_curv_coord_start,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            end
            local_end_position=convertCurvilinearToCartesian(local_curv_coord_end,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            if(abs(dP)>-1)
                local_P=Pstart+dP*(local_curv_coord_start+local_curv_coord_end)/(2*current_network.segment(i).L);
                color_idx=min(floor((local_P-Pmin)/dPcolor)+1,nb_color);
                local_c=c_array(color_idx,:);
            else
                local_c=c_array(1,:);
            end
            plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
            hold on
        end
        local_start_position=local_end_position;
        local_end_position=position_end;
        if(abs(dP)>0)
                local_P=Pstart+dP*(local_curv_coord_start+local_curv_coord_end)/(2*current_network.segment(i).L);
                color_idx=min(floor((local_P-Pmin)/dPcolor)+1,nb_color);
                local_c=c_array(color_idx,:);
        else
                local_c=c_array(1,:);
        end
        plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
    else
       if(abs(dP)>0)
          local_P=Pstart+dP/2;
          color_idx=min(floor((local_P-Pmin)/dPcolor)+1,nb_color);
          local_c=c_array(color_idx,:);
       else
          local_c=c_array(1,:);
       end
       plot3([position_start(1) position_end(1)],[position_start(2) position_end(2)],[position_start(3) position_end(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
       hold on
    end
end
colormap(c_array)
colorbar
set(gca,'XTick',[])
set(gca,'YTick',[])
title('Pressure')
caxis([3000 9000])
axis square
set(gca,'FontSize',22)
view(2)
axis([ current_network.X_min-10 current_network.X_max+10 current_network.Y_min-10 current_network.Y_max+10])

%% plot the absolute flow rate distribution
figure
c_array=summer(nb_color);
Qmax=0;
Qmin=inf;
for i=1:length(current_network.segment)
    if(current_network.segment(i).absQ>Qmax)
        Qmax=current_network.segment(i).absQ;
    end
    if(current_network.segment(i).absQ<Qmin)
        Qmin=current_network.segment(i).absQ;
    end
end
max_dQ=Qmax-Qmin;
%max_dQ=0.1*max_dQ;
dQcolor=max_dQ/nb_color;
size_subsegments=20;
for i=1:length(current_network.segment)
    n_subsegments=floor(current_network.segment(i).L/size_subsegments);
    position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
    position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
    
    local_Q=current_network.segment(i).absQ;
    color_idx=min(floor((local_Q-Qmin)/dQcolor),nb_color);
    if(color_idx==0)
       color_idx=1;
    end
    local_c=c_array(color_idx,:);
    
    if n_subsegments>0
        for j=1:n_subsegments
            local_curv_coord_start=(j-1)*size_subsegments;
            local_curv_coord_end=j*size_subsegments;
            if j==1
                local_start_position=position_start;
            else
                local_start_position=convertCurvilinearToCartesian(local_curv_coord_start,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            end
            local_end_position=convertCurvilinearToCartesian(local_curv_coord_end,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
            hold on
        end
        local_start_position=local_end_position;
        local_end_position=position_end;
        plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
    else
       plot3([position_start(1) position_end(1)],[position_start(2) position_end(2)],[position_start(3) position_end(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
       hold on
    end
    
end
colormap(c_array)
colorbar;
view(2)
axis([ current_network.X_min-10 current_network.X_max+10 current_network.Y_min-10 current_network.Y_max+10])
title('Absolute Flowrate')

%% plot the discharge hematocrit distribution
figure
c_array=winter(nb_color);
Hdmax=0;
Hdmin=inf;
for i=1:length(current_network.segment)
    if(current_network.segment(i).Hd>Hdmax)
        Hdmax=current_network.segment(i).Hd;
    end
    if(current_network.segment(i).Hd<Hdmin)
        Hdmin=current_network.segment(i).Hd;
    end
end
Hdmax=1;
max_dHd=Hdmax-Hdmin;
dHdcolor=max_dHd/nb_color;
size_subsegments=20;
for i=1:length(current_network.segment)
    n_subsegments=floor(current_network.segment(i).L/size_subsegments);
    position_start=current_network.node(current_network.segment(i).nodes(1)).coords;
    position_end=current_network.node(current_network.segment(i).nodes(2)).coords;
    
    local_Hd=current_network.segment(i).Hd;
    color_idx=min(floor((local_Hd-Hdmin)/dHdcolor),nb_color);
    if(color_idx==0)
       color_idx=1;
    end
    local_c=c_array(color_idx,:);
    
    if n_subsegments>0
        for j=1:n_subsegments
            local_curv_coord_start=(j-1)*size_subsegments;
            local_curv_coord_end=j*size_subsegments;
            if j==1
                local_start_position=position_start;
            else
                local_start_position=convertCurvilinearToCartesian(local_curv_coord_start,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            end
            local_end_position=convertCurvilinearToCartesian(local_curv_coord_end,current_network.segment(i).pt_coords,current_network.segment(i).pt_curv_coord);
            plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
            hold on
        end
        local_start_position=local_end_position;
        local_end_position=position_end;
        plot3([local_start_position(1) local_end_position(1)],[local_start_position(2) local_end_position(2)],[local_start_position(3) local_end_position(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
    else
       plot3([position_start(1) position_end(1)],[position_start(2) position_end(2)],[position_start(3) position_end(3)],'LineWidth',current_network.segment(i).d/2,'Color',local_c)
       hold on
    end
    
end
colormap(c_array)
colorbar;
view(2)
axis([ current_network.X_min-10 current_network.X_max+10 current_network.Y_min-10 current_network.Y_max+10])
title('Discharge hematocrit')


end

