function FQE=computePries(d0,d1,d2,Hd0,FQB)
%% function that compute Pries' law describing phase separation effect at a diverging bifurcation
A=-15.47*(d1^2-d2^2)/(d1^2+d2^2)*(1-Hd0)/d0;
B=1+8.13*(1-Hd0)/d0;
X0=1.12*(1-Hd0)/d0;
Y0=(FQB-X0)/(1-2*X0);

FQE=((FQB-X0)>0)*((1-X0-FQB)>0)*exp(A+B*log(Y0/(1-Y0)))/(1+exp(A+B*log(Y0/(1-Y0))))+((FQB-1+X0)>0);

end

