function current_network = computePressureMatrixStructure(current_network)
%% This function computes the structure of the matrix necessary to solve the blood flow problem
%i.e. identifying the indices of non zeros elements of the matrix
row=[];
column=[];
for i=1:length(current_network.node)
    neigh_nodes=current_network.node(i).neigh_nodes;
    for j=1:length(neigh_nodes)
       row=[row; i];
       column=[column; neigh_nodes(j)];
    end
    row=[row; i];
    column=[column; i];
end 
current_network.pressure_matrix_structure=[row column];
end

