function current_network=computePressureMatrixAndRHS(current_network)
%% This function compute the Matrix and Right Hand Side associated to the Blood flow problem : sum(Q)_node(i)=0 with Q=G*(Pstart-Pend)

RHS=zeros(length(current_network.node),1);
data=zeros(length(current_network.pressure_matrix_structure(:,1)),1);
idx=1;
for i=1:length(current_network.node)
    node=current_network.node(i);
    diag=0;
    if node.BC==0
        neigh_edges=node.neigh_segments;
        for j=1:length(neigh_edges)
            neigh_edge=neigh_edges(j);
            diag=diag+current_network.segment(neigh_edge).G;
            data(idx)=-current_network.segment(neigh_edge).G;
            idx=idx+1;
        end
        if diag==0
           diag=current_network.dim_conductance;
        end
        data(idx)=diag;
        idx=idx+1;
    else
        if(isempty(node.neigh_segments))
            data(idx)=current_network.dim_conductance;
            idx=idx+1;
        else
            neigh_edge=node.neigh_segments(1);
            if(node.flow_BC_type==0)
               RHS(i)=RHS(i)+current_network.segment(neigh_edge).G*node.flow_BC_value;
               data(idx)=0;
               idx=idx+1;
               diag=diag+current_network.segment(neigh_edge).G;
            end
            if(node.flow_BC_type==1)
               data(idx)=-current_network.segment(neigh_edge).G;
               idx=idx+1;
               diag=diag+current_network.segment(neigh_edge).G;
               RHS(i)=RHS(i)-node.flow_BC_value;
            end
            if(node.flow_BC_type==2)
               data(idx)=-current_network.segment(neigh_edge).G;
               idx=idx+1;
               diag=diag+current_network.segment(neigh_edge).G+node.flow_BC_value(1);
               RHS(i)=RHS(i)+node.flow_BC_value(1)*node.flow_BC_value(2);
            end

            if diag==0
               diag=current_network.dim_conductance;
            end
            data(idx)=diag;
            idx=idx+1;
        end
    end
end
current_network.data=data;
row=current_network.pressure_matrix_structure(:,1);
column=current_network.pressure_matrix_structure(:,2);
current_network.pressure_matrix=sparse(row,column,data,current_network.nb_node,current_network.nb_node);
current_network.pressure_rhs=RHS;

end

