function  current_network=computePressureAndFlowrate(S, current_network)
%% This function associates each node with a pressure and each segment with a flow rate

for i=1:length(current_network.node)
    current_network.node(i).P=S(i);
end

current_network.update_hematocrit_structure=0;
for i=1:length(current_network.segment)
    if(current_network.segment(i).filter_status==0)
        P1=current_network.node(current_network.segment(i).nodes(1)).P;
        P2=current_network.node(current_network.segment(i).nodes(2)).P;
        current_network.segment(i).Q=current_network.segment(i).G*(P1-P2);
    else
        current_network.segment(i).Q=0;
    end
    current_network.segment(i).absQ=abs(current_network.segment(i).Q);
    signQ=sign(current_network.segment(i).Q);
    if(signQ ~=current_network.segment(i).signQ)
       current_network.update_hematocrit_structure=1;
    end
    current_network.segment(i).signQ=signQ;
end

current_network.perfusion=0;
for i=1:length(current_network.node)
    if current_network.node(i).BC==1
       if isempty(current_network.node(i).neigh_segments)==0
          current_network.perfusion=current_network.perfusion+0.5*abs(current_network.segment(current_network.node(i).neigh_segments(1)).Q);
       end
    end
end

end

