function current_network = computeFlow(current_network)
%% This function solves the blood flow problem, i.e. computes the distribution of pressure, flow rate and discharge hematocrit throughout the network
global params
j=0;
resHd=[inf inf];

if params.solve_RBC==1
    %% solve iteratively the pressure, flow rate and hematocrit with stopping criterion on overall conservation of red blood cell flow rate conservation
    while (resHd(1)>1e-4 || resHd(2)>1e-6) && j<1000
        j=j+1;
        if j<500
            current_network=computeApparentViscosity(current_network);
            current_network=computeSegmentConductance(current_network);

            current_network=computePressureMatrixAndRHS(current_network);
            S=current_network.pressure_matrix\current_network.pressure_rhs;
            current_network=computePressureAndFlowrate(S,current_network);
        end
        if current_network.inlet_discharge_hematocrit>1e-10
            current_network.update_hematocrit_structure=1;
            if(current_network.update_hematocrit_structure==1)
                current_network=computeBifurcationNature(current_network);
            end
            [resHd, current_network]=computeDischargeHematocrit(current_network);
        else
            resHd(1)=0;
            resHd(2)=0;
        end
    end
    %this line can be uncommented to access convergence status
    %resh_flow=[j log10(resHd)]
else
    current_network=computeApparentViscosity(current_network);
    current_network=computeSegmentConductance(current_network);

    current_network=computePressureMatrixAndRHS(current_network);
    S=current_network.pressure_matrix\current_network.pressure_rhs;
    current_network=computePressureAndFlowrate(S,current_network);
end

current_network.S=S;
end
