function [resHd, current_network]=computeDischargeHematocrit(current_network)
%% This function compute the discharge hematocrit distribution throughout the network, using Pries' laws 
H_buffer=zeros(length(current_network.segment),1);

for i=1:length(current_network.node)
    if current_network.node(i).BC==0
        P=current_network.node(i).P;
        if current_network.node(i).bifurcation_type==-1
            downstream_segments=current_network.node(i).downstream_segments;
            for j=1:length(downstream_segments)
                H_buffer(downstream_segments(j))=0;
            end
        elseif current_network.node(i).bifurcation_type==0
            upstream_RBC_flowrate=0;
            for j=1:length(current_network.node(i).upstream_segments)
                upstream_Hd=current_network.segment(current_network.node(i).upstream_segments(j)).Hd;
                upstream_flowrate=current_network.segment(current_network.node(i).upstream_segments(j)).absQ;
                upstream_RBC_flowrate=upstream_RBC_flowrate+abs(upstream_Hd*upstream_flowrate);
            end
            downstream_flowrate=current_network.segment(current_network.node(i).downstream_segments(1)).absQ;
            downstream_Hd=upstream_RBC_flowrate/downstream_flowrate;
            H_buffer(current_network.node(i).downstream_segments(1))=downstream_Hd;
        elseif current_network.node(i).bifurcation_type==1
            upstream_flowrate=current_network.segment(current_network.node(i).upstream_segments(1)).absQ;
            upstream_Hd=current_network.segment(current_network.node(i).upstream_segments(1)).Hd;
            upstream_RBC_flowrate=upstream_flowrate*upstream_Hd;
            upstream_diameter=current_network.segment(current_network.node(i).upstream_segments(1)).d;
            
            downstream_flowrate_1=current_network.segment(current_network.node(i).downstream_segments(1)).absQ;
            downstream_d_1=current_network.segment(current_network.node(i).downstream_segments(1)).d;
            downstream_flowrate_fraction_1=downstream_flowrate_1/upstream_flowrate;
            
            downstream_flowrate_2=current_network.segment(current_network.node(i).downstream_segments(2)).absQ;
            downstream_d_2=current_network.segment(current_network.node(i).downstream_segments(2)).d;
            downstream_flowrate_fraction_2=downstream_flowrate_2/upstream_flowrate;
            
            downstream_RBC_flowrate_fraction_1=computePries(upstream_diameter,downstream_d_1,downstream_d_2,upstream_Hd,downstream_flowrate_fraction_1);
            downstream_RBC_flowrate_fraction_2=1-downstream_RBC_flowrate_fraction_1;
            downstream_Hd_1=upstream_Hd*downstream_RBC_flowrate_fraction_1/downstream_flowrate_fraction_1;
            downstream_Hd_2=upstream_Hd*downstream_RBC_flowrate_fraction_2/downstream_flowrate_fraction_2;
            
            if(upstream_Hd==1)
                downstream_Hd_1=1;
                downstream_Hd_2=1;
            end
            
            if(downstream_Hd_1>1)
                downstream_Hd_1=1;
                downstream_Hd_2=(upstream_RBC_flowrate-downstream_flowrate_1)/downstream_flowrate_2;
            elseif downstream_Hd_2>1
                downstream_Hd_2=1;
                downstream_Hd_1=(upstream_RBC_flowrate-downstream_flowrate_2)/downstream_flowrate_1;
            end
            
            H_buffer(current_network.node(i).downstream_segments(1))=downstream_Hd_1;
            H_buffer(current_network.node(i).downstream_segments(2))=downstream_Hd_2;
        elseif current_network.node(i).bifurcation_type==2
            upstream_segments=current_network.node(i).upstream_segments;
            upstream_flowrate_equivalent=0;
            upstream_RBC_flowrate_equivalent=0;
            upstream_diameter_equivalent=0;
            for j=1:length(upstream_segments)
                upstream_flowrate_equivalent=upstream_flowrate_equivalent+current_network.segment(upstream_segments(j)).absQ;
                upstream_RBC_flowrate_equivalent=upstream_RBC_flowrate_equivalent+current_network.segment(upstream_segments(j)).absQ*current_network.segment(upstream_segments(j)).Hd;
                upstream_diameter_equivalent=upstream_diameter_equivalent+current_network.segment(upstream_segments(j)).d^2;
            end
            upstream_diameter_equivalent=sqrt(upstream_diameter_equivalent);
            upstream_hematocrit_equivalent=upstream_RBC_flowrate_equivalent/upstream_flowrate_equivalent;
            
            downstream_segments=current_network.node(i).downstream_segments;
            max_downstream_flowrate=-inf;
            for j=1:length(downstream_segments)
                if current_network.segment(downstream_segments(j)).absQ>max_downstream_flowrate
                    max_downstream_flowrate=current_network.segment(downstream_segments(j)).absQ;
                    downstream_segment_equivalent_1_idx=downstream_segments(j);
                end
            end
            downstream_flowrate_equivalent_1=max_downstream_flowrate;
            downstream_diameter_equivalent_1=current_network.segment(downstream_segment_equivalent_1_idx).d;
            
            downstream_segment_equivalent_2_list=[];
            for j=1:length(downstream_segments)
                if downstream_segments(j)~=downstream_segment_equivalent_1_idx
                    downstream_segment_equivalent_2_list=[downstream_segment_equivalent_2_list downstream_segments(j)];
                end
            end
            downstream_flowrate_equivalent_2=0;
            downstream_diameter_equivalent_2=0;
            for j=1:length(downstream_segment_equivalent_2_list)
                downstream_flowrate_equivalent_2=downstream_flowrate_equivalent_2+current_network.segment(downstream_segment_equivalent_2_list(j)).absQ;
                downstream_diameter_equivalent_2=downstream_diameter_equivalent_2+current_network.segment(downstream_segment_equivalent_2_list(j)).d^2;
            end
            downstream_diameter_equivalent_2=sqrt(downstream_diameter_equivalent_2);
            
            
            FQB_equivalent_1=downstream_flowrate_equivalent_1/upstream_flowrate_equivalent;
            FQE_equivalent_1=computePries(upstream_diameter_equivalent,downstream_diameter_equivalent_1,downstream_diameter_equivalent_2,upstream_hematocrit_equivalent,FQB_equivalent_1);
            
            downstream_hematocrit_equivalent_1=upstream_hematocrit_equivalent*FQE_equivalent_1/FQB_equivalent_1;
            downstream_hematocrit_equivalent_2=upstream_hematocrit_equivalent*(1-FQE_equivalent_1)/(1-FQB_equivalent_1);
            
            if(upstream_hematocrit_equivalent==1)
                downstream_hematocrit_equivalent_1=1;
                downstream_hematocrit_equivalent_2=1;
            end
            
            if(downstream_hematocrit_equivalent_1>1)
                downstream_hematocrit_equivalent_1=1;
                downstream_hematocrit_equivalent_2=(upstream_flowrate_equivalent-downstream_flowrate_equivalent_1)/downstream_flowrate_equivalent_2;
            elseif downstream_hematocrit_equivalent_2>1
                downstream_hematocrit_equivalent_2=1;
                downstream_hematocrit_equivalent_1=(upstream_flowrate_equivalent-downstream_flowrate_equivalent_2)/downstream_flowrate_equivalent_1;
            end
            
            H_buffer(downstream_segment_equivalent_1_idx)=downstream_hematocrit_equivalent_1;
            for j=1:length(downstream_segment_equivalent_2_list)
                H_buffer(downstream_segment_equivalent_2_list(j))=downstream_hematocrit_equivalent_2;
            end
        end
    end
end

%% remove the possible inf due to dividing by zero
for i=1:length(current_network.segment)
    if current_network.segment(i).absQ==0
        H_buffer(i)=0;
    end
    
    if H_buffer(i)>1
        H_buffer(i)=1;
    end
    
end

%% update the hematocrit field and compute residuals
relaxation_factor=0.2;
Hd_previous_iteration=zeros(length(current_network.segment),1);
Hd_current_iteration=zeros(length(current_network.segment),1);
for i=1:length(current_network.segment)
    Hd_previous_iteration(i)=current_network.segment(i).Hd;
    if current_network.segment(i).inlet==0
        if(abs(current_network.segment(i).Q/current_network.perfusion)>1e-5)
            current_network.segment(i).Hd=relaxation_factor*H_buffer(i)+(1-relaxation_factor)*current_network.segment(i).Hd;
        else
            current_network.segment(i).Hd=0;
        end
    end
    Hd_current_iteration(i)=current_network.segment(i).Hd;
end
global_variation=norm(Hd_previous_iteration-Hd_current_iteration)/norm(Hd_current_iteration);

total_conservation=0;
for i=1:length(current_network.node)
    if current_network.node(i).BC==0
        local_RBC_conservation=0;
        local_conservation=0;
        for j=1:length(current_network.node(i).upstream_segments)
            upstream_segment=current_network.node(i).upstream_segments(j);
            upstream_flowrate=current_network.segment(upstream_segment).Q;
            upstream_Hd=current_network.segment(upstream_segment).Hd;
            upstream_RBC_flowrate=abs(upstream_flowrate*upstream_Hd);
            local_RBC_conservation=local_RBC_conservation+upstream_RBC_flowrate;
            local_conservation=local_conservation+abs(upstream_flowrate);
        end
        
        for j=1:length(current_network.node(i).downstream_segments)
            downstream_segment=current_network.node(i).downstream_segments(j);
            downstream_flowrate=current_network.segment(downstream_segment).Q;
            downstream_Hd=current_network.segment(downstream_segment).Hd;
            downstream_RBC_flowrate=-abs(downstream_flowrate*downstream_Hd);
            local_RBC_conservation=local_RBC_conservation+downstream_RBC_flowrate;
            local_conservation=local_conservation-abs(downstream_flowrate);
        end
        current_network.node(i).local_RBC_conservation=local_RBC_conservation;
        current_network.node(i).local_conservation=local_conservation;
        total_conservation=total_conservation+abs(local_RBC_conservation);
    end
end
total_conservation=total_conservation/current_network.perfusion;


resHd=[global_variation total_conservation];
end


