function current_network=computeBifurcationNature(current_network)
%% This function this function identifies each node that is not a boundary node
% as being either a converging bifurcation (only one outlet segment)
% or a diverging bifurcation (more than one outlet segment)
% this steps in necessary to compute the discharge hematocrit distribution

for i=1:length(current_network.node)
    node=current_network.node(i);
    P=node.P;
    upstream_segments=[];
    downstream_segments=[];
    if node.BC==0 
       nb_downstream=0;
       nb_upstream=0;
       neigh_nodes=node.neigh_nodes;
       neigh_segments=node.neigh_segments;
       for j=1:length(neigh_nodes)
           neigh_node=neigh_nodes(j);
           neigh_segment=neigh_segments(j);
           P_neigh=current_network.node(neigh_node).P;
           if P_neigh<=P
              nb_downstream=nb_downstream+1;
              downstream_segments=[downstream_segments neigh_segment]; 
           elseif P_neigh>P
              nb_upstream=nb_upstream+1;
              upstream_segments=[upstream_segments neigh_segment]; 
           end
       end
       if length(neigh_nodes)==2
           if(nb_downstream==1)
             current_network.node(i).bifurcation_type=0; 
           else
             current_network.node(i).bifurcation_type=-1;
           end
       elseif length(neigh_nodes)==3
           if (nb_downstream==0 || nb_downstream==3)
               current_network.node(i).bifurcation_type=-1;
           elseif (nb_downstream==1)
               current_network.node(i).bifurcation_type=0;
           elseif(nb_downstream==2)
               current_network.node(i).bifurcation_type=1;
           end
       elseif length(neigh_nodes)>3
           if (nb_downstream==0 || nb_downstream==length(neigh_nodes))
               current_network.node(i).bifurcation_type=-1;
           elseif (nb_downstream==1)
               current_network.node(i).bifurcation_type=0;
           elseif(nb_downstream>=2)
               current_network.node(i).bifurcation_type=2;
           end
       end
    else
        current_network.node(i).bifurcation_type=0;
        if current_network.node(node.neigh_nodes(1)).P>=P
           upstream_segments=[upstream_segments node.neigh_segments(1)];
        else
           downstream_segments=[downstream_segments node.neigh_segments(1)];
           current_network.segment(node.neigh_segments(1)).inlet=1;
        end
    end
    current_network.node(i).upstream_segments=upstream_segments;
    current_network.node(i).downstream_segments=downstream_segments;
end

end



