function current_network = computeApparentViscosity(current_network)
%% This function computes the apparent viscosity of the blood according to the Fahraeus-Lindqvist effect

for i=1:length(current_network.segment)
    
    d=current_network.segment(i).d;
    Hd=current_network.segment(i).Hd;
    
    C=(0.8+exp(-0.075*d).*(-1+1./(1+1e-11*d.^12)))+(1./(1+1e-11*d.^12));
    mu045=6*exp(-0.085*d)+3.2-2.44*exp(-0.06*d.^0.645);
    muplasma=1.5e-3;
    a=(mu045-1);
    b=(1-Hd)^C-1;
    c=(d/(d-1.1))^2;
    e=(1-0.45)^C-1; 
    mu=muplasma*(1+a*b*c/e)*c;
    current_network.segment(i).mu=mu;
end

end

