import three;

settings.outformat = "png";
defaultpen(fontsize(20pt));
unitsize(1cm);
real sc=0.6;
real sc2=2;
draw(shift(0, sc2,0)*scale(sc,sc, sc)*unitsphere, blue);
draw(shift(0,-sc2/2, -sc2*sqrt(3)/2)*scale(sc,sc,sc)*unitsphere, blue);
draw(shift(0,sc2/2, -sc2*sqrt(3)/2)*scale(sc,sc,sc)*unitsphere, blue);
draw(shift(0,-sc2,0)*scale(sc,sc,sc)*unitsphere, blue);
draw(shift(0,-sc2/2, sc2*sqrt(3)/2)*scale(sc,sc,sc)*unitsphere, blue);
draw(shift(0,sc2/2, sc2*sqrt(3)/2)*scale(sc,sc,sc)*unitsphere, blue);

triple arrowstart=(-sc2*5, 0,0);
triple arrowend=(-sc2*1, 0,0);
draw(arrowstart--arrowend,
arrow=Arrow3(emissive(red), size=60), linewidth(20pt)+red);
//L=Label("$l=0$", position=MidPoint,align=S));

label("$l=0$",arrowstart+arrowend/2-(0,0,1),S, red+fontsize(20pt));

triple arrowstart2=(sc2*1, 0,0);
triple arrowend2=(sc2*3, 0,0);
draw(arrowstart2--arrowend2,
arrow=Arrow3(emissive(red),size=40), linewidth(10pt)+red,
L=Label("$l=0$", position=EndPoint,align=W));
triple shift=(0,0,sc2*0.5);
draw(arrowstart2+shift--arrowend2+shift,
arrow=Arrow3(emissive(red),size=40), linewidth(10pt)+red,
L=Label("$l=1$", position=EndPoint,align=W, embed=Scale)
);
draw(arrowstart2-shift--arrowend2-shift,
arrow=Arrow3(emissive(red),size=40), linewidth(10pt)+red,
L=Label("$l=-1$", position=EndPoint,align=W, embed=Scale));
draw(arrowstart2-2*shift--arrowend2-2*shift,
arrow=Arrow3(emissive(red),size=40), linewidth(10pt)+red,
L=Label("$l=-2$", position=EndPoint,align=W, embed=Scale));
draw(arrowstart2+2*shift--arrowend2+2*shift,
arrow=Arrow3(emissive(red),size=40), linewidth(10pt)+red,
L=Label("$l=2$", position=EndPoint,align=W, embed=Scale));
