import numpy as np
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib import patches, path
from string import ascii_lowercase

lambda0=1
d0=1
eta=0.1
hermitian=True
simplify=False
extent=50
D0=1.6 #2.1 #6
Vquad0=3.0 #1.0 #000
Lmax=6
rtrunc=-1 #0.6*d
B0=12
Lmax=6

#Nparts=[1,2,3]


fsize=32

#list of systems: [[d0, hermitian,simplify, D0,Npart,B0,Vquad0,rtrunc], axcoords, ovcolumn, exponent]
# axcoords - coordinates of subplot in the plot
# ovcolumn - column in the data file which corresponds to overlaps
# exponent - the y scale will be in the units 10^{exponent}
systems=[
[[0.05, True, False, 2.1,3,12,3,-1,9], [0,0], 2,3], 
[[0.3, True, False, 1.6,2,12,10,-1,7], [0,1], 2, 0], 
[[0.3, True, False, 0.6,2,12,0,-1,5], [0,2], 2, 0], 
        ]

# font for the plot
plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['CMU Serif']
plt.rcParams['mathtext.fontset'] = 'cm'

# generate subplots
ygridmax=1
xgridmax=3
fig, axall=plt.subplots(ygridmax,xgridmax, sharex=True, figsize=(12,5), squeeze=False)


# iterate over systems, plot spectrum for each of them in a separate subplot
for isyst, syst in enumerate(systems):
    par, axcoords,ovcolumn, exponent=syst
    d0, hermitian,simplify, D0,Npart,B0,Vquad0,rtrunc,mmax=par
    A=np.loadtxt("spectrum_OBC_d0={:.4f}_herm{}_simp{}_D0={:.4f}_Npart={}_B0={:.4f}_Vquad0={:.4f}_rtrunc={:.4f}_mmax{}.txt".format(d0, hermitian,simplify, D0,Npart,B0,Vquad0,rtrunc, mmax)) 
    ax = axall[axcoords[0], axcoords[1]]
    scale=10**exponent # workaround to be able to change "offset text" of the plot: divide the plotted values by 10^exponent and add  "10^exponent" text to the plot manually
    im=ax.scatter(A[:,0], A[:,1]/scale, c=A[:,ovcolumn], vmin=0,vmax=1, zorder=10)
    ax.set_xlabel(r"$L$", fontsize=fsize, labelpad=0)
    if(axcoords[1]==0):
      ax.set_ylabel(r"$E/\Gamma_0$", fontsize=fsize, labelpad=0)
    ax.text(-0.29, 0.95, "("+ascii_lowercase[isyst]+")",  transform=ax.transAxes, fontsize=fsize)
    if(exponent>0):
      ax.text(-0.05, 1.00,  r"$\times 10^{}$".format(exponent)   ,  transform=ax.transAxes, fontsize=fsize)
    ax.tick_params(axis='both', which='major', labelsize=fsize)

###########################
#  draw boxes around eigenstate branches
#################################

class RoundedPolygon(patches.PathPatch):
    # construct polygons with rounded edges
    # source: https://stackoverflow.com/a/66279687/2912349
    def __init__(self, xy, pad, **kwargs):
        p = path.Path(*self.__round(xy=xy, pad=pad))
        super().__init__(path=p, **kwargs)

    def __round(self, xy, pad):
        n = len(xy)

        for i in range(0, n):

            x0, x1, x2 = np.atleast_1d(xy[i - 1], xy[i], xy[(i + 1) % n])

            d01, d12 = x1 - x0, x2 - x1
            l01, l12 = np.linalg.norm(d01), np.linalg.norm(d12)
            u01, u12 = d01 / l01, d12 / l12

            x00 = x0 + min(pad, 0.5 * l01) * u01
            x01 = x1 - min(pad, 0.5 * l01) * u01
            x10 = x1 + min(pad, 0.5 * l12) * u12
            x11 = x2 - min(pad, 0.5 * l12) * u12

            if i == 0:
                verts = [x00, x01, x1, x10]
            else:
                verts += [x01, x1, x10]

        codes = [path.Path.MOVETO] + n*[path.Path.LINETO, path.Path.CURVE3, path.Path.CURVE3]

        verts[0] = verts[-1]

        return np.atleast_1d(verts, codes)


# ---------------- draw boxes (coordinates entered manually) ----------------------------------
xy = np.array([(1.5,-7), (2.5,-7), (3,-6.9), (4,-6.6),(5,-6.3),(6,-6.), (6, -4.3), (5, -5), (4,-5.5), (3,-6.), (1.5,-6.5)]) #, zorder=5, facecolor="None", edgecolor="r")
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor='r')
axall[0,1].add_patch(rp)
xy = np.array([(-1,-6.3),(0,-6),(1,-5.7), (1.3,-5.5), (1.3,-3.6), (0.8,-3.6), (0,-4.3), (-1,-5)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor='r')
axall[0,1].add_patch(rp)
xy = np.array([(-0.3,-6.8), (1, -6.3), (2,-5.7), (3,-5.4),(4,-5.), (5.3,-4.5),(5.3,-4.1),(4,-4.4), (3,-4.8), (2,-5.2), (1,-5.8), (-0.3, -6.5)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor="b", linestyle="--")
axall[0,1].add_patch(rp)
axall[0,1].set_xlim(-0.5, 5.5)

xy = np.array([(1.7,-6.5),(2,-7), (3,-6.3), (4,-5.7),(5,-5),(6,-4.3), (6, -2.5), (5, -3.6), (4,-4.4), (3,-5.2), (1.7,-5.9)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor='r')
axall[0,2].add_patch(rp)
xy = np.array([(-1,-5.2),(0,-4.5), (1,-4),(2.3,-3), (2.3,-1.8), (1,-2.4),(0,-3), (-1,-4)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor='r')
axall[0,2].add_patch(rp)
xy = np.array([(-0.3,-7.7),(0.2,-7.7),  (1, -6.5), (2,-5.3), (3,-4.3), (4.3,-3.5),(4.3,-2.2), (3,-3), (2,-3.8), (1,-5), (-0.3, -6.7)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor="b", linestyle="--")
axall[0,2].add_patch(rp)
axall[0,2].set_xlim(-0.5, 5.5)

xy = np.array([(-0.3, -1.80), (1,-1.78),(2,-1.76), (3,-1.74), (4,-1.71),(5.4,-1.68), (5.4, -1.625), (4,-1.62), (3,-1.64), (2,-1.67), (1,-1.72), (-0.3, -1.76)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor='r')
axall[0,0].add_patch(rp)
xy = np.array([(2.75,-1.83), (3.2,-1.83),(4,-1.75), (5.2,-1.73),(5.2,-1.7),(3.8,-1.72), (2.8,-1.8)])
rp = RoundedPolygon(xy=xy, pad=0.5, facecolor='None', edgecolor="b", linestyle="--")
axall[0,0].add_patch(rp)
axall[0,0].set_xlim(-0.5, 5.5)


# --------------- add colorbar --------------
ax_cbar=fig.add_axes([0.915,0.15, 0.02, 0.75])
plt.colorbar(im, cax=ax_cbar)
ax_cbar.set_title(r"$O$", fontsize=fsize)
ax_cbar.set_yticks([0,0.2,0.4,0.6,0.8, 1.0])
ax_cbar.tick_params(axis='both', which='major', labelsize=fsize)

# adjust the 
plt.subplots_adjust(left=0.13, bottom=0.18, right=0.905, top=0.92, wspace=0.4)


plt.savefig("Figure3.pdf")

plt.show()
