import numpy as np
import scipy as sp
from scipy.special import dawsn
import sympy as sp
import matplotlib.pyplot as plt


plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['CMU Serif']
plt.rcParams['mathtext.fontset'] = 'cm'


# Explicit expressions for first three modes (can be plotted for verification)
#def F0(f0):
#  return 0.25*(1+np.sqrt(2)*(-f0+1./f0)*dawsn(1/(f0*np.sqrt(2)))     )
#
#def F1(f0):
#  return 0.5*(0.75-0.25/(f0**2) +0.25*np.sqrt(2)*(-3*f0+1./(f0**3))*dawsn(1/(f0*np.sqrt(2)))     )
#
#def F2(f0):
#  return 0.125*(-0.25/(f0**4)-0.5/(f0**2)+15./4.+np.sqrt(2)*(-15./4.*f0-0.75/f0+0.25/(f0**3)+0.25/(f0**5))*dawsn(1/(f0*np.sqrt(2)))     )



u, f, D=sp.symbols("u, f, D")


# apply integration by parts (see readme file)
def ExpandInt(power):
  if(power%2==0):
    expr=D
    for power0 in range(power,0, -2):
      expr=expr.subs(D, u**(power0-1)/2-(power0-1)*D/2)
    return expr

# get the full expression for normalization constant in terms of f and D (Dawson function)
def FullIntExpression(l):
  pref=1/(sp.Pow(2,l))*(1/(2*f**2)-u**2)**l*(2*f**2*u**2+1)
  pref=sp.expand(pref)
  monomials=pref.args
  fullexpr=0
  for monomial in monomials:
    power=sp.degree(monomial, u)
    coeff0=monomial/sp.Pow(u,power)
    eint=ExpandInt(power) 
    fullexpr+=coeff0*eint
  fullexpr*=2*sp.sqrt(2)*f
  fullexpr=fullexpr.subs(u, 1/(sp.sqrt(2)*f))
  fullexpr=fullexpr*sp.Pow(2,l)/(4*sp.factorial(l))/sp.Pow(f,2)
  return fullexpr

# evaluate the numerical value of the normalization constant
def EvaluateInt(fullexpr, f0):
  D0=dawsn(1/(f0*np.sqrt(2)))
  fullexpr2=fullexpr.subs(f, f0)
  fullexpr2=fullexpr2.subs(D, D0)
  return fullexpr2.evalf()

# compute and plot the normalization
w0s=np.linspace(0.001, 2, 100)
plt.figure(figsize=(5,4))
fsize=13
for l in range(6):
  Fs=[]
  expr=FullIntExpression(l)
  print("l=", l, expr)
  for iw0, w0 in enumerate(w0s):
    F=EvaluateInt(expr,1./(2.*np.pi*w0))
    Fs.append(F)
  plt.plot(w0s, Fs, label=r"$|l|={}$".format(l))

#adjust plot details
plt.legend(fontsize=fsize)
plt.xlabel("$w_0/\lambda_A$",fontsize=fsize)
plt.ylabel("$F$",fontsize=fsize)
ax=plt.gca()
ax.tick_params(axis='both', which='major', labelsize=fsize)
plt.tight_layout()
plt.savefig("Figure16.pdf")

plt.show()

