import numpy as np
import matplotlib.pyplot as plt

# d0 values for each column
d0s=[0.1, 0.2, 0.3, 0.4, 0.5, 1.0, 1.7]

# set font size and font for the plot
fsize=13
plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['CMU Serif']
plt.rcParams['mathtext.fontset'] = 'cm'

# generate subplots
width_ratios=list(np.ones(len(d0s)))
fig, ax = plt.subplots(3,len(d0s), figsize=(10,6), width_ratios=width_ratios, height_ratios=[1,1,1])

# system parameters
hermitian=True # if diagonalize the Hermitian part of the Hamiltonian (keep True otherwise the orbitals will be nonorthogonal) 
D0=0.6 # system size 
simplify=False #use simplified model instead of the full model
Vquad0=0 # rescaled confining potential strength (not useful for D0=0.6)
Lmax=6 # Lmax-fold rotational symmetry
rtrunc=-1 #truncation radius of interaction (-1 if no truncation)
mmax=5 #cutoff in orbital space
B0=12 # rescaled magnetic field


#find minimum and maximum of the decay rate, to set a common scale for all row 1 plots
gammamins=[]
gammamaxs=[]
for id0, d0 in enumerate(d0s): 
  A=np.loadtxt("spectrum_OBC_d0={:.4f}_herm{}_simp{}_D0={:.4f}_Npart={}_B0={:.4f}_Vquad0={:.4f}_rtrunc={:.4f}_mmax{}.txt".format(d0, True,False, D0,1,B0,Vquad0,rtrunc, mmax))
  icol=2
  gammamins.append(np.min(A[:,icol]))
  gammamaxs.append(np.max(A[:,icol]))
gammamin=np.min(gammamins)
gammamax=np.max(gammamaxs)

# exponents to set the scale of each plot 
exponents=[[1,2,2],
[1,1,1],
[0,0,0],
[0,0,0],
[0,0,0],
[-1,-1,-1],
[-1,-1,-1]
        ]

# load spectra with the overlap / decay rate and plot them
for id0, d0 in enumerate(d0s): 
  e1,e2,e3=exponents[id0]
  scale=10**e1
  A=np.loadtxt("spectrum_OBC_d0={:.4f}_herm{}_simp{}_D0={:.4f}_Npart={}_B0={:.4f}_Vquad0={:.4f}_rtrunc={:.4f}_mmax{}.txt".format(d0, True,False, D0,1,B0,Vquad0,rtrunc, mmax))
  im1=ax[0, id0].scatter(A[:,0], A[:,1]/scale, c=A[:,2], vmin=gammamin, vmax=gammamax)
  if(e1!=0):
    ax[0,id0].text(0.0, 1.00,  r"$\times 10^{{{}}}$".format(e1)   ,  transform=ax[0,id0].transAxes, fontsize=fsize)
  scale=10**e2
  A=np.loadtxt("spectrum_OBC_d0={:.4f}_herm{}_simp{}_D0={:.4f}_Npart={}_B0={:.4f}_Vquad0={:.4f}_rtrunc={:.4f}_mmax{}.txt".format(d0, True,False, D0,2,B0,Vquad0,rtrunc, mmax))
  im2=ax[1, id0].scatter(A[:,0], A[:,1]/scale, c=A[:,2], vmin=0, vmax=1)
  if(e2!=0):
    ax[1,id0].text(0.0, 1.00,  r"$\times 10^{{{}}}$".format(e2)   ,  transform=ax[1,id0].transAxes, fontsize=fsize)
  scale=10**e3
  A=np.loadtxt("spectrum_OBC_d0={:.4f}_herm{}_simp{}_D0={:.4f}_Npart={}_B0={:.4f}_Vquad0={:.4f}_rtrunc={:.4f}_mmax{}.txt".format(d0, True,False, D0,3,B0,Vquad0,rtrunc, mmax))
  im3=ax[2, id0].scatter(A[:,0], A[:,1]/scale, c=A[:,2], vmin=0, vmax=1)
  if(e3!=0):
    ax[2,id0].text(0.0, 1.00,  r"$\times 10^{{{}}}$".format(e3)   ,  transform=ax[2,id0].transAxes, fontsize=fsize)
  # set tick labek suze
  ax[0, id0].tick_params(axis='both', which='major', labelsize=fsize)
  ax[1, id0].tick_params(axis='both', which='major', labelsize=fsize)
  ax[2, id0].tick_params(axis='both', which='major', labelsize=fsize)
  ax[0, id0].yaxis.offsetText.set_fontsize(fsize)
  ax[1, id0].yaxis.offsetText.set_fontsize(fsize)
  ax[2, id0].yaxis.offsetText.set_fontsize(fsize)

# add colorbars
axcb1=fig.add_axes([0.935, 0.695, 0.01, 0.215])
cbar1=plt.colorbar(im1, cax=axcb1)
cbar1.set_label(r"$\Gamma/\Gamma_0$", fontsize=fsize)
axcb2=fig.add_axes([0.935, 0.392, 0.01, 0.215])
cbar2=plt.colorbar(im2, cax=axcb2)
cbar2.set_label(r"$O$", fontsize=fsize)
axcb3=fig.add_axes([0.935, 0.09, 0.01, 0.215])
cbar3=plt.colorbar(im3, cax=axcb3)
cbar3.set_label(r"$O$", fontsize=fsize)
axcb1.tick_params(axis='both', which='major', labelsize=fsize)
axcb2.tick_params(axis='both', which='major', labelsize=fsize)
axcb3.tick_params(axis='both', which='major', labelsize=fsize)

#add plot labels
for i in range(0,3):
  ax[i,0].set_ylabel(r"$N_\mathrm{part}=$"+str(i+1)+"\n"+r"$E/\Gamma_0$", fontsize=fsize)
for id0, d0 in enumerate(d0s): 
  ax[0,id0].text(0.5, 1.25,r"$d_0={}$".format(d0), fontsize=fsize, transform=ax[0,id0].transAxes, ha="center")
  ax[2,id0].set_xlabel(r"$L$".format(d0), fontsize=fsize)

plt.subplots_adjust(left=0.09, right=0.92, bottom=0.09, top=0.91, wspace=0.7, hspace=0.4)
plt.savefig("Figure15.pdf")

plt.show()
