import numpy as np
import matplotlib.pyplot as plt
from string import ascii_lowercase

# system parameters to load appropriate files: number of particles, if H was Hermitian, D0, B0, rtrunc
params_all=[
[2, True, 1.6, 12, -1],
[3, True, 1.6, 12, -1],
[2, True, 2.1, 12, -1],
[3, True, 2.1, 12, -1],
        ]
npar=len(params_all)

#set font size and fonts for the plot
fsize=13 
plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.serif'] = ['CMU Serif']
plt.rcParams['mathtext.fontset'] = 'cm'


#create subplots
width_ratios=list(np.ones(npar))
width_ratios.append(0.1)
fig,ax=plt.subplots(2,npar//2, squeeze=False, sharex=True, sharey=True, figsize=(5,4.5))


# load and plot data
for ip,params in enumerate(params_all):
  ipy=ip//2
  ipx=ip%2
  Npart, hermitian, D0,B0,rtrunc=params
  fname="phasediagram_gsoverlap_OBC_Npart={}_herm{}_D0={:.4f}_B0={:.4f}_rtrunc={:.4f}.txt".format(Npart, hermitian, D0,B0,rtrunc)
  # load axes limits and steps from file header
  f=open(fname)
  lines=f.readlines()
  line=lines[0].split()
  linef=[]
  for i in range(1,7):
    linef.append(float(line[i]))
  d0min, d0max, dd0, Vquad0min, Vquad0max, dVquad0=linef 
  overlaps=np.loadtxt(fname)# load overlap map from fle
  im1=ax[ipy,ipx].imshow(np.transpose(overlaps), extent=[d0min-dd0/2., d0max+dd0/2., Vquad0min-dVquad0/2., Vquad0max+dVquad0/2.], origin="lower", vmin=0, vmax=1) # plot overlap map
  ax[ipy,ipx].set_aspect("auto") # so that the plots don't keep aspect ratio 1


# set plot details, labels, colorbar etc.
for i in range(2):
  ax[1, i].set_xlabel(r"$d_0$", fontsize=fsize, labelpad=1)
ax[0, 0].set_ylabel(r"$V_\mathrm{harm0}$", fontsize=fsize, labelpad=-5)
ax[1, 0].set_ylabel(r"$V_\mathrm{harm0}$", fontsize=fsize, labelpad=-5)
for i in range(2):
 for j in range(2):
  k=2*i+j
  ax[i,j].text(0.05, 0.87,"("+ascii_lowercase[k]+")", transform=ax[i,j].transAxes, fontsize=fsize)
  ax[i,j].tick_params(axis='both', which='major', labelsize=fsize)
plt.subplots_adjust(left=0.12, right=0.88, bottom=0.12, top=0.98, hspace=0.1, wspace=0.1)
ax1=fig.add_axes([0.89, 0.12, 0.02, 0.86])
ax1.tick_params(axis='both', which='major', labelsize=fsize)
plt.colorbar(im1, cax=ax1)
ax1.set_ylabel(r"$O(|\Psi_0\rangle )$", size=fsize, labelpad=-7)
plt.savefig("Figure14.pdf")

plt.show()


